/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __SHELL32_H__
#define __SHELL32_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "advapi32.h"
#include "ole32.h"
#include "user32.h"

typedef struct _W32LdrDrop *HDROP;

#define S_OK 0
#define NOERROR 0
#define E_FAIL 0x80004005
typedef struct _IMalloc IMalloc, *LPMALLOC;
#include "pshpack1.h"
typedef struct _IMallocVtbl
{
  HRESULT (WINAPI *QueryInterface)(IMalloc *This, REFIID riid, void **ppvObject);
  ULONG (WINAPI *AddRef)(IMalloc *This);
  ULONG (WINAPI *Release)(IMalloc *This);
  void *(WINAPI *Alloc)(IMalloc *This, SIZE_T cb);
  void *(WINAPI *Realloc)(IMalloc *This, void *pv, SIZE_T cb);
  void (WINAPI *Free)(IMalloc *This, void *pv);
  SIZE_T (WINAPI *GetSize)(IMalloc *This, void *pv);
  int (WINAPI *DidAlloc)(IMalloc *This, void *pv);
  void (WINAPI *HeapMinimize)(IMalloc *This);
} IMallocVtbl;
struct _IMalloc
{
  struct _IMallocVtbl *lpVtbl;
  ULONG ulCounter;
};
#include "poppack.h"

#include "pshpack1.h"
typedef struct _SHITEMID
{
  WORD cb;
  BYTE abID[1];
} SHITEMID, *PSHITEMID, *LPSHITEMID;
typedef CONST SHITEMID *PCSHITEMID, *LPCSHITEMID;
typedef struct _ITEMIDLIST
{
  SHITEMID mkid;
} ITEMIDLIST, *PITEMIDLIST, *LPITEMIDLIST;
typedef CONST ITEMIDLIST *PCITEMIDLIST, *LPCITEMIDLIST;
#include "poppack.h"
#define BIF_RETURNONLYFSDIRS   0x0001
#define BIF_DONTGOBELOWDOMAIN  0x0002
#define BIF_STATUSTEXT         0x0004
#define BIF_RETURNFSANCESTORS  0x0008
#define BIF_EDITBOX            0x0010
#define BIF_VALIDATE           0x0020
#define BIF_NEWDIALOGSTYLE     0x0040
#define BIF_USENEWUI           0x0050
#define BIF_BROWSEINCLUDEURLS  0x0080
#define BIF_UAHINT             0x0100
#define BIF_NONEWFOLDERBUTTON  0x0200
#define BIF_NOTRANSLATETARGETS 0x0400
#define BIF_BROWSEFORCOMPUTER  0x1000
#define BIF_BROWSEFORPRINTER   0x2000
#define BIF_BROWSEINCLUDEFILES 0x4000
#define BIF_SHAREABLE          0x8000
typedef INT (CALLBACK *BFFCALLBACK)(HWND, UINT, LPARAM, LPARAM);
/* #include "pshpack8.h" */
typedef struct _BROWSEINFOA
{
  HWND hwndOwner;
  LPCITEMIDLIST pidlRoot;
  LPSTR pszDisplayName;
  LPCSTR lpszTitle;
  UINT ulFlags;
  BFFCALLBACK lpfn;
  LPARAM lParam;
  INT iImage;
} BROWSEINFOA, *PBROWSEINFOA, *LPBROWSEINFOA;
typedef struct _BROWSEINFOW
{
  HWND hwndOwner;
  LPCITEMIDLIST pidlRoot;
  LPWSTR pszDisplayName;
  LPCWSTR lpszTitle;
  UINT ulFlags;
  BFFCALLBACK lpfn;
  LPARAM lParam;
  INT iImage;
} BROWSEINFOW, *PBROWSEINFOW, *LPBROWSEINFOW;
/* #include "poppack.h" */
#ifdef UNICODE
# define BROWSEINFO   BROWSEINFOW
# define PBROWSEINFO  PBROWSEINFOW
# define LPBROWSEINFO LPBROWSEINFOW
#else /* not UNICODE */
# define BROWSEINFO   BROWSEINFOA
# define PBROWSEINFO  PBROWSEINFOA
# define LPBROWSEINFO LPBROWSEINFOA
#endif /* not UNICODE */

#define SEE_MASK_CLASSNAME      0x00000001
#define SEE_MASK_CLASSKEY       0x00000003
#define SEE_MASK_IDLIST         0x00000004
#define SEE_MASK_INVOKEIDLIST   0x0000000c
#define SEE_MASK_ICON           0x00000010
#define SEE_MASK_HOTKEY         0x00000020
#define SEE_MASK_NOCLOSEPROCESS 0x00000040
#define SEE_MASK_CONNECTNETDRV  0x00000080
#define SEE_MASK_FLAG_DDEWAIT   0x00000100
#define SEE_MASK_DOENVSUBST     0x00000200
#define SEE_MASK_FLAG_NO_UI     0x00000400
#define SEE_MASK_UNICODE        0x00004000
#define SEE_MASK_NO_CONSOLE     0x00008000
#define SEE_MASK_HMONITOR       0x00200000
#include "pshpack1.h"
typedef struct _SHELLEXECUTEINFOA
{
  DWORD cbSize;
  ULONG fMask;
  HWND hwnd;
  LPCSTR lpVerb;
  LPCSTR lpFile;
  LPCSTR lpParameters;
  LPCSTR lpDirectory;
  INT nShow;
  HINSTANCE hInstApp;
  LPVOID lpIDList;
  LPCSTR lpClass;
  HKEY hkeyClass;
  DWORD dwHotKey;
  union
  {
    HANDLE hIcon;
    HANDLE hMonitor;
  } DUMMYUNIONNAME;
  HANDLE hProcess;
} SHELLEXECUTEINFOA, *PSHELLEXECUTEINFOA, *LPSHELLEXECUTEINFOA;
typedef struct _SHELLEXECUTEINFOW
{
  DWORD cbSize;
  ULONG fMask;
  HWND hwnd;
  LPCWSTR lpVerb;
  LPCWSTR lpFile;
  LPCWSTR lpParameters;
  LPCWSTR lpDirectory;
  INT nShow;
  HINSTANCE hInstApp;
  LPVOID lpIDList;
  LPCWSTR lpClass;
  HKEY hkeyClass;
  DWORD dwHotKey;
  union
  {
    HANDLE hIcon;
    HANDLE hMonitor;
  } DUMMYUNIONNAME;
  HANDLE hProcess;
} SHELLEXECUTEINFOW, *PSHELLEXECUTEINFOW, *LPSHELLEXECUTEINFOW;
#include "poppack.h"
#ifdef UNICODE
# define SHELLEXECUTEINFO SHELLEXECUTEINFOW
# define PSHELLEXECUTEINFO PSHELLEXECUTEINFOW
# define LPSHELLEXECUTEINFO LPSHELLEXECUTEINFOW
#else /* not UNICODE */
# define SHELLEXECUTEINFO SHELLEXECUTEINFOA
# define PSHELLEXECUTEINFO PSHELLEXECUTEINFOA
# define LPSHELLEXECUTEINFO LPSHELLEXECUTEINFOA
#endif /* not UNICODE */

#define FO_MOVE   0x0001
#define FO_COPY   0x0002
#define FO_DELETE 0x0003
#define FO_RENAME 0x0004
#define FOF_MULTIDESTFILES        0x0001
#define FOF_CONFIRMMOUSE          0x0002
#define FOF_SILENT                0x0004
#define FOF_RENAMEONCOLLISION     0x0008
#define FOF_NOCONFIRMATION        0x0010
#define FOF_WANTMAPPINGHANDLE     0x0020
#define FOF_ALLOWUNDO             0x0040
#define FOF_FILESONLY             0x0080
#define FOF_SIMPLEPROGRESS        0x0100
#define FOF_NOCONFIRMMKDIR        0x0200
#define FOF_NOERRORUI             0x0400
#define FOF_NOCOPYSECURITYATTRIBS 0x0800
#define FOF_NORECURSION           0x1000
#define FOF_NO_CONNECTED_ELEMENTS 0x2000
#define FOF_WANTNUKEWARNING       0x4000
#define FOF_NORECURSEREPARSE      0x8000
typedef WORD FILEOP_FLAGS;
#include "pshpack1.h"
typedef struct _SHFILEOPSTRUCTA
{
  HWND hwnd;
  UINT wFunc;
  LPCSTR pFrom;
  LPCSTR pTo;
  FILEOP_FLAGS fFlags;
  BOOL fAnyOperationsAborted;
  LPVOID hNameMappings;
  LPCSTR lpszProgressTitle;
} SHFILEOPSTRUCTA, *PSHFILEOPSTRUCTA, *LPSHFILEOPSTRUCTA;
typedef struct _SHFILEOPSTRUCTW
{
  HWND hwnd;
  UINT wFunc;
  LPCWSTR pFrom;
  LPCWSTR pTo;
  FILEOP_FLAGS fFlags;
  BOOL fAnyOperationsAborted;
  LPVOID hNameMappings;
  LPCWSTR lpszProgressTitle;
} SHFILEOPSTRUCTW, *PSHFILEOPSTRUCTW, *LPSHFILEOPSTRUCTW;
#include "poppack.h"
#ifdef UNICODE
# define SHFILEOPSTRUCT SHFILEOPSTRUCTW
# define PSHFILEOPSTRUCT PSHFILEOPSTRUCTW
# define LPSHFILEOPSTRUCT LPSHFILEOPSTRUCTW
#else /* not UNICODE */
# define SHFILEOPSTRUCT SHFILEOPSTRUCTA
# define PSHFILEOPSTRUCT PSHFILEOPSTRUCTA
# define LPSHFILEOPSTRUCT LPSHFILEOPSTRUCTA
#endif /* not UNICODE */


extern W32LdrExport shell32_exports[];


VOID WINAPI DragAcceptFiles (HWND hWnd, BOOL fAccept);
VOID WINAPI DragFinish (HDROP hDrop);
UINT WINAPI DragQueryFileA (HDROP hDrop, UINT iFile, LPSTR lpszFile, UINT cch);
UINT WINAPI DragQueryFileW (HDROP hDrop, UINT iFile, LPWSTR lpszFile, UINT cch);
BOOL WINAPI DragQueryPoint (HDROP hDrop, LPPOINT lppt);
HINSTANCE WINAPI FindExecutableA (LPCSTR lpFile, LPCSTR lpDirectory, LPSTR lpResult);
HINSTANCE WINAPI FindExecutableW (LPCWSTR lpFile, LPCWSTR lpDirectory, LPWSTR lpResult);
LPITEMIDLIST WINAPI SHBrowseForFolderA (LPBROWSEINFOA lpbi);
LPITEMIDLIST WINAPI SHBrowseForFolderW (LPBROWSEINFOW lpbi);
INT WINAPI SHFileOperationA (LPSHFILEOPSTRUCTA lpFileOp);
INT WINAPI SHFileOperationW (LPSHFILEOPSTRUCTW lpFileOp);
HRESULT WINAPI SHGetMalloc (LPMALLOC *ppMalloc);
BOOL WINAPI SHGetPathFromIDListA (LPCITEMIDLIST pidl, LPSTR pszPath);
BOOL WINAPI SHGetPathFromIDListW (LPCITEMIDLIST pidl, LPWSTR pszPath);
HINSTANCE WINAPI ShellExecuteA (HWND hWnd, LPCSTR lpOperation, LPCSTR lpFile, LPCSTR lpParameters, LPCSTR lpDirectory, INT nShowCmd);
BOOL WINAPI ShellExecuteExA (LPSHELLEXECUTEINFOA lpExecInfo);
BOOL WINAPI ShellExecuteExW (LPSHELLEXECUTEINFOW lpExecInfo);
HINSTANCE WINAPI ShellExecuteW (HWND hWnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters, LPCWSTR lpDirectory, INT nShowCmd);


#ifdef UNICODE
# define DragQueryFile DragQueryFileW
# define FindExecutable FindExecutableW
# define SHBrowseForFolder SHBrowseForFolderW
# define SHFileOperation SHFileOperationW
# define SHGetPathFromIDList SHGetPathFromIDListW
# define ShellExecute ShellExecuteW
# define ShellExecuteEx ShellExecuteExW
#else /* not UNICODE*/
# define DragQueryFile DragQueryFileA
# define FindExecutable FindExecutableA
# define SHBrowseForFolder SHBrowseForFolderA
# define SHFileOperation SHFileOperationA
# define SHGetPathFromIDList SHGetPathFromIDListA
# define ShellExecute ShellExecuteA
# define ShellExecuteEx ShellExecuteExA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __SHELL32_H__ */
