/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __USER32_H__
#define __USER32_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "gdi32.h"
/* ja:システム */
#define COLOR_SCROLLBAR               0
#define COLOR_BACKGROUND              1
#define COLOR_DESKTOP                 COLOR_BACKGROUND
#define COLOR_ACTIVECAPTION           2
#define COLOR_INACTIVECAPTION         3
#define COLOR_MENU                    4
#define COLOR_WINDOW                  5
#define COLOR_WINDOWFRAME             6
#define COLOR_MENUTEXT                7
#define COLOR_WINDOWTEXT              8
#define COLOR_CAPTIONTEXT             9
#define COLOR_ACTIVEBORDER            10
#define COLOR_INACTIVEBORDER          11
#define COLOR_APPWORKSPACE            12
#define COLOR_HIGHLIGHT               13
#define COLOR_HIGHLIGHTTEXT           14
#define COLOR_BTNFACE                 15
#define COLOR_3DFACE                  COLOR_BTNFACE
#define COLOR_BTNSHADOW               16
#define COLOR_3DSHADOW                COLOR_BTNSHADOW
#define COLOR_GRAYTEXT                17
#define COLOR_BTNTEXT                 18
#define COLOR_INACTIVECAPTIONTEXT     19
#define COLOR_BTNHIGHLIGHT            20
#define COLOR_3DHIGHLIGHT             COLOR_BTNHIGHLIGHT
#define COLOR_3DHILIGHT               COLOR_BTNHIGHLIGHT
#define COLOR_BTNHILIGHT              COLOR_BTNHIGHLIGHT
#define COLOR_3DDKSHADOW              21
#define COLOR_3DLIGHT                 22
#define COLOR_INFOTEXT                23
#define COLOR_INFOBK                  24
#define COLOR_ALTERNATEBTNFACE        25
#define COLOR_HOTLIGHT                26
#define COLOR_GRADIENTACTIVECAPTION   27
#define COLOR_GRADIENTINACTIVECAPTION 28
#define COLOR_MENUHILIGHT             29
#define COLOR_MENUBAR                 30
#define SM_CXSCREEN          0
#define SM_CYSCREEN          1
#define SM_CXVSCROLL         2
#define SM_CYHSCROLL         3
#define SM_CYCAPTION         4
#define SM_CXBORDER          5
#define SM_CYBORDER          6
#define SM_CXDLGFRAME        7
#define SM_CYDLGFRAME        8
#define SM_CYVTHUMB          9
#define SM_CXHTHUMB          10
#define SM_CXICON            11
#define SM_CYICON            12
#define SM_CXCURSOR          13
#define SM_CYCURSOR          14
#define SM_CYMENU            15
#define SM_CXFULLSCREEN      16
#define SM_CYFULLSCREEN      17
#define SM_CYKANJIWINDOW     18
#define SM_MOUSEPRESENT      19
#define SM_CYVSCROLL         20
#define SM_CXHSCROLL         21
#define SM_DEBUG             22
#define SM_SWAPBUTTON        23
#define SM_RESERVED1         24
#define SM_RESERVED2         25
#define SM_RESERVED3         26
#define SM_RESERVED4         27
#define SM_CXMIN             28
#define SM_CYMIN             29
#define SM_CXSIZE            30
#define SM_CYSIZE            31
#define SM_CXFRAME           32
#define SM_CYFRAME           33
#define SM_CXMINTRACK        34
#define SM_CYMINTRACK        35
#define SM_CXDOUBLECLK       36
#define SM_CYDOUBLECLK       37
#define SM_CXICONSPACING     38
#define SM_CYICONSPACING     39
#define SM_MENUDROPALIGNMENT 40
#define SM_PENWINDOWS        41
#define SM_DBCSENABLED       42
#define SM_CMOUSEBUTTONS     43
#define SM_CXFIXEDFRAME      SM_CXDLGFRAME
#define SM_CYFIXEDFRAME      SM_CYDLGFRAME
#define SM_CXSIZEFRAME       SM_CXFRAME
#define SM_CYSIZEFRAME       SM_CYFRAME
#define SM_SECURE            44
#define SM_CXEDGE            45
#define SM_CYEDGE            46
#define SM_CXMINSPACING      47
#define SM_CYMINSPACING      48
#define SM_CXSMICON          49
#define SM_CYSMICON          50
#define SM_CYSMCAPTION       51
#define SM_CXSMSIZE          52
#define SM_CYSMSIZE          53
#define SM_CXMENUSIZE        54
#define SM_CYMENUSIZE        55
#define SM_ARRANGE           56
#define SM_CXMINIMIZED       57
#define SM_CYMINIMIZED       58
#define SM_CXMAXTRACK        59
#define SM_CYMAXTRACK        60
#define SM_CXMAXIMIZED       61
#define SM_CYMAXIMIZED       62
#define SM_NETWORK           63
#define SM_CLEANBOOT         67
#define SM_CXDRAG            68
#define SM_CYDRAG            69
#define SM_SHOWSOUNDS        70
#define SM_CXMENUCHECK       71
#define SM_CYMENUCHECK       72
#define SM_SLOWMACHINE       73
#define SM_MIDEASTENABLED    74
#define SM_MOUSEWHEELPRESENT 75
#define SM_XVIRTUALSCREEN    76
#define SM_YVIRTUALSCREEN    77
#define SM_CXVIRTUALSCREEN   78
#define SM_CYVIRTUALSCREEN   79
#define SM_CMONITORS         80
#define SM_SAMEDISPLAYFORMAT 81
#define SM_IMMENABLED        82
#define SM_CXFOCUSBORDER     83
#define SM_CYFOCUSBORDER     84
#define SM_TABLETPC          86
#define SM_MEDIACENTER       87
#define SM_STARTER           88
#define SM_SERVERR2          89
#define SM_CMETRICS          90
#define SPI_GETBEEP               1
#define SPI_SETBEEP               2
#define SPI_GETMOUSE              3
#define SPI_SETMOUSE              4
#define SPI_GETBORDER             5
#define SPI_SETBORDER             6
#define SPI_GETKEYBOARDSPEED      10
#define SPI_SETKEYBOARDSPEED      11
#define SPI_LANGDRIVER            12
#define SPI_ICONHORIZONTALSPACING 13
#define SPI_GETSCREENSAVETIMEOUT  14
#define SPI_SETSCREENSAVETIMEOUT  15
#define SPI_GETSCREENSAVEACTIVE   16
#define SPI_SETSCREENSAVEACTIVE   17
#define SPI_GETGRIDGRANULARITY    18
#define SPI_SETGRIDGRANULARITY    19
#define SPI_SETDESKWALLPAPER      20
#define SPI_SETDESKPATTERN        21
#define SPI_GETKEYBOARDDELAY      22
#define SPI_SETKEYBOARDDELAY      23
#define SPI_ICONVERTICALSPACING   24
#define SPI_GETICONTITLEWRAP      25
#define SPI_SETICONTITLEWRAP      26
#define SPI_GETMENUDROPALIGNMENT  27
#define SPI_SETMENUDROPALIGNMENT  28
#define SPI_SETDOUBLECLKWIDTH     29
#define SPI_SETDOUBLECLKHEIGHT    30
#define SPI_GETICONTITLELOGFONT   31
#define SPI_SETDOUBLECLICKTIME    32
#define SPI_SETMOUSEBUTTONSWAP    33
#define SPI_SETICONTITLELOGFONT   34
#define SPI_GETFASTTASKSWITCH     35
#define SPI_SETFASTTASKSWITCH     36
#define SPI_SETDRAGFULLWINDOWS    37
#define SPI_GETDRAGFULLWINDOWS    38
#define SPI_GETNONCLIENTMETRICS   41
#define SPI_SETNONCLIENTMETRICS   42
#define SPI_GETMINIMIZEDMETRICS   43
#define SPI_SETMINIMIZEDMETRICS   44
#define SPI_GETICONMETRICS        45
#define SPI_SETICONMETRICS        46
#define SPI_SETWORKAREA           47
#define SPI_GETWORKAREA           48
#define SPI_SETPENWINDOWS         49
#define SPI_GETFILTERKEYS         50
#define SPI_SETFILTERKEYS         51
#define SPI_GETTOGGLEKEYS         52
#define SPI_SETTOGGLEKEYS         53
#define SPI_GETMOUSEKEYS          54
#define SPI_SETMOUSEKEYS          55
#define SPI_GETSHOWSOUNDS         56
#define SPI_SETSHOWSOUNDS         57
#define SPI_GETSTICKYKEYS         58
#define SPI_SETSTICKYKEYS         59
#define SPI_GETACCESSTIMEOUT      60
#define SPI_SETACCESSTIMEOUT      61
#define SPI_GETSERIALKEYS         62
#define SPI_SETSERIALKEYS         63
#define SPI_GETSOUNDSENTRY        64
#define SPI_SETSOUNDSENTRY        65
#define SPI_GETHIGHCONTRAST       66
#define SPI_SETHIGHCONTRAST       67
#define SPI_GETKEYBOARDPREF       68
#define SPI_SETKEYBOARDPREF       69
#define SPI_GETSCREENREADER       70
#define SPI_SETSCREENREADER       71
#define SPI_GETANIMATION          72
#define SPI_SETANIMATION          73
#define SPI_GETFONTSMOOTHING      74
#define SPI_SETFONTSMOOTHING      75
#define SPI_SETDRAGWIDTH          76
#define SPI_SETDRAGHEIGHT         77
#define SPI_SETHANDHELD           78
#define SPI_GETLOWPOWERTIMEOUT    79
#define SPI_GETPOWEROFFTIMEOUT    80
#define SPI_SETLOWPOWERTIMEOUT    81
#define SPI_SETPOWEROFFTIMEOUT    82
#define SPI_GETLOWPOWERACTIVE     83
#define SPI_GETPOWEROFFACTIVE     84
#define SPI_SETLOWPOWERACTIVE     85
#define SPI_SETPOWEROFFACTIVE     86
#define SPI_SETCURSORS            87
#define SPI_SETICONS              88
#define SPI_GETDEFAULTINPUTLANG   89
#define SPI_SETDEFAULTINPUTLANG   90
#define SPI_SETLANGTOGGLE         91
#define SPI_GETWINDOWSEXTENSION   92
#define SPI_SETMOUSETRAILS        93
#define SPI_GETMOUSETRAILS        94
#define SPI_GETSNAPTODEFBUTTON    95
#define SPI_SETSNAPTODEFBUTTON    96
#define SPI_SETSCREENSAVERRUNNING 97
#define SPI_SCREENSAVERRUNNING    SPI_SETSCREENSAVERRUNNING
#define SPI_GETMOUSEHOVERWIDTH    98
#define SPI_SETMOUSEHOVERWIDTH    99
#define SPI_GETMOUSEHOVERHEIGHT   100
#define SPI_SETMOUSEHOVERHEIGHT   101
#define SPI_GETMOUSEHOVERTIME     102
#define SPI_SETMOUSEHOVERTIME     103
#define SPI_GETWHEELSCROLLLINES   104
#define SPI_SETWHEELSCROLLLINES   105
#define SPI_GETMENUSHOWDELAY      106
#define SPI_SETMENUSHOWDELAY      107
#define SPI_GETSHOWIMEUI          110
#define SPI_SETSHOWIMEUI          111
#define SPI_GETMOUSESPEED         112
#define SPI_SETMOUSESPEED         113
#define SPI_GETSCREENSAVERRUNNING 114
#define SPI_GETDESKWALLPAPER      115

/* ja:描画 */
#include "pshpack1.h"
typedef struct _POINT
{
  LONG x;
  LONG y;
} POINT, *PPOINT, *LPPOINT;
typedef struct _RECT
{
  LONG left;
  LONG top;
  LONG right;
  LONG bottom;
} RECT, *PRECT, *LPRECT;
typedef const RECT *LPCRECT;
typedef struct _PAINTSTRUCT
{
  HDC hdc;
  BOOL fErase;
  RECT rcPaint;
  BOOL fRestore;
  BOOL fIncUpdate;
  BYTE rgbReserved[32];
} PAINTSTRUCT, *PPAINTSTRUCT, *LPPAINTSTRUCT;
#include "poppack.h"
/* ja:ウエイト */
#define WAIT_TIMEOUT 0x00000102
#define INFINITE     0xffffffff
/* ja:アイコン */
typedef LPVOID HICON;
/* ja:カーソル */
#define IDC_ARROW       MAKEINTRESOURCE(32512)
#define IDC_IBEAM       MAKEINTRESOURCE(32513)
#define IDC_WAIT        MAKEINTRESOURCE(32514)
#define IDC_CROSS       MAKEINTRESOURCE(32515)
#define IDC_UPARROW     MAKEINTRESOURCE(32516)
#define IDC_SIZE        MAKEINTRESOURCE(32640)
#define IDC_ICON        MAKEINTRESOURCE(32641)
#define IDC_SIZENWSE    MAKEINTRESOURCE(32642)
#define IDC_SIZENESW    MAKEINTRESOURCE(32643)
#define IDC_SIZEWE      MAKEINTRESOURCE(32644)
#define IDC_SIZENS      MAKEINTRESOURCE(32645)
#define IDC_SIZEALL     MAKEINTRESOURCE(32646)
#define IDC_NO          MAKEINTRESOURCE(32648)
#define IDC_HAND        MAKEINTRESOURCE(32649)
#define IDC_APPSTARTING MAKEINTRESOURCE(32650)
#define IDC_HELP        MAKEINTRESOURCE(32651)
typedef LPVOID HCURSOR;
/* ja:ビットマップ */
typedef GdkPixbuf *HBITMAP;
#include "pshpack1.h"
typedef struct _BITMAPINFOHEADER
{
  DWORD biSize;
  LONG biWidth;
  LONG biHeight;
  WORD biPlanes;
  WORD biBitCount;
  DWORD biCompression;
  DWORD biSizeImage;
  LONG biXPelsPerMeter;
  LONG biYPelsPerMeter;
  DWORD biClrUsed;
  DWORD biClrImportant;
} BITMAPINFOHEADER, *PBITMAPINFOHEADER, *LPBITMAPINFOHEADER;
#include "poppack.h"
/* ja:メニュー */
#define MF_INSERT          0x00000000
#define MF_CHANGE          0x00000080
#define MF_APPEND          0x00000100
#define MF_DELETE          0x00000200
#define MF_REMOVE          0x00001000
#define MF_BYCOMMAND       0x00000000
#define MF_BYPOSITION      0x00000400
#define MF_SEPARATOR       0x00000800
#define MF_ENABLED         0x00000000
#define MF_GRAYED          0x00000001
#define MF_DISABLED        0x00000002
#define MF_UNCHECKED       0x00000000
#define MF_CHECKED         0x00000008
#define MF_USECHECKBITMAPS 0x00000200
#define MF_STRING          0x00000000
#define MF_BITMAP          0x00000004
#define MF_OWNERDRAW       0x00000100
#define MF_POPUP           0x00000010
#define MF_MENUBARBREAK    0x00000020
#define MF_MENUBREAK       0x00000040
#define MF_UNHILITE        0x00000000
#define MF_HILITE          0x00000080
#define MF_DEFAULT         0x00001000
#define MF_SYSMENU         0x00002000
#define MF_HELP            0x00004000
#define MF_RIGHTJUSTIFY    0x00004000
#define MF_MOUSESELECT     0x00008000
#define MF_END             0x00000080
#define MIIM_STATE      0x00000001
#define MIIM_ID         0x00000002
#define MIIM_SUBMENU    0x00000004
#define MIIM_CHECKMARKS 0x00000008
#define MIIM_TYPE       0x00000010
#define MIIM_DATA       0x00000020
#define MIIM_STRING     0x00000040
#define MIIM_BITMAP     0x00000080
#define MIIM_FTYPE      0x00000100
#define TPM_LEFTBUTTON   0x0000
#define TPM_RIGHTBUTTON  0x0002
#define TPM_LEFTALIGN    0x0000
#define TPM_CENTERALIGN  0x0004
#define TPM_RIGHTALIGN   0x0008
#define TPM_TOPALIGN     0x0000
#define TPM_VCENTERALIGN 0x0010
#define TPM_BOTTOMALIGN  0x0020
#define TPM_HORIZONTAL   0x0000
#define TPM_VERTICAL     0x0040
#define TPM_RETURNCMD    0x0100
typedef LPVOID HMENU;
#include "pshpack1.h"
typedef struct _MENUITEMINFOA
{
  UINT cbSize;
  UINT fMask;
  UINT fType;
  UINT fState;
  UINT wID;
  HMENU hSubMenu;
  HBITMAP hbmpChecked;
  HBITMAP hbmpUnchecked;
  ULONG_PTR dwItemData;
  LPSTR dwTypeData;
  UINT cch;
  HBITMAP hbmpItem;
} MENUITEMINFOA, *PMENUITEMINFOA, *LPMENUITEMINFOA;
typedef struct _MENUITEMINFOW
{
  UINT cbSize;
  UINT fMask;
  UINT fType;
  UINT fState;
  UINT wID;
  HMENU hSubMenu;
  HBITMAP hbmpChecked;
  HBITMAP hbmpUnchecked;
  ULONG_PTR dwItemData;
  LPWSTR dwTypeData;
  UINT cch;
  HBITMAP hbmpItem;
} MENUITEMINFOW, *PMENUITEMINFOW, *LPMENUITEMINFOW;
#include "poppack.h"
#ifdef UNICODE
# define MENUITEMINFO MENUITEMINFOW
# define PMENUITEMINFO PMENUITEMINFOW
# define LPMENUITEMINFO LPMENUITEMINFOW
#else /* not UNICODE */
# define MENUITEMINFO MENUITEMINFOA
# define PMENUITEMINFO PMENUITEMINFOA
# define LPMENUITEMINFO LPMENUITEMINFOA
#endif /* not UNICODE */
/* ja:アクセラレータ */
typedef LPVOID HACCEL;
/* ja:クリップボード */
#define CF_TEXT        1
#define CF_OEMTEXT     7
#define CF_UNICODETEXT 13
/* ja:メッセージ */
#define PM_NOREMOVE 0x0000
#define PM_REMOVE   0x0001
#include "pshpack1.h"
typedef struct _MSG
{
  HWND hwnd;
  UINT message;
  WPARAM wParam;
  LPARAM lParam;
  DWORD time;
  POINT pt;
} MSG, *PMSG, *LPMSG;
#include "poppack.h"
/* ja:ウインドウ */
#define HWND_DESKTOP NULL
#define CW_USEDEFAULT ((INT)0x80000000)
#define GWL_USERDATA   (-21)
#define GWL_EXSTYLE    (-20)
#define GWL_STYLE      (-16)
#define GWL_ID         (-12)
#define GWL_HWNDPARENT (-8)
#define GWL_HINSTANCE  (-6)
#define GWL_WNDPROC    (-4)
#define DWL_MSGRESULT 0
#define DWL_DLGPROC   4
#define DWL_USER      8
#define GW_HWNDFIRST 0
#define GW_HWNDLAST  1
#define GW_HWNDNEXT  2
#define GW_HWNDPREV  3
#define GW_OWNER     4
#define GW_CHILD     5
#define SW_HIDE            0
#define SW_SHOWNORMAL      1
#define SW_NORMAL          1
#define SW_SHOWMINIMIZED   2
#define SW_SHOWMAXIMIZED   3
#define SW_MAXIMIZE        3
#define SW_SHOWNOACTIVATE  4
#define SW_SHOW            5
#define SW_MINIMIZE        6
#define SW_SHOWMINNOACTIVE 7
#define SW_SHOWNA          8
#define SW_RESTORE         9
#define SW_SHOWDEFAULT     10
#define SW_FORCEMINIMIZE   11
#define SW_MAX             11
#define SW_NORMALNA        0xcc
#define HWND_TOP       ((HWND)0)
#define HWND_BOTTOM    ((HWND)1)
#define HWND_TOPMOST   ((HWND)-1)
#define HWND_NOTOPMOST ((HWND)-2)
#define HWND_MESSAGE   ((HWND)-3)
#define SWP_NOSIZE         0x0001
#define SWP_NOMOVE         0x0002
#define SWP_NOZORDER       0x0004
#define SWP_NOREDRAW       0x0008
#define SWP_NOACTIVATE     0x0010
#define SWP_FRAMECHANGED   0x0020
#define SWP_SHOWWINDOW     0x0040
#define SWP_HIDEWINDOW     0x0080
#define SWP_NOCOPYBITS     0x0100
#define SWP_NOOWNERZORDER  0x0200
#define SWP_DRAWFRAME      SWP_FRAMECHANGED
#define SWP_NOREPOSITION   SWP_NOOWNERZORDER
#define SWP_NOSENDCHANGING 0x0400
#define SWP_DEFERERASE     0x2000
#define SWP_ASYNCWINDOWPOS 0x4000
#define WS_OVERLAPPED          0x00000000
#define WS_POPUP               0x80000000
#define WS_CHILD               0x40000000
#define WS_MINIMIZE            0x20000000
#define WS_VISIBLE             0x10000000
#define WS_DISABLED            0x08000000
#define WS_CLIPSIBLINGS        0x04000000
#define WS_CLIPCHILDREN        0x02000000
#define WS_MAXIMIZE            0x01000000
#define WS_CAPTION             0x00c00000
#define WS_BORDER              0x00800000
#define WS_DLGFRAME            0x00400000
#define WS_VSCROLL             0x00200000
#define WS_HSCROLL             0x00100000
#define WS_SYSMENU             0x00080000
#define WS_THICKFRAME          0x00040000
#define WS_GROUP               0x00020000
#define WS_TABSTOP             0x00010000
#define WS_MINIMIZEBOX         0x00020000
#define WS_MAXIMIZEBOX         0x00010000
#define WS_TILED               WS_OVERLAPPED
#define WS_ICONIC              WS_MINIMIZE
#define WS_SIZEBOX             WS_THICKFRAME
#define WS_OVERLAPPEDWINDOW    (WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_MINIMIZEBOX|WS_MAXIMIZEBOX)
#define WS_POPUPWINDOW         (WS_POPUP|WS_BORDER|WS_SYSMENU)
#define WS_CHILDWINDOW         (WS_CHILD)
#define WS_TILEDWINDOW         (WS_OVERLAPPEDWINDOW)
#define WS_EX_DLGMODALFRAME    0x00000001
#define WS_EX_DRAGDETECT       0x00000002
#define WS_EX_NOPARENTNOTIFY   0x00000004
#define WS_EX_TOPMOST          0x00000008
#define WS_EX_ACCEPTFILES      0x00000010
#define WS_EX_TRANSPARENT      0x00000020
#define WS_EX_MDICHILD         0x00000040
#define WS_EX_TOOLWINDOW       0x00000080
#define WS_EX_WINDOWEDGE       0x00000100
#define WS_EX_CLIENTEDGE       0x00000200
#define WS_EX_CONTEXTHELP      0x00000400
#define WS_EX_RIGHT            0x00001000
#define WS_EX_LEFT             0x00000000
#define WS_EX_RTLREADING       0x00002000
#define WS_EX_LTRREADING       0x00000000
#define WS_EX_LEFTSCROLLBAR    0x00004000
#define WS_EX_RIGHTSCROLLBAR   0x00000000
#define WS_EX_CONTROLPARENT    0x00010000
#define WS_EX_STATICEDGE       0x00020000
#define WS_EX_APPWINDOW        0x00040000
#define WS_EX_LAYOUTRTL        0x00400000
#define WS_EX_NOINHERITLAYOUT  0x00100000
#define WS_EX_OVERLAPPEDWINDOW (WS_EX_WINDOWEDGE|WS_EX_CLIENTEDGE)
#define WS_EX_PALETTEWINDOW    (WS_EX_WINDOWEDGE|WS_EX_TOOLWINDOW|WS_EX_TOPMOST)
#define WS_EX_LAYERED          0x00080000L
#define WS_EX_TRAYWINDOW       0x80000000L
typedef LRESULT (CALLBACK *WNDPROC)(HWND, UINT, WPARAM, LPARAM);
typedef INT_PTR (CALLBACK *DLGPROC)(HWND, UINT, WPARAM, LPARAM);
typedef BOOL CALLBACK (*WNDENUMPROC)(HWND, LPARAM);
#include "pshpack1.h"
typedef struct _WNDCLASSEXA
{
  UINT cbSize;
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCSTR lpszMenuName;
  LPCSTR lpszClassName;
  HICON hIconSm;
} WNDCLASSEXA, *PWNDCLASSEXA, *LPWNDCLASSEXA;
typedef struct _WNDCLASSEXW
{
  UINT cbSize;
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCWSTR lpszMenuName;
  LPCWSTR lpszClassName;
  HICON hIconSm;
} WNDCLASSEXW, *PWNDCLASSEXW, *LPWNDCLASSEXW;
#include "poppack.h"
#ifdef UNICODE
# define WNDCLASSEX WNDCLASSEXW
# define PWNDCLASSEX PWNDCLASSEXW
# define LPWNDCLASSEX LPWNDCLASSEXW
#else /* not UNICODE */
# define WNDCLASSEX WNDCLASSEXA
# define PWNDCLASSEX PWNDCLASSEXA
# define LPWNDCLASSEX LPWNDCLASSEXA
#endif /* not UNICODE */
/* ja:メッセージ */
#define WM_NULL                   0x0000
#define WM_CREATE                 0x0001
#define WM_DESTROY                0x0002
#define WM_MOVE                   0x0003
#define WM_SIZEWAIT               0x0004
#define WM_SIZE                   0x0005
#define WM_ACTIVATE               0x0006
#define WM_SETFOCUS               0x0007
#define WM_KILLFOCUS              0x0008
#define WM_SETVISIBLE             0x0009
#define WM_ENABLE                 0x000a
#define WM_SETREDRAW              0x000b
#define WM_SETTEXT                0x000c
#define WM_GETTEXT                0x000d
#define WM_GETTEXTLENGTH          0x000e
#define WM_PAINT                  0x000f
#define WM_CLOSE                  0x0010
#define WM_QUERYENDSESSION        0x0011
#define WM_QUIT                   0x0012
#define WM_QUERYOPEN              0x0013
#define WM_ERASEBKGND             0x0014
#define WM_SYSCOLORCHANGE         0x0015
#define WM_ENDSESSION             0x0016
#define WM_SYSTEMERROR            0x0017
#define WM_SHOWWINDOW             0x0018
#define WM_CTLCOLOR               0x0019
#define WM_WININICHANGE           0x001a
#define WM_SETTINGCHANGE          WM_WININICHANGE
#define WM_DEVMODECHANGE          0x001b
#define WM_ACTIVATEAPP            0x001c
#define WM_FONTCHANGE             0x001d
#define WM_TIMECHANGE             0x001e
#define WM_CANCELMODE             0x001f
#define WM_SETCURSOR              0x0020
#define WM_MOUSEACTIVATE          0x0021
#define WM_CHILDACTIVATE          0x0022
#define WM_QUEUESYNC              0x0023
#define WM_GETMINMAXINFO          0x0024
#define WM_PAINTICON              0x0026
#define WM_ICONERASEBKGND         0x0027
#define WM_NEXTDLGCTL             0x0028
#define WM_ALTTABACTIVE           0x0029
#define WM_SPOOLERSTATUS          0x002a
#define WM_DRAWITEM               0x002b
#define WM_MEASUREITEM            0x002c
#define WM_DELETEITEM             0x002d
#define WM_VKEYTOITEM             0x002e
#define WM_CHARTOITEM             0x002f
#define WM_SETFONT                0x0030
#define WM_GETFONT                0x0031
#define WM_SETHOTKEY              0x0032
#define WM_GETHOTKEY              0x0033
#define WM_FILESYSCHANGE          0x0034
#define WM_ISACTIVEICON           0x0035
#define WM_QUERYPARKICON          0x0036
#define WM_QUERYDRAGICON          0x0037
#define WM_QUERYSAVESTATE         0x0038
#define WM_COMPAREITEM            0x0039
#define WM_TESTING                0x003a
#define WM_GETOBJECT              0x003d
#define WM_ACTIVATESHELLWINDOW    0x003e
#define WM_COMPACTING             0x0041
#define WM_COMMNOTIFY             0x0044
#define WM_WINDOWPOSCHANGING      0x0046
#define WM_WINDOWPOSCHANGED       0x0047
#define WM_POWER                  0x0048
#define WM_COPYDATA               0x004a
#define WM_CANCELJOURNAL          0x004b
#define WM_NOTIFY                 0x004e
#define WM_INPUTLANGCHANGEREQUEST 0x0050
#define WM_INPUTLANGCHANGE        0x0051
#define WM_TCARD                  0x0052
#define WM_HELP                   0x0053
#define WM_USERCHANGED            0x0054
#define WM_NOTIFYFORMAT           0x0055
#define WM_CONTEXTMENU            0x007b
#define WM_STYLECHANGING          0x007c
#define WM_STYLECHANGED           0x007d
#define WM_DISPLAYCHANGE          0x007e
#define WM_GETICON                0x007f
#define WM_SETICON                0x0080
#define WM_NCCREATE               0x0081
#define WM_NCDESTROY              0x0082
#define WM_NCCALCSIZE             0x0083
#define WM_NCHITTEST              0x0084
#define WM_NCPAINT                0x0085
#define WM_NCACTIVATE             0x0086
#define WM_GETDLGCODE             0x0087
#define WM_SYNCPAINT              0x0088
#define WM_SYNCTASK               0x0089
#define WM_NCMOUSEMOVE            0x00a0
#define WM_NCLBUTTONDOWN          0x00a1
#define WM_NCLBUTTONUP            0x00a2
#define WM_NCLBUTTONDBLCLK        0x00a3
#define WM_NCRBUTTONDOWN          0x00a4
#define WM_NCRBUTTONUP            0x00a5
#define WM_NCRBUTTONDBLCLK        0x00a6
#define WM_NCMBUTTONDOWN          0x00a7
#define WM_NCMBUTTONUP            0x00a8
#define WM_NCMBUTTONDBLCLK        0x00a9
#define WM_NCXBUTTONDOWN          0x00ab
#define WM_NCXBUTTONUP            0x00ac
#define WM_NCXBUTTONDBLCLK        0x00ad
#define WM_KEYDOWN                0x0100
#define WM_KEYFIRST               WM_KEYDOWN
#define WM_KEYUP                  0x0101
#define WM_CHAR                   0x0102
#define WM_DEADCHAR               0x0103
#define WM_SYSKEYDOWN             0x0104
#define WM_SYSKEYUP               0x0105
#define WM_SYSCHAR                0x0106
#define WM_SYSDEADCHAR            0x0107
#define WM_KEYLAST                0x0108
#define WM_IME_STARTCOMPOSITION   0x010d
#define WM_IME_ENDCOMPOSITION     0x010e
#define WM_IME_COMPOSITION        0x010f
#define WM_IME_KEYLAST            WM_IME_COMPOSITION
#define WM_INITDIALOG             0x0110
#define WM_COMMAND                0x0111
#define WM_SYSCOMMAND             0x0112
#define WM_TIMER                  0x0113
#define WM_HSCROLL                0x0114
#define WM_VSCROLL                0x0115
#define WM_INITMENU               0x0116
#define WM_INITMENUPOPUP          0x0117
#define WM_SYSTIMER               0x0118
#define WM_MENUSELECT             0x011f
#define WM_MENUCHAR               0x0120
#define WM_ENTERIDLE              0x0121
#define WM_MENURBUTTONUP          0x0122
#define WM_MENUDRAG               0x0123
#define WM_MENUGETOBJECT          0x0124
#define WM_UNINITMENUPOPUP        0x0125
#define WM_MENUCOMMAND            0x0126
#define WM_CHANGEUISTATE          0x0127
#define WM_UPDATEUISTATE          0x0128
#define WM_QUERYUISTATE           0x0129
#define WM_LBTRACKPOINT           0x0131
#define WM_CTLCOLORMSGBOX         0x0132
#define WM_CTLCOLOREDIT           0x0133
#define WM_CTLCOLORLISTBOX        0x0134
#define WM_CTLCOLORBTN            0x0135
#define WM_CTLCOLORDLG            0x0136
#define WM_CTLCOLORSCROLLBAR      0x0137
#define WM_CTLCOLORSTATIC         0x0138
#define WM_MOUSEMOVE              0x0200
#define WM_MOUSEFIRST             WM_MOUSEMOVE
#define WM_LBUTTONDOWN            0x0201
#define WM_LBUTTONUP              0x0202
#define WM_LBUTTONDBLCLK          0x0203
#define WM_RBUTTONDOWN            0x0204
#define WM_RBUTTONUP              0x0205
#define WM_RBUTTONDBLCLK          0x0206
#define WM_MBUTTONDOWN            0x0207
#define WM_MBUTTONUP              0x0208
#define WM_MBUTTONDBLCLK          0x0209
#define WM_MOUSEWHEEL             0x020a
#define WM_XBUTTONDOWN            0x020b
#define WM_XBUTTONUP              0x020c
#define WM_XBUTTONDBLCLK          0x020d
#define WM_MOUSELAST              0x020d
#define WM_PARENTNOTIFY           0x0210
#define WM_ENTERMENULOOP          0x0211
#define WM_EXITMENULOOP           0x0212
#define WM_NEXTMENU               0x0213
#define WM_SIZING                 0x0214
#define WM_CAPTURECHANGED         0x0215
#define WM_MOVING                 0x0216
#define WM_POWERBROADCAST         0x0218
#define WM_DEVICECHANGE           0x0219
#define WM_MDICREATE              0x0220
#define WM_MDIDESTROY             0x0221
#define WM_MDIACTIVATE            0x0222
#define WM_MDIRESTORE             0x0223
#define WM_MDINEXT                0x0224
#define WM_MDIMAXIMIZE            0x0225
#define WM_MDITILE                0x0226
#define WM_MDICASCADE             0x0227
#define WM_MDIICONARRANGE         0x0228
#define WM_MDIGETACTIVE           0x0229
#define WM_MDIREFRESHMENU         0x0234
#define WM_DROPOBJECT             0x022a
#define WM_QUERYDROPOBJECT        0x022b
#define WM_BEGINDRAG              0x022c
#define WM_DRAGLOOP               0x022d
#define WM_DRAGSELECT             0x022e
#define WM_DRAGMOVE               0x022f
#define WM_MDISETMENU             0x0230
#define WM_ENTERSIZEMOVE          0x0231
#define WM_EXITSIZEMOVE           0x0232
#define WM_DROPFILES              0x0233
#define WM_IME_SETCONTEXT         0x0281
#define WM_IME_NOTIFY             0x0282
#define WM_IME_CONTROL            0x0283
#define WM_IME_COMPOSITIONFULL    0x0284
#define WM_IME_SELECT             0x0285
#define WM_IME_CHAR               0x0286
#define WM_IME_REQUEST            0x0288
#define WM_IME_KEYDOWN            0x0290
#define WM_IME_KEYUP              0x0291
#define WM_CUT                    0x0300
#define WM_COPY                   0x0301
#define WM_PASTE                  0x0302
#define WM_CLEAR                  0x0303
#define WM_UNDO                   0x0304
#define WM_RENDERFORMAT           0x0305
#define WM_RENDERALLFORMATS       0x0306
#define WM_DESTROYCLIPBOARD       0x0307
#define WM_DRAWCLIPBOARD          0x0308
#define WM_PAINTCLIPBOARD         0x0309
#define WM_VSCROLLCLIPBOARD       0x030a
#define WM_SIZECLIPBOARD          0x030b
#define WM_ASKCBFORMATNAME        0x030c
#define WM_CHANGECBCHAIN          0x030d
#define WM_HSCROLLCLIPBOARD       0x030e
#define WM_QUERYNEWPALETTE        0x030f
#define WM_PALETTEISCHANGING      0x0310
#define WM_PALETTECHANGED         0x0311
#define WM_HOTKEY                 0x0312
#define WM_PRINT                  0x0317
#define WM_PRINTCLIENT            0x0318
#define WM_THEMECHANGED           0x031a
#define WM_PENWINFIRST            0x0380
#define WM_PENWINLAST             0x038f
#define WM_USER                   0x0400
#define WM_APP                    0x8000
  /* en:WM_NOTIFY */
#include "pshpack1.h"
typedef struct _NMHDR
{
  HWND hwndFrom;
  UINT_PTR idFrom;
  UINT code;
} NMHDR, *PNMHDR, *LPNMHDR;
#include "poppack.h"
  /* en:WM_[LMR]BUTTONDBLCLK/WM_[LMR]BUTTONDOWN/WM_[LMR]BUTTONUP */
#define MK_LBUTTON  0x0001
#define MK_RBUTTON  0x0002
#define MK_SHIFT    0x0004
#define MK_CONTROL  0x0008
#define MK_MBUTTON  0x0010
  /* ja:マウスメッセージ */
#define XBUTTON1 0x0001
#define XBUTTON2 0x0002
#define WHEEL_DELTA      120
#define WHEEL_PAGESCROLL (UINT_MAX)
#define GET_WHEEL_DELTA_WPARAM(wParam) ((SHORT)HIWORD(wParam))
  /* en:WM_MOVING/WM_SIZING wParam */
#define WMSZ_LEFT        1
#define WMSZ_RIGHT       2
#define WMSZ_TOP         3
#define WMSZ_TOPLEFT     4
#define WMSZ_TOPRIGHT    5
#define WMSZ_BOTTOM      6
#define WMSZ_BOTTOMLEFT  7
#define WMSZ_BOTTOMRIGHT 8
  /* en:WM_SIZE wParam */
#define SIZE_RESTORED  0
#define SIZE_MINIMIZED 1
#define SIZE_MAXIMIZED 2
#define SIZE_MAXSHOW   3
#define SIZE_MAXHIDE   4
  /* en:WM_POWERBROADCAST wParam */
#define PBT_APMQUERYSUSPEND       0x0000
#define PBT_APMQUERYSTANDBY       0x0001
#define PBT_APMQUERYSUSPENDFAILED 0x0002
#define PBT_APMQUERYSTANDBYFAILED 0x0003
#define PBT_APMSUSPEND            0x0004
#define PBT_APMSTANDBY            0x0005
#define PBT_APMRESUMECRITICAL     0x0006
#define PBT_APMRESUMESUSPEND      0x0007
#define PBT_APMRESUMESTANDBY      0x0008
#define PBT_APMBATTERYLOW         0x0009
#define PBT_APMPOWERSTATUSCHANGE  0x000a
#define PBT_APMOEMEVENT           0x000b
#define PBT_APMRESUMEAUTOMATIC    0x0012
  /* en:WM_H/VSCROLL */
#define SB_LINEUP        0
#define SB_LINELEFT      0
#define SB_LINEDOWN      1
#define SB_LINERIGHT     1
#define SB_PAGEUP        2
#define SB_PAGELEFT      2
#define SB_PAGEDOWN      3
#define SB_PAGERIGHT     3
#define SB_THUMBPOSITION 4
#define SB_THUMBTRACK    5
#define SB_TOP           6
#define SB_LEFT          6
#define SB_BOTTOM        7
#define SB_RIGHT         7
#define SB_ENDSCROLL     8
  /* ja:スクロールバー */
#define SB_HORZ 0
#define SB_VERT 1
#define SB_CTL  2
#define SB_BOTH 3
  /* ja:WM_SYSCOMMANDパラメータ */
#define SC_SIZE         0xf000
#define SC_MOVE         0xf010
#define SC_MINIMIZE     0xf020
#define SC_MAXIMIZE     0xf030
#define SC_NEXTWINDOW   0xf040
#define SC_PREVWINDOW   0xf050
#define SC_CLOSE        0xf060
#define SC_VSCROLL      0xf070
#define SC_HSCROLL      0xf080
#define SC_MOUSEMENU    0xf090
#define SC_KEYMENU      0xf100
#define SC_ARRANGE      0xf110
#define SC_RESTORE      0xf120
#define SC_TASKLIST     0xf130
#define SC_SCREENSAVE   0xf140
#define SC_HOTKEY       0xf150
#define SC_DEFAULT      0xf160
#define SC_MONITORPOWER 0xf170
#define SC_CONTEXTHELP  0xf180
#define SC_SEPARATOR    0xf00f
#define SC_ICON         SC_MINIMIZE
#define SC_ZOOM         SC_MAXIMIZE
/* ja:ダイアログ */
#define DialogBoxA(a,b,c,d) DialogBoxParamA(a,b,c,d,0)
#define DialogBoxW(a,b,c,d) DialogBoxParamW(a,b,c,d,0)
#ifdef UNICODE
# define DialogBox(a,b,c,d) DialogBoxParamW(a,b,c,d,0)
#else /* not UNICODE */
# define DialogBox(a,b,c,d) DialogBoxParamA(a,b,c,d,0)
#endif /* not UNICODE */
#define DS_ABSALIGN      0x0001
#define DS_SYSMODAL      0x0002
#define DS_3DLOOK        0x0004
#define DS_FIXEDSYS      0x0008
#define DS_NOFAILCREATE  0x0010
#define DS_LOCALEDIT     0x0020
#define DS_SETFONT       0x0040
#define DS_MODALFRAME    0x0080
#define DS_NOIDLEMSG     0x0100
#define DS_SETFOREGROUND 0x0200
#define DS_CONTROL       0x0400
#define DS_CENTER        0x0800
#define DS_CENTERMOUSE   0x1000
#define DS_CONTEXTHELP   0x2000
#define DS_USEPIXELS     0x8000
#define DS_SHELLFONT     (DS_SETFONT|DS_FIXEDSYS)
#define DM_GETDEFID      (WM_USER+0)
#define DM_SETDEFID      (WM_USER+1)
#define DM_REPOSITION    (WM_USER+2)
#define DC_HASDEFID      0x534b
#include "pshpack2.h"
typedef struct _DLGTEMPLATE
{
  DWORD style;
  DWORD exstyle;
  WORD cdit;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
} DLGTEMPLATE, *PDLGTEMPLATE, *LPDLGTEMPLATE;
typedef CONST DLGTEMPLATE *PCDLGTEMPLATE, *LPCDLGTEMPLATE;
typedef struct _DLGITEMTEMPLATE
{
  DWORD style;
  DWORD exstyle;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
  WORD ID;
} DLGITEMTEMPLATE, *PDLGITEMTEMPLATE, *LPDLGITEMTEMPLATE;
typedef CONST DLGITEMTEMPLATE *PCDLGITEMTEMPLATE, *LCPDLGITEMTEMPLATE;
typedef struct _DLGTEMPLATEEX
{
  WORD dlgVer;
  WORD signature;
  DWORD helpID;
  DWORD exstyle;
  DWORD style;
  WORD cdit;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
} DLGTEMPLATEEX, *PDLGTEMPLATEEX, *LPDLGTEMPLATEEX;
typedef CONST DLGTEMPLATEEX *PCDLGTEMPLATEEX, *LPCDLGTEMPLATEEX;
typedef struct _DLGITEMTEMPLATEEX
{
  DWORD helpID;
  DWORD exstyle;
  DWORD style;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
  WORD ID;
} DLGITEMTEMPLATEEX, *PDLGITEMTEMPLATEEX, *LPDLGITEMTEMPLATEEX;
typedef CONST DLGITEMTEMPLATEEX *PCDLGITEMTEMPLATEEX, *LPCDLGITEMTEMPLATEEX;
#include "poppack.h"
/* ja:ボタンコントロール */
#define BS_PUSHBUTTON          0x00000000
#define BS_DEFPUSHBUTTON       0x00000001
#define BS_CHECKBOX            0x00000002
#define BS_AUTOCHECKBOX        0x00000003
#define BS_RADIOBUTTON         0x00000004
#define BS_3STATE              0x00000005
#define BS_AUTO3STATE          0x00000006
#define BS_GROUPBOX            0x00000007
#define BS_USERBUTTON          0x00000008
#define BS_AUTORADIOBUTTON     0x00000009
#define BS_OWNERDRAW           0x0000000b
#define BS_TYPEMASK            0x0000000f
#define BS_LEFTTEXT            0x00000020
#define BS_RIGHTBUTTON         BS_LEFTTEXT
#define BS_TEXT                0x00000000L
#define BS_ICON                0x00000040
#define BS_BITMAP              0x00000080
#define BS_LEFT                0x00000100
#define BS_RIGHT               0x00000200
#define BS_CENTER              0x00000300
#define BS_TOP                 0x00000400
#define BS_BOTTOM              0x00000800
#define BS_VCENTER             0x00000c00
#define BS_PUSHLIKE            0x00001000
#define BS_MULTILINE           0x00002000
#define BS_NOTIFY              0x00004000
#define BS_FLAT                0x00008000
#define BM_GETCHECK            0x00f0
#define BM_SETCHECK            0x00f1
#define BM_GETSTATE            0x00f2
#define BM_SETSTATE            0x00f3
#define BM_SETSTYLE            0x00f4
#define BM_CLICK               0x00f5
#define BM_GETIMAGE            0x00f6
#define BM_SETIMAGE            0x00f7
#define BN_CLICKED             0
#define BN_PAINT               1
#define BN_HILITE              2
#define BN_PUSHED              BN_HILITE
#define BN_UNHILITE            3
#define BN_UNPUSHED            BN_UNHILITE
#define BN_DISABLE             4
#define BN_DOUBLECLICKED       5
#define BN_DBLCLK              BN_DOUBLECLICKED
#define BN_SETFOCUS            6
#define BN_KILLFOCUS           7
#define BST_UNCHECKED          0x0000
#define BST_CHECKED            0x0001
#define BST_INDETERMINATE      0x0002
#define BST_PUSHED             0x0004
#define BST_FOCUS              0x0008
/* ja:コンボボックスコントロール */
#define CBS_SIMPLE               0x0001
#define CBS_DROPDOWN             0x0002
#define CBS_DROPDOWNLIST         0x0003
#define CBS_OWNERDRAWFIXED       0x0010
#define CBS_OWNERDRAWVARIABLE    0x0020
#define CBS_AUTOHSCROLL          0x0040
#define CBS_OEMCONVERT           0x0080
#define CBS_SORT                 0x0100
#define CBS_HASSTRINGS           0x0200
#define CBS_NOINTEGRALHEIGHT     0x0400
#define CBS_DISABLENOSCROLL      0x0800
#define CBS_UPPERCASE            0x2000
#define CBS_LOWERCASE            0x4000
#define CB_GETEDITSEL            0x0140
#define CB_LIMITTEXT             0x0141
#define CB_SETEDITSEL            0x0142
#define CB_ADDSTRING             0x0143
#define CB_DELETESTRING          0x0144
#define CB_DIR                   0x0145
#define CB_GETCOUNT              0x0146
#define CB_GETCURSEL             0x0147
#define CB_GETLBTEXT             0x0148
#define CB_GETLBTEXTLEN          0x0149
#define CB_INSERTSTRING          0x014a
#define CB_RESETCONTENT          0x014b
#define CB_FINDSTRING            0x014c
#define CB_SELECTSTRING          0x014d
#define CB_SETCURSEL             0x014e
#define CB_SHOWDROPDOWN          0x014f
#define CB_GETITEMDATA           0x0150
#define CB_SETITEMDATA           0x0151
#define CB_GETDROPPEDCONTROLRECT 0x0152
#define CB_SETITEMHEIGHT         0x0153
#define CB_GETITEMHEIGHT         0x0154
#define CB_SETEXTENDEDUI         0x0155
#define CB_GETEXTENDEDUI         0x0156
#define CB_GETDROPPEDSTATE       0x0157
#define CB_FINDSTRINGEXACT       0x0158
#define CB_SETLOCALE             0x0159
#define CB_GETLOCALE             0x015a
#define CB_GETTOPINDEX           0x015b
#define CB_SETTOPINDEX           0x015c
#define CB_GETHORIZONTALEXTENT   0x015d
#define CB_SETHORIZONTALEXTENT   0x015e
#define CB_GETDROPPEDWIDTH       0x015f
#define CB_SETDROPPEDWIDTH       0x0160
#define CB_INITSTORAGE           0x0161
#define CB_MULTIPLEADDSTRING     0x0163
#define CB_GETCOMBOBOXINFO       0x0164
#define CB_MSGMAX                0x0165
#define CBN_ERRSPACE             (-1)
#define CBN_SELCHANGE            1
#define CBN_DBLCLK               2
#define CBN_SETFOCUS             3
#define CBN_KILLFOCUS            4
#define CBN_EDITCHANGE           5
#define CBN_EDITUPDATE           6
#define CBN_DROPDOWN             7
#define CBN_CLOSEUP              8
#define CBN_SELENDOK             9
#define CBN_SELENDCANCEL         10
#define CB_OKAY                  0
#define CB_ERR                   (-1)
#define CB_ERRSPACE              (-2)
/* ja:エディトリストコントロール */
#define ES_LEFT                0x0000
#define ES_CENTER              0x0001
#define ES_RIGHT               0x0002
#define ES_MULTILINE           0x0004
#define ES_UPPERCASE           0x0008
#define ES_LOWERCASE           0x0010
#define ES_PASSWORD            0x0020
#define ES_AUTOVSCROLL         0x0040
#define ES_AUTOHSCROLL         0x0080
#define ES_NOHIDESEL           0x0100
#define ES_OEMCONVERT          0x0400
#define ES_READONLY            0x0800
#define ES_WANTRETURN          0x1000
#define ES_NUMBER              0x2000
#define EM_GETSEL              0x00b0
#define EM_SETSEL              0x00b1
#define EM_GETRECT             0x00b2
#define EM_SETRECT             0x00b3
#define EM_SETRECTNP           0x00b4
#define EM_SCROLL              0x00b5
#define EM_LINESCROLL          0x00b6
#define EM_SCROLLCARET         0x00b7
#define EM_GETMODIFY           0x00b8
#define EM_SETMODIFY           0x00b9
#define EM_GETLINECOUNT        0x00ba
#define EM_LINEINDEX           0x00bb
#define EM_SETHANDLE           0x00bc
#define EM_GETHANDLE           0x00bd
#define EM_GETTHUMB            0x00be
#define EM_LINELENGTH          0x00c1
#define EM_REPLACESEL          0x00c2
#define EM_GETLINE             0x00c4
#define EM_LIMITTEXT           0x00c5
#define EM_CANUNDO             0x00c6
#define EM_UNDO                0x00c7
#define EM_FMTLINES            0x00c8
#define EM_LINEFROMCHAR        0x00c9
#define EM_SETTABSTOPS         0x00cb
#define EM_SETPASSWORDCHAR     0x00cc
#define EM_EMPTYUNDOBUFFER     0x00cd
#define EM_GETFIRSTVISIBLELINE 0x00ce
#define EM_SETREADONLY         0x00cf
#define EM_SETWORDBREAKPROC    0x00d0
#define EM_GETWORDBREAKPROC    0x00d1
#define EM_GETPASSWORDCHAR     0x00d2
#define EM_SETMARGINS          0x00d3
#define EM_GETMARGINS          0x00d4
#define EM_SETLIMITTEXT        EM_LIMITTEXT
#define EM_GETLIMITTEXT        0x00d5
#define EM_POSFROMCHAR         0x00d6
#define EM_CHARFROMPOS         0x00d7
#define EM_SETIMESTATUS        0x00d8
#define EM_GETIMESTATUS        0x00d9
#define EN_SETFOCUS            0x0100
#define EN_KILLFOCUS           0x0200
#define EN_CHANGE              0x0300
#define EN_UPDATE              0x0400
#define EN_ERRSPACE            0x0500
#define EN_MAXTEXT             0x0501
#define EN_HSCROLL             0x0601
#define EN_VSCROLL             0x0602
#define EN_ALIGN_LTR_EC        0x0700
#define EN_ALIGN_RTL_EC        0x0701
#define EC_LEFTMARGIN          0x0001
#define EC_RIGHTMARGIN         0x0002
#define EC_USEFONTINFO         0xffff
/* ja:リストコントロール */
#define LBS_NOTIFY             0x0001
#define LBS_SORT               0x0002
#define LBS_NOREDRAW           0x0004
#define LBS_MULTIPLESEL        0x0008
#define LBS_OWNERDRAWFIXED     0x0010
#define LBS_OWNERDRAWVARIABLE  0x0020
#define LBS_HASSTRINGS         0x0040
#define LBS_USETABSTOPS        0x0080
#define LBS_NOINTEGRALHEIGHT   0x0100
#define LBS_MULTICOLUMN        0x0200
#define LBS_WANTKEYBOARDINPUT  0x0400
#define LBS_EXTENDEDSEL        0x0800
#define LBS_DISABLENOSCROLL    0x1000
#define LBS_NODATA             0x2000
#define LBS_NOSEL              0x4000
#define LBS_COMBOBOX           0x8000
#define LBS_STANDARD           (LBS_NOTIFY|LBS_SORT|WS_VSCROLL|WS_BORDER)
#define LB_ADDSTRING           0x0180
#define LB_INSERTSTRING        0x0181
#define LB_DELETESTRING        0x0182
#define LB_SELITEMRANGEEX      0x0183
#define LB_RESETCONTENT        0x0184
#define LB_SETSEL              0x0185
#define LB_SETCURSEL           0x0186
#define LB_GETSEL              0x0187
#define LB_GETCURSEL           0x0188
#define LB_GETTEXT             0x0189
#define LB_GETTEXTLEN          0x018a
#define LB_GETCOUNT            0x018b
#define LB_SELECTSTRING        0x018c
#define LB_DIR                 0x018d
#define LB_GETTOPINDEX         0x018e
#define LB_FINDSTRING          0x018f
#define LB_GETSELCOUNT         0x0190
#define LB_GETSELITEMS         0x0191
#define LB_SETTABSTOPS         0x0192
#define LB_GETHORIZONTALEXTENT 0x0193
#define LB_SETHORIZONTALEXTENT 0x0194
#define LB_SETCOLUMNWIDTH      0x0195
#define LB_ADDFILE             0x0196
#define LB_SETTOPINDEX         0x0197
#define LB_GETITEMRECT         0x0198
#define LB_GETITEMDATA         0x0199
#define LB_SETITEMDATA         0x019a
#define LB_SELITEMRANGE        0x019b
#define LB_SETANCHORINDEX      0x019c
#define LB_GETANCHORINDEX      0x019d
#define LB_SETCARETINDEX       0x019e
#define LB_GETCARETINDEX       0x019f
#define LB_SETITEMHEIGHT       0x01a0
#define LB_GETITEMHEIGHT       0x01a1
#define LB_FINDSTRINGEXACT     0x01a2
#define LB_SETLOCALE           0x01a5
#define LB_GETLOCALE           0x01a6
#define LB_SETCOUNT            0x01a7
#define LB_INITSTORAGE         0x01a8
#define LB_ITEMFROMPOINT       0x01a9
#define LB_MSGMAX              0x01b0
#define LB_MULTIPLEADDSTRING   0x01b1
#define LB_GETLISTBOXINFO      0x01b2
#define LBN_ERRSPACE           (-2)
#define LBN_SELCHANGE          1
#define LBN_DBLCLK             2
#define LBN_SELCANCEL          3
#define LBN_SETFOCUS           4
#define LBN_KILLFOCUS          5
#define LB_OKAY                0
#define LB_ERR                 (-1)
#define LB_ERRSPACE            (-2)
/* ja:スタティックコントロール */
#define SS_LEFT            0x00000000
#define SS_CENTER          0x00000001
#define SS_RIGHT           0x00000002
#define SS_ICON            0x00000003
#define SS_BLACKRECT       0x00000004
#define SS_GRAYRECT        0x00000005
#define SS_WHITERECT       0x00000006
#define SS_BLACKFRAME      0x00000007
#define SS_GRAYFRAME       0x00000008
#define SS_WHITEFRAME      0x00000009
#define SS_USERITEM        0x0000000a
#define SS_SIMPLE          0x0000000b
#define SS_LEFTNOWORDWRAP  0x0000000c
#define SS_OWNERDRAW       0x0000000d
#define SS_BITMAP          0x0000000e
#define SS_ENHMETAFILE     0x0000000f
#define SS_ETCHEDHORZ      0x00000010
#define SS_ETCHEDVERT      0x00000011
#define SS_ETCHEDFRAME     0x00000012
#define SS_TYPEMASK        0x0000001f
#define SS_REALSIZECONTROL 0x00000040
#define SS_NOPREFIX        0x00000080
#define SS_NOTIFY          0x00000100
#define SS_CENTERIMAGE     0x00000200
#define SS_RIGHTJUST       0x00000400
#define SS_REALSIZEIMAGE   0x00000800
#define SS_SUNKEN          0x00001000
#define SS_EDITCONTROL     0x00002000
#define SS_ENDELLIPSIS     0x00004000
#define SS_PATHELLIPSIS    0x00008000
#define SS_WORDELLIPSIS    0x0000c000
#define SS_ELLIPSISMASK    0x0000c000
#define STM_SETICON        0x0170
#define STM_GETICON        0x0171
#define STM_SETIMAGE       0x0172
#define STM_GETIMAGE       0x0173
#define STM_MSGMAX         0x0174
#define STN_CLICKED        0
#define STN_DBLCLK         1
#define STN_ENABLE         2
#define STN_DISABLE        3
/* ja:スクロールバーコントロール */
#define SBS_HORZ                    0x0000
#define SBS_VERT                    0x0001
#define SBS_TYPEMASK                0x0001
#define SBS_TOPALIGN                0x0002
#define SBS_LEFTALIGN               0x0002
#define SBS_BOTTOMALIGN             0x0004
#define SBS_RIGHTALIGN              0x0004
#define SBS_SIZEBOXTOPLEFTALIGN     0x0002
#define SBS_SIZEBOXBOTTOMRIGHTALIGN 0x0004
#define SBS_SIZEBOX                 0x0008
#define SBS_SIZEGRIP                0x0010
#define SBM_SETPOS                  0x00e0
#define SBM_GETPOS                  0x00e1
#define SBM_SETRANGE                0x00e2
#define SBM_GETRANGE                0x00e3
#define SBM_ENABLE_ARROWS           0x00e4
#define SBM_SETRANGEREDRAW          0x00e6
#define SBM_SETSCROLLINFO           0x00e9
#define SBM_GETSCROLLINFO           0x00ea
#define SBM_GETSCROLLBARINFO        0x00eb
/* ja:メッセージボックス */
#define MB_OK                   0x00000000
#define MB_OKCANCEL             0x00000001
#define MB_ABORTRETRYIGNORE     0x00000002
#define MB_YESNOCANCEL          0x00000003
#define MB_YESNO                0x00000004
#define MB_RETRYCANCEL          0x00000005
#define MB_TYPEMASK             0x0000000F
#define MB_ICONHAND             0x00000010
#define MB_ICONQUESTION         0x00000020
#define MB_ICONEXCLAMATION      0x00000030
#define MB_ICONASTERISK         0x00000040
#define MB_USERICON             0x00000080
#define MB_ICONMASK             0x000000F0
#define MB_ICONINFORMATION      MB_ICONASTERISK
#define MB_ICONSTOP             MB_ICONHAND
#define MB_ICONWARNING          MB_ICONEXCLAMATION
#define MB_ICONERROR            MB_ICONHAND
#define MB_DEFBUTTON1           0x00000000
#define MB_DEFBUTTON2           0x00000100
#define MB_DEFBUTTON3           0x00000200
#define MB_DEFBUTTON4           0x00000300
#define MB_DEFMASK              0x00000f00
#define MB_APPLMODAL            0x00000000
#define MB_SYSTEMMODAL          0x00001000
#define MB_TASKMODAL            0x00002000
#define MB_MODEMASK             0x00003000
#define MB_HELP                 0x00004000
#define MB_NOFOCUS              0x00008000
#define MB_MISCMASK             0x0000C000
#define MB_SETFOREGROUND        0x00010000
#define MB_DEFAULT_DESKTOP_ONLY 0x00020000
#define MB_SERVICE_NOTIFICATION 0x00040000
#define MB_TOPMOST              0x00040000
#define MB_RIGHT                0x00080000
#define MB_RTLREADING           0x00100000
/* ID */
#define IDOK       1
#define IDCANCEL   2
#define IDABORT    3
#define IDRETRY    4
#define IDIGNORE   5
#define IDYES      6
#define IDNO       7
#define IDCLOSE    8
#define IDHELP     9
#define IDTRYAGAIN 10
#define IDCONTINUE 11


extern W32LdrExport user32_exports[];


HDC WINAPI BeginPaint (HWND hWnd, LPPAINTSTRUCT lpPaint);
LPSTR WINAPI CharLowerA (LPSTR lpsz);
LPWSTR WINAPI CharLowerW (LPWSTR lpsz);
LPSTR WINAPI CharUpperA (LPSTR lpsz);
LPWSTR WINAPI CharUpperW (LPWSTR lpsz);
BOOL WINAPI CheckDlgButton (HWND hDlg, INT nIDButton, UINT uCheck);
BOOL WINAPI CheckRadioButton (HWND hDlg, INT nIDFirstButton, INT nIDLastButton, INT nIDCheckButton);
LRESULT WINAPI DefWindowProcA (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI DefWindowProcW (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
BOOL WINAPI DestroyWindow (HWND hWnd);
INT WINAPI DialogBoxIndirectParamA (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
INT WINAPI DialogBoxIndirectParamW (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
INT WINAPI DialogBoxParamA (HINSTANCE hInstance, LPCSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
INT WINAPI DialogBoxParamW (HINSTANCE hInstance, LPCWSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
BOOL WINAPI EnableWindow (HWND hWnd, BOOL bEnable);
BOOL WINAPI EndDialog (HWND hDlg, INT nResult);
BOOL WINAPI EndPaint (HWND hWnd, LPPAINTSTRUCT lpPaint);
BOOL WINAPI EnumThreadWindows (DWORD dwThreadId, WNDENUMPROC lpfn, LPARAM lParam);
BOOL WINAPI GetClientRect (HWND hWnd, LPRECT lpRect);
HDC WINAPI GetDC (HWND hWnd);
HWND WINAPI GetDesktopWindow (VOID);
INT WINAPI GetDlgCtrlID (HWND hWndCtl);
HWND WINAPI GetDlgItem (HWND hDlg, INT nIDDlgItem);
UINT WINAPI GetDlgItemInt (HWND hDlg, INT nIDDlgItem, BOOL *lpTranslated, BOOL bSigned);
HWND WINAPI GetFocus (VOID);
INT WINAPI GetKeyboardType (INT nTypeFlag);
INT WINAPI GetScrollPos (HWND hWnd, INT nBar);
BOOL WINAPI GetScrollRange (HWND hWnd, INT nBar, LPINT lpMinPos, LPINT lpMaxPos);
DWORD WINAPI GetSysColor (int nIndex);
INT WINAPI GetSystemMetrics (INT nIndex);
LONG WINAPI GetWindowLongA (HWND hWnd, INT nIndex);
LONG WINAPI GetWindowLongW (HWND hWnd, INT nIndex);
BOOL WINAPI GetWindowRect (HWND hWnd, LPRECT lpRect);
INT WINAPI GetWindowTextA (HWND hWnd, LPSTR lpString, INT nMaxCount);
INT WINAPI GetWindowTextW (HWND hWnd, LPWSTR lpString, INT nMaxCount);
BOOL WINAPI InvalidateRect (HWND hWnd, CONST RECT *lpRect, BOOL bErase);
UINT WINAPI IsDlgButtonChecked (HWND hDlg, INT nIDButton);
BOOL WINAPI IsRectEmpty (CONST RECT *lprc);
HBITMAP WINAPI LoadBitmapA (HINSTANCE hInstance, LPCSTR lpBitmapName);
HBITMAP WINAPI LoadBitmapW (HINSTANCE hInstance, LPCWSTR lpBitmapName);
INT WINAPI LoadStringA (HINSTANCE hInstance, UINT uID, LPSTR lpBuffer, INT nBufferMax);
INT WINAPI LoadStringW (HINSTANCE hInstance, UINT uID, LPWSTR lpBuffer, INT nBufferMax);
INT WINAPI MapWindowPoints (HWND hWndFrom, HWND hWndTo, LPPOINT lpPoints, UINT cPoints);
BOOL WINAPI MessageBeep (UINT uType);
INT WINAPI MessageBoxA (HWND hWnd, LPCSTR lpText, LPCSTR lpCaption, UINT uType);
INT WINAPI MessageBoxExA (HWND hWnd, LPCSTR lpText, LPCSTR lpCaption, UINT uType, WORD wLanguageId);
INT WINAPI MessageBoxExW (HWND hWnd, LPCWSTR lpText, LPCWSTR lpCaption, UINT uType, WORD wLanguageId);
INT WINAPI MessageBoxW (HWND hWnd, LPCWSTR lpText, LPCWSTR lpCaption, UINT uType);
BOOL WINAPI MoveWindow (HWND hWnd, INT X, INT Y, INT nWidth, INT nHeight, BOOL bRepaint);
BOOL WINAPI OffsetRect (LPRECT lprc, INT dx, INT dy);
INT WINAPI ReleaseDC (HWND hWnd, HDC hDC);
BOOL WINAPI ScreenToClient (HWND hWnd, LPPOINT lpPoint);
LONG WINAPI SendDlgItemMessageA (HWND hDlg, INT nIDDlgItem, UINT Msg, WPARAM wParam, LPARAM lParam);
LONG WINAPI SendDlgItemMessageW (HWND hDlg, INT nIDDlgItem, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI SendMessageA (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI SendMessageW (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
BOOL WINAPI SetDlgItemInt (HWND hDlg, INT nIDDlgItem, UINT uValue, BOOL bSigned);
BOOL WINAPI SetDlgItemTextW (HWND hDlg, INT nIDDlgItem, LPCWSTR lpString);
HWND WINAPI SetFocus (HWND hWnd);
INT WINAPI SetScrollPos (HWND hWnd, INT nBar, INT nPos, BOOL bRedraw);
BOOL WINAPI SetScrollRange (HWND hWnd, INT nBar, INT nMinPos, INT nMaxPos, BOOL bRedraw);
LONG WINAPI SetWindowLongA (HWND hWnd, INT nIndex, LONG dwNewLong);
LONG WINAPI SetWindowLongW (HWND hWnd, INT nIndex, LONG dwNewLong);
BOOL WINAPI SetWindowPos (HWND hWnd, HWND hWndInsertAfter, INT X, INT Y, INT cx, INT cy, UINT uFlags);
BOOL WINAPI SetWindowTextA (HWND hWnd, LPCSTR lpString);
BOOL WINAPI SetWindowTextW (HWND hWnd, LPCWSTR lpString);
BOOL WINAPI ShowWindow (HWND hWnd, INT nCmdShow);
BOOL WINAPI SystemParametersInfoA (UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni);
BOOL WINAPI SystemParametersInfoW (UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni);
BOOL WINAPI WinHelpA (HWND hWndMain, LPCSTR lpszHelp, UINT uCommand, DWORD dwData);
BOOL WINAPI WinHelpW (HWND hWndMain, LPCWSTR lpszHelp, UINT uCommand, DWORD dwData);
INT WINAPIV wsprintfA (LPSTR lpOutput, LPCSTR lpFormat, ...);
INT WINAPIV wsprintfW (LPWSTR lpOutput, LPCWSTR lpFormat, ...);
INT WINAPI wvsprintfA (LPSTR lpOutput, LPCSTR lpFormat, va_list arglist);
INT WINAPI wvsprintfW (LPSTR lpOutput, LPCSTR lpFormat, va_list arglist);


#ifdef UNICODE
# define CharLower CharLowerW
# define CharUpper CharUpperW
# define DefWindowProc DefWindowProcW
# define DialogBoxIndirectParam DialogBoxIndirectParamW
# define DialogBoxParam DialogBoxParamW
# define GetWindowLong GetWindowLongW
# define GetWindowText GetWindowTextW
# define LoadBitmap LoadBitmapW
# define LoadString LoadStringW
# define MessageBox MessageBoxW
# define MessageBoxEx MessageBoxExW
# define SendDlgItemMessage SendDlgItemMessageW
# define SendMessage SendMessageW
# define SetWindowLong SetWindowLongW
# define SetWindowText SetWindowTextW
# define SystemParametersInfo SystemParametersInfoW
# define WinHelp WinHelpW
# define wsprintf wsprintfW
# define wvsprintf wvsprintfW
#else /* not UNICODE*/
# define CharLower CharLowerA
# define CharUpper CharUpperA
# define DefWindowProc DefWindowProcA
# define DialogBoxIndirectParam DialogBoxIndirectParamA
# define DialogBoxParam DialogBoxParamA
# define GetWindowLong GetWindowLongA
# define GetWindowText GetWindowTextA
# define LoadBitmap LoadBitmapA
# define LoadString LoadStringA
# define MessageBox MessageBoxA
# define MessageBoxEx MessageBoxExA
# define SendDlgItemMessage SendDlgItemMessageA
# define SendMessage SendMessageA
# define SetWindowLong SetWindowLongA
# define SetWindowText SetWindowTextA
# define SystemParametersInfo SystemParametersInfoA
# define WinHelp WinHelpA
# define wsprintf wsprintfA
# define wvsprintf wvsprintfA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __USER32_H__ */
