/*
    Video maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "keyfile.h"
#include "misc/fileio.h"
#include "misc/profile.h"
#include "orz/orzhistory.h"


/******************************************************************************
*                                                                             *
* ja:キーファイル関数群                                                       *
*                                                                             *
******************************************************************************/
/*  ja:キーファイルから読み込む
    file,ファイル名(NULL:読み込まない)                                      */
void
keyfile_read (const gchar *file)
{
  GKeyFile *key_file;

  key_file = g_key_file_new ();
  if (g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL))
    {
      gchar *utf8str;
      gint i;

      license = g_key_file_get_integer (key_file, "license", "hash", NULL);
      orz_history_set_num (ORZ_HISTORY (history),
                g_key_file_get_integer (key_file, "pref", "history", NULL));
      newfile = g_key_file_get_boolean (key_file, "pref", "newfile", NULL);
      second = g_key_file_get_boolean (key_file, "pref", "second", NULL);
      def_width = g_key_file_get_integer (key_file, "pref", "width", NULL);
      def_height = g_key_file_get_integer (key_file, "pref", "height", NULL);
      n_pos = g_key_file_get_integer (key_file, "pref", "npos", NULL);
      addext = g_key_file_get_boolean (key_file, "vmaid", "addext", NULL);
      default_ratio = g_key_file_get_boolean (key_file, "vmaid", "ratio",
                                                                        NULL);
      file_merge = g_key_file_get_boolean (key_file, "vmaid", "merge", NULL);
      default_view = g_key_file_get_integer (key_file, "vmaid", "view", NULL);
      default_rate = g_key_file_get_integer (key_file, "vmaid", "rate", NULL);
      default_selfrm = g_key_file_get_boolean (key_file, "vmaid", "selfrm",
                                                                        NULL);
      utf8str = g_key_file_get_string (key_file, "vmaid", "openpath", NULL);
      open_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      utf8str = g_key_file_get_string (key_file, "vmaid", "savepath", NULL);
      save_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      /* ja:ファイルの履歴 */
      for (i = orz_history_get_num (ORZ_HISTORY (history)) - 1; i >= 0; i--)
        {
          gchar *key;

          key = g_strdup_printf ("file%d", i);
          utf8str = g_key_file_get_string (key_file, "history", key, NULL);
          g_free (key);
          if (utf8str)
            {
              gchar *file;

              file = g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL);
              g_free (utf8str);
              orz_history_add_file (ORZ_HISTORY (history), file);
              g_free (file);
            }
        }
    }
  g_key_file_free (key_file);
}


/*  ja:キーファイルに書き込む
    file,ファイル名(NULL:書き込まない)                                      */
void
keyfile_write (const gchar *file)
{
  GKeyFile *key_file;

  if (file)
    {
      gsize length;
      gchar *data;
      gint i;
      GList *glist;

      key_file = g_key_file_new ();
      g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
      g_key_file_set_integer (key_file, "license", "hash", license);
      g_key_file_set_integer (key_file, "pref", "history",
                                orz_history_get_num (ORZ_HISTORY (history)));
      g_key_file_set_boolean (key_file, "pref", "newfile", newfile);
      g_key_file_set_boolean (key_file, "pref", "second", second);
      g_key_file_set_integer (key_file, "pref", "width", def_width);
      g_key_file_set_integer (key_file, "pref", "height", def_height);
      g_key_file_set_integer (key_file, "pref", "npos", n_pos);
      g_key_file_set_boolean (key_file, "vmaid", "addext", addext);
      g_key_file_set_boolean (key_file, "vmaid", "ratio", default_ratio);
      g_key_file_set_boolean (key_file, "vmaid", "merge", file_merge);
      g_key_file_set_integer (key_file, "vmaid", "view", default_view);
      g_key_file_set_integer (key_file, "vmaid", "rate", default_rate);
      g_key_file_set_boolean (key_file, "vmaid", "selfrm", default_selfrm);
      if (open_path)
        {
          gchar *utf8str;

          utf8str = g_filename_to_utf8 (open_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "vmaid", "openpath", utf8str);
              g_free (utf8str);
            }
        }
      if (save_path)
        {
          gchar *utf8str;

          utf8str = g_filename_to_utf8 (save_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "vmaid", "savepath", utf8str);
              g_free (utf8str);
            }
        }
      /* ja:ファイルの履歴 */
      glist = orz_history_get_file (ORZ_HISTORY (history));
      for (i = 0; i < g_list_length (glist); i++)
        {
          gchar *key, *utf8str;

          key = g_strdup_printf ("file%d", i);
          utf8str = g_filename_to_utf8 (g_list_nth_data (glist, i), -1,
                                                            NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "history", key, utf8str);
              g_free (utf8str);
            }
          g_free (key);
        }
      g_list_free (glist);
      while (i <= ORZ_HISTORY_NUM_MAX)
        {
          gchar *key;

          key = g_strdup_printf ("file%d", i++);
          g_key_file_remove_key (key_file, "history", key, NULL);
          g_free (key);
        }
      data = g_key_file_to_data (key_file, &length, NULL);
      g_key_file_free (key_file);
      if (data)
        {
          fileio_save (file, data, length);
          g_free (data);
        }
    }
}
