/*
    Video maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __PROPERTY_H__
#define __PROPERTY_H__


#include "vmaid.h"


G_BEGIN_DECLS


typedef struct _PropertyConfig
{
  guint32 rate, scale;
  guint16 priority0, priority1, language0, language1;
  gchar *name0, *name1;
  /* ja:ビデオ固有 */
  gint32 width, height;
  guint16 bit_count;
  gint32 x_pixels_per_meter, y_pixels_per_meter;
  /* ja:オーディオ固有 */
  guint32 samples_per_sec;
  guint16 channels;
  guint16 bits_per_sample;
} PropertyConfig;


/******************************************************************************
*                                                                             *
* ja:プロパティダイアログ関数群                                               *
*                                                                             *
******************************************************************************/
/*  ja:プロパティダイアログ表示
    propcfg,プロパティ構造体
        RET,TRUE:OK,FALSE:Cancel                                            */
gboolean
property_dialog (PropertyConfig *propcfg);


G_END_DECLS


#endif /* __PROPERTY_H__ */
