/*
    w32loader
    copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __COMMCTRL_H__
#define __COMMCTRL_H__


#include "w32ldr.h"


G_BEGIN_DECLS


#include "user32.h"

/* ja:共通 */
#define CLR_NONE    0xffffffff
#define CLR_DEFAULT 0xff000000
#define CLR_HILIGHT CLR_DEFAULT
#define CCS_TOP              0x00000001
#define CCS_NOMOVEY          0x00000002
#define CCS_BOTTOM           0x00000003
#define CCS_NORESIZE         0x00000004
#define CCS_NOPARENTALIGN    0x00000008
#define CCS_ADJUSTABLE       0x00000020
#define CCS_NODIVIDER        0x00000040
#define CCS_VERT             0x00000080
#define CCS_LEFT             (CCS_VERT|CCS_TOP)
#define CCS_RIGHT            (CCS_VERT|CCS_BOTTOM)
#define CCS_NOMOVEX          (CCS_VERT|CCS_NOMOVEY)
#define CCM_FIRST            0x2000
#define CCM_SETBKCOLOR       (CCM_FIRST+1)
#define CCM_SETCOLORSCHEME   (CCM_FIRST+2)
#define CCM_GETCOLORSCHEME   (CCM_FIRST+3)
#define CCM_GETDROPTARGET    (CCM_FIRST+4)
#define CCM_SETUNICODEFORMAT (CCM_FIRST+5)
#define CCM_GETUNICODEFORMAT (CCM_FIRST+6)
#define CCM_SETVERSION       (CCM_FIRST+7)
#define CCM_GETVERSION       (CCM_FIRST+8)
#define CCM_SETNOTIFYWINDOW  (CCM_FIRST+9)
#define CCM_SETWINDOWTHEME   (CCM_FIRST+11)
#define CCM_DPISCALE         (CCM_FIRST+12)
#define NM_FIRST             (0)
#define NM_LAST              (-99)
#define NM_OUTOFMEMORY       (NM_FIRST-1)
#define NM_CLICK             (NM_FIRST-2)
#define NM_DBLCLK            (NM_FIRST-3)
#define NM_RETURN            (NM_FIRST-4)
#define NM_RCLICK            (NM_FIRST-5)
#define NM_RDBLCLK           (NM_FIRST-6)
#define NM_SETFOCUS          (NM_FIRST-7)
#define NM_KILLFOCUS         (NM_FIRST-8)
#include "pshpack1.h"
typedef struct _INITCOMMONCONTROLSEX
{
  DWORD dwSize;
  DWORD dwICC;
} INITCOMMONCONTROLSEX, *PINITCOMMONCONTROLSEX, *LPINITCOMMONCONTROLSEX;
typedef struct _NMHDR
{
  HWND hwndFrom;
  UINT_PTR idFrom;
  UINT code;
} NMHDR, *PNMHDR, *LPNMHDR;
#include "poppack.h"

/* ja:ツールバー */
/* ja:ツールチップ */
#include "w32tool.h"

/* ja:ステータスウインドウ */
#include "w32stat.h"

/* ja:プロパティシート */
#include "w32prsht.h"

/* ja:イメージリスト */
#define ILC_MASK     0x0001
#define ILC_COLOR    0x0000
#define ILC_COLORDDB 0x00fe
#define ILC_COLOR4   0x0004
#define ILC_COLOR8   0x0008
#define ILC_COLOR16  0x0010
#define ILC_COLOR24  0x0018
#define ILC_COLOR32  0x0020
#define ILC_PALETTE  0x0800
#define ILD_NORMAL        0x0000
#define ILD_TRANSPARENT   0x0001
#define ILD_BLEND25       0x0002
#define ILD_FOCUS         ILD_BLEND25
#define ILD_BLEND50       0x0004
#define ILD_BLEND         ILD_BLEND50
#define ILD_SELECTED      ILD_BLEND50
#define ILD_MASK          0x0010
#define ILD_IMAGE         0x0020
#define ILD_ROP           0x0040
#define ILD_OVERLAYMASK   0x0f00
#define ILD_PRESERVEALPHA 0x1000
#define ILD_SCALE         0x2000
#define ILD_DPISCALE      0x4000
#define ILD_ASYNC         0x8000
#define ILS_NORMAL   0x0000
#define ILS_GLOW     0x0001
#define ILS_SHADOW   0x0002
#define ILS_SATURATE 0x0004
#define ILS_ALPHA    0x0008
#define ImageList_ExtractIcon(hInstance,hImage,i) ImageList_GetIcon(hImage,i,0)
#define ImageList_LoadBitmap(hInstance,lpszBitmap,cx,cGrow,crMask) ImageList_LoadImage(hInstance,lpszBitmap,cx,cGrow,crMask,IMAGE_BITMAP,0)
#define ImageList_RemoveAll(hImage) ImageList_Remove(hImage,-1)
typedef LPVOID HIMAGELIST;
typedef LPVOID LPSTREAM;
#include "pshpack1.h"
typedef struct _IMAGELISTDRAWPARAMS
{
  DWORD cbSize;
  HIMAGELIST himl;
  INT i;
  HDC hdcDst;
  INT x;
  INT y;
  INT cx;
  INT cy;
  INT xBitmap;
  INT yBitmap;
  COLORREF rgbBk;
  COLORREF rgbFg;
  UINT fStyle;
  DWORD dwRop;
  DWORD fState;
  DWORD Frame;
  COLORREF crEffect;
} IMAGELISTDRAWPARAMS, *PIMAGELISTDRAWPARAMS, *LPIMAGELISTDRAWPARAMS;
typedef struct _IMAGEINFO
{
  HBITMAP hbmImage;
  HBITMAP hbmMask;
  INT Unused1;
  INT Unused2;
  RECT rcImage;
} IMAGEINFO, *PIMAGEINFO, *LPIMAGEINFO;
#include "poppack.h"

/* ja:リストビュー */
#include "w32lview.h"

/* ja:ツリービュー */
#include "w32tview.h"

/* ja:プログレスコントロール */
#include "w32prgrs.h"

/* ja:ヘッダコントロール */
#define WC_HEADERA "SysHeader32"
#define WC_HEADERW (w32ldr_tchar_to_wc("SysHeader32"))
#ifdef UNICODE
# define WC_HEADER WC_HEADERW
#else /* not UNICODE */
# define WC_HEADER WC_HEADERA
#endif /* not UNICODE */
#define HDS_HORZ       0x0000
#define HDS_BUTTONS    0x0002
#define HDS_HOTTRACK   0x0004
#define HDS_HIDDEN     0x0008
#define HDS_DRAGDROP   0x0040
#define HDS_FULLDRAG   0x0080
#define HDS_FILTERBAR  0x0100
#define HDS_FLAT       0x0200
#define HDS_CHECKBOXES 0x0400
#define HDM_FIRST        0x1200
#define HDM_GETITEMCOUNT (HDM_FIRST+0)
#define HDM_INSERTITEMA  (HDM_FIRST+1)
#define HDM_INSERTITEMW  (HDM_FIRST+10)
#define HDM_DELETEITEM   (HDM_FIRST+2)
#define HDM_GETITEMA     (HDM_FIRST+3)
#define HDM_GETITEMW     (HDM_FIRST+11)
#define HDM_SETITEMA     (HDM_FIRST+4)
#define HDM_SETITEMW     (HDM_FIRST+12)
#define HDM_LAYOUT       (HDM_FIRST+5)
#define HDM_HITTEST      (HDM_FIRST+6)
#ifdef UNICODE
# define HDM_INSERTITEM HDM_INSERTITEMW
# define HDM_GETITEM HDM_GETITEMW
# define HDM_SETITEM HDM_SETITEMW
#else /* not UNICODE */
# define HDM_INSERTITEM HDM_INSERTITEMA
# define HDM_GETITEM HDM_GETITEMA
# define HDM_SETITEM HDM_SETITEMA
#endif /* not UNICODE */
#define HDN_FIRST            (-300)
#define HDN_LAST             (-399)
#define HDN_ITEMCHANGINGA    (HDN_FIRST-0)
#define HDN_ITEMCHANGINGW    (HDN_FIRST-20)
#define HDN_ITEMCHANGEDA     (HDN_FIRST-1)
#define HDN_ITEMCHANGEDW     (HDN_FIRST-21)
#define HDN_ITEMCLICKA       (HDN_FIRST-2)
#define HDN_ITEMCLICKW       (HDN_FIRST-22)
#define HDN_ITEMDBLCLICKA    (HDN_FIRST-3)
#define HDN_ITEMDBLCLICKW    (HDN_FIRST-23)
#define HDN_DIVIDERDBLCLICKA (HDN_FIRST-5)
#define HDN_DIVIDERDBLCLICKW (HDN_FIRST-25)
#define HDN_BEGINTRACKA      (HDN_FIRST-6)
#define HDN_BEGINTRACKW      (HDN_FIRST-26)
#define HDN_ENDTRACKA        (HDN_FIRST-7)
#define HDN_ENDTRACKW        (HDN_FIRST-27)
#define HDN_TRACKA           (HDN_FIRST-8)
#define HDN_TRACKW           (HDN_FIRST-28)
#ifdef UNICODE
# define HDN_ITEMCHANGING HDN_ITEMCHANGINGW
# define HDN_ITEMCHANGED HDN_ITEMCHANGEDW
# define HDN_ITEMCLICK HDN_ITEMCLICKW
# define HDN_ITEMDBLCLICK HDN_ITEMDBLCLICKW
# define HDN_DIVIDERDBLCLICK HDN_DIVIDERDBLCLICKW
# define HDN_BEGINTRACK HDN_BEGINTRACKW
# define HDN_ENDTRACK HDN_ENDTRACKW
# define HDN_TRACK HDN_TRACKW
#else /* not UNICODE */
# define HDN_ITEMCHANGING HDN_ITEMCHANGINGA
# define HDN_ITEMCHANGED HDN_ITEMCHANGEDA
# define HDN_ITEMCLICK HDN_ITEMCLICKA
# define HDN_ITEMDBLCLICK HDN_ITEMDBLCLICKA
# define HDN_DIVIDERDBLCLICK HDN_DIVIDERDBLCLICKA
# define HDN_BEGINTRACK HDN_BEGINTRACKA
# define HDN_ENDTRACK HDN_ENDTRACKA
# define HDN_TRACK HDN_TRACKA
#endif /* not UNICODE */

#define HDI_WIDTH       0x0001
#define HDI_HEIGHT      HDI_WIDTH
#define HDI_TEXT        0x0002
#define HDI_FORMAT      0x0004
#define HDI_LPARAM      0x0008
#define HDI_BITMAP      0x0010
#define HDF_LEFT        0x0000
#define HDF_RIGHT       0x0001
#define HDF_CENTER      0x0002
#define HDF_JUSTIFYMASK 0x0003
#define HDF_RTLREADING  0x0004
#define HDF_BITMAP      0x2000
#define HDF_STRING      0x4000
#define HDF_OWNERDRAW   0x8000
#include "pshpack1.h"
typedef struct _HD_ITEMA
{
  UINT mask;
  INT cxy;
  LPSTR pszText;
  HBITMAP hbm;
  INT cchTextMax;
  INT fmt;
  LPARAM lParam;
} HD_ITEMA, *PHD_ITEMA, *LPHD_ITEMA;
typedef struct _HD_ITEMW
{
  UINT mask;
  INT cxy;
  LPWSTR pszText;
  HBITMAP hbm;
  INT cchTextMax;
  INT fmt;
  LPARAM lParam;
} HD_ITEMW, *PHD_ITEMW, *LPHD_ITEMW;
#include "poppack.h"
#ifdef UNICODE
# define HD_ITEM HD_ITEMW
# define PHD_ITEM PHD_ITEMW
# define LPHD_ITEM LPHD_ITEMW
#else /* not UNICODE */
# define HD_ITEM HD_ITEMA
# define PHD_ITEM PHD_ITEMA
# define LPHD_ITEM LPHD_ITEMA
#endif /* not UNICODE */

#include "pshpack1.h"
typedef struct _HD_LAYOUT
{
  LPRECT prc;
  LPWINDOWPOS pwpos;
} HD_LAYOUT, *PHD_LAYOUT, *LPHD_LAYOUT;
#include "poppack.h"

#define HHT_NOWHERE   0x0001
#define HHT_ONHEADER  0x0002
#define HHT_ONDIVIDER 0x0004
#define HHT_ONDIVOPEN 0x0008
#define HHT_TORIGHT   0x0400
#define HHT_TOLEFT    0x0800

#include "pshpack1.h"
typedef struct _HD_NOTIFYA
{
  NMHDR hdr;
  INT iItem;
  INT iButton;
  HD_ITEMA *pitem;
} HD_NOTIFYA, *PHD_NOTIFYA, *LPHD_NOTIFYA;
typedef struct _HD_NOTIFYW
{
  NMHDR hdr;
  INT iItem;
  INT iButton;
  HD_ITEMW *pitem;
} HD_NOTIFYW, *PHD_NOTIFYW, *LPHD_NOTIFYW;
#include "poppack.h"
#ifdef UNICODE
# define HD_NOTIFY HD_NOTIFYW
# define PHD_NOTIFY PHD_NOTIFYW
# define LPHD_NOTIFY LPHD_NOTIFYW
#else /* not UNICODE */
# define HD_NOTIFY HD_NOTIFYA
# define PHD_NOTIFY PHD_NOTIFYA
# define LPHD_NOTIFY LPHD_NOTIFYA
#endif /* not UNICODE */

#define Header_DeleteItem(hWnd,index) SendMessageA(hWnd,HDM_DELETEITEM,index,0)
#define Header_GetItemA(hWnd,index,phdi) SendMessageA(hWnd,HDM_GETITEMA,index,GPOINTER_TO_INT(phdi))
#define Header_GetItemW(hWnd,index,phdi) SendMessageW(hWnd,HDM_GETITEMW,index,GPOINTER_TO_INT(phdi))
#define Header_GetItemCount(hWnd) SendMessageA(hWnd,HDM_GETITEMCOUNT,0,0)
#define Header_InsertItemA(hWnd,index,phdi) SendMessageA(hWnd,HDM_INSERTITEMA,index,GPOINTER_TO_INT(phdi))
#define Header_InsertItemW(hWnd,index,phdi) SendMessageW(hWnd,HDM_INSERTITEMW,index,GPOINTER_TO_INT(phdi))
#define Header_Layout(hWnd,playout) SendMessageA(hWnd,HDM_LAYOUT,0,GPOINTER_TO_INT(playout))
#define Header_SetItemA(hWnd,index,phdi) SendMessageA(hWnd,HDM_SETITEMA,index,GPOINTER_TO_INT(phdi))
#define Header_SetItemW(hWnd,index,phdi) SendMessageW(hWnd,HDM_SETITEMW,index,GPOINTER_TO_INT(phdi))
#ifdef UNICODE
# define Header_GetItem Header_GetItemW
# define Header_InsertItem Header_InsertItemW
# define Header_SetItem Header_SetItemW
#else /* not UNICODE */
# define Header_GetItem Header_GetItemA
# define Header_InsertItem Header_InsertItemA
# define Header_SetItem Header_SetItemA
#endif /* not UNICODE */

/* ja:スピンボタンコントロール */
#include "w32updwn.h"


extern W32LdrExport w32ldr_commctrl_exports[];


HPROPSHEETPAGE WINAPI CreatePropertySheetPageA (LPCPROPSHEETPAGEA lppsp);
HPROPSHEETPAGE WINAPI CreatePropertySheetPageW (LPCPROPSHEETPAGEW lppsp);
HWND WINAPI CreateStatusWindowA (LONG lStyle, LPCSTR lpszText, HWND hWndParent, UINT wID);
HWND WINAPI CreateStatusWindowW (LONG lStyle, LPCWSTR lpszText, HWND hWndParent, UINT wID);
HWND WINAPI CreateToolbarEx (HWND hWndParent, DWORD dwStyle, UINT wID, INT nBitmaps, HINSTANCE hInstance, UINT wBMID, LPCTBBUTTON lpButtons, INT iNumButtons, INT dxButton, INT dyButton, INT dxBitmap, INT dyBitmap, UINT uStructSize);
HWND WINAPI CreateUpDownControl (DWORD dwStyle, INT x, INT y, INT cx, INT cy, HWND hParent, INT nID, HINSTANCE hInst, HWND hBuddy, INT nUpper, INT nLower, INT nPos);
BOOL WINAPI DestroyPropertySheetPage (HPROPSHEETPAGE hPage);
INT WINAPI ImageList_Add (HIMAGELIST hImage, HBITMAP hBitmap, HBITMAP hBitmapMask);
INT WINAPI ImageList_AddIcon (HIMAGELIST hImage, HICON hIcon);
INT WINAPI ImageList_AddMasked (HIMAGELIST hImage, HBITMAP hBitmap, COLORREF crMask);
BOOL WINAPI ImageList_BeginDrag (HIMAGELIST hImage, INT iTrack, INT dxHotspot, INT dyHotspot);
BOOL WINAPI ImageList_Copy (HIMAGELIST hImageDst, INT iDst, HIMAGELIST hImageSrc, INT iSrc, UINT uFlags);
HIMAGELIST WINAPI ImageList_Create (INT cx, INT cy, UINT flags, INT cInitial, INT cGrow);
BOOL WINAPI ImageList_Destroy (HIMAGELIST hImage);
BOOL WINAPI ImageList_DragEnter (HWND hWndLock, INT x, INT y);
BOOL WINAPI ImageList_DragLeave (HWND hWndLock);
BOOL WINAPI ImageList_DragMove (INT x, INT y);
BOOL WINAPI ImageList_DragShowNolock (BOOL fShow);
BOOL WINAPI ImageList_Draw (HIMAGELIST hImage, INT i, HDC hdcDst, INT x, INT y, UINT fStyle);
BOOL WINAPI ImageList_DrawEx (HIMAGELIST hImage, INT i, HDC hdcDst, INT x, INT y, INT dx, INT dy, COLORREF rgbBk, COLORREF rgbFg, UINT fStyle);
BOOL WINAPI ImageList_DrawIndirect (LPIMAGELISTDRAWPARAMS lpImageListDrawIndirect);
HIMAGELIST WINAPI ImageList_Duplicate (HIMAGELIST hImage);
VOID WINAPI ImageList_EndDrag (VOID);
COLORREF WINAPI ImageList_GetBkColor (HIMAGELIST hImage);
HIMAGELIST ImageList_GetDragImage (LPPOINT lppt, LPPOINT lpptHotspot);
HICON WINAPI ImageList_GetIcon (HIMAGELIST hImage, INT i, UINT flags);
BOOL WINAPI ImageList_GetIconSize (HIMAGELIST hImage, INT *cx, INT *cy);
INT WINAPI ImageList_GetImageCount (HIMAGELIST hImage);
BOOL WINAPI ImageList_GetImageInfo (HIMAGELIST hImage, INT i, LPIMAGEINFO lpImageInfo);
HIMAGELIST WINAPI ImageList_LoadImageA (HINSTANCE hInstance, LPCSTR lpszBitmap, INT cx, INT cGrow, COLORREF crMask, UINT uType, UINT uFlags);
HIMAGELIST WINAPI ImageList_LoadImageW (HINSTANCE hInstance, LPCWSTR lpszBitmap, INT cx, INT cGrow, COLORREF crMask, UINT uType, UINT uFlags);
HIMAGELIST WINAPI ImageList_Merge (HIMAGELIST hImage1, INT i1, HIMAGELIST hImage2, INT i2, INT dx, INT dy);
HIMAGELIST WINAPI ImageList_Read (LPSTREAM lpstm);
BOOL WINAPI ImageList_Remove (HIMAGELIST hImage, INT i);
BOOL WINAPI ImageList_Replace (HIMAGELIST hImage, INT i, HBITMAP hBitmap, HBITMAP hBitmapMask);
INT WINAPI ImageList_ReplaceIcon (HIMAGELIST hImage, INT i, HICON hIcon);
COLORREF ImageList_SetBkColor (HIMAGELIST hImage, COLORREF clrBk);
BOOL WINAPI ImageList_SetDragCursorImage (HIMAGELIST hImage, INT iDrag, INT dxHotspot, INT dyHotspot);
BOOL WINAPI ImageList_SetIconSize (HIMAGELIST hImage, INT cx, INT cy);
BOOL WINAPI ImageList_SetImageCount (HIMAGELIST hIMage, UINT uNewCount);
BOOL WINAPI ImageList_SetOverlayImage (HIMAGELIST hIMage, INT iImage, INT iOverlay);
BOOL WINAPI ImageList_Write (HIMAGELIST hImage, LPSTREAM lpstm);
void WINAPI InitCommonControls (VOID);
BOOL WINAPI InitCommonControlsEx (LPINITCOMMONCONTROLSEX pInitCtrls);
INT WINAPI PropertySheetA (LPCPROPSHEETHEADERA lppsph);
INT WINAPI PropertySheetW (LPCPROPSHEETHEADERW lppsph);


#ifdef UNICODE
# define CreatePropertySheetPage CreatePropertySheetPageW
# define CreateStatusWindow CreateStatusWindowW
# define ImageList_LoadImage ImageList_LoadImageW
# define PropertySheet PropertySheetW
#else /* not UNICODE*/
# define CreatePropertySheetPage CreatePropertySheetPageA
# define CreateStatusWindow CreateStatusWindowA
# define ImageList_LoadImage ImageList_LoadImageA
# define PropertySheet PropertySheetA
#endif /* not UNICODE */


G_END_DECLS


#endif /* __COMMCTRL_H__ */
