/*
    w32loader
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "kernel32.h"
#include <time.h>
#include "w32ldr.h"
#include "misc/profile.h"


#ifdef W32LDR_HEADER
/* ja:一般 */
#define MAX_PATH 260
#define INVALID_HANDLE_VALUE ((HANDLE)-1)
#define WAIT_FAILED 0xffffffff
#define DONT_RESOLVE_DLL_REFERENCES   0x00000001
#define LOAD_LIBRARY_AS_DATAFILE      0x00000002
#define LOAD_WITH_ALTERED_SEARCH_PATH 0x00000008
typedef LPVOID LPCRITICAL_SECTION;
typedef LRESULT CALLBACK (*FARPROC) (VOID);
typedef struct _W32LdrHandle *HANDLE;
/* ja:メモリ */
#define LMEM_INVALID_HANDLE 0x8000
#define GMEM_INVALID_HANDLE 0x8000
typedef HANDLE HGLOBAL, HLOCAL;
#include "pshpack1.h"
typedef struct _MEMORY_BASIC_INFORMATION
{
  LPVOID BaseAddress;
  LPVOID AllocationBase;
  DWORD AllocationProtect;
  SIZE_T RegionSize;
  DWORD State;
  DWORD Protect;
  DWORD Type;
} MEMORY_BASIC_INFORMATION, *PMEMORY_BASIC_INFORMATION, *LPMEMORY_BASIC_INFORMATION;
typedef struct tagMEMORYSTATUS
{
  DWORD dwLength;
  DWORD dwMemoryLoad;
  SIZE_T dwTotalPhys;
  SIZE_T dwAvailPhys;
  SIZE_T dwTotalPageFile;
  SIZE_T dwAvailPageFile;
  SIZE_T dwTotalVirtual;
  SIZE_T dwAvailVirtual;
} MEMORYSTATUS, *PMEMORYSTATUS, *LPMEMORYSTATUS;
#include "poppack.h"
/* ja:ファイル */
#define STD_INPUT_HANDLE         (-10)
#define STD_OUTPUT_HANDLE        (-11)
#define STD_ERROR_HANDLE         (-12)
#define INVALID_SET_FILE_POINTER (-1)
#define FILE_TYPE_UNKNOWN        0x0000
#define FILE_TYPE_DISK           0x0001
#define FILE_TYPE_CHAR           0x0002
#define FILE_TYPE_PIPE           0x0003
#define FILE_TYPE_REMOTE         0x8000
#define FILE_BEGIN               0
#define FILE_CURRENT             1
#define FILE_END                 2
#include "pshpack1.h"
typedef struct _OVERLAPPED
{
  ULONG_PTR Internal;
  ULONG_PTR InternalHigh;
  DWORD Offset;
  DWORD OffsetHigh;
  HANDLE hEvent;
} OVERLAPPED, *POVERLAPPED, *LPOVERLAPPED;
#include "poppack.h"
/* ja:ファイル(Win16互換) */
#include "misc/fileio.h"
#define HFILE_ERROR ((HFILE)-1)
typedef FileIO *HFILE;
/* ja:言語/ロケール/コードページ */
#define MAX_DEFAULTCHAR 2
#define MAX_LEADBYTES   12
#define CP_ACP        0
#define CP_OEMCP      1
#define CP_MACCP      2
#define CP_THREAD_ACP 3
#define CP_SYMBOL     42
#define CP_UTF7       65000
#define CP_UTF8       65001
#define LCMAP_LOWERCASE 0x00000100
#define LCMAP_UPPERCASE 0x00000200
#define LCMAP_SORTKEY   0x00000400
#define LCMAP_BYTEREV   0x00000800
#define MAKELCID(l,s)        (MAKELONG(l,s))
#define MAKELANGID(p,s)      ((((guint16)(s))<<10)|(guint16)(p))
#define PRIMARYLANGID(l)     ((guint16)(l)&0x3ff)
#define SUBLANGID(l)         ((guint16)(l)>>10)
#define LANGIDFROMLCID(lcid) ((WORD)(lcid))
#define SORTIDFROMLCID(lcid) ((WORD)((((DWORD)(lcid)) >> 16) & 0x0f))
#define LANG_MAIN_NEUTRAL                0x00
#define LANG_MAIN_AFRIKAANS              0x36
#define LANG_MAIN_ALBANIAN               0x1c
#define LANG_MAIN_ARABIC                 0x01
#define LANG_MAIN_ARMENIAN               0x2b
#define LANG_MAIN_ASSAMESE               0x4d
#define LANG_MAIN_AZERI                  0x2c
#define LANG_MAIN_BASQUE                 0x2d
#define LANG_MAIN_BENGALI                0x45
#define LANG_MAIN_BULGARIAN              0x02
#define LANG_MAIN_BYELORUSSIAN           0x23
#define LANG_MAIN_CATALAN                0x03
#define LANG_MAIN_CHINESE                0x04
#define LANG_MAIN_SERBO_CROATIAN         0x1a
#define LANG_MAIN_CROATIAN               LANG_MAIN_SERBO_CROATIAN
#define LANG_MAIN_SERBIAN                LANG_MAIN_SERBO_CROATIAN
#define LANG_MAIN_CZECH                  0x05
#define LANG_MAIN_DANISH                 0x06
#define LANG_MAIN_DUTCH                  0x13
#define LANG_MAIN_ENGLISH                0x09
#define LANG_MAIN_ESTONIAN               0x25
#define LANG_MAIN_FAEROESE               0x38
#define LANG_MAIN_FARSI                  0x29
#define LANG_MAIN_FINNISH                0x0b
#define LANG_MAIN_FRENCH                 0x0c
#define LANG_MAIN_GAELIC                 0x3c
#define LANG_MAIN_GEORGIAN               0x37
#define LANG_MAIN_GERMAN                 0x07
#define LANG_MAIN_GREEK                  0x08
#define LANG_MAIN_GUJARATI               0x47
#define LANG_MAIN_HEBREW                 0x0D
#define LANG_MAIN_HINDI                  0x39
#define LANG_MAIN_HUNGARIAN              0x0e
#define LANG_MAIN_ICELANDIC              0x0f
#define LANG_MAIN_INDONESIAN             0x21
#define LANG_MAIN_ITALIAN                0x10
#define LANG_MAIN_JAPANESE               0x11
#define LANG_MAIN_KANNADA                0x4b
#define LANG_MAIN_KAZAKH                 0x3f
#define LANG_MAIN_KONKANI                0x57
#define LANG_MAIN_KOREAN                 0x12
#define LANG_MAIN_LATVIAN                0x26
#define LANG_MAIN_LITHUANIAN             0x27
#define LANG_MAIN_MACEDONIAN             0x2f
#define LANG_MAIN_MALAY                  0x3e
#define LANG_MAIN_MALAYALAM              0x4c
#define LANG_MAIN_MALTESE                0x3a
#define LANG_MAIN_MAORI                  0x28
#define LANG_MAIN_MARATHI                0x4e
#define LANG_MAIN_NORWEGIAN              0x14
#define LANG_MAIN_ORIYA                  0x48
#define LANG_MAIN_POLISH                 0x15
#define LANG_MAIN_PORTUGUESE             0x16
#define LANG_MAIN_PUNJABI                0x46
#define LANG_MAIN_RHAETO_ROMANCE         0x17
#define LANG_MAIN_ROMANIAN               0x18
#define LANG_MAIN_RUSSIAN                0x19
#define LANG_MAIN_SAAMI                  0x3b
#define LANG_MAIN_SANSKRIT               0x4f
#define LANG_MAIN_SLOVAK                 0x1b
#define LANG_MAIN_SLOVENIAN              0x24
#define LANG_MAIN_SORBIAN                0x2e
#define LANG_MAIN_SPANISH                0x0a
#define LANG_MAIN_SUTU                   0x30
#define LANG_MAIN_SWAHILI                0x41
#define LANG_MAIN_SWEDISH                0x1d
#define LANG_MAIN_TAMIL                  0x49
#define LANG_MAIN_TATAR                  0x44
#define LANG_MAIN_TELUGU                 0x4a
#define LANG_MAIN_THAI                   0x1e
#define LANG_MAIN_TSONGA                 0x31
#define LANG_MAIN_TSWANA                 0x32
#define LANG_MAIN_TURKISH                0x1f
#define LANG_MAIN_UKRAINIAN              0x22
#define LANG_MAIN_URDU                   0x20
#define LANG_MAIN_UZBEK                  0x43
#define LANG_MAIN_VENDA                  0x33
#define LANG_MAIN_VIETNAMESE             0x2a
#define LANG_MAIN_XHOSA                  0x34
#define LANG_MAIN_ZULU                   0x35
#define LANG_MAIN_ESPERANTO              0x8f
#define LANG_MAIN_WALON                  0x90
#define LANG_MAIN_CORNISH                0x91
#define LANG_MAIN_WELSH                  0x92
#define LANG_MAIN_BRETON                 0x93
#define LANG_SUB_NEUTRAL                 0x00
#define LANG_SUB_DEFAULT                 0x01
#define LANG_SUB_SYS_DEFAULT             0x02
#define LANG_SUB_ARABIC                  0x01
#define LANG_SUB_ARABIC_SAUDI_ARABIA     0x01
#define LANG_SUB_ARABIC_IRAQ             0x02
#define LANG_SUB_ARABIC_EGYPT            0x03
#define LANG_SUB_ARABIC_LIBYA            0x04
#define LANG_SUB_ARABIC_ALGERIA          0x05
#define LANG_SUB_ARABIC_MOROCCO          0x06
#define LANG_SUB_ARABIC_TUNISIA          0x07
#define LANG_SUB_ARABIC_OMAN             0x08
#define LANG_SUB_ARABIC_YEMEN            0x09
#define LANG_SUB_ARABIC_SYRIA            0x0a
#define LANG_SUB_ARABIC_JORDAN           0x0b
#define LANG_SUB_ARABIC_LEBANON          0x0c
#define LANG_SUB_ARABIC_KUWAIT           0x0d
#define LANG_SUB_ARABIC_UAE              0x0e
#define LANG_SUB_ARABIC_BAHRAIN          0x0f
#define LANG_SUB_ARABIC_QATAR            0x10
#define LANG_SUB_CHINESE_TRADITIONAL     0x01
#define LANG_SUB_CHINESE_SIMPLIFIED      0x02
#define LANG_SUB_CHINESE_HONGKONG        0x03
#define LANG_SUB_CHINESE_SINGAPORE       0x04
#define LANG_SUB_CHINESE_MACAU           0x05
#define LANG_SUB_DUTCH                   0x01
#define LANG_SUB_DUTCH_BELGIAN           0x02
#define LANG_SUB_DUTCH_SURINAM           0x03
#define LANG_SUB_ENGLISH_US              0x01
#define LANG_SUB_ENGLISH_UK              0x02
#define LANG_SUB_ENGLISH_AUS             0x03
#define LANG_SUB_ENGLISH_CAN             0x04
#define LANG_SUB_ENGLISH_NZ              0x05
#define LANG_SUB_ENGLISH_EIRE            0x06
#define LANG_SUB_ENGLISH_SAFRICA         0x07
#define LANG_SUB_ENGLISH_JAMAICA         0x08
#define LANG_SUB_ENGLISH_CARRIBEAN       0x09
#define LANG_SUB_ENGLISH_BELIZE          0x0a
#define LANG_SUB_ENGLISH_TRINIDAD        0x0b
#define LANG_SUB_ENGLISH_ZIMBABWE        0x0c
#define LANG_SUB_ENGLISH_PHILIPPINES     0x0d
#define LANG_SUB_FRENCH                  0x01
#define LANG_SUB_FRENCH_BELGIAN          0x02
#define LANG_SUB_FRENCH_CANADIAN         0x03
#define LANG_SUB_FRENCH_SWISS            0x04
#define LANG_SUB_FRENCH_LUXEMBOURG       0x05
#define LANG_SUB_FRENCH_MONACO           0x06
#define LANG_SUB_GERMAN                  0x01
#define LANG_SUB_GERMAN_SWISS            0x02
#define LANG_SUB_GERMAN_AUSTRIAN         0x03
#define LANG_SUB_GERMAN_LUXEMBOURG       0x04
#define LANG_SUB_GERMAN_LIECHTENSTEIN    0x05
#define LANG_SUB_ITALIAN                 0x01
#define LANG_SUB_ITALIAN_SWISS           0x02
#define LANG_SUB_KOREAN                  0x01
#define LANG_SUB_KOREAN_JOHAB            0x02
#define LANG_SUB_NORWEGIAN_BOKMAL        0x01
#define LANG_SUB_NORWEGIAN_NYNORSK       0x02
#define LANG_SUB_PORTUGUESE              0x02
#define LANG_SUB_PORTUGUESE_BRAZILIAN    0x01
#define LANG_SUB_SPANISH                 0x01
#define LANG_SUB_SPANISH_MEXICAN         0x02
#define LANG_SUB_SPANISH_MODERN          0x03
#define LANG_SUB_SPANISH_GUATEMALA       0x04
#define LANG_SUB_SPANISH_COSTARICA       0x05
#define LANG_SUB_SPANISH_PANAMA          0x06
#define LANG_SUB_SPANISH_DOMINICAN       0x07
#define LANG_SUB_SPANISH_VENEZUELA       0x08
#define LANG_SUB_SPANISH_COLOMBIA        0x09
#define LANG_SUB_SPANISH_PERU            0x0a
#define LANG_SUB_SPANISH_ARGENTINA       0x0b
#define LANG_SUB_SPANISH_ECUADOR         0x0c
#define LANG_SUB_SPANISH_CHILE           0x0d
#define LANG_SUB_SPANISH_URUGUAY         0x0e
#define LANG_SUB_SPANISH_PARAGUAY        0x0f
#define LANG_SUB_SPANISH_BOLIVIA         0x10
#define LANG_SUB_SPANISH_EL_SALVADOR     0x11
#define LANG_SUB_SPANISH_HONDURAS        0x12
#define LANG_SUB_SPANISH_NICARAGUA       0x13
#define LANG_SUB_SPANISH_PUERTO_RICO     0x14
#define LANG_SUB_ROMANIAN                0x01
#define LANG_SUB_ROMANIAN_MOLDAVIA       0x02
#define LANG_SUB_RUSSIAN                 0x01
#define LANG_SUB_RUSSIAN_MOLDAVIA        0x02
#define LANG_SUB_CROATIAN                0x01
#define LANG_SUB_SERBIAN                 0x02
#define LANG_SUB_SERBIAN_LATIN           0x03
#define LANG_SUB_SWEDISH                 0x01
#define LANG_SUB_SWEDISH_FINLAND         0x02
#define LANG_SUB_LITHUANIAN              0x01
#define LANG_SUB_LITHUANIAN_CLASSIC      0x02
#define LANG_SUB_AZERI                   0x01
#define LANG_SUB_AZERI_CYRILLIC          0x02
#define LANG_SUB_GAELIC                  0x01
#define LANG_SUB_GAELIC_SCOTTISH         0x02
#define LANG_SUB_GAELIC_MANX             0x03
#define LANG_SUB_MALAY                   0x01
#define LANG_SUB_MALAY_BRUNEI_DARUSSALAM 0x02
#define LANG_SUB_UZBEK                   0x01
#define LANG_SUB_UZBEK_CYRILLIC          0x02
#define LANG_SUB_URDU_PAKISTAN           0x01
typedef WORD LANGID;
typedef DWORD CALID;
typedef DWORD CALTYPE;
typedef DWORD LCID;
typedef DWORD LCTYPE;
typedef BOOL CALLBACK (*CALINFO_ENUMPROCA)(LPSTR);
typedef BOOL CALLBACK (*CALINFO_ENUMPROCW)(LPWSTR);
typedef DWORD CALLBACK (*LPTHREAD_START_ROUTINE)(LPVOID);
#ifdef UNICODE
# define CALINFO_ENUMPROC CALINFO_ENUMPROCW
#else /* not UNICODE */
# define CALINFO_ENUMPROC CALINFO_ENUMPROCA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
} CPINFO, *LPCPINFO;
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
  WCHAR UnicodeDefaultChar;
  UINT CodePage;
  CHAR CodePageName[MAX_PATH];
} CPINFOEXA, *LPCPINFOEXA;
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
  WCHAR UnicodeDefaultChar;
  UINT CodePage;
  WCHAR CodePageName[MAX_PATH];
} CPINFOEXW, *LPCPINFOEXW;
#ifdef UNICODE
# define CPINFOEX CPINFOEXW
# define LPCPINFOEX LPCPINFOEXW
#else /* not UNICODE */
# define CPINFOEX CPINFOEXA
# define LPCPINFOEX LPCPINFOEXA
#endif /* not UNICODE */
#include "poppack.h"
/* ja:環境 */
#define VER_PLATFORM_WIN32s        0
#define VER_PLATFORM_WIN32_WINDOWS 1
#define VER_PLATFORM_WIN32_NT      2
#ifdef G_HAVE_GINT64
typedef gint64 LARGE_INTEGER, *PLARGE_INTEGER, *LPLARGE_INTEGER;
#else /* not G_HAVE_GINT64 */
typedef gint32 LARGE_INTEGER, *PLARGE_INTEGER, *LPLARGE_INTEGER;
#endif /* not G_HAVE_GINT64 */
#include "pshpack1.h"
typedef struct
{
  DWORD dwOSVersionInfoSize;
  DWORD dwMajorVersion;
  DWORD dwMinorVersion;
  DWORD dwBuildNumber;
  DWORD dwPlatformId;
  CHAR szCSDVersion[128];
} OSVERSIONINFOA, *POSVERSIONINFOA, *LPOSVERSIONINFOA;
typedef struct
{
  DWORD dwOSVersionInfoSize;
  DWORD dwMajorVersion;
  DWORD dwMinorVersion;
  DWORD dwBuildNumber;
  DWORD dwPlatformId;
  WCHAR szCSDVersion[128];
} OSVERSIONINFOW, *POSVERSIONINFOW, *LPOSVERSIONINFOW;
#ifdef UNICODE
# define OSVERSIONINFO OSVERSIONINFOW
# define POSVERSIONINFO POSVERSIONINFOW
# define LPOSVERSIONINFO LPOSVERSIONINFOW
#else /* not UNICODE */
# define OSVERSIONINFO OSVERSIONINFOA
# define POSVERSIONINFO POSVERSIONINFOA
# define LPOSVERSIONINFO LPOSVERSIONINFOA
#endif /* not UNICODE */
typedef struct _STARTUPINFOA
{
  DWORD cb;
  LPSTR lpReserved;
  LPSTR lpDesktop;
  LPSTR lpTitle;
  DWORD dwX;
  DWORD dwY;
  DWORD dwXSize;
  DWORD dwYSize;
  DWORD dwXCountChars;
  DWORD dwYCountChars;
  DWORD dwFillAttribute;
  DWORD dwFlags;
  WORD wShowWindow;
  WORD cbReserved2;
  BYTE *lpReserved2;
  HANDLE hStdInput;
  HANDLE hStdOutput;
  HANDLE hStdError;
} STARTUPINFOA, *LPSTARTUPINFOA;
typedef struct _STARTUPINFOW
{
  DWORD cb;
  LPWSTR lpReserved;
  LPWSTR lpDesktop;
  LPWSTR lpTitle;
  DWORD dwX;
  DWORD dwY;
  DWORD dwXSize;
  DWORD dwYSize;
  DWORD dwXCountChars;
  DWORD dwYCountChars;
  DWORD dwFillAttribute;
  DWORD dwFlags;
  WORD wShowWindow;
  WORD cbReserved2;
  BYTE *lpReserved2;
  HANDLE hStdInput;
  HANDLE hStdOutput;
  HANDLE hStdError;
} STARTUPINFOW, *LPSTARTUPINFOW;
#ifdef UNICODE
# define STARTUPINFO STARTUPINFOW
# define LPSTARTUPINFO LPSTARTUPINFOW
#else /* not UNICODE */
# define STARTUPINFO STARTUPINFOA
# define LPSTARTUPINFO LPSTARTUPINFOA
#endif /* not UNICODE */
typedef struct _SYSTEM_INFO
{
  union {
  DWORD dwOemId;
    struct {
      WORD wProcessorArchitecture;
      WORD wReserved;
    } DUMMYSTRUCTNAME;
  } DUMMYUNIONNAME;
  DWORD dwPageSize;
  LPVOID lpMinimumApplicationAddress;
  LPVOID lpMaximumApplicationAddress;
  DWORD dwActiveProcessorMask;
  DWORD dwNumberOfProcessors;
  DWORD dwProcessorType;
  DWORD dwAllocationGranularity;
  WORD wProcessorLevel;
  WORD wProcessorRevision;
} SYSTEM_INFO, *LPSYSTEM_INFO;
typedef struct _SYSTEMTIME
{
  WORD wYear;
  WORD wMonth;
  WORD wDayOfWeek;
  WORD wDay;
  WORD wHour;
  WORD wMinute;
  WORD wSecond;
  WORD wMilliseconds;
} SYSTEMTIME, *PSYSTEMTIME, *LPSYSTEMTIME;
#include "poppack.h"
#endif /* W32LDR_HEADER */


typedef struct _W32LdrHandle
{
  gint counter;
  FileIO *fio;
#ifdef USE_THREAD
  GThread *gthread;
#endif /* USE_THREAD */
} W32LdrHandle;
typedef struct _W32LdrNlsInfo
{
  gchar *lang;
  gchar *region;
  guint16 lcid;
  gchar *langage;
  gchar *locale;
  guint acp;
  guint oemcp;
} W32LdrNlsInfo;
static W32LdrNlsInfo nls_information[] = {
{"af",  NULL, MAKELANGID (LANG_MAIN_AFRIKAANS, LANG_SUB_DEFAULT),               "Afrikaans",           "Afrikaans",                    1252, 850},
{"sq",  NULL, MAKELANGID (LANG_MAIN_ALBANIAN, LANG_SUB_DEFAULT),                "Albanian",            "Albanian",                     1250, 852},
{"ar",  "SA", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_SAUDI_ARABIA),      "Arabic",              "Arabic (Saudi Arabia)",        1256, 720},
{"ar",  "IQ", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_IRAQ),              "Arabic",              "Arabic (Iraq)",                1256, 720},
{"ar",  "EG", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_EGYPT),             "Arabic",              "Arabic (Egypt)",               1256, 720},
{"ar",  "LY", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_LIBYA),             "Arabic",              "Arabic (Libya)",               1256, 720},
{"ar",  "DZ", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_ALGERIA),           "Arabic",              "Arabic (Algeria)",             1256, 720},
{"ar",  "MA", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_MOROCCO),           "Arabic",              "Arabic (Morocco)",             1256, 720},
{"ar",  "TN", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_TUNISIA),           "Arabic",              "Arabic (Tunisia))",            1256, 720},
{"ar",  "OM", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_OMAN),              "Arabic",              "Arabic (Oman)",                1256, 720},
{"ar",  "YE", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_YEMEN),             "Arabic",              "Arabic (Yemen)",               1256, 720},
{"ar",  "SY", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_SYRIA),             "Arabic",              "Arabic (Syria)",               1256, 720},
{"ar",  "JO", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_JORDAN),            "Arabic",              "Arabic (Jordan)",              1256, 720},
{"ar",  "LB", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_LEBANON),           "Arabic",              "Arabic (Lebanon)",             1256, 720},
{"ar",  "KW", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_KUWAIT),            "Arabic",              "Arabic (Kuwait)",              1256, 720},
{"ar",  "AE", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_UAE),               "Arabic",              "Arabic (U.A.E.)",              1256, 720},
{"ar",  "BH", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_BAHRAIN),           "Arabic",              "Arabic (Bahrain)",             1256, 720},
{"ar",  "QA", MAKELANGID (LANG_MAIN_ARABIC, LANG_SUB_ARABIC_QATAR),             "Arabic",              "Arabic (Qatar)",               1256, 720},
{"am",  NULL, MAKELANGID (LANG_MAIN_ARMENIAN, LANG_SUB_DEFAULT),                "Armenian",            "Armenian",                     0,    1},
{"az",  NULL, MAKELANGID (LANG_MAIN_AZERI, LANG_SUB_AZERI),                     "Azeri (Latin)",       "Azeri (Latin)",                1254, 857},
{"az",  NULL, MAKELANGID (LANG_MAIN_AZERI, LANG_SUB_AZERI_CYRILLIC),            "Azeri (Cyrillic)",    "Azeri (Cyrillic)",             1251, 866},
{"eu",  NULL, MAKELANGID (LANG_MAIN_BASQUE, LANG_SUB_DEFAULT),                  "Basque",              "Basque",                       1252, 850},
{"bn",  NULL, MAKELANGID (LANG_MAIN_BENGALI, LANG_SUB_DEFAULT),                 "Bengali",             "Bengali (India)",              0,    1},
{"bg",  NULL, MAKELANGID (LANG_MAIN_BULGARIAN, LANG_SUB_DEFAULT),               "Bulgarian",           "Bulgarian",                    1251, 866},
{"be",  NULL, MAKELANGID (LANG_MAIN_BYELORUSSIAN, LANG_SUB_DEFAULT),            "Belarusian",          "Belarusian",                   1251, 866},
{"ca",  NULL, MAKELANGID (LANG_MAIN_CATALAN, LANG_SUB_DEFAULT),                 "Catalan",             "Catalan",                      1252, 850},
{"zh",  "TW", MAKELANGID (LANG_MAIN_CHINESE, LANG_SUB_CHINESE_TRADITIONAL),     "Chinese",             "Chinese (Taiwan)",             950,  950},
{"zh",  "CN", MAKELANGID (LANG_MAIN_CHINESE, LANG_SUB_CHINESE_SIMPLIFIED),      "Chinese",             "Chinese (PRC)",                936,  936},
{"zh",  "HK", MAKELANGID (LANG_MAIN_CHINESE, LANG_SUB_CHINESE_HONGKONG),        "Chinese",             "Chinese (Hong Kong S.A.R.)",   950,  950},
{"zh",  "SG", MAKELANGID (LANG_MAIN_CHINESE, LANG_SUB_CHINESE_SINGAPORE),       "Chinese",             "Chinese (Singapore)",          936,  936},
{"zh",  "MO", MAKELANGID (LANG_MAIN_CHINESE, LANG_SUB_CHINESE_MACAU),           "Chinese",             "Chinese (Macau S.A.R.)",       950,  950},
{"sh",  NULL, MAKELANGID (LANG_MAIN_SERBO_CROATIAN, LANG_SUB_DEFAULT),          "Croatian",            "Croatian",                     1250, 852},
{"hr",  NULL, MAKELANGID (LANG_MAIN_CROATIAN, LANG_SUB_CROATIAN),               "Croatian",            "Croatian",                     1250, 852},
{"sr",  NULL, MAKELANGID (LANG_MAIN_SERBIAN, LANG_SUB_SERBIAN),                 "Serbian (Cyrillic)",  "Serbian (Cyrillic)",           1251, 855},
{"sr",  NULL, MAKELANGID (LANG_MAIN_SERBIAN, LANG_SUB_SERBIAN_LATIN),           "Serbian (Latin)",     "Serbian (Latin)",              1250, 852},
{"ca",  NULL, MAKELANGID (LANG_MAIN_CZECH, LANG_SUB_DEFAULT),                   "Czech",               "Czech",                        1250, 852},
{"da",  NULL, MAKELANGID (LANG_MAIN_DANISH, LANG_SUB_DEFAULT),                  "Danish",              "Danish",                       1252, 850},
{"nl",  NULL, MAKELANGID (LANG_MAIN_DUTCH, LANG_SUB_DUTCH),                     "Dutch",               "Dutch (Netherlands)",          1252, 850},
{"nl",  "BE", MAKELANGID (LANG_MAIN_DUTCH, LANG_SUB_DUTCH_BELGIAN),             "Dutch",               "Dutch (Belgium)",              1252, 850},
{"nl",  "SR", MAKELANGID (LANG_MAIN_DUTCH, LANG_SUB_DUTCH_SURINAM),             "Dutch",               "Dutch (Surinam)",              1252, 850},
{"en",  "US", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_US),              "English",             "English (United States)",      1252, 437},
{"en",  "GB", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_UK),              "English",             "English (United Kingdom)",     1252, 850},
{"en",  "UK", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_UK),              "English",             "English (United Kingdom)",     1252, 850},
{"en",  "AU", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_AUS),             "English",             "English (Australia)",          1252, 850},
{"en",  "CA", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CAN),             "English",             "English (Canada)",             1252, 850},
{"en",  "NZ", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_NZ),              "English",             "English (New Zealand)",        1252, 850},
{"en",  "IE", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_EIRE),            "English",             "English (Ireland)",            1252, 850},
{"en",  "ZA", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_SAFRICA),         "English",             "English (South Africa)",       1252, 437},
{"en",  "JM", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_JAMAICA),         "English",             "English (Jamaica)",            1252, 850},
{"en",  "AG", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "AI", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "AN", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "AW", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "BB", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "BS", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "CU", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "DM", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "DO", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "GD", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "HT", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "LC", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "MQ", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "MS", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "KN", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "KY", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "PR", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "TC", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "VC", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "VG", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "VI", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_CARRIBEAN),       "English",             "English (Caribbean)",          1252, 850},
{"en",  "BZ", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_BELIZE),          "English",             "English (Belize)",             1252, 850},
{"en",  "TT", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_TRINIDAD),        "English",             "English (Trinidad)",           1252, 850},
{"en",  "ZW", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_ZIMBABWE),        "English",             "English (Zimbabwe)",           1252, 437},
{"en",  "PH", MAKELANGID (LANG_MAIN_ENGLISH, LANG_SUB_ENGLISH_PHILIPPINES),     "English",             "English (Philippines)",        1252, 437},
{"et",  NULL, MAKELANGID (LANG_MAIN_ESTONIAN, LANG_SUB_DEFAULT),                "Estonian",            "Estonian",                     1257, 775},
{"fo",  NULL, MAKELANGID (LANG_MAIN_FAEROESE, LANG_SUB_DEFAULT),                "Faeroese",            "Faeroese",                     1252, 850},
{"fa",  NULL, MAKELANGID (LANG_MAIN_FARSI, LANG_SUB_DEFAULT),                   "Farsi",               "Farsi",                        1256, 720},
{"fi",  NULL, MAKELANGID (LANG_MAIN_FINNISH, LANG_SUB_DEFAULT),                 "Finnish",             "Finnish",                      1252, 850},
{"fr",  NULL, MAKELANGID (LANG_MAIN_FRENCH, LANG_SUB_FRENCH),                   "French",              "French (France)",              1252, 850},
{"fr",  "BE", MAKELANGID (LANG_MAIN_FRENCH, LANG_SUB_FRENCH_BELGIAN),           "French",              "French (Belgium)",             1252, 850},
{"fr",  "CA", MAKELANGID (LANG_MAIN_FRENCH, LANG_SUB_FRENCH_CANADIAN),          "French",              "French (Canada)",              1252, 850},
{"fr",  "CH", MAKELANGID (LANG_MAIN_FRENCH, LANG_SUB_FRENCH_SWISS),             "French",              "French (Belgium)",             1252, 850},
{"fr",  "LU", MAKELANGID (LANG_MAIN_FRENCH, LANG_SUB_FRENCH_LUXEMBOURG),        "French",              "French (Luxembourg)",          1252, 850},
{"fr",  "MC", MAKELANGID (LANG_MAIN_FRENCH, LANG_SUB_FRENCH_MONACO),            "French",              "French (Monaco)",              1252, 850},
{"gd",  NULL, MAKELANGID (LANG_MAIN_GAELIC, LANG_SUB_GAELIC),                   "Gaelic",              "Gaelic",                       1252, 850},
{"gd",  NULL, MAKELANGID (LANG_MAIN_GAELIC, LANG_SUB_GAELIC_SCOTTISH),          "Gaelic",              "Gaelic (Scotland)",            1252, 850},
{"gd",  "IM", MAKELANGID (LANG_MAIN_GAELIC, LANG_SUB_GAELIC_MANX),              "Gaelic",              "Gaelic (Manx)",                1252, 850},
{"ka",  NULL, MAKELANGID (LANG_MAIN_GEORGIAN, LANG_SUB_DEFAULT),                "Georgian",            "Georgian",                     0,    1},
{"de",  NULL, MAKELANGID (LANG_MAIN_GERMAN, LANG_SUB_GERMAN),                   "German",              "German (Germany)",             1252, 850},
{"de",  "CH", MAKELANGID (LANG_MAIN_GERMAN, LANG_SUB_GERMAN_SWISS),             "German",              "German (Switzerland)",         1252, 850},
{"de",  "AT", MAKELANGID (LANG_MAIN_GERMAN, LANG_SUB_GERMAN_AUSTRIAN),          "German",              "German (Austria)",             1252, 850},
{"de",  "LU", MAKELANGID (LANG_MAIN_GERMAN, LANG_SUB_GERMAN_LUXEMBOURG),        "German",              "German (Luxembourg)",          1252, 850},
{"de",  "LI", MAKELANGID (LANG_MAIN_GERMAN, LANG_SUB_GERMAN_LIECHTENSTEIN),     "German",              "German (Liechtenstein)",       1252, 850},
{"el",  NULL, MAKELANGID (LANG_MAIN_GREEK, LANG_SUB_DEFAULT),                   "Greek",               "Greek",                        1253, 737},
{"gu",  NULL, MAKELANGID (LANG_MAIN_GUJARATI, LANG_SUB_DEFAULT),                "Gujarati",            "Gujarati",                     0,    1},
{"el",  NULL, MAKELANGID (LANG_MAIN_HEBREW, LANG_SUB_DEFAULT),                  "Hebrew",              "Hebrew",                       1255, 862},
{"hi",  NULL, MAKELANGID (LANG_MAIN_HINDI, LANG_SUB_DEFAULT),                   "Hindi",               "Hindi",                        0,    1},
{"el",  NULL, MAKELANGID (LANG_MAIN_HUNGARIAN, LANG_SUB_DEFAULT),               "Hungarian",           "Hungarian",                    1250, 852},
{"is",  NULL, MAKELANGID (LANG_MAIN_ICELANDIC, LANG_SUB_DEFAULT),               "Icelandic",           "Icelandic",                    1252, 850},
{"id",  NULL, MAKELANGID (LANG_MAIN_INDONESIAN, LANG_SUB_DEFAULT),              "Indonesian",          "Indonesian",                   1252, 850},
{"it",  NULL, MAKELANGID (LANG_MAIN_ITALIAN, LANG_SUB_ITALIAN),                 "Italian",             "Italian (Italy)",              1252, 850},
{"it",  "CH", MAKELANGID (LANG_MAIN_ITALIAN, LANG_SUB_ITALIAN_SWISS),           "Italian",             "Italian (Switzerland)",        1252, 850},
{"ja",  NULL, MAKELANGID (LANG_MAIN_JAPANESE, LANG_SUB_DEFAULT),                "Japanese",            "Japanese",                     932,  932},
{"kn",  NULL, MAKELANGID (LANG_MAIN_KANNADA, LANG_SUB_DEFAULT),                 "Kannada",             "Kannada",                      0,    1},
{"kk",  NULL, MAKELANGID (LANG_MAIN_KAZAKH, LANG_SUB_DEFAULT),                  "Kazakh",              "Kazakh",                       1251, 866},
{"kok", NULL, MAKELANGID (LANG_MAIN_KONKANI, LANG_SUB_DEFAULT),                 "Konkani",             "Konkani",                      0,    1},
{"ko",  NULL, MAKELANGID (LANG_MAIN_KOREAN, LANG_SUB_KOREAN),                   "Korean",              "Korean",                       949 , 949},
{"lv",  NULL, MAKELANGID (LANG_MAIN_LATVIAN, LANG_SUB_DEFAULT),                 "Latvian",             "Latvian",                      1257, 775},
{"lt",  NULL, MAKELANGID (LANG_MAIN_LITHUANIAN, LANG_SUB_LITHUANIAN),           "Lithuanian",          "Lithuanian",                   1257, 775},
{"lt",  NULL, MAKELANGID (LANG_MAIN_LITHUANIAN, LANG_SUB_LITHUANIAN_CLASSIC),   "Lithuanian",          "Lithuanian (Classic)",         1257, 775},/* ? */
{"mk",  NULL, MAKELANGID (LANG_MAIN_MACEDONIAN, LANG_SUB_DEFAULT),              "FYRO Macedonian",     "FYRO Macedonian",              1251, 866},
{"ms",  NULL, MAKELANGID (LANG_MAIN_MALAY, LANG_SUB_MALAY),                     "Malay",               "Malay (Malaysia)",             1252, 850},
{"ms",  NULL, MAKELANGID (LANG_MAIN_MALAY, LANG_SUB_MALAY_BRUNEI_DARUSSALAM),   "Malay",               "Malay (Brunei Darussalam)",    1252, 850},
{"ml",  NULL, MAKELANGID (LANG_MAIN_MALAYALAM, LANG_SUB_DEFAULT),               "Malayalam",           "Malayalam (India)",            0,    1},
{"mt",  NULL, MAKELANGID (LANG_MAIN_MALTESE, LANG_SUB_DEFAULT),                 "Maltese",             "Maltese",                      0,    1},
{"mi",  NULL, MAKELANGID (LANG_MAIN_MAORI, LANG_SUB_DEFAULT),                   "Maori",               "Maori",                        0,    1},
{"mr",  NULL, MAKELANGID (LANG_MAIN_MARATHI, LANG_SUB_DEFAULT),                 "Marathi",             "Marathi",                      0,    1},
{"no",  NULL, MAKELANGID (LANG_MAIN_NORWEGIAN, LANG_SUB_NORWEGIAN_BOKMAL),      "Norwegian (Bokmal)",  "Norwegian (Bokmal)",           1252, 850},
{"nb",  NULL, MAKELANGID (LANG_MAIN_NORWEGIAN, LANG_SUB_NORWEGIAN_BOKMAL),      "Norwegian (Bokmal)",  "Norwegian (Bokmal)",           1252, 850},
{"nn",  NULL, MAKELANGID (LANG_MAIN_NORWEGIAN, LANG_SUB_NORWEGIAN_NYNORSK),     "Norwegian (Nynorsk)", "Norwegian (Nynorsk)",          1252, 850},
{"or",  NULL, MAKELANGID (LANG_MAIN_ORIYA, LANG_SUB_DEFAULT),                   "Oriya",               "Oriya",                        0,    1}, /* ? */
{"pl",  NULL, MAKELANGID (LANG_MAIN_POLISH, LANG_SUB_DEFAULT),                  "Polish",              "Polish",                       1250, 852},
{"pt",  NULL, MAKELANGID (LANG_MAIN_PORTUGUESE, LANG_SUB_PORTUGUESE),           "Portuguese",          "Portuguese (Portugal)",        1250, 852},
{"pt",  "BR", MAKELANGID (LANG_MAIN_PORTUGUESE, LANG_SUB_PORTUGUESE_BRAZILIAN), "Portuguese",          "Portuguese (Brazil)",          1250, 852},
{"pa",  NULL, MAKELANGID (LANG_MAIN_PUNJABI, LANG_SUB_DEFAULT),                 "Punjabi",             "Punjabi",                      0,    1},
{"rm",  NULL, MAKELANGID (LANG_MAIN_RHAETO_ROMANCE, LANG_SUB_DEFAULT),          "Rhaeto Romance",      "Rhaeto Romance",               0,    1}, /* ? */
{"ro",  NULL, MAKELANGID (LANG_MAIN_ROMANIAN, LANG_SUB_ROMANIAN),               "Romanian",            "Romanian (Romania)",           1250, 852},
{"ro",  "MD", MAKELANGID (LANG_MAIN_ROMANIAN, LANG_SUB_ROMANIAN_MOLDAVIA),      "Romanian",            "Romanian (Moldavia)",          1250, 852}, /* ? */
{"ru",  NULL, MAKELANGID (LANG_MAIN_RUSSIAN, LANG_SUB_RUSSIAN),                 "Russian",             "Russian (Russia)",             1251, 866},
{"ro",  "MD", MAKELANGID (LANG_MAIN_RUSSIAN, LANG_SUB_RUSSIAN_MOLDAVIA),        "Russian",             "Russian (Moldavia)",           1251, 866}, /* ? */
{"se",  NULL, MAKELANGID (LANG_MAIN_SAAMI, LANG_SUB_DEFAULT),                   "Sami (Northern)",     "Sami, Northern (Norway)",      1252, 850},
{"sa",  NULL, MAKELANGID (LANG_MAIN_SANSKRIT, LANG_SUB_DEFAULT),                "Sanskrit",            "Sanskrit",                     0,    1},
{"sk",  NULL, MAKELANGID (LANG_MAIN_SLOVAK, LANG_SUB_DEFAULT),                  "Slovak",              "Slovak",                       1250, 852},
{"sl",  NULL, MAKELANGID (LANG_MAIN_SLOVENIAN, LANG_SUB_DEFAULT),               "Slovenian",           "Slovenian",                    1250, 852},
{"sb",  NULL, MAKELANGID (LANG_MAIN_SORBIAN, LANG_SUB_DEFAULT),                 "Sorbian",             "Sorbian",                      1250, 852},
{"es",  NULL, MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH),                 "Spanish",             "Spanish (Traditional Sort)",   1252, 850},
{"es",  "MX", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_MEXICAN),         "Spanish",             "Spanish (Mexico)",             1252, 850},
{"es",  NULL, MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_MODERN),          "Spanish",             "Spanish (International Sort)", 1252, 850},
{"es",  "GT", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_GUATEMALA),       "Spanish",             "Spanish (Guatemala)",          1252, 850},
{"es",  "CR", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_COSTARICA),       "Spanish",             "Spanish (Costa Rica)",         1252, 850},
{"es",  "PA", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_PANAMA),          "Spanish",             "Spanish (Panama)",             1252, 850},
{"es",  "DO", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_DOMINICAN),       "Spanish",             "Spanish (Dominican Republic)", 1252, 850},
{"es",  "VE", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_VENEZUELA),       "Spanish",             "Spanish (Venezuela)",          1252, 850},
{"es",  "CO", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_COLOMBIA),        "Spanish",             "Spanish (Colombia)",           1252, 850},
{"es",  "PE", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_PERU),            "Spanish",             "Spanish (Peru))",              1252, 850},
{"es",  "AR", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_ARGENTINA),       "Spanish",             "Spanish (Argentina)",          1252, 850},
{"es",  "EC", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_ECUADOR),         "Spanish",             "Spanish (Ecuador)",            1252, 850},
{"es",  "CL", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_CHILE),           "Spanish",             "Spanish (Chile)",              1252, 850},
{"es",  "UY", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_URUGUAY),         "Spanish",             "Spanish (Uruguay)",            1252, 850},
{"es",  "PY", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_PARAGUAY),        "Spanish",             "Spanish (Paraguay)",           1252, 850},
{"es",  "BO", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_BOLIVIA),         "Spanish",             "Spanish (Bolivia)",            1252, 850},
{"es",  "SV", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_EL_SALVADOR),     "Spanish",             "Spanish (El Salvador)",        1252, 850},
{"es",  "HN", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_HONDURAS),        "Spanish",             "Spanish (Honduras)",           1252, 850},
{"es",  "NI", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_NICARAGUA),       "Spanish",             "Spanish (Nicaragua)",          1252, 850},
{"es",  "PR", MAKELANGID (LANG_MAIN_SPANISH, LANG_SUB_SPANISH_PUERTO_RICO),     "Spanish",             "Spanish (Puerto Rico)",        1252, 850},
{"sx",  NULL, MAKELANGID (LANG_MAIN_SUTU, LANG_SUB_DEFAULT),                    "Sutu",                "Sutu",                         0,    1}, /* ? */
{"sw",  NULL, MAKELANGID (LANG_MAIN_SWAHILI, LANG_SUB_DEFAULT),                 "Swahili",             "Swahili",                      1252, 437},
{"sv",  NULL, MAKELANGID (LANG_MAIN_SWEDISH, LANG_SUB_SWEDISH),                 "Swedish",             "Swedish",                      1252, 850},
{"sv",  "FI", MAKELANGID (LANG_MAIN_SWEDISH, LANG_SUB_SWEDISH_FINLAND),         "Swedish",             "Swedish (Finland)",            1252, 850},
{"ta",  NULL, MAKELANGID (LANG_MAIN_TAMIL, LANG_SUB_DEFAULT),                   "Tamil",               "Tamil",                        0,    1},
{"tt",  NULL, MAKELANGID (LANG_MAIN_TATAR, LANG_SUB_DEFAULT),                   "Tatar",               "Tatar",                        1251, 866},
{"te",  NULL, MAKELANGID (LANG_MAIN_TELUGU, LANG_SUB_DEFAULT),                  "Telugu",              "Telugu",                       0,    1},
{"th",  NULL, MAKELANGID (LANG_MAIN_THAI, LANG_SUB_DEFAULT),                    "Thai",                "Thai",                         874,  874},
{"ts",  NULL, MAKELANGID (LANG_MAIN_TSONGA, LANG_SUB_DEFAULT),                  "Tsonga",              "Tsonga",                       0,    1}, /* ? */
{"tn",  NULL, MAKELANGID (LANG_MAIN_TSWANA, LANG_SUB_DEFAULT),                  "Tswana",              "Tswana",                       1252, 850},
{"tr",  NULL, MAKELANGID (LANG_MAIN_TURKISH, LANG_SUB_DEFAULT),                 "Turkish",             "Turkish",                      1254, 857},
{"uk",  NULL, MAKELANGID (LANG_MAIN_UKRAINIAN, LANG_SUB_DEFAULT),               "Ukrainian",           "Ukrainian",                    1251, 866},
{"ur",  NULL, MAKELANGID (LANG_MAIN_URDU, LANG_SUB_URDU_PAKISTAN),              "Urdu",                "Urdu",                         1256, 720},
{"uz",  NULL, MAKELANGID (LANG_MAIN_UZBEK, LANG_SUB_UZBEK),                     "Uzbek (Latin)",       "Uzbek (Latin)",                1254, 857},
{"uz",  NULL, MAKELANGID (LANG_MAIN_UZBEK, LANG_SUB_UZBEK_CYRILLIC),            "Uzbek (Cyrillic)",    "Uzbek (Cyrillic)",             1251, 866},
{"ve",  NULL, MAKELANGID (LANG_MAIN_VENDA, LANG_SUB_DEFAULT),                   "Venda",               "Venda",                        0,    1}, /* ? */
{"vi",  NULL, MAKELANGID (LANG_MAIN_VIETNAMESE, LANG_SUB_DEFAULT),              "Vietnamese",          "Vietnamese",                   1258, 1258},
{"xh",  NULL, MAKELANGID (LANG_MAIN_XHOSA, LANG_SUB_DEFAULT),                   "Xhosa",               "Xhosa",                        1252, 850},
{"eo",  NULL, MAKELANGID (LANG_MAIN_ESPERANTO, LANG_SUB_DEFAULT),               "Esperanto",           "Esperanto",                    0,    1}, /* ? */
{"wa",  NULL, MAKELANGID (LANG_MAIN_WALON, LANG_SUB_DEFAULT),                   "Walon",               "Walon",                        0,    1}, /* ? */
{"kw",  NULL, MAKELANGID (LANG_MAIN_CORNISH, LANG_SUB_DEFAULT),                 "Cornish",             "Cornish",                      0,    1}, /* ? */
{"cy",  NULL, MAKELANGID (LANG_MAIN_WELSH, LANG_SUB_DEFAULT),                   "Welsh",               "Welsh",                        1252, 850},
{"br",  NULL, MAKELANGID (LANG_MAIN_BRETON, LANG_SUB_DEFAULT),                  "Breton",              "Breton",                       0,    1}, /* ? */
{NULL,  NULL, MAKELANGID (LANG_MAIN_NEUTRAL, LANG_SUB_NEUTRAL),                 NULL,                  NULL,                           0,    0}};


static W32LdrNlsInfo *
get_nls_information (void)
{
  const gchar *ev;
  gint i;
  static gint nls_information_index = -1;

  if (nls_information_index < 0)
    {
      if (((ev = g_getenv ("LC_ALL")) && ev[0] != '\0')
          || ((ev = g_getenv ("LC_MESSAGES")) && ev[0] != '\0')
          || ((ev = g_getenv ("LANG")) && ev[0] != '\0'))
        {
          gchar *lang;

          lang = g_strdup (ev);
          for (i = 0; g_ascii_isalpha (lang[i]); i++);
          lang[i] = '\0';
          if (ev[i] != '\0')
            {
              gchar *region;

              region = g_strdup (ev + i + 1);
              for (i = 0; g_ascii_isalpha (region[i]); i++);
              region[i] = '\0';
              for (i = 0; nls_information[i].langage; i++)
                if (nls_information[i].region
                    && g_strcasecmp (nls_information[i].lang, lang) == 0
                    && g_strcasecmp (nls_information[i].region, region) == 0)
                  {
                    nls_information_index = i;
                    break;
                  }
              g_free (region);
            }
          if (nls_information_index < 0)
            for (i = 0; nls_information[i].langage; i++)
              if (g_strcasecmp (nls_information[i].lang, lang) == 0)
                {
                  nls_information_index = i;
                  break;
                }
          g_free (lang);
        }
      if (nls_information_index < 0)
        for (i = 0; nls_information[i].langage; i++)
          if (g_strcasecmp (nls_information[i].lang, "en") == 0)
            {
              nls_information_index = i;
              break;
            }
      if (nls_information_index < 0)
        nls_information_index = 0;
    }
  return nls_information + nls_information_index;
}


/* AddAtomA ordinal = 1, argument = 4 temporary */
DWORD WINAPI AddAtomA (DWORD dwArgv0)
{
  return 0;
}


/* AddAtomW ordinal = 2, argument = 4 temporary */
DWORD WINAPI AddAtomW (DWORD dwArgv0)
{
  return 0;
}


/* AddConsoleAliasA ordinal = 3, argument = 12 temporary */
DWORD WINAPI AddConsoleAliasA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AddConsoleAliasW ordinal = 4, argument = 12 temporary */
DWORD WINAPI AddConsoleAliasW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AllocConsole ordinal = 5, argument = 0 */
BOOL WINAPI AllocConsole (VOID)
{
  return TRUE;
}


/* AllocateUserPhysicalPages ordinal = 6, argument = 12 temporary */
DWORD WINAPI AllocateUserPhysicalPages (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AreFileApisANSI ordinal = 7, argument = 0 temporary */
DWORD WINAPI AreFileApisANSI (VOID)
{
  return 0;
}


/* AssignProcessToJobObject ordinal = 8, argument = 8 temporary */
DWORD WINAPI AssignProcessToJobObject (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BackupRead ordinal = 9, argument = 28 temporary */
DWORD WINAPI BackupRead (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* BackupSeek ordinal = 10, argument = 24 temporary */
DWORD WINAPI BackupSeek (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* BackupWrite ordinal = 11, argument = 28 temporary */
DWORD WINAPI BackupWrite (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* BaseAttachCompleteThunk ordinal = 12, argument = 0 temporary */
DWORD WINAPI BaseAttachCompleteThunk (VOID)
{
  return 0;
}


/* Beep ordinal = 13, argument = 8 temporary */
DWORD WINAPI Beep (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BeginUpdateResourceA ordinal = 14, argument = 8 temporary */
DWORD WINAPI BeginUpdateResourceA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BeginUpdateResourceW ordinal = 15, argument = 8 temporary */
DWORD WINAPI BeginUpdateResourceW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BindIoCompletionCallback ordinal = 16, argument = 12 temporary */
DWORD WINAPI BindIoCompletionCallback (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* BuildCommDCBA ordinal = 17, argument = 8 temporary */
DWORD WINAPI BuildCommDCBA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* BuildCommDCBAndTimeoutsA ordinal = 18, argument = 12 temporary */
DWORD WINAPI BuildCommDCBAndTimeoutsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* BuildCommDCBAndTimeoutsW ordinal = 19, argument = 12 temporary */
DWORD WINAPI BuildCommDCBAndTimeoutsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* BuildCommDCBW ordinal = 20, argument = 8 temporary */
DWORD WINAPI BuildCommDCBW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CallNamedPipeA ordinal = 21, argument = 28 temporary */
DWORD WINAPI CallNamedPipeA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CallNamedPipeW ordinal = 22, argument = 28 temporary */
DWORD WINAPI CallNamedPipeW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CancelDeviceWakeupRequest ordinal = 23, argument = 4 temporary */
DWORD WINAPI CancelDeviceWakeupRequest (DWORD dwArgv0)
{
  return 0;
}


/* CancelIo ordinal = 24, argument = 4 temporary */
DWORD WINAPI CancelIo (DWORD dwArgv0)
{
  return 0;
}


/* CancelTimerQueueTimer ordinal = 25, argument = 8 temporary */
DWORD WINAPI CancelTimerQueueTimer (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CancelWaitableTimer ordinal = 26, argument = 4 temporary */
DWORD WINAPI CancelWaitableTimer (DWORD dwArgv0)
{
  return 0;
}


/* ChangeTimerQueueTimer ordinal = 27, argument = 16 temporary */
DWORD WINAPI ChangeTimerQueueTimer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ClearCommBreak ordinal = 28, argument = 4 temporary */
DWORD WINAPI ClearCommBreak (DWORD dwArgv0)
{
  return 0;
}


/* ClearCommError ordinal = 29, argument = 12 temporary */
DWORD WINAPI ClearCommError (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CloseConsoleHandle ordinal = 30, argument = 0 temporary */
DWORD WINAPI CloseConsoleHandle (VOID)
{
  return 0;
}


/* CloseHandle ordinal = 31, argument = 4 */
BOOL WINAPI CloseHandle (HANDLE hObject)
{
  hObject->counter--;
  if (hObject->counter <= 0)
    {
      fileio_close (hObject->fio);
      g_free (hObject);
    }
  return TRUE;
}


/* CloseProfileUserMapping ordinal = 32, argument = 0 temporary */
DWORD WINAPI CloseProfileUserMapping (VOID)
{
  return 0;
}


/* CmdBatNotification ordinal = 33, argument = 0 temporary */
DWORD WINAPI CmdBatNotification (VOID)
{
  return 0;
}


/* CommConfigDialogA ordinal = 34, argument = 12 temporary */
DWORD WINAPI CommConfigDialogA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CommConfigDialogW ordinal = 35, argument = 12 temporary */
DWORD WINAPI CommConfigDialogW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CompareFileTime ordinal = 36, argument = 8 temporary */
DWORD WINAPI CompareFileTime (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CompareStringA ordinal = 37, argument = 24 temporary */
DWORD WINAPI CompareStringA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CompareStringW ordinal = 38, argument = 24 temporary */
DWORD WINAPI CompareStringW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ConnectNamedPipe ordinal = 39, argument = 8 temporary */
DWORD WINAPI ConnectNamedPipe (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ConsoleMenuControl ordinal = 40, argument = 0 temporary */
DWORD WINAPI ConsoleMenuControl (VOID)
{
  return 0;
}


/* ContinueDebugEvent ordinal = 41, argument = 12 temporary */
DWORD WINAPI ContinueDebugEvent (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ConvertDefaultLocale ordinal = 42, argument = 4 temporary */
DWORD WINAPI ConvertDefaultLocale (DWORD dwArgv0)
{
  return 0;
}


/* ConvertThreadToFiber ordinal = 43, argument = 4 temporary */
DWORD WINAPI ConvertThreadToFiber (DWORD dwArgv0)
{
  return 0;
}


/* CopyFileA ordinal = 44, argument = 12 */
BOOL WINAPI CopyFileA (LPCSTR lpExistingFileName, LPCWSTR lpNewFileName, BOOL bFailIfExists)
{
  return FALSE;
}


/* CopyFileExA ordinal = 45, argument = 24 temporary */
DWORD WINAPI CopyFileExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CopyFileExW ordinal = 46, argument = 24 temporary */
DWORD WINAPI CopyFileExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CopyFileW ordinal = 47, argument = 12 */
BOOL WINAPI CopyFileW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName, BOOL bFailIfExists)
{
  return FALSE;
}


/* CreateConsoleScreenBuffer ordinal = 48, argument = 20 temporary */
DWORD WINAPI CreateConsoleScreenBuffer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CreateDirectoryA ordinal = 49, argument = 8 */
BOOL WINAPI CreateDirectoryA (LPCSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
  return FALSE;
}


/* CreateDirectoryExA ordinal = 50, argument = 12 temporary */
DWORD WINAPI CreateDirectoryExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateDirectoryExW ordinal = 51, argument = 12 temporary */
DWORD WINAPI CreateDirectoryExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateDirectoryW ordinal = 52, argument = 8 */
BOOL WINAPI CreateDirectoryW (LPCWSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttributes)
{
  return FALSE;
}


/* CreateEventA ordinal = 53, argument = 16 */
HANDLE WINAPI CreateEventA (LPSECURITY_ATTRIBUTES lpEventAttributes, BOOL bManualReset, BOOL bInitialState, LPCSTR lpName)
{
  return NULL;
}


/* CreateEventW ordinal = 54, argument = 16 */
HANDLE WINAPI CreateEventW (LPSECURITY_ATTRIBUTES lpEventAttributes, BOOL bManualReset, BOOL bInitialState, LPCWSTR lpName)
{
  return NULL;
}


/* CreateFiber ordinal = 55, argument = 12 temporary */
DWORD WINAPI CreateFiber (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateFiberEx ordinal = 56, argument = 20 temporary */
DWORD WINAPI CreateFiberEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CreateFileA ordinal = 57, argument = 28 */
HANDLE WINAPI CreateFileA (LPCSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile)
{
  gchar *file;
  FileIO *fio;
  HANDLE hFile = INVALID_HANDLE_VALUE;

  file = w32ldr_filename_from_mb (lpFileName);
  fio = fileio_open (file,
            FILEIO_ACCESS_READ, FILEIO_SHARE_READ, FILEIO_MODE_OPEN_EXISTING);
  g_free (file);
  if (fio)
    {
      hFile = g_malloc0 (sizeof (W32LdrHandle));
      hFile->counter = 1;
      hFile->fio = fio;
    }
  return hFile;
}


/* CreateFileMappingA ordinal = 58, argument = 24 */
HANDLE WINAPI CreateFileMappingA (HANDLE hFile, LPSECURITY_ATTRIBUTES lpAttributes, DWORD flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, LPCSTR lpName)
{
  hFile->counter++;
  return hFile;
}


/* CreateFileMappingW ordinal = 59, argument = 24 */
HANDLE WINAPI CreateFileMappingW (HANDLE hFile, LPSECURITY_ATTRIBUTES lpAttributes, DWORD flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, LPCWSTR lpName)
{
  hFile->counter++;
  return hFile;
}


/* CreateFileW ordinal = 60, argument = 28 */
HANDLE WINAPI CreateFileW (LPCWSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile)
{
  gchar *file;
  FileIO *fio;
  HANDLE hFile = INVALID_HANDLE_VALUE;

  file = w32ldr_filename_from_wc (lpFileName);
  fio = fileio_open (file,
            FILEIO_ACCESS_READ, FILEIO_SHARE_READ, FILEIO_MODE_OPEN_EXISTING);
  g_free (file);
  if (fio)
    {
      hFile = g_malloc (sizeof (W32LdrHandle));
      hFile->counter = 1;
      hFile->fio = fio;
    }
  return hFile;
}


/* CreateHardLinkA ordinal = 61, argument = 12 temporary */
DWORD WINAPI CreateHardLinkA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateHardLinkW ordinal = 62, argument = 12 temporary */
DWORD WINAPI CreateHardLinkW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateIoCompletionPort ordinal = 63, argument = 16 temporary */
DWORD WINAPI CreateIoCompletionPort (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateJobObjectA ordinal = 64, argument = 8 temporary */
DWORD WINAPI CreateJobObjectA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateJobObjectW ordinal = 65, argument = 8 temporary */
DWORD WINAPI CreateJobObjectW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateMailslotA ordinal = 66, argument = 16 temporary */
DWORD WINAPI CreateMailslotA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateMailslotW ordinal = 67, argument = 16 temporary */
DWORD WINAPI CreateMailslotW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateMutexA ordinal = 68, argument = 12 temporary */
DWORD WINAPI CreateMutexA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateMutexW ordinal = 69, argument = 12 temporary */
DWORD WINAPI CreateMutexW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateNamedPipeA ordinal = 70, argument = 32 temporary */
DWORD WINAPI CreateNamedPipeA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* CreateNamedPipeW ordinal = 71, argument = 32 temporary */
DWORD WINAPI CreateNamedPipeW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* CreatePipe ordinal = 72, argument = 16 temporary */
DWORD WINAPI CreatePipe (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateProcessA ordinal = 73, argument = 40 temporary */
DWORD WINAPI CreateProcessA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* CreateProcessInternalA ordinal = 74, argument = 0 temporary */
DWORD WINAPI CreateProcessInternalA (VOID)
{
  return 0;
}


/* CreateProcessInternalW ordinal = 75, argument = 0 temporary */
DWORD WINAPI CreateProcessInternalW (VOID)
{
  return 0;
}


/* CreateProcessInternalWSecure ordinal = 76, argument = 0 temporary */
DWORD WINAPI CreateProcessInternalWSecure (VOID)
{
  return 0;
}


/* CreateProcessW ordinal = 77, argument = 40 temporary */
DWORD WINAPI CreateProcessW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* CreateRemoteThread ordinal = 78, argument = 28 temporary */
DWORD WINAPI CreateRemoteThread (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CreateSemaphoreA ordinal = 79, argument = 16 */
HANDLE WINAPI CreateSemaphoreA (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes, LONG lInitialCount, LONG lMaximumCount, LPCSTR lpName)
{
  return NULL;
}


/* CreateSemaphoreW ordinal = 80, argument = 16 */
HANDLE WINAPI CreateSemaphoreW (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes, LONG lInitialCount, LONG lMaximumCount, LPCWSTR lpName)
{
  return NULL;
}


/* CreateTapePartition ordinal = 81, argument = 16 temporary */
DWORD WINAPI CreateTapePartition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateThread ordinal = 82, argument = 24 */
HANDLE WINAPI CreateThread (LPSECURITY_ATTRIBUTES lpThreadAttributes, DWORD dwStackSize, LPTHREAD_START_ROUTINE lpStartAddress, LPVOID lpParameter, DWORD dwCreationFlags, LPDWORD lpThreadId)
{
#ifdef USE_THREAD
  GThread *gthread;
  HANDLE hThread = INVALID_HANDLE_VALUE;

  gthread = g_thread_create ((GThreadFunc)lpStartAddress,
                                                    lpParameter, TRUE, NULL);
  if (lpThreadId)
    *lpThreadId = (DWORD)gthread;
  if (gthread)
    {
      hThread = g_malloc0 (sizeof (W32LdrHandle));
      hThread->counter = 1;
      hThread->gthread = gthread;
    }
  return hThread;
#else /* not USE_THREAD */
  return NULL;
#endif /* not USE_THREAD */
}


/* CreateTimerQueue ordinal = 83, argument = 0 temporary */
DWORD WINAPI CreateTimerQueue (VOID)
{
  return 0;
}


/* CreateTimerQueueTimer ordinal = 84, argument = 28 temporary */
DWORD WINAPI CreateTimerQueueTimer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* CreateToolhelp32Snapshot ordinal = 85, argument = 8 temporary */
DWORD WINAPI CreateToolhelp32Snapshot (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateVirtualBuffer ordinal = 86, argument = 0 temporary */
DWORD WINAPI CreateVirtualBuffer (VOID)
{
  return 0;
}


/* CreateWaitableTimerA ordinal = 87, argument = 12 temporary */
DWORD WINAPI CreateWaitableTimerA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateWaitableTimerW ordinal = 88, argument = 12 temporary */
DWORD WINAPI CreateWaitableTimerW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DebugActiveProcess ordinal = 89, argument = 4 temporary */
DWORD WINAPI DebugActiveProcess (DWORD dwArgv0)
{
  return 0;
}


/* DebugBreak ordinal = 90, argument = 0 temporary */
DWORD WINAPI DebugBreak (VOID)
{
  return 0;
}


/* DefineDosDeviceA ordinal = 91, argument = 12 temporary */
DWORD WINAPI DefineDosDeviceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DefineDosDeviceW ordinal = 92, argument = 12 temporary */
DWORD WINAPI DefineDosDeviceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DelayLoadFailureHook ordinal = 93, argument = 0 temporary */
DWORD WINAPI DelayLoadFailureHook (VOID)
{
  return 0;
}


/* DeleteAtom ordinal = 94, argument = 4 temporary */
DWORD WINAPI DeleteAtom (DWORD dwArgv0)
{
  return 0;
}


/* DeleteCriticalSection ordinal = 95, argument = 4 */
VOID WINAPI DeleteCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{
  g_mutex_free ((GMutex *)lpCriticalSection);
}


/* DeleteFiber ordinal = 96, argument = 4 temporary */
DWORD WINAPI DeleteFiber (DWORD dwArgv0)
{
  return 0;
}


/* DeleteFileA ordinal = 97, argument = 4 */
BOOL WINAPI DeleteFileA (LPCSTR lpFileName)
{
  return FALSE;
}


/* DeleteFileW ordinal = 98, argument = 4 */
BOOL WINAPI DeleteFileW (LPCWSTR lpFileName)
{
  return FALSE;
}


/* DeleteTimerQueue ordinal = 99, argument = 4 temporary */
DWORD WINAPI DeleteTimerQueue (DWORD dwArgv0)
{
  return 0;
}


/* DeleteTimerQueueEx ordinal = 100, argument = 8 temporary */
DWORD WINAPI DeleteTimerQueueEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DeleteTimerQueueTimer ordinal = 101, argument = 12 temporary */
DWORD WINAPI DeleteTimerQueueTimer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DeleteVolumeMountPointA ordinal = 102, argument = 4 temporary */
DWORD WINAPI DeleteVolumeMountPointA (DWORD dwArgv0)
{
  return 0;
}


/* DeleteVolumeMountPointW ordinal = 103, argument = 4 temporary */
DWORD WINAPI DeleteVolumeMountPointW (DWORD dwArgv0)
{
  return 0;
}


/* DeviceIoControl ordinal = 104, argument = 32 temporary */
DWORD WINAPI DeviceIoControl (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* DisableThreadLibraryCalls ordinal = 105, argument = 4 */
BOOL WINAPI DisableThreadLibraryCalls (HMODULE hLibModule)
{
  return TRUE;
}


/* DisconnectNamedPipe ordinal = 106, argument = 4 temporary */
DWORD WINAPI DisconnectNamedPipe (DWORD dwArgv0)
{
  return 0;
}


/* DnsHostnameToComputerNameA ordinal = 107, argument = 12 temporary */
DWORD WINAPI DnsHostnameToComputerNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DnsHostnameToComputerNameW ordinal = 108, argument = 12 temporary */
DWORD WINAPI DnsHostnameToComputerNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DosDateTimeToFileTime ordinal = 109, argument = 12 temporary */
DWORD WINAPI DosDateTimeToFileTime (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DosPathToSessionPathA ordinal = 110, argument = 0 temporary */
DWORD WINAPI DosPathToSessionPathA (VOID)
{
  return 0;
}


/* DosPathToSessionPathW ordinal = 111, argument = 0 temporary */
DWORD WINAPI DosPathToSessionPathW (VOID)
{
  return 0;
}


/* DuplicateConsoleHandle ordinal = 112, argument = 0 temporary */
DWORD WINAPI DuplicateConsoleHandle (VOID)
{
  return 0;
}


/* DuplicateHandle ordinal = 113, argument = 28 temporary */
DWORD WINAPI DuplicateHandle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* EndUpdateResourceA ordinal = 114, argument = 8 temporary */
DWORD WINAPI EndUpdateResourceA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EndUpdateResourceW ordinal = 115, argument = 8 temporary */
DWORD WINAPI EndUpdateResourceW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnterCriticalSection ordinal = 116, argument = 4 */
VOID WINAPI EnterCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{
  g_mutex_lock ((GMutex *)lpCriticalSection);
}


/* EnumCalendarInfoA ordinal = 117, argument = 16 */
BOOL WINAPI EnumCalendarInfoA (CALINFO_ENUMPROCA lpCalInfoEnumProc, LCID Locale, CALID Calendar, CALTYPE CalType)
{
  return FALSE;
}


/* EnumCalendarInfoExA ordinal = 118, argument = 16 temporary */
DWORD WINAPI EnumCalendarInfoExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumCalendarInfoExW ordinal = 119, argument = 16 temporary */
DWORD WINAPI EnumCalendarInfoExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumCalendarInfoW ordinal = 120, argument = 16 */
BOOL WINAPI EnumCalendarInfoW (CALINFO_ENUMPROCW lpCalInfoEnumProc, LCID Locale, CALID Calendar, CALTYPE CalType)
{
  return FALSE;
}


/* EnumDateFormatsA ordinal = 121, argument = 12 temporary */
DWORD WINAPI EnumDateFormatsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumDateFormatsExA ordinal = 122, argument = 12 temporary */
DWORD WINAPI EnumDateFormatsExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumDateFormatsExW ordinal = 123, argument = 12 temporary */
DWORD WINAPI EnumDateFormatsExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumDateFormatsW ordinal = 124, argument = 12 temporary */
DWORD WINAPI EnumDateFormatsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumLanguageGroupLocalesA ordinal = 125, argument = 16 temporary */
DWORD WINAPI EnumLanguageGroupLocalesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumLanguageGroupLocalesW ordinal = 126, argument = 16 temporary */
DWORD WINAPI EnumLanguageGroupLocalesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumResourceLanguagesA ordinal = 127, argument = 20 temporary */
DWORD WINAPI EnumResourceLanguagesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnumResourceLanguagesW ordinal = 128, argument = 20 temporary */
DWORD WINAPI EnumResourceLanguagesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnumResourceNamesA ordinal = 129, argument = 16 temporary */
DWORD WINAPI EnumResourceNamesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumResourceNamesW ordinal = 130, argument = 16 temporary */
DWORD WINAPI EnumResourceNamesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumResourceTypesA ordinal = 131, argument = 12 temporary */
DWORD WINAPI EnumResourceTypesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumResourceTypesW ordinal = 132, argument = 12 temporary */
DWORD WINAPI EnumResourceTypesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumSystemCodePagesA ordinal = 133, argument = 8 temporary */
DWORD WINAPI EnumSystemCodePagesA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumSystemCodePagesW ordinal = 134, argument = 8 temporary */
DWORD WINAPI EnumSystemCodePagesW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumSystemLanguageGroupsA ordinal = 135, argument = 12 temporary */
DWORD WINAPI EnumSystemLanguageGroupsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumSystemLanguageGroupsW ordinal = 136, argument = 12 temporary */
DWORD WINAPI EnumSystemLanguageGroupsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumSystemLocalesA ordinal = 137, argument = 8 temporary */
DWORD WINAPI EnumSystemLocalesA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumSystemLocalesW ordinal = 138, argument = 8 temporary */
DWORD WINAPI EnumSystemLocalesW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* EnumTimeFormatsA ordinal = 139, argument = 12 temporary */
DWORD WINAPI EnumTimeFormatsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumTimeFormatsW ordinal = 140, argument = 12 temporary */
DWORD WINAPI EnumTimeFormatsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumUILanguagesA ordinal = 141, argument = 12 temporary */
DWORD WINAPI EnumUILanguagesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumUILanguagesW ordinal = 142, argument = 12 temporary */
DWORD WINAPI EnumUILanguagesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EraseTape ordinal = 143, argument = 12 temporary */
DWORD WINAPI EraseTape (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EscapeCommFunction ordinal = 144, argument = 8 temporary */
DWORD WINAPI EscapeCommFunction (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ExitProcess ordinal = 145, argument = 4 */
VOID WINAPI ExitProcess (UINT uExitCode)
{
}


/* ExitThread ordinal = 146, argument = 4 temporary */
DWORD WINAPI ExitThread (DWORD dwArgv0)
{
  return 0;
}


/* ExitVDM ordinal = 147, argument = 0 temporary */
DWORD WINAPI ExitVDM (VOID)
{
  return 0;
}


/* ExpandEnvironmentStringsA ordinal = 148, argument = 12 temporary */
DWORD WINAPI ExpandEnvironmentStringsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExpandEnvironmentStringsW ordinal = 149, argument = 12 temporary */
DWORD WINAPI ExpandEnvironmentStringsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExpungeConsoleCommandHistoryA ordinal = 150, argument = 0 temporary */
DWORD WINAPI ExpungeConsoleCommandHistoryA (VOID)
{
  return 0;
}


/* ExpungeConsoleCommandHistoryW ordinal = 151, argument = 0 temporary */
DWORD WINAPI ExpungeConsoleCommandHistoryW (VOID)
{
  return 0;
}


/* ExtendVirtualBuffer ordinal = 152, argument = 0 temporary */
DWORD WINAPI ExtendVirtualBuffer (VOID)
{
  return 0;
}


/* FatalAppExitA ordinal = 153, argument = 8 temporary */
DWORD WINAPI FatalAppExitA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FatalAppExitW ordinal = 154, argument = 8 temporary */
DWORD WINAPI FatalAppExitW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FatalExit ordinal = 155, argument = 4 temporary */
DWORD WINAPI FatalExit (DWORD dwArgv0)
{
  return 0;
}


/* FileTimeToDosDateTime ordinal = 156, argument = 12 temporary */
DWORD WINAPI FileTimeToDosDateTime (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FileTimeToLocalFileTime ordinal = 157, argument = 8 temporary */
DWORD WINAPI FileTimeToLocalFileTime (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FileTimeToSystemTime ordinal = 158, argument = 8 temporary */
DWORD WINAPI FileTimeToSystemTime (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FillConsoleOutputAttribute ordinal = 159, argument = 20 temporary */
DWORD WINAPI FillConsoleOutputAttribute (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* FillConsoleOutputCharacterA ordinal = 160, argument = 20 temporary */
DWORD WINAPI FillConsoleOutputCharacterA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* FillConsoleOutputCharacterW ordinal = 161, argument = 20 temporary */
DWORD WINAPI FillConsoleOutputCharacterW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* FindAtomA ordinal = 162, argument = 4 temporary */
DWORD WINAPI FindAtomA (DWORD dwArgv0)
{
  return 0;
}


/* FindAtomW ordinal = 163, argument = 4 temporary */
DWORD WINAPI FindAtomW (DWORD dwArgv0)
{
  return 0;
}


/* FindClose ordinal = 164, argument = 4 temporary */
DWORD WINAPI FindClose (DWORD dwArgv0)
{
  return 0;
}


/* FindCloseChangeNotification ordinal = 165, argument = 4 temporary */
DWORD WINAPI FindCloseChangeNotification (DWORD dwArgv0)
{
  return 0;
}


/* FindFirstChangeNotificationA ordinal = 166, argument = 12 temporary */
DWORD WINAPI FindFirstChangeNotificationA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindFirstChangeNotificationW ordinal = 167, argument = 12 temporary */
DWORD WINAPI FindFirstChangeNotificationW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindFirstFileA ordinal = 168, argument = 8 temporary */
DWORD WINAPI FindFirstFileA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FindFirstFileExA ordinal = 169, argument = 24 temporary */
DWORD WINAPI FindFirstFileExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* FindFirstFileExW ordinal = 170, argument = 24 temporary */
DWORD WINAPI FindFirstFileExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* FindFirstFileW ordinal = 171, argument = 8 temporary */
DWORD WINAPI FindFirstFileW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FindFirstVolumeA ordinal = 172, argument = 8 temporary */
DWORD WINAPI FindFirstVolumeA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FindFirstVolumeMountPointA ordinal = 173, argument = 12 temporary */
DWORD WINAPI FindFirstVolumeMountPointA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindFirstVolumeMountPointW ordinal = 174, argument = 12 temporary */
DWORD WINAPI FindFirstVolumeMountPointW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindFirstVolumeW ordinal = 175, argument = 8 temporary */
DWORD WINAPI FindFirstVolumeW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FindNextChangeNotification ordinal = 176, argument = 4 temporary */
DWORD WINAPI FindNextChangeNotification (DWORD dwArgv0)
{
  return 0;
}


/* FindNextFileA ordinal = 177, argument = 8 temporary */
DWORD WINAPI FindNextFileA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FindNextFileW ordinal = 178, argument = 8 temporary */
DWORD WINAPI FindNextFileW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FindNextVolumeA ordinal = 179, argument = 12 temporary */
DWORD WINAPI FindNextVolumeA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindNextVolumeMountPointA ordinal = 180, argument = 12 temporary */
DWORD WINAPI FindNextVolumeMountPointA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindNextVolumeMountPointW ordinal = 181, argument = 12 temporary */
DWORD WINAPI FindNextVolumeMountPointW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindNextVolumeW ordinal = 182, argument = 12 temporary */
DWORD WINAPI FindNextVolumeW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FindResourceA ordinal = 183, argument = 12 */
HRSRC WINAPI FindResourceA (HMODULE hModule, LPCSTR lpName, LPCSTR lpType)
{
  guint16 langid, primary, secondary;
  HRSRC hRsrc;

  langid = GetUserDefaultUILanguage ();
  hRsrc = FindResourceExA (hModule, lpType, lpName, langid);
  if (hRsrc)
    return hRsrc;
  primary = PRIMARYLANGID (langid);
  for (secondary = 0; secondary < 0x40; secondary++)
    if ((hRsrc = FindResourceExA (hModule, lpType, lpName,
                                            MAKELANGID (primary, secondary))))
      return hRsrc;
  for (primary = 0; primary < 0x400; primary++)
    for (secondary = 0; secondary < 0x40; secondary++)
      if ((hRsrc = FindResourceExA (hModule, lpType, lpName,
                                            MAKELANGID (primary, secondary))))
        return hRsrc;
  return NULL;
}


/* FindResourceExA ordinal = 184, argument = 16 */
HRSRC WINAPI FindResourceExA (HMODULE hModule, LPCSTR lpType, LPCSTR lpName, WORD wLanguage)
{
  guint8 *data;
  gchar *buf, *key;

  if (GPOINTER_TO_INT (lpType) < 0x10000)
    {
      buf = g_strdup_printf ("/0x%x", GPOINTER_TO_INT (lpType));
    }
  else
    {
      gchar *utf8str, *tmp;

      utf8str = w32ldr_utf8_from_mb (lpType);
      tmp = g_utf8_strup (utf8str, -1);
      g_free (utf8str);
      buf = g_strdup_printf ("/%s", tmp);
      g_free (tmp);
    }
  if (GPOINTER_TO_INT (lpName) < 0x10000)
    {
      key = g_strdup_printf ("%s/0x%x/0x%x",
                                    buf, GPOINTER_TO_INT (lpName), wLanguage);
    }
  else
    {
      gchar *utf8str, *tmp;

      utf8str = w32ldr_utf8_from_mb (lpName);
      tmp = g_utf8_strup (utf8str, -1);
      g_free (utf8str);
      key = g_strdup_printf ("%s/%s/0x%x", buf, tmp, wLanguage);
      g_free (tmp);
    }
  g_free (buf);
  data = w32ldr_get_resource (((W32LdrModule *)hModule) - 1, key);
  g_free (key);
  return data;
}


/* FindResourceExW ordinal = 185, argument = 16 */
HRSRC WINAPI FindResourceExW (HMODULE hModule, LPCWSTR lpType, LPCWSTR lpName, WORD wLanguage)
{
  guint8 *data;
  gchar *buf, *key;

  if (GPOINTER_TO_INT (lpType) < 0x10000)
    {
      buf = g_strdup_printf ("/0x%x", GPOINTER_TO_INT (lpType));
    }
  else
    {
      gchar *utf8str, *tmp;

      utf8str = g_utf16_to_utf8 (lpType, -1, NULL, NULL, NULL);
      tmp = g_utf8_strup (utf8str, -1);
      g_free (utf8str);
      buf = g_strdup_printf ("/%s", tmp);
      g_free (tmp);
    }
  if (GPOINTER_TO_INT (lpName) < 0x10000)
    {
      key = g_strdup_printf ("%s/0x%x/0x%x",
                                    buf, GPOINTER_TO_INT (lpName), wLanguage);
    }
  else
    {
      gchar *utf8str, *tmp;

      utf8str = g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL);
      tmp = g_utf8_strup (utf8str, -1);
      g_free (utf8str);
      key = g_strdup_printf ("%s/%s/0x%x", buf, tmp, wLanguage);
      g_free (tmp);
    }
  g_free (buf);
  data = w32ldr_get_resource (((W32LdrModule *)hModule) - 1, key);
  g_free (key);
  return data;
}


/* FindResourceW ordinal = 186, argument = 12 */
HRSRC WINAPI FindResourceW (HMODULE hModule, LPCWSTR lpName, LPCWSTR lpType)
{
  guint16 langid, primary, secondary;
  HRSRC hRsrc;

  langid = GetUserDefaultUILanguage ();
  hRsrc = FindResourceExW (hModule, lpType, lpName, langid);
  if (hRsrc)
    return hRsrc;
  primary = PRIMARYLANGID (langid);
  for (secondary = 0; secondary < 0x40; secondary++)
    if ((hRsrc = FindResourceExW (hModule, lpType, lpName,
                                            MAKELANGID (primary, secondary))))
      return hRsrc;
  for (primary = 0; primary < 0x400; primary++)
    for (secondary = 0; secondary < 0x40; secondary++)
      if ((hRsrc = FindResourceExW (hModule, lpType, lpName,
                                            MAKELANGID (primary, secondary))))
        return hRsrc;
  return NULL;
}


/* FindVolumeClose ordinal = 187, argument = 4 temporary */
DWORD WINAPI FindVolumeClose (DWORD dwArgv0)
{
  return 0;
}


/* FindVolumeMountPointClose ordinal = 188, argument = 4 temporary */
DWORD WINAPI FindVolumeMountPointClose (DWORD dwArgv0)
{
  return 0;
}


/* FlushConsoleInputBuffer ordinal = 189, argument = 4 temporary */
DWORD WINAPI FlushConsoleInputBuffer (DWORD dwArgv0)
{
  return 0;
}


/* FlushFileBuffers ordinal = 190, argument = 4 */
BOOL WINAPI FlushFileBuffers (HANDLE hFile)
{
  return TRUE;
}


/* FlushInstructionCache ordinal = 191, argument = 12 temporary */
DWORD WINAPI FlushInstructionCache (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FlushViewOfFile ordinal = 192, argument = 8 temporary */
DWORD WINAPI FlushViewOfFile (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FoldStringA ordinal = 193, argument = 20 temporary */
DWORD WINAPI FoldStringA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* FoldStringW ordinal = 194, argument = 20 temporary */
DWORD WINAPI FoldStringW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* FormatMessageA ordinal = 195, argument = 28 temporary */
DWORD WINAPI FormatMessageA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* FormatMessageW ordinal = 196, argument = 28 temporary */
DWORD WINAPI FormatMessageW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* FreeConsole ordinal = 197, argument = 0 temporary */
DWORD WINAPI FreeConsole (VOID)
{
  return 0;
}


/* FreeEnvironmentStringsA ordinal = 198, argument = 4 */
BOOL WINAPI FreeEnvironmentStringsA (LPSTR lpszEnvironmentBlock)
{
  return TRUE;
}


/* FreeEnvironmentStringsW ordinal = 199, argument = 4 */
BOOL WINAPI FreeEnvironmentStringsW (LPWSTR lpszEnvironmentBlock)
{
  return TRUE;
}


/* FreeLibrary ordinal = 200, argument = 4 */
BOOL WINAPI FreeLibrary (HMODULE hModule)
{
  return hModule ? w32ldr_free_module (((W32LdrModule *)hModule) - 1) : FALSE;
}


/* FreeLibraryAndExitThread ordinal = 201, argument = 8 temporary */
DWORD WINAPI FreeLibraryAndExitThread (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FreeResource ordinal = 202, argument = 4 */
BOOL WINAPI FreeResource (HGLOBAL hResData)
{
  return TRUE;
}


/* FreeUserPhysicalPages ordinal = 203, argument = 12 temporary */
DWORD WINAPI FreeUserPhysicalPages (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FreeVirtualBuffer ordinal = 204, argument = 0 temporary */
DWORD WINAPI FreeVirtualBuffer (VOID)
{
  return 0;
}


/* GenerateConsoleCtrlEvent ordinal = 205, argument = 8 temporary */
DWORD WINAPI GenerateConsoleCtrlEvent (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetACP ordinal = 206, argument = 0 */
UINT WINAPI GetACP (VOID)
{
  W32LdrNlsInfo *nls_info;

  nls_info = get_nls_information ();
  return nls_info->acp == 0 ? 1252 : nls_info->acp;
}


/* GetAtomNameA ordinal = 207, argument = 12 temporary */
DWORD WINAPI GetAtomNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetAtomNameW ordinal = 208, argument = 12 temporary */
DWORD WINAPI GetAtomNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetBinaryType ordinal = 209, argument = 8 temporary */
/* DWORD WINAPI GetBinaryType (DWORD dwArgv0, DWORD dwArgv1) */


/* GetBinaryTypeA ordinal = 210, argument = 8 temporary */
DWORD WINAPI GetBinaryTypeA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetBinaryTypeW ordinal = 211, argument = 8 temporary */
DWORD WINAPI GetBinaryTypeW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCPInfo ordinal = 212, argument = 8 */
BOOL WINAPI GetCPInfo (UINT CodePage, LPCPINFO lpCPInfo)
{
  gint i;
  CPINFOEXA CPInfoExA;

  if (!lpCPInfo || !GetCPInfoExA (CodePage, 0, &CPInfoExA))
    return FALSE;
  lpCPInfo->MaxCharSize = CPInfoExA.MaxCharSize;
  for (i = 0; i < MAX_DEFAULTCHAR; i++)
    lpCPInfo->DefaultChar[i] = CPInfoExA.DefaultChar[i];
  for (i = 0; i < MAX_LEADBYTES; i++)
    lpCPInfo->LeadByte[i] = CPInfoExA.LeadByte[i];
  return TRUE;
}


/* GetCPInfoExA ordinal = 213, argument = 12 */
BOOL WINAPI GetCPInfoExA (UINT CodePage, DWORD dwFlags, LPCPINFOEXA lpCPInfoEx)
{
  if (!lpCPInfoEx)
    return FALSE;
  g_memset (lpCPInfoEx, 0, sizeof (CPINFOEXA));
  lpCPInfoEx->DefaultChar[0] = '?';
  lpCPInfoEx->UnicodeDefaultChar = '?';
  switch (CodePage)
    {
      case CP_ACP:
      case CP_MACCP: lpCPInfoEx->CodePage = GetACP (); break;
      case CP_OEMCP: lpCPInfoEx->CodePage = GetOEMCP (); break;
      default:       lpCPInfoEx->CodePage = CodePage;
    }
  switch (lpCPInfoEx->CodePage)
    {
      case  437: g_strcpy (lpCPInfoEx->CodePageName, "US (OEM)"); break;
      case  720: g_strcpy (lpCPInfoEx->CodePageName, "Arabic (OEM)"); break;
      case  737: g_strcpy (lpCPInfoEx->CodePageName, "Greek (OEM)"); break;
      case  775: g_strcpy (lpCPInfoEx->CodePageName, "Baltic (OEM)"); break;
      case  850: g_strcpy (lpCPInfoEx->CodePageName, "Multilingual Latin I (OEM)"); break;
      case  852: g_strcpy (lpCPInfoEx->CodePageName, "Latin II (OEM)"); break;
      case  855: g_strcpy (lpCPInfoEx->CodePageName, "Cyrillic (OEM)"); break;
      case  857: g_strcpy (lpCPInfoEx->CodePageName, "Turkish (OEM)"); break;
      case  858: g_strcpy (lpCPInfoEx->CodePageName, "Multilingual Latin I + Euro (OEM)"); break;
      case  862: g_strcpy (lpCPInfoEx->CodePageName, "Hebrew (OEM)"); break;
      case  866: g_strcpy (lpCPInfoEx->CodePageName, "Russian (OEM)"); break;
      case  874: g_strcpy (lpCPInfoEx->CodePageName, "Thai"); break;
      case  932: g_strcpy (lpCPInfoEx->CodePageName, "Japanese Shift-JIS"); break;
      case  936: g_strcpy (lpCPInfoEx->CodePageName, "Simplified Chinese GBK"); break;
      case  949: g_strcpy (lpCPInfoEx->CodePageName, "Korean"); break;
      case  950: g_strcpy (lpCPInfoEx->CodePageName, "Traditional Chinese Big5"); break;
      case 1250: g_strcpy (lpCPInfoEx->CodePageName, "Central Europe"); break;
      case 1251: g_strcpy (lpCPInfoEx->CodePageName, "Cyrillic"); break;
      case 1252: g_strcpy (lpCPInfoEx->CodePageName, "Latin I"); break;
      case 1253: g_strcpy (lpCPInfoEx->CodePageName, "Greek"); break;
      case 1254: g_strcpy (lpCPInfoEx->CodePageName, "Turkish"); break;
      case 1255: g_strcpy (lpCPInfoEx->CodePageName, "Hebrew"); break;
      case 1256: g_strcpy (lpCPInfoEx->CodePageName, "Arabic"); break;
      case 1257: g_strcpy (lpCPInfoEx->CodePageName, "Baltic"); break;
      case 1258: g_strcpy (lpCPInfoEx->CodePageName, "Vietnam"); break;
      default:   g_strcpy (lpCPInfoEx->CodePageName, "Latin I"); lpCPInfoEx->CodePage = 1252;
    }
  switch (lpCPInfoEx->CodePage)
    {
      case  932:
        lpCPInfoEx->MaxCharSize = 2;
        lpCPInfoEx->LeadByte[0] = 0x81; lpCPInfoEx->LeadByte[1] = 0x9f;
        lpCPInfoEx->LeadByte[2] = 0xe0; lpCPInfoEx->LeadByte[3] = 0xfc;
        break;
      case  936:
      case  949:
      case  950:
        lpCPInfoEx->MaxCharSize = 2;
        lpCPInfoEx->LeadByte[0] = 0x81; lpCPInfoEx->LeadByte[1] = 0xfe;
        break;
      default:
        lpCPInfoEx->MaxCharSize = 1;
    }
  return TRUE;
}


/* GetCPInfoExW ordinal = 214, argument = 12 */
BOOL WINAPI GetCPInfoExW (UINT CodePage, DWORD dwFlags, LPCPINFOEXW lpCPInfoEx)
{
  gint i;
  CPINFOEXA CPInfoExA;

  if (!lpCPInfoEx || !GetCPInfoExA (CodePage, dwFlags, &CPInfoExA))
    return FALSE;
  lpCPInfoEx->MaxCharSize = CPInfoExA.MaxCharSize;
  for (i = 0; i < MAX_DEFAULTCHAR; i++)
    lpCPInfoEx->DefaultChar[i] = CPInfoExA.DefaultChar[i];
  for (i = 0; i < MAX_LEADBYTES; i++)
    lpCPInfoEx->LeadByte[i] = CPInfoExA.LeadByte[i];
  lpCPInfoEx->UnicodeDefaultChar = CPInfoExA.UnicodeDefaultChar;
  lpCPInfoEx->CodePage = CPInfoExA.CodePage;
  for (i = 0; i < MAX_PATH; i++)
    lpCPInfoEx->CodePageName[i] = CPInfoExA.CodePageName[i];
  return TRUE;
}


/* GetCalendarInfoA ordinal = 215, argument = 24 temporary */
DWORD WINAPI GetCalendarInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetCalendarInfoW ordinal = 216, argument = 24 temporary */
DWORD WINAPI GetCalendarInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetCommConfig ordinal = 217, argument = 12 temporary */
DWORD WINAPI GetCommConfig (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetCommMask ordinal = 218, argument = 8 temporary */
DWORD WINAPI GetCommMask (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCommModemStatus ordinal = 219, argument = 8 temporary */
DWORD WINAPI GetCommModemStatus (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCommProperties ordinal = 220, argument = 8 temporary */
DWORD WINAPI GetCommProperties (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCommState ordinal = 221, argument = 8 temporary */
DWORD WINAPI GetCommState (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCommTimeouts ordinal = 222, argument = 8 temporary */
DWORD WINAPI GetCommTimeouts (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCommandLineA ordinal = 223, argument = 0 */
LPSTR WINAPI GetCommandLineA (VOID)
{
  static gchar *prgname = NULL;

  if (!prgname)
    {
      gchar *tmp;

      tmp = g_get_prgname ();
      prgname = w32ldr_utf8_to_mb (tmp);
      g_free (tmp);
    }
  return prgname;
}


/* GetCommandLineW ordinal = 224, argument = 0 */
LPWSTR WINAPI GetCommandLineW (VOID)
{
  static gunichar2 *prgname = NULL;

  if (!prgname)
    {
      gchar *tmp;

      tmp = g_get_prgname ();
      prgname = g_utf8_to_utf16 (tmp, -1, NULL, NULL, NULL);
      g_free (tmp);
    }
  return prgname;
}


/* GetCompressedFileSizeA ordinal = 225, argument = 8 temporary */
DWORD WINAPI GetCompressedFileSizeA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCompressedFileSizeW ordinal = 226, argument = 8 temporary */
DWORD WINAPI GetCompressedFileSizeW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetComputerNameA ordinal = 227, argument = 8 temporary */
DWORD WINAPI GetComputerNameA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetComputerNameExA ordinal = 228, argument = 12 temporary */
DWORD WINAPI GetComputerNameExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetComputerNameExW ordinal = 229, argument = 12 temporary */
DWORD WINAPI GetComputerNameExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetComputerNameW ordinal = 230, argument = 8 temporary */
DWORD WINAPI GetComputerNameW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleAliasA ordinal = 231, argument = 16 temporary */
DWORD WINAPI GetConsoleAliasA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetConsoleAliasExesA ordinal = 232, argument = 8 temporary */
DWORD WINAPI GetConsoleAliasExesA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleAliasExesLengthA ordinal = 233, argument = 0 temporary */
DWORD WINAPI GetConsoleAliasExesLengthA (VOID)
{
  return 0;
}


/* GetConsoleAliasExesLengthW ordinal = 234, argument = 0 temporary */
DWORD WINAPI GetConsoleAliasExesLengthW (VOID)
{
  return 0;
}


/* GetConsoleAliasExesW ordinal = 235, argument = 8 temporary */
DWORD WINAPI GetConsoleAliasExesW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleAliasW ordinal = 236, argument = 16 temporary */
DWORD WINAPI GetConsoleAliasW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetConsoleAliasesA ordinal = 237, argument = 12 temporary */
DWORD WINAPI GetConsoleAliasesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetConsoleAliasesLengthA ordinal = 238, argument = 4 temporary */
DWORD WINAPI GetConsoleAliasesLengthA (DWORD dwArgv0)
{
  return 0;
}


/* GetConsoleAliasesLengthW ordinal = 239, argument = 4 temporary */
DWORD WINAPI GetConsoleAliasesLengthW (DWORD dwArgv0)
{
  return 0;
}


/* GetConsoleAliasesW ordinal = 240, argument = 12 temporary */
DWORD WINAPI GetConsoleAliasesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetConsoleCP ordinal = 241, argument = 0 temporary */
DWORD WINAPI GetConsoleCP (VOID)
{
  return 0;
}


/* GetConsoleCharType ordinal = 242, argument = 0 temporary */
DWORD WINAPI GetConsoleCharType (VOID)
{
  return 0;
}


/* GetConsoleCommandHistoryA ordinal = 243, argument = 0 temporary */
DWORD WINAPI GetConsoleCommandHistoryA (VOID)
{
  return 0;
}


/* GetConsoleCommandHistoryLengthA ordinal = 244, argument = 0 temporary */
DWORD WINAPI GetConsoleCommandHistoryLengthA (VOID)
{
  return 0;
}


/* GetConsoleCommandHistoryLengthW ordinal = 245, argument = 0 temporary */
DWORD WINAPI GetConsoleCommandHistoryLengthW (VOID)
{
  return 0;
}


/* GetConsoleCommandHistoryW ordinal = 246, argument = 0 temporary */
DWORD WINAPI GetConsoleCommandHistoryW (VOID)
{
  return 0;
}


/* GetConsoleCursorInfo ordinal = 247, argument = 8 temporary */
DWORD WINAPI GetConsoleCursorInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleCursorMode ordinal = 248, argument = 0 temporary */
DWORD WINAPI GetConsoleCursorMode (VOID)
{
  return 0;
}


/* GetConsoleDisplayMode ordinal = 249, argument = 4 temporary */
DWORD WINAPI GetConsoleDisplayMode (DWORD dwArgv0)
{
  return 0;
}


/* GetConsoleFontInfo ordinal = 250, argument = 0 temporary */
DWORD WINAPI GetConsoleFontInfo (VOID)
{
  return 0;
}


/* GetConsoleFontSize ordinal = 251, argument = 8 temporary */
DWORD WINAPI GetConsoleFontSize (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleHardwareState ordinal = 252, argument = 0 temporary */
DWORD WINAPI GetConsoleHardwareState (VOID)
{
  return 0;
}


/* GetConsoleInputExeNameA ordinal = 253, argument = 0 temporary */
DWORD WINAPI GetConsoleInputExeNameA (VOID)
{
  return 0;
}


/* GetConsoleInputExeNameW ordinal = 254, argument = 0 temporary */
DWORD WINAPI GetConsoleInputExeNameW (VOID)
{
  return 0;
}


/* GetConsoleInputWaitHandle ordinal = 255, argument = 0 temporary */
DWORD WINAPI GetConsoleInputWaitHandle (VOID)
{
  return 0;
}


/* GetConsoleKeyboardLayoutNameA ordinal = 256, argument = 0 temporary */
DWORD WINAPI GetConsoleKeyboardLayoutNameA (VOID)
{
  return 0;
}


/* GetConsoleKeyboardLayoutNameW ordinal = 257, argument = 0 temporary */
DWORD WINAPI GetConsoleKeyboardLayoutNameW (VOID)
{
  return 0;
}


/* GetConsoleMode ordinal = 258, argument = 8 temporary */
DWORD WINAPI GetConsoleMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleNlsMode ordinal = 259, argument = 0 temporary */
DWORD WINAPI GetConsoleNlsMode (VOID)
{
  return 0;
}


/* GetConsoleOutputCP ordinal = 260, argument = 0 temporary */
DWORD WINAPI GetConsoleOutputCP (VOID)
{
  return 0;
}


/* GetConsoleScreenBufferInfo ordinal = 261, argument = 8 temporary */
DWORD WINAPI GetConsoleScreenBufferInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleTitleA ordinal = 262, argument = 8 temporary */
DWORD WINAPI GetConsoleTitleA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleTitleW ordinal = 263, argument = 8 temporary */
DWORD WINAPI GetConsoleTitleW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetConsoleWindow ordinal = 264, argument = 0 temporary */
DWORD WINAPI GetConsoleWindow (VOID)
{
  return 0;
}


/* GetCurrencyFormatA ordinal = 265, argument = 24 temporary */
DWORD WINAPI GetCurrencyFormatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetCurrencyFormatW ordinal = 266, argument = 24 temporary */
DWORD WINAPI GetCurrencyFormatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetCurrentConsoleFont ordinal = 267, argument = 12 temporary */
DWORD WINAPI GetCurrentConsoleFont (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetCurrentDirectoryA ordinal = 268, argument = 8 temporary */
DWORD WINAPI GetCurrentDirectoryA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCurrentDirectoryW ordinal = 269, argument = 8 temporary */
DWORD WINAPI GetCurrentDirectoryW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCurrentProcess ordinal = 270, argument = 0 */
HANDLE WINAPI GetCurrentProcess (VOID)
{
  return (HANDLE)-1;
}


/* GetCurrentProcessId ordinal = 271, argument = 0 temporary */
DWORD WINAPI GetCurrentProcessId (VOID)
{
  return 0;
}


/* GetCurrentThread ordinal = 272, argument = 0 */
HANDLE WINAPI GetCurrentThread (VOID)
{
#ifdef USE_THREAD
  static HANDLE hThread = INVALID_HANDLE_VALUE;

  if (hThread == INVALID_HANDLE_VALUE)
    {
      hThread = g_malloc0 (sizeof (W32LdrHandle));
      hThread->counter = 1;
      hThread->gthread = g_thread_self ();
    }
  return hThread;
#else /* not USE_THREAD */
  return (HANDLE)0xfffffffe;
#endif /* not USE_THREAD */
}


/* GetCurrentThreadId ordinal = 273, argument = 0 */
DWORD WINAPI GetCurrentThreadId (VOID)
{
#ifdef USE_THREAD
  static HANDLE hThread = INVALID_HANDLE_VALUE;

  if (hThread == INVALID_HANDLE_VALUE)
    {
      hThread = g_malloc0 (sizeof (W32LdrHandle));
      hThread->counter = 1;
      hThread->gthread = g_thread_self ();
    }
  return (DWORD)hThread;
#else /* not USE_THREAD */
  return 0xfffffffe;
#endif /* not USE_THREAD */
}


/* GetDateFormatA ordinal = 274, argument = 24 temporary */
DWORD WINAPI GetDateFormatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetDateFormatW ordinal = 275, argument = 24 temporary */
DWORD WINAPI GetDateFormatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetDefaultCommConfigA ordinal = 276, argument = 12 temporary */
DWORD WINAPI GetDefaultCommConfigA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetDefaultCommConfigW ordinal = 277, argument = 12 temporary */
DWORD WINAPI GetDefaultCommConfigW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetDefaultSortkeySize ordinal = 278, argument = 0 temporary */
DWORD WINAPI GetDefaultSortkeySize (VOID)
{
  return 0;
}


/* GetDevicePowerState ordinal = 279, argument = 8 temporary */
DWORD WINAPI GetDevicePowerState (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetDiskFreeSpaceA ordinal = 280, argument = 20 temporary */
DWORD WINAPI GetDiskFreeSpaceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetDiskFreeSpaceExA ordinal = 281, argument = 16 temporary */
DWORD WINAPI GetDiskFreeSpaceExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetDiskFreeSpaceExW ordinal = 282, argument = 16 temporary */
DWORD WINAPI GetDiskFreeSpaceExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetDiskFreeSpaceW ordinal = 283, argument = 20 temporary */
DWORD WINAPI GetDiskFreeSpaceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetDriveTypeA ordinal = 284, argument = 4 temporary */
DWORD WINAPI GetDriveTypeA (DWORD dwArgv0)
{
  return 0;
}


/* GetDriveTypeW ordinal = 285, argument = 4 temporary */
DWORD WINAPI GetDriveTypeW (DWORD dwArgv0)
{
  return 0;
}


/* GetEnvironmentStrings ordinal = 286, argument = 0 */
/* LPVOID WINAPI GetEnvironmentStrings (VOID) */


/* GetEnvironmentStringsA ordinal = 287, argument = 0 */
LPVOID WINAPI GetEnvironmentStringsA (VOID)
{
  static gchar cEnv[] = {'\0', '\0'};

  return cEnv;
}


/* GetEnvironmentStringsW ordinal = 288, argument = 0 */
LPVOID WINAPI GetEnvironmentStringsW (VOID)
{
  static gunichar2 wEnv[] = {'\0', '\0'};

  return wEnv;
}


/* GetEnvironmentVariableA ordinal = 289, argument = 12 */
DWORD WINAPI GetEnvironmentVariableA (LPCSTR lpName, LPSTR lpBuffer, DWORD nSize)
{
  gsize leng;
  gchar *ev, *name;

  name = w32ldr_utf8_from_mb (lpName);
  ev = w32ldr_utf8_to_mb (g_getenv (name));
  g_free (name);
  if (!ev)
    return 0;
  leng = g_strlen (ev);
  if (!lpBuffer || nSize <= leng)
    {
      g_free (ev);
      return leng + 1;
    }
  g_strcpy (lpBuffer, ev);
  g_free (ev);
  return leng;
}


/* GetEnvironmentVariableW ordinal = 290, argument = 12 */
DWORD WINAPI GetEnvironmentVariableW (LPCWSTR lpName, LPWSTR lpBuffer, DWORD nSize)
{
  gsize leng;
  gchar *name;
  gunichar2 *ev;

  name = g_utf16_to_utf8 (lpName, -1, NULL, NULL, NULL);
  ev = g_utf8_to_utf16 (g_getenv (name), -1, NULL, NULL, NULL);
  g_free (name);
  if (!ev)
    return 0;
  leng = lstrlenW (ev);
  if (!lpBuffer || nSize <= leng)
    {
      g_free (ev);
      return leng + 1;
    }
  lstrcpyW (lpBuffer, ev);
  g_free (ev);
  return leng;
}


/* GetExitCodeProcess ordinal = 291, argument = 8 temporary */
DWORD WINAPI GetExitCodeProcess (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetExitCodeThread ordinal = 292, argument = 8 temporary */
DWORD WINAPI GetExitCodeThread (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetFileAttributesA ordinal = 293, argument = 4 temporary */
DWORD WINAPI GetFileAttributesA (DWORD dwArgv0)
{
  return 0;
}


/* GetFileAttributesExA ordinal = 294, argument = 12 temporary */
DWORD WINAPI GetFileAttributesExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetFileAttributesExW ordinal = 295, argument = 12 temporary */
DWORD WINAPI GetFileAttributesExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetFileAttributesW ordinal = 296, argument = 4 temporary */
DWORD WINAPI GetFileAttributesW (DWORD dwArgv0)
{
  return 0;
}


/* GetFileInformationByHandle ordinal = 297, argument = 8 temporary */
DWORD WINAPI GetFileInformationByHandle (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetFileSize ordinal = 298, argument = 8 */
DWORD WINAPI GetFileSize (HANDLE hFile, LPDWORD lpFileSizeHigh)
{
  if (lpFileSizeHigh)
    lpFileSizeHigh = 0;
  return fileio_size (hFile->fio);
}


/* GetFileSizeEx ordinal = 299, argument = 8 temporary */
DWORD WINAPI GetFileSizeEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetFileTime ordinal = 300, argument = 16 temporary */
DWORD WINAPI GetFileTime (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetFileType ordinal = 301, argument = 4 */
DWORD WINAPI GetFileType (HANDLE hFile)
{
  return FILE_TYPE_DISK;
}


/* GetFullPathNameA ordinal = 302, argument = 16 temporary */
DWORD WINAPI GetFullPathNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetFullPathNameW ordinal = 303, argument = 16 temporary */
DWORD WINAPI GetFullPathNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetHandleInformation ordinal = 304, argument = 8 temporary */
DWORD WINAPI GetHandleInformation (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetLargestConsoleWindowSize ordinal = 305, argument = 4 temporary */
DWORD WINAPI GetLargestConsoleWindowSize (DWORD dwArgv0)
{
  return 0;
}


/* GetLastError ordinal = 306, argument = 0 */
DWORD WINAPI GetLastError (VOID)
{
  return 0;
}


/* GetLinguistLangSize ordinal = 307, argument = 0 temporary */
DWORD WINAPI GetLinguistLangSize (VOID)
{
  return 0;
}


/* GetLocalTime ordinal = 308, argument = 4 */
VOID WINAPI GetLocalTime (LPSYSTEMTIME lpSystemTime)
{

  if (lpSystemTime)
    {
      time_t t;
      struct tm *tm;

      t = time (NULL);
      tm = localtime (&t);
      if (tm)
        {
          lpSystemTime->wYear = tm->tm_year + 1900;
          lpSystemTime->wMonth = tm->tm_mon + 1;
          lpSystemTime->wDayOfWeek = tm->tm_wday;
          lpSystemTime->wDay = tm->tm_mday;
          lpSystemTime->wHour = tm->tm_hour;
          lpSystemTime->wMinute = tm->tm_min;
          lpSystemTime->wSecond = tm->tm_sec;
        }
      else
        {
          lpSystemTime->wYear = 1980;
          lpSystemTime->wMonth = 1;
          lpSystemTime->wDayOfWeek = 2;
          lpSystemTime->wDay = 1;
          lpSystemTime->wHour = 0;
          lpSystemTime->wMinute = 0;
          lpSystemTime->wSecond = 0;
        }
      lpSystemTime->wMilliseconds = 0;
    }
}


/* GetLocaleInfo ordinal = 309, argument = 16 */
INT WINAPI GetLocaleInfoA (LCID Locale, LCTYPE LCType, LPSTR lpLCData, INT cchData)
{
  if (lpLCData && cchData > 0)
    lpLCData[0] = '\0';
  return 0;
}


/* GetLocaleInfoW ordinal = 310, argument = 16 */
INT WINAPI GetLocaleInfoW (LCID Locale, LCTYPE LCType, LPWSTR lpLCData, INT cchData)
{
  if (lpLCData && cchData > 0)
    lpLCData[0] = '\0';
  return 0;
}


/* GetLogicalDriveStringsA ordinal = 311, argument = 8 temporary */
DWORD WINAPI GetLogicalDriveStringsA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetLogicalDriveStringsW ordinal = 312, argument = 8 temporary */
DWORD WINAPI GetLogicalDriveStringsW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetLogicalDrives ordinal = 313, argument = 0 temporary */
DWORD WINAPI GetLogicalDrives (VOID)
{
  return 0;
}


/* GetLongPathNameA ordinal = 314, argument = 12 temporary */
DWORD WINAPI GetLongPathNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetLongPathNameW ordinal = 315, argument = 12 temporary */
DWORD WINAPI GetLongPathNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetMailslotInfo ordinal = 316, argument = 20 temporary */
DWORD WINAPI GetMailslotInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetModuleFileNameA ordinal = 317, argument = 12 */
DWORD WINAPI GetModuleFileNameA (HMODULE hModule, LPSTR lpFilename, DWORD nSize)
{
  gchar *file;

  if (!lpFilename || nSize <= 0)
    return 0;
  file = w32ldr_filename_to_mb (hModule ? ((W32LdrModule *)hModule)[-1].file
                                        : g_get_prgname ());
  g_strncpy (lpFilename, file, nSize);
  g_free (file);
  return g_strlen (lpFilename);
}


/* GetModuleFileNameW ordinal = 318, argument = 12 */
DWORD WINAPI GetModuleFileNameW (HMODULE hModule, LPWSTR lpFilename, DWORD nSize)
{
  gunichar2 *file;

  if (!lpFilename || nSize <= 0)
    return 0;
  file = w32ldr_filename_to_wc (hModule ? ((W32LdrModule *)hModule)[-1].file
                                        : g_get_prgname ());
  lstrcpynW (lpFilename, file, nSize);
  g_free (file);
  return lstrlenW (lpFilename);
}


/* GetModuleHandleA ordinal = 319, argument = 4 */
HMODULE WINAPI GetModuleHandleA (LPCSTR lpModuleName)
{
  gchar *file;
  W32LdrModule *module;

  file = w32ldr_filename_from_mb (lpModuleName);
  module = w32ldr_get_module (file);
  g_free (file);
  return module ? module + 1 : NULL;
}


/* GetModuleHandleW ordinal = 320, argument = 4 */
HMODULE WINAPI GetModuleHandleW (LPCWSTR lpModuleName)
{
  gchar *file;
  W32LdrModule *module;

  file = w32ldr_filename_from_wc (lpModuleName);
  module = w32ldr_get_module (file);
  g_free (file);
  return module ? module + 1 : NULL;
}


/* GetNamedPipeHandleStateA ordinal = 321, argument = 28 temporary */
DWORD WINAPI GetNamedPipeHandleStateA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetNamedPipeHandleStateW ordinal = 322, argument = 28 temporary */
DWORD WINAPI GetNamedPipeHandleStateW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetNamedPipeInfo ordinal = 323, argument = 20 temporary */
DWORD WINAPI GetNamedPipeInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetNextVDMCommand ordinal = 324, argument = 0 temporary */
DWORD WINAPI GetNextVDMCommand (VOID)
{
  return 0;
}


/* GetNlsSectionName ordinal = 325, argument = 0 temporary */
DWORD WINAPI GetNlsSectionName (VOID)
{
  return 0;
}


/* GetNumberFormatA ordinal = 326, argument = 24 temporary */
DWORD WINAPI GetNumberFormatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetNumberFormatW ordinal = 327, argument = 24 temporary */
DWORD WINAPI GetNumberFormatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetNumberOfConsoleFonts ordinal = 328, argument = 0 temporary */
DWORD WINAPI GetNumberOfConsoleFonts (VOID)
{
  return 0;
}


/* GetNumberOfConsoleInputEvents ordinal = 329, argument = 8 temporary */
DWORD WINAPI GetNumberOfConsoleInputEvents (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetNumberOfConsoleMouseButtons ordinal = 330, argument = 4 temporary */
DWORD WINAPI GetNumberOfConsoleMouseButtons (DWORD dwArgv0)
{
  return 0;
}


/* GetOEMCP ordinal = 331, argument = 0 */
UINT WINAPI GetOEMCP (VOID)
{
  W32LdrNlsInfo *nls_info;

  nls_info = get_nls_information ();
  return nls_info->oemcp == 1 ? 850 : nls_info->oemcp;
}


/* GetOverlappedResult ordinal = 332, argument = 16 temporary */
DWORD WINAPI GetOverlappedResult (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetPriorityClass ordinal = 333, argument = 4 temporary */
DWORD WINAPI GetPriorityClass (DWORD dwArgv0)
{
  return 0;
}


/* GetPrivateProfileIntA ordinal = 334, argument = 16 */
UINT WINAPI GetPrivateProfileIntA (LPCSTR lpAppName, LPCSTR lpKeyName, INT nDefault, LPCSTR lpFileName)
{
  gchar *group, *key, *file, *tmp;
  GKeyFile *key_file;
  UINT uResult;

  group = w32ldr_utf8_from_mb (lpAppName);
  key = w32ldr_utf8_from_mb (lpKeyName);
  tmp = w32ldr_filename_from_mb (lpFileName);
  file = w32ldr_dir_get_filename_for_read (tmp);
  g_free (tmp);
  key_file = g_key_file_new ();
  uResult = g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL)
                            && g_key_file_has_key (key_file, group, key, NULL)
            ? g_key_file_get_integer (key_file, group, key, NULL) : nDefault;
  g_key_file_free (key_file);
  g_free (file);
  g_free (group);
  g_free (key);
  return uResult;
}


/* GetPrivateProfileIntW ordinal = 335, argument = 16 */
UINT WINAPI GetPrivateProfileIntW (LPCWSTR lpAppName, LPCWSTR lpKeyName, INT nDefault, LPCWSTR lpFileName)
{
  gchar *group, *key, *file, *tmp;
  GKeyFile *key_file;
  UINT uResult;

  group = g_utf16_to_utf8 (lpAppName, -1, NULL, NULL, NULL);
  key = g_utf16_to_utf8 (lpKeyName, -1, NULL, NULL, NULL);
  file = w32ldr_filename_from_wc (lpFileName);
  tmp = w32ldr_filename_from_wc (lpFileName);
  file = w32ldr_dir_get_filename_for_read (tmp);
  g_free (tmp);
  key_file = g_key_file_new ();
  uResult = g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL)
                            && g_key_file_has_key (key_file, group, key, NULL)
            ? g_key_file_get_integer (key_file, group, key, NULL) : nDefault;
  g_key_file_free (key_file);
  g_free (file);
  g_free (group);
  g_free (key);
  return uResult;
}


/* GetPrivateProfileSectionA ordinal = 336, argument = 16 temporary */
DWORD WINAPI GetPrivateProfileSectionA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetPrivateProfileSectionNamesA ordinal = 337, argument = 12 temporary */
DWORD WINAPI GetPrivateProfileSectionNamesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetPrivateProfileSectionNamesW ordinal = 338, argument = 12 temporary */
DWORD WINAPI GetPrivateProfileSectionNamesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetPrivateProfileSectionW ordinal = 339, argument = 16 temporary */
DWORD WINAPI GetPrivateProfileSectionW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetPrivateProfileStringA ordinal = 340, argument = 24 */
DWORD WINAPI GetPrivateProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpDefault, LPSTR lpReturnedString, DWORD nSize, LPCSTR lpFileName)
{
  gchar *group, *key, *file, *str, *tmp;
  GKeyFile *key_file;

  group = w32ldr_utf8_from_mb (lpAppName);
  key = w32ldr_utf8_from_mb (lpKeyName);
  tmp = w32ldr_filename_from_mb (lpFileName);
  file = w32ldr_dir_get_filename_for_read (tmp);
  g_free (tmp);
  key_file = g_key_file_new ();
  str = g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL)
                            && g_key_file_has_key (key_file, group, key, NULL)
                ? g_key_file_get_string (key_file, group, key, NULL) : NULL;
  g_key_file_free (key_file);
  g_free (file);
  g_free (group);
  g_free (key);
  if (str)
    {
      gchar *tmp;

      tmp = w32ldr_utf8_to_mb (str);
      g_free (str);
      str = tmp;
    }
  if (!str)
    str = g_strdup (lpDefault);
  lstrcpynA (lpReturnedString, str, nSize);
  g_free (str);
  return g_strlen (lpReturnedString);
}


/* GetPrivateProfileStringW ordinal = 341, argument = 24 */
DWORD WINAPI GetPrivateProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpDefault, LPWSTR lpReturnedString, DWORD nSize, LPCWSTR lpFileName)
{
  gchar *group, *key, *file, *str, *tmp;
  gunichar2 *utf16str = NULL;
  GKeyFile *key_file;

  group = g_utf16_to_utf8 (lpAppName, -1, NULL, NULL, NULL);
  key = g_utf16_to_utf8 (lpKeyName, -1, NULL, NULL, NULL);
  tmp = w32ldr_filename_from_wc (lpFileName);
  file = w32ldr_dir_get_filename_for_read (tmp);
  g_free (tmp);
  key_file = g_key_file_new ();
  str = g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL)
                            && g_key_file_has_key (key_file, group, key, NULL)
                ? g_key_file_get_string (key_file, group, key, NULL) : NULL;
  g_key_file_free (key_file);
  g_free (file);
  g_free (group);
  g_free (key);
  if (str)
    {
      utf16str = g_utf8_to_utf16 (str, -1, NULL, NULL, NULL);
      g_free (str);
    }
  lstrcpynW (lpReturnedString, utf16str ? utf16str : lpDefault, nSize);
  g_free (utf16str);
  return lstrlenW (lpReturnedString);
}


/* GetPrivateProfileStructA ordinal = 342, argument = 20 temporary */
DWORD WINAPI GetPrivateProfileStructA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetPrivateProfileStructW ordinal = 343, argument = 20 temporary */
DWORD WINAPI GetPrivateProfileStructW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetProcAddress ordinal = 344, argument = 8 */
FARPROC WINAPI GetProcAddress (HMODULE hModule, LPCSTR lpProcName)
{
  return hModule ? w32ldr_get_func (((W32LdrModule *)hModule) - 1, lpProcName)
                 : NULL;
}


/* GetProcessAffinityMask ordinal = 345, argument = 12 temporary */
DWORD WINAPI GetProcessAffinityMask (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetProcessHeap ordinal = 346, argument = 0 */
HANDLE WINAPI GetProcessHeap (VOID)
{
  return NULL;
}


/* GetProcessHeaps ordinal = 347, argument = 8 */
DWORD WINAPI GetProcessHeaps (DWORD NumberOfHeaps, HANDLE *ProcessHeaps)
{
  return 0;
}


/* GetProcessIoCounters ordinal = 348, argument = 8 temporary */
DWORD WINAPI GetProcessIoCounters (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetProcessPriorityBoost ordinal = 349, argument = 8 temporary */
DWORD WINAPI GetProcessPriorityBoost (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetProcessShutdownParameters ordinal = 350, argument = 8 temporary */
DWORD WINAPI GetProcessShutdownParameters (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetProcessTimes ordinal = 351, argument = 20 temporary */
DWORD WINAPI GetProcessTimes (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetProcessVersion ordinal = 352, argument = 4 temporary */
DWORD WINAPI GetProcessVersion (DWORD dwArgv0)
{
  return 0;
}


/* GetProcessWorkingSetSize ordinal = 353, argument = 12 temporary */
DWORD WINAPI GetProcessWorkingSetSize (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetProfileIntA ordinal = 354, argument = 12 */
UINT WINAPI GetProfileIntA (LPCSTR lpAppName, LPCSTR lpKeyName, INT nDefault)
{
  return GetPrivateProfileIntA (lpAppName, lpKeyName, nDefault, "win.ini");
}


/* GetProfileIntW ordinal = 355, argument = 12 */
UINT WINAPI GetProfileIntW (LPCWSTR lpAppName, LPCWSTR lpKeyName, INT nDefault)
{
  gunichar2 file[] = {'w', 'i', 'n', '.', 'i', 'n', 'i', '\0'};

  return GetPrivateProfileIntW (lpAppName, lpKeyName, nDefault, file);
}


/* GetProfileSectionA ordinal = 356, argument = 12 temporary */
DWORD WINAPI GetProfileSectionA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetProfileSectionW ordinal = 357, argument = 12 temporary */
DWORD WINAPI GetProfileSectionW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetProfileStringA ordinal = 358, argument = 20 */
DWORD WINAPI GetProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpDefault, LPSTR lpReturnedString, DWORD nSize)
{
  return GetPrivateProfileStringA (lpAppName, lpKeyName, lpDefault,
                                        lpReturnedString, nSize, "win.ini");
}


/* GetProfileStringW ordinal = 359, argument = 20 */
DWORD WINAPI GetProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpDefault, LPWSTR lpReturnedString, DWORD nSize)
{
  gunichar2 file[] = {'w', 'i', 'n', '.', 'i', 'n', 'i', '\0'};

  return GetPrivateProfileStringW (lpAppName, lpKeyName, lpDefault,
                                                lpReturnedString, nSize, file);
}


/* GetQueuedCompletionStatus ordinal = 360, argument = 20 temporary */
DWORD WINAPI GetQueuedCompletionStatus (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetShortPathNameA ordinal = 361, argument = 12 */
DWORD WINAPI GetShortPathNameA (LPCSTR lpszLongPath, LPSTR lpszShortPath, DWORD cchBuffer)
{
  g_strncpy (lpszShortPath, lpszLongPath, cchBuffer);
  return g_strlen (lpszShortPath);
}


/* GetShortPathNameW ordinal = 362, argument = 12 */
DWORD WINAPI GetShortPathNameW (LPCWSTR lpszLongPath, LPWSTR lpszShortPath, DWORD cchBuffer)
{
  lstrcpynW (lpszShortPath, lpszLongPath, cchBuffer);
  return lstrlenW (lpszShortPath);
}


/* GetStartupInfoA ordinal = 363, argument = 4 temporary */
DWORD WINAPI GetStartupInfoA (DWORD dwArgv0)
{
  return 0;
}


/* GetStartupInfoW ordinal = 364, argument = 4 temporary */
DWORD WINAPI GetStartupInfoW (DWORD dwArgv0)
{
  return 0;
}


/* GetStdHandle ordinal = 365, argument = 4 */
HANDLE WINAPI GetStdHandle (DWORD nStdHandle)
{
  return INVALID_HANDLE_VALUE;
}


/* GetStringTypeA ordinal = 366, argument = 20 */
BOOL WINAPI GetStringTypeA (LCID Locale, DWORD dwInfoType, LPCSTR lpSrcStr, INT cchSrc, LPWORD lpCharType)
{
  if (!lpSrcStr || !lpCharType)
    return FALSE;
  g_memset (lpCharType, 0,
                (cchSrc < 0 ? g_strlen (lpSrcStr) : cchSrc) * sizeof (WORD));
  return TRUE;
}


/* GetStringTypeExA ordinal = 367, argument = 20 temporary */
DWORD WINAPI GetStringTypeExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetStringTypeExW ordinal = 368, argument = 20 temporary */
DWORD WINAPI GetStringTypeExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetStringTypeW ordinal = 369, argument = 16 */
BOOL WINAPI GetStringTypeW (DWORD dwInfoType, LPCWSTR lpSrcStr, INT cchSrc, LPWORD lpCharType)
{
  if (!lpSrcStr || !lpCharType)
    return FALSE;
  g_memset (lpCharType, 0,
                (cchSrc < 0 ? lstrlenW (lpSrcStr) : cchSrc) * sizeof (WORD));
  return TRUE;
}


/* GetSystemDefaultLCID ordinal = 370, argument = 0 */
DWORD WINAPI GetSystemDefaultLCID (VOID)
{
  W32LdrNlsInfo *nls_info;

  nls_info = get_nls_information ();
  return nls_info->lcid;
}


/* GetSystemDefaultLangID ordinal = 371, argument = 0 */
LANGID WINAPI GetSystemDefaultLangID (VOID)
{
  return LANGIDFROMLCID (GetSystemDefaultLCID ());
}


/* GetSystemDefaultUILanguage ordinal = 372, argument = 0 */
LANGID WINAPI GetSystemDefaultUILanguage (VOID)
{
  return GetSystemDefaultLangID ();
}


/* GetSystemDirectoryA ordinal = 373, argument = 8 */
UINT WINAPI GetSystemDirectoryA (LPSTR lpBuffer, UINT uSize)
{
  gsize leng;
  gchar *dir;

  dir = w32ldr_filename_to_mb (w32ldr_dir_get_path (W32LDR_DIR_SYSTEM));
  leng = g_strlen (dir) + 1;
  if (lpBuffer && uSize >= leng)
    {
      g_strncpy (lpBuffer, dir, uSize);
      leng--;
    }
  return leng;
}


/* GetSystemDirectoryW ordinal = 374, argument = 8 */
UINT WINAPI GetSystemDirectoryW (LPWSTR lpBuffer, UINT uSize)
{
  gsize leng;
  gunichar2 *dir;

  dir = w32ldr_filename_to_wc (w32ldr_dir_get_path (W32LDR_DIR_SYSTEM));
  leng = lstrlenW (dir) + 1;
  if (lpBuffer && uSize >= leng)
    {
      lstrcpynW (lpBuffer, dir, uSize);
      leng--;
    }
  return leng;
}


/* GetSystemInfo ordinal = 375, argument = 4 temporary */
DWORD WINAPI GetSystemInfo (DWORD dwArgv0)
{
  return 0;
}


/* GetSystemPowerStatus ordinal = 376, argument = 4 temporary */
DWORD WINAPI GetSystemPowerStatus (DWORD dwArgv0)
{
  return 0;
}


/* GetSystemTime ordinal = 377, argument = 4 temporary */
DWORD WINAPI GetSystemTime (DWORD dwArgv0)
{
  return 0;
}


/* GetSystemTimeAdjustment ordinal = 378, argument = 12 temporary */
DWORD WINAPI GetSystemTimeAdjustment (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetSystemTimeAsFileTime ordinal = 379, argument = 4 temporary */
DWORD WINAPI GetSystemTimeAsFileTime (DWORD dwArgv0)
{
  return 0;
}


/* GetSystemWindowsDirectoryA ordinal = 380, argument = 8 temporary */
DWORD WINAPI GetSystemWindowsDirectoryA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetSystemWindowsDirectoryW ordinal = 381, argument = 8 temporary */
DWORD WINAPI GetSystemWindowsDirectoryW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetTapeParameters ordinal = 382, argument = 16 temporary */
DWORD WINAPI GetTapeParameters (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetTapePosition ordinal = 383, argument = 20 temporary */
DWORD WINAPI GetTapePosition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetTapeStatus ordinal = 384, argument = 4 temporary */
DWORD WINAPI GetTapeStatus (DWORD dwArgv0)
{
  return 0;
}


/* GetTempFileNameA ordinal = 385, argument = 16 temporary */
DWORD WINAPI GetTempFileNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetTempFileNameW ordinal = 386, argument = 16 temporary */
DWORD WINAPI GetTempFileNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetTempPathA ordinal = 387, argument = 8 temporary */
DWORD WINAPI GetTempPathA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetTempPathW ordinal = 388, argument = 8 temporary */
DWORD WINAPI GetTempPathW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetThreadContext ordinal = 389, argument = 8 temporary */
DWORD WINAPI GetThreadContext (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetThreadLocale ordinal = 390, argument = 0 */
LCID WINAPI GetThreadLocale (VOID)
{
  return GetACP ();
}


/* GetThreadPriority ordinal = 391, argument = 4 temporary */
DWORD WINAPI GetThreadPriority (DWORD dwArgv0)
{
  return 0;
}


/* GetThreadPriorityBoost ordinal = 392, argument = 8 temporary */
DWORD WINAPI GetThreadPriorityBoost (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetThreadSelectorEntry ordinal = 393, argument = 12 temporary */
DWORD WINAPI GetThreadSelectorEntry (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetThreadTimes ordinal = 394, argument = 20 temporary */
DWORD WINAPI GetThreadTimes (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetTickCount ordinal = 395, argument = 0 temporary */
DWORD WINAPI GetTickCount (VOID)
{
  return 0;
}


/* GetTimeFormatA ordinal = 396, argument = 24 temporary */
DWORD WINAPI GetTimeFormatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetTimeFormatW ordinal = 397, argument = 24 temporary */
DWORD WINAPI GetTimeFormatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetTimeZoneInformation ordinal = 398, argument = 4 temporary */
DWORD WINAPI GetTimeZoneInformation (DWORD dwArgv0)
{
  return 0;
}


/* GetUserDefaultLCID ordinal = 399, argument = 0 */
DWORD WINAPI GetUserDefaultLCID (VOID)
{
  return GetSystemDefaultLCID ();
}


/* GetUserDefaultLangID ordinal = 400, argument = 0 */
LANGID WINAPI GetUserDefaultLangID (VOID)
{
  return LANGIDFROMLCID (GetUserDefaultLCID ());
}


/* GetUserDefaultUILanguage ordinal = 401, argument = 0 */
LANGID WINAPI GetUserDefaultUILanguage (VOID)
{
  return GetUserDefaultLangID ();
}


/* GetVDMCurrentDirectories ordinal = 402, argument = 0 temporary */
DWORD WINAPI GetVDMCurrentDirectories (VOID)
{
  return 0;
}


/* GetVersion ordinal = 403, argument = 0 */
DWORD WINAPI GetVersion (VOID)
{
  return 0;
}


/* GetVersionExA ordinal = 404, argument = 4 */
BOOL WINAPI GetVersionExA (LPOSVERSIONINFOA lpVersionInfo)
{
  if (!lpVersionInfo)
    return FALSE;
  lpVersionInfo->dwMajorVersion = 0;
  lpVersionInfo->dwMinorVersion = 0;
  lpVersionInfo->dwBuildNumber = 0;
  lpVersionInfo->dwPlatformId = VER_PLATFORM_WIN32_WINDOWS;
  g_strcpy (lpVersionInfo->szCSDVersion, "w32loader");
  return TRUE;
}


/* GetVersionExW ordinal = 405, argument = 4 */
BOOL WINAPI GetVersionExW (LPOSVERSIONINFOW lpVersionInfo)
{
  if (!lpVersionInfo)
    return FALSE;
  lpVersionInfo->dwMajorVersion = 0;
  lpVersionInfo->dwMinorVersion = 0;
  lpVersionInfo->dwBuildNumber = 0;
  lpVersionInfo->dwPlatformId = VER_PLATFORM_WIN32_WINDOWS;
  lpVersionInfo->szCSDVersion[0] = 'w';
  lpVersionInfo->szCSDVersion[1] = '3';
  lpVersionInfo->szCSDVersion[2] = '2';
  lpVersionInfo->szCSDVersion[3] = 'l';
  lpVersionInfo->szCSDVersion[4] = 'o';
  lpVersionInfo->szCSDVersion[5] = 'a';
  lpVersionInfo->szCSDVersion[6] = 'd';
  lpVersionInfo->szCSDVersion[7] = 'e';
  lpVersionInfo->szCSDVersion[8] = 'r';
  lpVersionInfo->szCSDVersion[9] = '\0';
  return TRUE;
}


/* GetVolumeInformationA ordinal = 406, argument = 32 temporary */
DWORD WINAPI GetVolumeInformationA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* GetVolumeInformationW ordinal = 407, argument = 32 temporary */
DWORD WINAPI GetVolumeInformationW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* GetVolumeNameForVolumeMountPointA ordinal = 408, argument = 12 temporary */
DWORD WINAPI GetVolumeNameForVolumeMountPointA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetVolumeNameForVolumeMountPointW ordinal = 409, argument = 12 temporary */
DWORD WINAPI GetVolumeNameForVolumeMountPointW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetVolumePathNameA ordinal = 410, argument = 12 temporary */
DWORD WINAPI GetVolumePathNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetVolumePathNameW ordinal = 411, argument = 12 temporary */
DWORD WINAPI GetVolumePathNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetWindowsDirectoryA ordinal = 412, argument = 8 temporary */
DWORD WINAPI GetWindowsDirectoryA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWindowsDirectoryW ordinal = 413, argument = 8 temporary */
DWORD WINAPI GetWindowsDirectoryW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWriteWatch ordinal = 414, argument = 24 temporary */
DWORD WINAPI GetWriteWatch (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GlobalAddAtomA ordinal = 415, argument = 4 temporary */
DWORD WINAPI GlobalAddAtomA (DWORD dwArgv0)
{
  return 0;
}


/* GlobalAddAtomW ordinal = 416, argument = 4 temporary */
DWORD WINAPI GlobalAddAtomW (DWORD dwArgv0)
{
  return 0;
}


/* GlobalAlloc ordinal = 417, argument = 8 */
HGLOBAL WINAPI GlobalAlloc (UINT uFlags, UINT uBytes)
{
  return LocalAlloc (uFlags, uBytes);
}


/* GlobalCompact ordinal = 418, argument = 4 temporary */
DWORD WINAPI GlobalCompact (DWORD dwArgv0)
{
  return 0;
}


/* GlobalDeleteAtom ordinal = 419, argument = 4 temporary */
DWORD WINAPI GlobalDeleteAtom (DWORD dwArgv0)
{
  return 0;
}


/* GlobalFindAtomA ordinal = 420, argument = 4 temporary */
DWORD WINAPI GlobalFindAtomA (DWORD dwArgv0)
{
  return 0;
}


/* GlobalFindAtomW ordinal = 421, argument = 4 temporary */
DWORD WINAPI GlobalFindAtomW (DWORD dwArgv0)
{
  return 0;
}


/* GlobalFix ordinal = 422, argument = 4 temporary */
DWORD WINAPI GlobalFix (DWORD dwArgv0)
{
  return 0;
}


/* GlobalFlags ordinal = 423, argument = 4 */
UINT WINAPI GlobalFlags (HGLOBAL hMem)
{
  return LocalFlags (hMem);
}


/* GlobalFree ordinal = 424, argument = 4 */
HGLOBAL WINAPI GlobalFree (HGLOBAL hMem)
{
  return LocalFree (hMem);
}


/* GlobalGetAtomNameA ordinal = 425, argument = 12 temporary */
DWORD WINAPI GlobalGetAtomNameA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GlobalGetAtomNameW ordinal = 426, argument = 12 temporary */
DWORD WINAPI GlobalGetAtomNameW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GlobalHandle ordinal = 427, argument = 4 */
HGLOBAL WINAPI GlobalHandle (LPCVOID pMem)
{
  return LocalHandle (pMem);
}


/* GlobalLock ordinal = 428, argument = 4 */
LPVOID WINAPI GlobalLock (HGLOBAL hMem)
{
  return LocalLock (hMem);
}


/* GlobalMemoryStatus ordinal = 429, argument = 4 temporary */
DWORD WINAPI GlobalMemoryStatus (DWORD dwArgv0)
{
  return 0;
}


/* GlobalMemoryStatusEx ordinal = 430, argument = 4 temporary */
DWORD WINAPI GlobalMemoryStatusEx (DWORD dwArgv0)
{
  return 0;
}


/* GlobalReAlloc ordinal = 431, argument = 12 */
HGLOBAL WINAPI GlobalReAlloc (HGLOBAL hMem, UINT uBytes, UINT uFlags)
{
  return LocalReAlloc (hMem, uBytes, uFlags);
}


/* GlobalSize ordinal = 432, argument = 4 */
UINT WINAPI GlobalSize (HGLOBAL hMem)
{
  return LocalSize (hMem);
}


/* GlobalUnWire ordinal = 433, argument = 4 temporary */
DWORD WINAPI GlobalUnWire (DWORD dwArgv0)
{
  return 0;
}


/* GlobalUnfix ordinal = 434, argument = 4 temporary */
DWORD WINAPI GlobalUnfix (DWORD dwArgv0)
{
  return 0;
}


/* GlobalUnlock ordinal = 435, argument = 4 */
UINT WINAPI GlobalUnlock (HGLOBAL hMem)
{
  return LocalUnlock (hMem);
}


/* GlobalWire ordinal = 436, argument = 4 temporary */
DWORD WINAPI GlobalWire (DWORD dwArgv0)
{
  return 0;
}


/* Heap32First ordinal = 437, argument = 12 temporary */
DWORD WINAPI Heap32First (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* Heap32ListFirst ordinal = 438, argument = 8 temporary */
DWORD WINAPI Heap32ListFirst (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Heap32ListNext ordinal = 439, argument = 8 temporary */
DWORD WINAPI Heap32ListNext (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Heap32Next ordinal = 440, argument = 4 temporary */
DWORD WINAPI Heap32Next (DWORD dwArgv0)
{
  return 0;
}


/* HeapAlloc ordinal = 441, argument = 12 */
LPVOID WINAPI HeapAlloc (HANDLE hHeap, DWORD dwFlags, DWORD dwBytes)
{
  gint i;
  LPDWORD hMem;

  if (!hHeap || dwBytes <= 0
                        || !(hMem = g_malloc0 (dwBytes + sizeof (DWORD) * 2)))
    return NULL;
  hMem[0] = dwFlags;
  hMem[1] = dwBytes;
  for (i = 0; ((LPDWORD *)hHeap)[i]; i++);
  hHeap = g_realloc (hHeap, (i + 2) * sizeof (LPDWORD));
  ((LPDWORD *)hHeap)[i] = hMem;
  ((LPDWORD *)hHeap)[i + 1] = NULL;
  return hMem + 2;
}


/* HeapCompact ordinal = 442, argument = 8 temporary */
DWORD WINAPI HeapCompact (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* HeapCreate ordinal = 443, argument = 12 */
HANDLE WINAPI HeapCreate (DWORD flOptions, DWORD dwInitialSize, DWORD dwMaximumSize)
{
  return g_malloc0 (sizeof (LPDWORD));
}


/* HeapCreateTagsW ordinal = 444, argument = 0 temporary */
DWORD WINAPI HeapCreateTagsW (VOID)
{
  return 0;
}


/* HeapDestroy ordinal = 445, argument = 4 */
BOOL WINAPI HeapDestroy (HANDLE hHeap)
{
  gint i;

  if (!hHeap)
    return FALSE;
  for (i = 0; ((LPDWORD *)hHeap)[i]; i++)
    g_free (((LPDWORD *)hHeap)[i]);
  g_free (hHeap);
  return TRUE;
}


/* HeapExtend ordinal = 446, argument = 0 temporary */
DWORD WINAPI HeapExtend (VOID)
{
  return 0;
}


/* HeapFree ordinal = 447, argument = 12 */
BOOL WINAPI HeapFree (HANDLE hHeap, DWORD dwFlags, LPVOID lpMem)
{
  gint i;

  if (!hHeap || !lpMem)
    return FALSE;
  for (i = 0; ((LPDWORD *)hHeap)[i]; i++)
    if (((LPDWORD *)hHeap)[i] == (LPDWORD)lpMem - 2)
      {
        g_free ((LPDWORD)lpMem - 2);
        while (((LPDWORD *)hHeap)[i])
          {
            ((LPDWORD *)hHeap)[i] = ((LPDWORD *)hHeap)[i + 1];
            i++;
          }
        return TRUE;
      }
  return FALSE;
}


/* HeapLock ordinal = 448, argument = 4 temporary */
DWORD WINAPI HeapLock (DWORD dwArgv0)
{
  return 0;
}


/* HeapQueryInformation ordinal = 449, argument = 20 temporary */
DWORD WINAPI HeapQueryInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* HeapQueryTagW ordinal = 450, argument = 0 temporary */
DWORD WINAPI HeapQueryTagW (VOID)
{
  return 0;
}


/* HeapReAlloc ordinal = 451, argument = 16 */
LPVOID WINAPI HeapReAlloc (HANDLE hHeap, DWORD dwFlags, LPVOID lpMem, DWORD dwBytes)
{
  gint i;

  if (!hHeap || !lpMem)
    return NULL;
  if (dwBytes <= 0)
    {
      HeapFree (hHeap, dwFlags, lpMem);
      return NULL;
    }
  for (i = 0; ((LPDWORD *)hHeap)[i]; i++)
    if (((LPDWORD *)hHeap)[i] == (LPDWORD)lpMem - 2)
      break;
  if (!((LPDWORD *)hHeap)[i]
    || !(lpMem = g_realloc ((LPDWORD)lpMem - 2,dwBytes + sizeof (DWORD) * 2)))
    return NULL;
  if (((LPDWORD)lpMem)[1] < dwBytes)
    g_memset ((guint8 *)lpMem + sizeof (DWORD) * 2 + ((LPDWORD)lpMem)[1], 0,
                                                dwBytes - ((LPDWORD)lpMem)[1]);
  ((LPDWORD)lpMem)[1] = dwBytes;
  ((LPDWORD *)hHeap)[i] = lpMem;
  return (LPDWORD)lpMem + 2;
}


/* HeapSetInformation ordinal = 452, argument = 16 temporary */
DWORD WINAPI HeapSetInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* HeapSize ordinal = 453, argument = 12 */
DWORD WINAPI HeapSize (HANDLE hHeap, DWORD dwFlags, LPCVOID lpMem)
{
  return lpMem ? ((LPDWORD)lpMem)[-1] : 0;
}


/* HeapSummary ordinal = 454, argument = 0 temporary */
DWORD WINAPI HeapSummary (VOID)
{
  return 0;
}


/* HeapUnlock ordinal = 455, argument = 4 temporary */
DWORD WINAPI HeapUnlock (DWORD dwArgv0)
{
  return 0;
}


/* HeapUsage ordinal = 456, argument = 0 temporary */
DWORD WINAPI HeapUsage (VOID)
{
  return 0;
}


/* HeapValidate ordinal = 457, argument = 12 temporary */
DWORD WINAPI HeapValidate (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* HeapWalk ordinal = 458, argument = 8 temporary */
DWORD WINAPI HeapWalk (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* InitAtomTable ordinal = 459, argument = 4 temporary */
DWORD WINAPI InitAtomTable (DWORD dwArgv0)
{
  return 0;
}


/* InitializeCriticalSection ordinal = 460, argument = 4 */
VOID WINAPI InitializeCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{
  (GMutex *)lpCriticalSection = g_mutex_new ();
}


/* InitializeCriticalSectionAndSpinCount ordinal = 461, argument = 8 temporary */
DWORD WINAPI InitializeCriticalSectionAndSpinCount (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* InterlockedCompareExchange ordinal = 462, argument = 12 */
PVOID WINAPI InterlockedCompareExchange (PVOID *Destination, PVOID Exchange, PVOID Comperand)
{
  PVOID pResult;

  pResult = *Destination;
  if (*Destination == Comperand)
    *Destination = Exchange;
  return pResult;
}


/* InterlockedDecrement ordinal = 463, argument = 4 */
LONG WINAPI InterlockedDecrement (LPLONG lpAddend)
{
  InterlockedExchangeAdd (lpAddend, -1);
  return lpAddend ? *lpAddend : 0;
}


/* InterlockedExchange ordinal = 464, argument = 8 */
LONG WINAPI InterlockedExchange (LPLONG Target, LONG Value)
{
  LONG lResult = 0;

  if (Target)
    {
      lResult = *Target;
      *Target = Value;
    }
  return lResult;
}


/* InterlockedExchangeAdd ordinal = 465, argument = 8 */
LONG WINAPI InterlockedExchangeAdd (PLONG lpAddend, LONG Increment)
{
  LONG lResult = 0;

  if (lpAddend)
    {
      lResult = *lpAddend;
      *lpAddend += Increment;
    }
  return lResult;
}


/* InterlockedIncrement ordinal = 466, argument = 4 */
LONG WINAPI InterlockedIncrement (LPLONG lpAddend)
{
  InterlockedExchangeAdd (lpAddend, 1);
  return lpAddend ? *lpAddend : 0;
}


/* InvalidateConsoleDIBits ordinal = 467, argument = 0 temporary */
DWORD WINAPI InvalidateConsoleDIBits (VOID)
{
  return 0;
}


/* IsBadCodePtr ordinal = 468, argument = 4 */
BOOL WINAPI IsBadCodePtr (FARPROC lpfn)
{
  return TRUE;
}


/* IsBadHugeReadPtr ordinal = 469, argument = 8 temporary */
DWORD WINAPI IsBadHugeReadPtr (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsBadHugeWritePtr ordinal = 470, argument = 8 temporary */
DWORD WINAPI IsBadHugeWritePtr (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsBadReadPtr ordinal = 471, argument = 8 */
BOOL WINAPI IsBadReadPtr (LPVOID lp, UINT ucb)
{
  return TRUE;
}


/* IsBadStringPtrA ordinal = 472, argument = 8 temporary */
DWORD WINAPI IsBadStringPtrA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsBadStringPtrW ordinal = 473, argument = 8 temporary */
DWORD WINAPI IsBadStringPtrW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsBadWritePtr ordinal = 474, argument = 8 */
BOOL WINAPI IsBadWritePtr (LPVOID lp, UINT ucb)
{
  return TRUE;
}


/* IsDBCSLeadByte ordinal = 475, argument = 4 */
BOOL WINAPI IsDBCSLeadByte (BYTE bTestChar)
{
  return IsDBCSLeadByteEx (CP_ACP, bTestChar);
}


/* IsDBCSLeadByteEx ordinal = 476, argument = 8 */
BOOL IsDBCSLeadByteEx (UINT CodePage, BYTE bTestChar)
{
  CPINFO CPInfo;

  if (GetCPInfo (CodePage, &CPInfo))
    {
      gint i;

      for (i = 0; CPInfo.LeadByte[i] != 0; i += 2)
        if (CPInfo.LeadByte[i] <= bTestChar
                                        && bTestChar <= CPInfo.LeadByte[i + 1])
          return TRUE;
    }
  return FALSE;
}


/* IsDebuggerPresent ordinal = 477, argument = 0 temporary */
DWORD WINAPI IsDebuggerPresent (VOID)
{
  return 0;
}


/* IsProcessorFeaturePresent ordinal = 478, argument = 4 temporary */
DWORD WINAPI IsProcessorFeaturePresent (DWORD dwArgv0)
{
  return 0;
}


/* IsSystemResumeAutomatic ordinal = 479, argument = 0 temporary */
DWORD WINAPI IsSystemResumeAutomatic (VOID)
{
  return 0;
}


/* IsValidCodePage ordinal = 480, argument = 4 temporary */
DWORD WINAPI IsValidCodePage (DWORD dwArgv0)
{
  return 0;
}


/* IsValidLanguageGroup ordinal = 481, argument = 8 temporary */
DWORD WINAPI IsValidLanguageGroup (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsValidLocale ordinal = 482, argument = 8 temporary */
DWORD WINAPI IsValidLocale (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LCMapStringA ordinal = 483, argument = 24 */
INT WINAPI LCMapStringA (LCID Locale, DWORD dwMapFlags, LPCSTR lpSrcStr, INT cchSrc, LPSTR lpDestStr, INT cchDest)
{
  gint leng;

  if (!lpSrcStr)
    return 0;
  leng = cchSrc >= 0 ? cchSrc : g_strlen (lpSrcStr) + 1;
  if (!lpDestStr || cchDest <= 0)
    return leng;
  if (leng > cchDest)
    return 0;
  if (dwMapFlags & LCMAP_SORTKEY)
    g_memset (lpDestStr, 0, leng);
  else
    g_strcpy (lpDestStr, lpSrcStr);
  return leng;
}


/* LCMapStringW ordinal = 484, argument = 24 */
INT WINAPI LCMapStringW (LCID Locale, DWORD dwMapFlags, LPCWSTR lpSrcStr, INT cchSrc, LPWSTR lpDestStr, INT cchDest)
{
  gint leng;

  if (!lpSrcStr)
    return 0;
  leng = cchSrc >= 0 ? cchSrc : lstrlenW (lpSrcStr) + 1;
  if (!lpDestStr || cchDest <= 0)
    return leng;
  if (leng > cchDest)
    return 0;
  if (dwMapFlags & LCMAP_SORTKEY)
    g_memset (lpDestStr, 0, leng);
  else
    lstrcpyW (lpDestStr, lpSrcStr);
  return leng;
}


/* LeaveCriticalSection ordinal = 485, argument = 4 */
VOID WINAPI LeaveCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{
  g_mutex_unlock ((GMutex *)lpCriticalSection);
}


/* LoadLibraryA ordinal = 486, argument = 4 */
HINSTANCE WINAPI LoadLibraryA (LPCSTR lpFileName)
{
  return LoadLibraryExA (lpFileName, NULL, 0);
}


/* LoadLibraryExA ordinal = 487, argument = 12 */
HINSTANCE WINAPI LoadLibraryExA (LPCSTR lpLibFileName, HANDLE hFile, DWORD dwFlags)
{
  gchar *file;
  W32LdrModule *module;

  file = w32ldr_filename_from_mb (lpLibFileName);
  module = w32ldr_load_module (file, dwFlags & LOAD_LIBRARY_AS_DATAFILE);
  g_free (file);
  return module ? module + 1 : NULL;
}


/* LoadLibraryExW ordinal = 488, argument = 12 */
HINSTANCE WINAPI LoadLibraryExW (LPCWSTR lpLibFileName, HANDLE hFile, DWORD dwFlags)
{
  gchar *file;
  W32LdrModule *module;

  file = w32ldr_filename_from_wc (lpLibFileName);
  module = w32ldr_load_module (file, dwFlags & LOAD_LIBRARY_AS_DATAFILE);
  g_free (file);
  return module ? module + 1 : NULL;
}


/* LoadLibraryW ordinal = 489, argument = 4 */
HINSTANCE WINAPI LoadLibraryW (LPCWSTR lpFileName)
{
  return LoadLibraryExW (lpFileName, NULL, 0);
}


/* LoadModule ordinal = 490, argument = 8 temporary */
DWORD WINAPI LoadModule (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LoadResource ordinal = 491, argument = 8 */
HGLOBAL WINAPI LoadResource (HMODULE hModule, HRSRC hResInfo)
{
  return (HGLOBAL)((LPDWORD)hResInfo + 1);
}


/* LocalAlloc ordinal = 492, argument = 8 */
HLOCAL WINAPI LocalAlloc (UINT uFlags, UINT uBytes)
{
  UINT_PTR hMem;

  if (uBytes <= 0 || (hMem = g_malloc0 (uBytes + sizeof (UINT) * 2)) == NULL)
    return NULL;
  hMem[0] = uFlags;
  hMem[1] = uBytes;
  return (HLOCAL)(hMem + 2);
}


/* LocalCompact ordinal = 493, argument = 4 temporary */
DWORD WINAPI LocalCompact (DWORD dwArgv0)
{
  return 0;
}


/* LocalFileTimeToFileTime ordinal = 494, argument = 8 temporary */
DWORD WINAPI LocalFileTimeToFileTime (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LocalFlags ordinal = 495, argument = 4 */
UINT WINAPI LocalFlags (HLOCAL hMem)
{
  return hMem ? ((UINT_PTR)hMem)[-2] : LMEM_INVALID_HANDLE;
}


/* LocalFree ordinal = 496, argument = 4 */
HLOCAL WINAPI LocalFree (HLOCAL hMem)
{
  if (hMem)
    g_free ((UINT_PTR)hMem - 2);
  return NULL;
}


/* LocalHandle ordinal = 497, argument = 4 */
HLOCAL WINAPI LocalHandle (LPCVOID pMem)
{
  return (HLOCAL)pMem;
}


/* LocalLock ordinal = 498, argument = 4 */
LPVOID WINAPI LocalLock (HLOCAL hMem)
{
  return hMem;
}


/* LocalReAlloc ordinal = 499, argument = 12 */
HLOCAL WINAPI LocalReAlloc (HLOCAL hMem, UINT uBytes, UINT uFlags)
{
  if (!hMem)
    return LocalAlloc (uFlags, uBytes);
  if (uBytes <= 0)
    {
      g_free ((UINT_PTR)hMem - 2);
      return NULL;
    }
  hMem = g_realloc((UINT_PTR)hMem - 2, uBytes + sizeof (UINT) * 2);
  if (!hMem)
    return NULL;
  if (((UINT_PTR)hMem)[1] < uBytes)
    g_memset ((guint8 *)hMem + sizeof (UINT) * 2 + ((UINT_PTR)hMem)[1], 0,
                                                uBytes - ((UINT_PTR)hMem)[1]);
  ((UINT_PTR)hMem)[1] = uBytes;
  return (HLOCAL)((UINT_PTR)hMem + 2);
}


/* LocalShrink ordinal = 500, argument = 8 temporary */
DWORD WINAPI LocalShrink (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* LocalSize ordinal = 501, argument = 4 */
UINT WINAPI LocalSize (HLOCAL hMem)
{
  return hMem ? ((UINT_PTR)hMem)[-1] : 0;
}


/* LocalUnlock ordinal = 502, argument = 4 */
UINT WINAPI LocalUnlock (HLOCAL hMem)
{
  return FALSE;
}


/* LockFile ordinal = 503, argument = 20 temporary */
DWORD WINAPI LockFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* LockFileEx ordinal = 504, argument = 24 temporary */
DWORD WINAPI LockFileEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* LockResource ordinal = 505, argument = 4 */
LPVOID WINAPI LockResource (HGLOBAL hResData)
{
  return hResData;
}


/* MapUserPhysicalPages ordinal = 506, argument = 12 temporary */
DWORD WINAPI MapUserPhysicalPages (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MapUserPhysicalPagesScatter ordinal = 507, argument = 12 temporary */
DWORD WINAPI MapUserPhysicalPagesScatter (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MapViewOfFile ordinal = 508, argument = 20 */
LPVOID WINAPI MapViewOfFile (HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, SIZE_T dwNumberOfBytesToMap)
{
  goffset cur;
  LPVOID lpMap;

  lpMap = g_malloc (dwNumberOfBytesToMap);
  if (!lpMap)
    return NULL;
  cur = fileio_seek (hFileMappingObject->fio, 0, FILEIO_SEEK_CUR);
  fileio_seek (hFileMappingObject->fio, dwFileOffsetLow, FILEIO_SEEK_SET);
  fileio_read (hFileMappingObject->fio, lpMap, dwNumberOfBytesToMap);
  fileio_seek (hFileMappingObject->fio, cur, FILEIO_SEEK_SET);
  return lpMap;
}


/* MapViewOfFileEx ordinal = 509, argument = 24 */
LPVOID WINAPI MapViewOfFileEx (HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, SIZE_T dwNumberOfBytesToMap, LPVOID lpBaseAddress)
{
  return MapViewOfFile (hFileMappingObject, dwDesiredAccess,
                    dwFileOffsetHigh, dwFileOffsetLow, dwNumberOfBytesToMap);
}


/* Module32First ordinal = 510, argument = 8 temporary */
DWORD WINAPI Module32First (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Module32FirstW ordinal = 511, argument = 8 temporary */
DWORD WINAPI Module32FirstW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Module32Next ordinal = 512, argument = 8 temporary */
DWORD WINAPI Module32Next (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Module32NextW ordinal = 513, argument = 8 temporary */
DWORD WINAPI Module32NextW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* MoveFileA ordinal = 514, argument = 8 */
BOOL WINAPI MoveFileA (LPCSTR lpExistingFileName, LPCSTR lpNewFileName)
{
  return FALSE;
}


/* MoveFileExA ordinal = 515, argument = 12 */
BOOL WINAPI MoveFileExA (LPCSTR lpExistingFileName, LPCSTR lpNewFileName, DWORD dwFlags)
{
  return FALSE;
}


/* MoveFileExW ordinal = 516, argument = 12 */
BOOL WINAPI MoveFileExW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName, DWORD dwFlags)
{
  return FALSE;
}


/* MoveFileW ordinal = 517, argument = 8 */
BOOL WINAPI MoveFileW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName)
{
  return FALSE;
}


/* MoveFileWithProgressA ordinal = 518, argument = 20 temporary */
DWORD WINAPI MoveFileWithProgressA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* MoveFileWithProgressW ordinal = 519, argument = 20 temporary */
DWORD WINAPI MoveFileWithProgressW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* MulDiv ordinal = 520, argument = 12 */
INT WINAPI MulDiv (INT nNumber, INT nNumerator, INT nDenominator)
{
  if (nDenominator == 0)
    return -1;
#ifdef G_HAVE_GINT64
  return (gint64)nNumber * (gint64)nNumerator / (gint64)nDenominator;
#else /* not G_HAVE_GINT64 */
  return nNumber * nNumerator / nDenominator;
#endif /* not G_HAVE_GINT64 */
}


/* MultiByteToWideChar ordinal = 521, argument = 24 */
INT WINAPI MultiByteToWideChar (UINT CodePage, DWORD dwFlags, LPCSTR lpMultiByteStr, INT cchMultiByte, LPWSTR lpWideCharStr, INT cchWideChar)
{
  gsize bytes_read, bytes_written, bytes_read_prev = (gsize)-1;
  gssize len;
  gchar *charset, *mb;
  gunichar2 *wc;
  gint result;
  GError *error = NULL;

  if (!lpMultiByteStr || cchMultiByte == 0)
    return 0;
  switch (CodePage)
    {
      case CP_ACP:
      case CP_MACCP:
      case CP_THREAD_ACP:
      case CP_SYMBOL:
        charset = g_strdup_printf ("CP%d", GetACP ());
        break;
      case CP_OEMCP:
        charset = g_strdup_printf ("CP%d", GetOEMCP ());
        break;
      case CP_UTF7:
        charset = g_strdup ("UTF-7");
        break;
      case CP_UTF8:
        charset = g_strdup ("UTF-8");
        break;
      default:
        charset = g_strdup_printf ("CP%d", CodePage);
    }
  len = (cchMultiByte < 0 ? g_strlen (lpMultiByteStr) + 1 : cchMultiByte)
                                                            * sizeof (gchar);
  mb = g_memdup (lpMultiByteStr, len * sizeof (gchar));
  while ((g_clear_error (&error),
            !(wc = (gunichar2 *)g_convert (mb, len, "UTF-16LE", charset,
                                        &bytes_read, &bytes_written, &error)))
                                    && bytes_read_prev != bytes_read && error
                                    && g_error_matches (error, G_CONVERT_ERROR,
                                            G_CONVERT_ERROR_ILLEGAL_SEQUENCE))
    {
      mb[bytes_read] = '?';
      bytes_read_prev = bytes_read;
    }
  g_free (mb);
  g_free (charset);
  if (!wc)
    {
      gint i;

      /* ja:キャラクターセットが無効 */
      wc = g_malloc ((cchMultiByte + 1)* sizeof (gunichar2));
      for (i = 0; i < cchMultiByte; i++)
        wc[i] = lpMultiByteStr[i] & 0x80 ? lpMultiByteStr[i] : '?';
      wc[i] = '\0';
    }
  result = bytes_written / sizeof (gunichar2);
  if (cchMultiByte < 0)
    result++;
  if (lpWideCharStr && cchWideChar > 0)
    {
      if (result > cchWideChar)
        result = cchWideChar;
      g_memmove (lpWideCharStr, wc, result * sizeof (gunichar2));
    }
  g_free (wc);
  return result;
}


/* NlsConvertIntegerToString ordinal = 522, argument = 0 temporary */
DWORD WINAPI NlsConvertIntegerToString (VOID)
{
  return 0;
}


/* NlsGetCacheUpdateCount ordinal = 523, argument = 0 temporary */
DWORD WINAPI NlsGetCacheUpdateCount (VOID)
{
  return 0;
}


/* NlsResetProcessLocale ordinal = 524, argument = 0 temporary */
DWORD WINAPI NlsResetProcessLocale (VOID)
{
  return 0;
}


/* OpenConsoleW ordinal = 525, argument = 0 temporary */
DWORD WINAPI OpenConsoleW (VOID)
{
  return 0;
}


/* OpenDataFile ordinal = 526, argument = 0 temporary */
DWORD WINAPI OpenDataFile (VOID)
{
  return 0;
}


/* OpenEventA ordinal = 527, argument = 12 temporary */
DWORD WINAPI OpenEventA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenEventW ordinal = 528, argument = 12 temporary */
DWORD WINAPI OpenEventW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenFile ordinal = 529, argument = 12 temporary */
DWORD WINAPI OpenFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenFileMappingA ordinal = 530, argument = 12 */
HANDLE WINAPI OpenFileMappingA (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName)
{
  return NULL;
}


/* OpenFileMappingW ordinal = 531, argument = 12 */
HANDLE WINAPI OpenFileMappingW (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName)
{
  return NULL;
}


/* OpenJobObjectA ordinal = 532, argument = 12 temporary */
DWORD WINAPI OpenJobObjectA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenJobObjectW ordinal = 533, argument = 12 temporary */
DWORD WINAPI OpenJobObjectW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenMutexA ordinal = 534, argument = 12 temporary */
DWORD WINAPI OpenMutexA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenMutexW ordinal = 535, argument = 12 temporary */
DWORD WINAPI OpenMutexW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenProcess ordinal = 536, argument = 12 temporary */
DWORD WINAPI OpenProcess (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenProfileUserMapping ordinal = 537, argument = 0 temporary */
DWORD WINAPI OpenProfileUserMapping (VOID)
{
  return 0;
}


/* OpenSemaphoreA ordinal = 538, argument = 12 temporary */
DWORD WINAPI OpenSemaphoreA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenSemaphoreW ordinal = 539, argument = 12 temporary */
DWORD WINAPI OpenSemaphoreW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenThread ordinal = 540, argument = 12 temporary */
DWORD WINAPI OpenThread (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenWaitableTimerA ordinal = 541, argument = 12 temporary */
DWORD WINAPI OpenWaitableTimerA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OpenWaitableTimerW ordinal = 542, argument = 12 temporary */
DWORD WINAPI OpenWaitableTimerW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OutputDebugStringA ordinal = 543, argument = 4 */
VOID WINAPI OutputDebugStringA (LPCSTR lpOutputString)
{
  gchar *str;

  str = w32ldr_utf8_from_mb (lpOutputString);
  g_print (str);
  g_free (str);
}


/* OutputDebugStringW ordinal = 544, argument = 4 */
VOID WINAPI OutputDebugStringW (LPCWSTR lpOutputString)
{
  gchar *str;

  str = g_utf16_to_utf8 (lpOutputString, -1, NULL, NULL, NULL);
  g_print (str);
  g_free (str);
}


/* PeekConsoleInputA ordinal = 545, argument = 16 temporary */
DWORD WINAPI PeekConsoleInputA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PeekConsoleInputW ordinal = 546, argument = 16 temporary */
DWORD WINAPI PeekConsoleInputW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PeekNamedPipe ordinal = 547, argument = 24 temporary */
DWORD WINAPI PeekNamedPipe (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* PostQueuedCompletionStatus ordinal = 548, argument = 16 temporary */
DWORD WINAPI PostQueuedCompletionStatus (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PrepareTape ordinal = 549, argument = 12 temporary */
DWORD WINAPI PrepareTape (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PrivCopyFileExW ordinal = 550, argument = 0 temporary */
DWORD WINAPI PrivCopyFileExW (VOID)
{
  return 0;
}


/* PrivMoveFileIdentityW ordinal = 551, argument = 0 temporary */
DWORD WINAPI PrivMoveFileIdentityW (VOID)
{
  return 0;
}


/* Process32First ordinal = 552, argument = 8 temporary */
DWORD WINAPI Process32First (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Process32FirstW ordinal = 553, argument = 8 temporary */
DWORD WINAPI Process32FirstW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Process32Next ordinal = 554, argument = 8 temporary */
DWORD WINAPI Process32Next (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Process32NextW ordinal = 555, argument = 8 temporary */
DWORD WINAPI Process32NextW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ProcessIdToSessionId ordinal = 556, argument = 8 temporary */
DWORD WINAPI ProcessIdToSessionId (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* PulseEvent ordinal = 557, argument = 4 temporary */
DWORD WINAPI PulseEvent (DWORD dwArgv0)
{
  return 0;
}


/* PurgeComm ordinal = 558, argument = 8 temporary */
DWORD WINAPI PurgeComm (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* QueryDosDeviceA ordinal = 559, argument = 12 temporary */
DWORD WINAPI QueryDosDeviceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* QueryDosDeviceW ordinal = 560, argument = 12 temporary */
DWORD WINAPI QueryDosDeviceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* QueryInformationJobObject ordinal = 561, argument = 20 temporary */
DWORD WINAPI QueryInformationJobObject (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* QueryPerformanceCounter ordinal = 562, argument = 4 */
BOOL WINAPI QueryPerformanceCounter (LARGE_INTEGER *lpPerformanceCount)
{
  return FALSE;
}


/* QueryPerformanceFrequency ordinal = 563, argument = 4 */
BOOL WINAPI QueryPerformanceFrequency (LARGE_INTEGER *lpFrequency)
{
  return FALSE;
}


/* QueryWin31IniFilesMappedToRegistry ordinal = 564, argument = 0 temporary */
DWORD WINAPI QueryWin31IniFilesMappedToRegistry (VOID)
{
  return 0;
}


/* QueueUserAPC ordinal = 565, argument = 12 temporary */
DWORD WINAPI QueueUserAPC (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* QueueUserWorkItem ordinal = 566, argument = 12 temporary */
DWORD WINAPI QueueUserWorkItem (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RaiseException ordinal = 567, argument = 16 temporary */
DWORD WINAPI RaiseException (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ReadConsoleA ordinal = 568, argument = 20 temporary */
DWORD WINAPI ReadConsoleA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleInputA ordinal = 569, argument = 16 temporary */
DWORD WINAPI ReadConsoleInputA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ReadConsoleInputExA ordinal = 570, argument = 0 temporary */
DWORD WINAPI ReadConsoleInputExA (VOID)
{
  return 0;
}


/* ReadConsoleInputExW ordinal = 571, argument = 0 temporary */
DWORD WINAPI ReadConsoleInputExW (VOID)
{
  return 0;
}


/* ReadConsoleInputW ordinal = 572, argument = 16 temporary */
DWORD WINAPI ReadConsoleInputW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ReadConsoleOutputA ordinal = 573, argument = 20 temporary */
DWORD WINAPI ReadConsoleOutputA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleOutputAttribute ordinal = 574, argument = 20 temporary */
DWORD WINAPI ReadConsoleOutputAttribute (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleOutputCharacterA ordinal = 575, argument = 20 temporary */
DWORD WINAPI ReadConsoleOutputCharacterA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleOutputCharacterW ordinal = 576, argument = 20 temporary */
DWORD WINAPI ReadConsoleOutputCharacterW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleOutputW ordinal = 577, argument = 20 temporary */
DWORD WINAPI ReadConsoleOutputW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadConsoleW ordinal = 578, argument = 20 temporary */
DWORD WINAPI ReadConsoleW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadDirectoryChangesW ordinal = 579, argument = 32 temporary */
DWORD WINAPI ReadDirectoryChangesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* ReadFile ordinal = 580, argument = 20 */
BOOL WINAPI ReadFile (HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped)
{
  gssize bytes_read;

  if (lpNumberOfBytesRead)
    *lpNumberOfBytesRead = 0;
  if (nNumberOfBytesToRead <= 0)
    return TRUE;
  bytes_read = fileio_read (hFile->fio, lpBuffer, nNumberOfBytesToRead);
  if (lpNumberOfBytesRead)
    *lpNumberOfBytesRead = bytes_read;
  return bytes_read >= 0;
}


/* ReadFileEx ordinal = 581, argument = 20 temporary */
DWORD WINAPI ReadFileEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadFileScatter ordinal = 582, argument = 20 temporary */
DWORD WINAPI ReadFileScatter (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ReadProcessMemory ordinal = 583, argument = 20 temporary */
DWORD WINAPI ReadProcessMemory (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RegisterConsoleIME ordinal = 584, argument = 0 temporary */
DWORD WINAPI RegisterConsoleIME (VOID)
{
  return 0;
}


/* RegisterConsoleOS2 ordinal = 585, argument = 0 temporary */
DWORD WINAPI RegisterConsoleOS2 (VOID)
{
  return 0;
}


/* RegisterConsoleVDM ordinal = 586, argument = 0 temporary */
DWORD WINAPI RegisterConsoleVDM (VOID)
{
  return 0;
}


/* RegisterWaitForInputIdle ordinal = 587, argument = 0 temporary */
DWORD WINAPI RegisterWaitForInputIdle (VOID)
{
  return 0;
}


/* RegisterWaitForSingleObject ordinal = 588, argument = 24 temporary */
DWORD WINAPI RegisterWaitForSingleObject (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* RegisterWaitForSingleObjectEx ordinal = 589, argument = 20 temporary */
DWORD WINAPI RegisterWaitForSingleObjectEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RegisterWowBaseHandlers ordinal = 590, argument = 0 temporary */
DWORD WINAPI RegisterWowBaseHandlers (VOID)
{
  return 0;
}


/* RegisterWowExec ordinal = 591, argument = 0 temporary */
DWORD WINAPI RegisterWowExec (VOID)
{
  return 0;
}


/* ReleaseMutex ordinal = 592, argument = 4 temporary */
DWORD WINAPI ReleaseMutex (DWORD dwArgv0)
{
  return 0;
}


/* ReleaseSemaphore ordinal = 593, argument = 12 */
BOOL WINAPI ReleaseSemaphore (HANDLE hSemaphore, LONG lReleaseCount, LPLONG lpPreviousCount)
{
  return FALSE;
}


/* RemoveDirectoryA ordinal = 594, argument = 4 */
BOOL WINAPI RemoveDirectoryA (LPCSTR lpPathName)
{
  return FALSE;
}


/* RemoveDirectoryW ordinal = 595, argument = 4 */
BOOL WINAPI RemoveDirectoryW (LPCWSTR lpPathName)
{
  return FALSE;
}


/* ReplaceFile ordinal = 596, argument = 24 temporary */
/* DWORD WINAPI ReplaceFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5) */


/* ReplaceFileA ordinal = 597, argument = 24 temporary */
DWORD WINAPI ReplaceFileA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ReplaceFileW ordinal = 598, argument = 24 temporary */
DWORD WINAPI ReplaceFileW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* RequestDeviceWakeup ordinal = 599, argument = 4 temporary */
DWORD WINAPI RequestDeviceWakeup (DWORD dwArgv0)
{
  return 0;
}


/* RequestWakeupLatency ordinal = 600, argument = 4 temporary */
DWORD WINAPI RequestWakeupLatency (DWORD dwArgv0)
{
  return 0;
}


/* ResetEvent ordinal = 601, argument = 4 */
BOOL WINAPI ResetEvent (HANDLE hEvent)
{
  return FALSE;
}


/* ResetWriteWatch ordinal = 602, argument = 8 temporary */
DWORD WINAPI ResetWriteWatch (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ResumeThread ordinal = 603, argument = 4 temporary */
DWORD WINAPI ResumeThread (DWORD dwArgv0)
{
  return 0;
}


/* RtlFillMemory ordinal = 604, argument = 12 temporary */
DWORD WINAPI RtlFillMemory (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RtlMoveMemory ordinal = 605, argument = 12 temporary */
DWORD WINAPI RtlMoveMemory (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RtlUnwind ordinal = 606, argument = 16 temporary */
DWORD WINAPI RtlUnwind (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* RtlZeroMemory ordinal = 607, argument = 8 temporary */
DWORD WINAPI RtlZeroMemory (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ScrollConsoleScreenBufferA ordinal = 608, argument = 20 temporary */
DWORD WINAPI ScrollConsoleScreenBufferA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ScrollConsoleScreenBufferW ordinal = 609, argument = 20 temporary */
DWORD WINAPI ScrollConsoleScreenBufferW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SearchPathA ordinal = 610, argument = 24 temporary */
DWORD WINAPI SearchPathA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SearchPathW ordinal = 611, argument = 24 temporary */
DWORD WINAPI SearchPathW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetCPGlobal ordinal = 612, argument = 0 temporary */
DWORD WINAPI SetCPGlobal (VOID)
{
  return 0;
}


/* SetCalendarInfoA ordinal = 613, argument = 16 temporary */
DWORD WINAPI SetCalendarInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetCalendarInfoW ordinal = 614, argument = 16 temporary */
DWORD WINAPI SetCalendarInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetCommBreak ordinal = 615, argument = 4 temporary */
DWORD WINAPI SetCommBreak (DWORD dwArgv0)
{
  return 0;
}


/* SetCommConfig ordinal = 616, argument = 12 temporary */
DWORD WINAPI SetCommConfig (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetCommMask ordinal = 617, argument = 8 temporary */
DWORD WINAPI SetCommMask (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetCommState ordinal = 618, argument = 8 temporary */
DWORD WINAPI SetCommState (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetCommTimeouts ordinal = 619, argument = 8 temporary */
DWORD WINAPI SetCommTimeouts (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetComputerNameA ordinal = 620, argument = 4 temporary */
DWORD WINAPI SetComputerNameA (DWORD dwArgv0)
{
  return 0;
}


/* SetComputerNameExA ordinal = 621, argument = 8 temporary */
DWORD WINAPI SetComputerNameExA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetComputerNameExW ordinal = 622, argument = 8 temporary */
DWORD WINAPI SetComputerNameExW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetComputerNameW ordinal = 623, argument = 4 temporary */
DWORD WINAPI SetComputerNameW (DWORD dwArgv0)
{
  return 0;
}


/* SetConsoleActiveScreenBuffer ordinal = 624, argument = 4 temporary */
DWORD WINAPI SetConsoleActiveScreenBuffer (DWORD dwArgv0)
{
  return 0;
}


/* SetConsoleCP ordinal = 625, argument = 4 temporary */
DWORD WINAPI SetConsoleCP (DWORD dwArgv0)
{
  return 0;
}


/* SetConsoleCommandHistoryMode ordinal = 626, argument = 0 temporary */
DWORD WINAPI SetConsoleCommandHistoryMode (VOID)
{
  return 0;
}


/* SetConsoleCtrlHandler ordinal = 627, argument = 8 temporary */
DWORD WINAPI SetConsoleCtrlHandler (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleCursor ordinal = 628, argument = 8 temporary */
DWORD WINAPI SetConsoleCursor (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleCursorInfo ordinal = 629, argument = 8 temporary */
DWORD WINAPI SetConsoleCursorInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleCursorMode ordinal = 630, argument = 0 temporary */
DWORD WINAPI SetConsoleCursorMode (VOID)
{
  return 0;
}


/* SetConsoleCursorPosition ordinal = 631, argument = 8 temporary */
DWORD WINAPI SetConsoleCursorPosition (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleDisplayMode ordinal = 632, argument = 0 temporary */
DWORD WINAPI SetConsoleDisplayMode (VOID)
{
  return 0;
}


/* SetConsoleFont ordinal = 633, argument = 0 temporary */
DWORD WINAPI SetConsoleFont (VOID)
{
  return 0;
}


/* SetConsoleHardwareState ordinal = 634, argument = 0 temporary */
DWORD WINAPI SetConsoleHardwareState (VOID)
{
  return 0;
}


/* SetConsoleIcon ordinal = 635, argument = 0 temporary */
DWORD WINAPI SetConsoleIcon (VOID)
{
  return 0;
}


/* SetConsoleInputExeNameA ordinal = 636, argument = 0 temporary */
DWORD WINAPI SetConsoleInputExeNameA (VOID)
{
  return 0;
}


/* SetConsoleInputExeNameW ordinal = 637, argument = 0 temporary */
DWORD WINAPI SetConsoleInputExeNameW (VOID)
{
  return 0;
}


/* SetConsoleKeyShortcuts ordinal = 638, argument = 0 temporary */
DWORD WINAPI SetConsoleKeyShortcuts (VOID)
{
  return 0;
}


/* SetConsoleLocalEUDC ordinal = 639, argument = 0 temporary */
DWORD WINAPI SetConsoleLocalEUDC (VOID)
{
  return 0;
}


/* SetConsoleMaximumWindowSize ordinal = 640, argument = 0 temporary */
DWORD WINAPI SetConsoleMaximumWindowSize (VOID)
{
  return 0;
}


/* SetConsoleMenuClose ordinal = 641, argument = 0 temporary */
DWORD WINAPI SetConsoleMenuClose (VOID)
{
  return 0;
}


/* SetConsoleMode ordinal = 642, argument = 8 temporary */
DWORD WINAPI SetConsoleMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleNlsMode ordinal = 643, argument = 0 temporary */
DWORD WINAPI SetConsoleNlsMode (VOID)
{
  return 0;
}


/* SetConsoleNumberOfCommandsA ordinal = 644, argument = 0 temporary */
DWORD WINAPI SetConsoleNumberOfCommandsA (VOID)
{
  return 0;
}


/* SetConsoleNumberOfCommandsW ordinal = 645, argument = 0 temporary */
DWORD WINAPI SetConsoleNumberOfCommandsW (VOID)
{
  return 0;
}


/* SetConsoleOS2OemFormat ordinal = 646, argument = 0 temporary */
DWORD WINAPI SetConsoleOS2OemFormat (VOID)
{
  return 0;
}


/* SetConsoleOutputCP ordinal = 647, argument = 4 temporary */
DWORD WINAPI SetConsoleOutputCP (DWORD dwArgv0)
{
  return 0;
}


/* SetConsolePalette ordinal = 648, argument = 0 temporary */
DWORD WINAPI SetConsolePalette (VOID)
{
  return 0;
}


/* SetConsoleScreenBufferSize ordinal = 649, argument = 8 */
BOOL WINAPI SetConsoleScreenBufferSize (HANDLE hConsoleOutput, DWORD dwSize)
{
  return TRUE;
}


/* SetConsoleTextAttribute ordinal = 650, argument = 8 temporary */
DWORD WINAPI SetConsoleTextAttribute (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetConsoleTitleA ordinal = 651, argument = 4 temporary */
DWORD WINAPI SetConsoleTitleA (DWORD dwArgv0)
{
  return 0;
}


/* SetConsoleTitleW ordinal = 652, argument = 4 temporary */
DWORD WINAPI SetConsoleTitleW (DWORD dwArgv0)
{
  return 0;
}


/* SetConsoleWindowInfo ordinal = 653, argument = 12 temporary */
DWORD WINAPI SetConsoleWindowInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetCriticalSectionSpinCount ordinal = 654, argument = 8 temporary */
DWORD WINAPI SetCriticalSectionSpinCount (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetCurrentDirectoryA ordinal = 655, argument = 4 temporary */
DWORD WINAPI SetCurrentDirectoryA (DWORD dwArgv0)
{
  return 0;
}


/* SetCurrentDirectoryW ordinal = 656, argument = 4 temporary */
DWORD WINAPI SetCurrentDirectoryW (DWORD dwArgv0)
{
  return 0;
}


/* SetDefaultCommConfigA ordinal = 657, argument = 12 temporary */
DWORD WINAPI SetDefaultCommConfigA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetDefaultCommConfigW ordinal = 658, argument = 12 temporary */
DWORD WINAPI SetDefaultCommConfigW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetEndOfFile ordinal = 659, argument = 4 */
BOOL WINAPI SetEndOfFile (HANDLE hFile)
{
  return TRUE;
}


/* SetEnvironmentVariableA ordinal = 660, argument = 8 temporary */
DWORD WINAPI SetEnvironmentVariableA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetEnvironmentVariableW ordinal = 661, argument = 8 temporary */
DWORD WINAPI SetEnvironmentVariableW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetErrorMode ordinal = 662, argument = 4 temporary */
DWORD WINAPI SetErrorMode (DWORD dwArgv0)
{
  return 0;
}


/* SetEvent ordinal = 663, argument = 4 temporary */
DWORD WINAPI SetEvent (DWORD dwArgv0)
{
  return 0;
}


/* SetFileApisToANSI ordinal = 664, argument = 0 temporary */
DWORD WINAPI SetFileApisToANSI (VOID)
{
  return 0;
}


/* SetFileApisToOEM ordinal = 665, argument = 0 temporary */
DWORD WINAPI SetFileApisToOEM (VOID)
{
  return 0;
}


/* SetFileAttributesA ordinal = 666, argument = 8 temporary */
DWORD WINAPI SetFileAttributesA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetFileAttributesW ordinal = 667, argument = 8 temporary */
DWORD WINAPI SetFileAttributesW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetFilePointer ordinal = 668, argument = 16 */
DWORD WINAPI SetFilePointer (HANDLE hFile, LONG lDistanceToMove, PLONG lpDistanceToMoveHigh, DWORD dwMoveMethod)
{
  guint whence;

  switch (dwMoveMethod)
    {
      case FILE_BEGIN: whence = FILEIO_SEEK_SET; break;
      case FILE_END:   whence = FILEIO_SEEK_END; break;
      default:         whence = FILEIO_SEEK_CUR;
    }
  return fileio_seek (hFile->fio, lDistanceToMove, whence);
}


/* SetFilePointerEx ordinal = 669, argument = 20 temporary */
DWORD WINAPI SetFilePointerEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SetFileTime ordinal = 670, argument = 16 temporary */
DWORD WINAPI SetFileTime (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetHandleCount ordinal = 671, argument = 4 */
UINT WINAPI SetHandleCount (UINT uNumber)
{
  return MIN (uNumber, 256);
}


/* SetHandleInformation ordinal = 672, argument = 12 temporary */
DWORD WINAPI SetHandleInformation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetInformationJobObject ordinal = 673, argument = 16 temporary */
DWORD WINAPI SetInformationJobObject (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetLastConsoleEventActive ordinal = 674, argument = 0 temporary */
DWORD WINAPI SetLastConsoleEventActive (VOID)
{
  return 0;
}


/* SetLastError ordinal = 675, argument = 4 */
VOID WINAPI SetLastError (DWORD dwErrCode)
{
}


/* SetLocalTime ordinal = 676, argument = 4 temporary */
DWORD WINAPI SetLocalTime (DWORD dwArgv0)
{
  return 0;
}


/* SetLocaleInfoA ordinal = 677, argument = 12 temporary */
DWORD WINAPI SetLocaleInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetLocaleInfoW ordinal = 678, argument = 12 temporary */
DWORD WINAPI SetLocaleInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetMailslotInfo ordinal = 679, argument = 8 temporary */
DWORD WINAPI SetMailslotInfo (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetMessageWaitingIndicator ordinal = 680, argument = 8 temporary */
DWORD WINAPI SetMessageWaitingIndicator (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetNamedPipeHandleState ordinal = 681, argument = 16 temporary */
DWORD WINAPI SetNamedPipeHandleState (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetPriorityClass ordinal = 682, argument = 8 temporary */
DWORD WINAPI SetPriorityClass (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetProcessAffinityMask ordinal = 683, argument = 8 temporary */
DWORD WINAPI SetProcessAffinityMask (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetProcessPriorityBoost ordinal = 684, argument = 8 temporary */
DWORD WINAPI SetProcessPriorityBoost (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetProcessShutdownParameters ordinal = 685, argument = 8 temporary */
DWORD WINAPI SetProcessShutdownParameters (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetProcessWorkingSetSize ordinal = 686, argument = 12 temporary */
DWORD WINAPI SetProcessWorkingSetSize (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetStdHandle ordinal = 687, argument = 8 */
BOOL WINAPI SetStdHandle (DWORD nStdHandle, HANDLE hHandle)
{
  return FALSE;
}


/* SetSystemPowerState ordinal = 688, argument = 8 temporary */
DWORD WINAPI SetSystemPowerState (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetSystemTime ordinal = 689, argument = 4 temporary */
DWORD WINAPI SetSystemTime (DWORD dwArgv0)
{
  return 0;
}


/* SetSystemTimeAdjustment ordinal = 690, argument = 8 temporary */
DWORD WINAPI SetSystemTimeAdjustment (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetTapeParameters ordinal = 691, argument = 12 temporary */
DWORD WINAPI SetTapeParameters (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetTapePosition ordinal = 692, argument = 24 temporary */
DWORD WINAPI SetTapePosition (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetTermsrvAppInstallMode ordinal = 693, argument = 0 temporary */
DWORD WINAPI SetTermsrvAppInstallMode (VOID)
{
  return 0;
}


/* SetThreadAffinityMask ordinal = 694, argument = 8 temporary */
DWORD WINAPI SetThreadAffinityMask (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetThreadContext ordinal = 695, argument = 8 temporary */
DWORD WINAPI SetThreadContext (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetThreadExecutionState ordinal = 696, argument = 4 temporary */
DWORD WINAPI SetThreadExecutionState (DWORD dwArgv0)
{
  return 0;
}


/* SetThreadIdealProcessor ordinal = 697, argument = 8 temporary */
DWORD WINAPI SetThreadIdealProcessor (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetThreadLocale ordinal = 698, argument = 4 temporary */
DWORD WINAPI SetThreadLocale (DWORD dwArgv0)
{
  return 0;
}


/* SetThreadPriority ordinal = 699, argument = 8 temporary */
DWORD WINAPI SetThreadPriority (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetThreadPriorityBoost ordinal = 700, argument = 8 temporary */
DWORD WINAPI SetThreadPriorityBoost (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetTimeZoneInformation ordinal = 701, argument = 4 temporary */
DWORD WINAPI SetTimeZoneInformation (DWORD dwArgv0)
{
  return 0;
}


/* SetTimerQueueTimer ordinal = 702, argument = 24 temporary */
DWORD WINAPI SetTimerQueueTimer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetUnhandledExceptionFilter ordinal = 703, argument = 4 temporary */
DWORD WINAPI SetUnhandledExceptionFilter (DWORD dwArgv0)
{
  return 0;
}


/* SetVDMCurrentDirectories ordinal = 704, argument = 0 temporary */
DWORD WINAPI SetVDMCurrentDirectories (VOID)
{
  return 0;
}


/* SetVolumeLabelA ordinal = 705, argument = 8 temporary */
DWORD WINAPI SetVolumeLabelA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetVolumeLabelW ordinal = 706, argument = 8 temporary */
DWORD WINAPI SetVolumeLabelW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetVolumeMountPointA ordinal = 707, argument = 8 temporary */
DWORD WINAPI SetVolumeMountPointA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetVolumeMountPointW ordinal = 708, argument = 8 temporary */
DWORD WINAPI SetVolumeMountPointW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetWaitableTimer ordinal = 709, argument = 24 temporary */
DWORD WINAPI SetWaitableTimer (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SetupComm ordinal = 710, argument = 12 temporary */
DWORD WINAPI SetupComm (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ShowConsoleCursor ordinal = 711, argument = 0 temporary */
DWORD WINAPI ShowConsoleCursor (VOID)
{
  return 0;
}


/* SignalObjectAndWait ordinal = 712, argument = 16 temporary */
DWORD WINAPI SignalObjectAndWait (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SizeofResource ordinal = 713, argument = 8 */
DWORD WINAPI SizeofResource (HMODULE hModule, HRSRC hResInfo)
{
  return *(LPDWORD)hResInfo;
}


/* Sleep ordinal = 714, argument = 4 */
VOID WINAPI Sleep (DWORD dwMilliseconds)
{
  usleep (dwMilliseconds);
}


/* SleepEx ordinal = 715, argument = 8 temporary */
DWORD WINAPI SleepEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SuspendThread ordinal = 716, argument = 4 temporary */
DWORD WINAPI SuspendThread (DWORD dwArgv0)
{
  return 0;
}


/* SwitchToFiber ordinal = 717, argument = 4 temporary */
DWORD WINAPI SwitchToFiber (DWORD dwArgv0)
{
  return 0;
}


/* SwitchToThread ordinal = 718, argument = 0 temporary */
DWORD WINAPI SwitchToThread (VOID)
{
  return 0;
}


/* SystemTimeToFileTime ordinal = 719, argument = 8 temporary */
DWORD WINAPI SystemTimeToFileTime (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SystemTimeToTzSpecificLocalTime ordinal = 720, argument = 12 temporary */
DWORD WINAPI SystemTimeToTzSpecificLocalTime (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* TerminateJobObject ordinal = 721, argument = 8 temporary */
DWORD WINAPI TerminateJobObject (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* TerminateProcess ordinal = 722, argument = 8 */
BOOL WINAPI TerminateProcess (HANDLE hProcess, UINT uExitCode)
{
  return TRUE;
}


/* TerminateThread ordinal = 723, argument = 8 temporary */
DWORD WINAPI TerminateThread (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* TermsrvAppInstallMode ordinal = 724, argument = 0 temporary */
DWORD WINAPI TermsrvAppInstallMode (VOID)
{
  return 0;
}


/* Thread32First ordinal = 725, argument = 8 temporary */
DWORD WINAPI Thread32First (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Thread32Next ordinal = 726, argument = 8 temporary */
DWORD WINAPI Thread32Next (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* TlsAlloc ordinal = 727, argument = 0 */
DWORD WINAPI TlsAlloc (VOID)
{
  return (DWORD)g_malloc (sizeof (LPVOID));
}


/* TlsFree ordinal = 728, argument = 4 */
BOOL WINAPI TlsFree (DWORD dwTlsIndex)
{
  g_free ((gpointer)dwTlsIndex);
  return TRUE;
}


/* TlsGetValue ordinal = 729, argument = 4 */
LPVOID WINAPI TlsGetValue (DWORD dwTlsIndex)
{
  return *(LPVOID *)dwTlsIndex;
}


/* TlsSetValue ordinal = 730, argument = 8 */
BOOL WINAPI TlsSetValue (DWORD dwTlsIndex, LPVOID lpTlsValue)
{
  *(LPVOID *)dwTlsIndex = lpTlsValue;
  return TRUE;
}


/* Toolhelp32ReadProcessMemory ordinal = 731, argument = 20 temporary */
DWORD WINAPI Toolhelp32ReadProcessMemory (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* TransactNamedPipe ordinal = 732, argument = 28 temporary */
DWORD WINAPI TransactNamedPipe (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* TransmitCommChar ordinal = 733, argument = 8 temporary */
DWORD WINAPI TransmitCommChar (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* TrimVirtualBuffer ordinal = 734, argument = 0 temporary */
DWORD WINAPI TrimVirtualBuffer (VOID)
{
  return 0;
}


/* TryEnterCriticalSection ordinal = 735, argument = 4 */
BOOL WINAPI TryEnterCriticalSection (LPCRITICAL_SECTION lpCriticalSection)
{
  return g_mutex_trylock ((GMutex *)lpCriticalSection);
}


/* UTRegister ordinal = 736, argument = 0 temporary */
DWORD WINAPI UTRegister (VOID)
{
  return 0;
}


/* UTUnRegister ordinal = 737, argument = 0 temporary */
DWORD WINAPI UTUnRegister (VOID)
{
  return 0;
}


/* UnhandledExceptionFilter ordinal = 738, argument = 4 temporary */
DWORD WINAPI UnhandledExceptionFilter (DWORD dwArgv0)
{
  return 0;
}


/* UnlockFile ordinal = 739, argument = 20 temporary */
DWORD WINAPI UnlockFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* UnlockFileEx ordinal = 740, argument = 20 temporary */
DWORD WINAPI UnlockFileEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* UnmapViewOfFile ordinal = 741, argument = 4 */
BOOL WINAPI UnmapViewOfFile (LPCVOID lpBaseAddress)
{
  g_free ((gpointer)lpBaseAddress);
  return TRUE;
}


/* UnregisterConsoleIME ordinal = 742, argument = 0 temporary */
DWORD WINAPI UnregisterConsoleIME (VOID)
{
  return 0;
}


/* UnregisterWait ordinal = 743, argument = 4 temporary */
DWORD WINAPI UnregisterWait (DWORD dwArgv0)
{
  return 0;
}


/* UnregisterWaitEx ordinal = 744, argument = 8 temporary */
DWORD WINAPI UnregisterWaitEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* UpdateResourceA ordinal = 745, argument = 24 temporary */
DWORD WINAPI UpdateResourceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* UpdateResourceW ordinal = 746, argument = 24 temporary */
DWORD WINAPI UpdateResourceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* VDMConsoleOperation ordinal = 747, argument = 0 temporary */
DWORD WINAPI VDMConsoleOperation (VOID)
{
  return 0;
}


/* VDMOperationStarted ordinal = 748, argument = 0 temporary */
DWORD WINAPI VDMOperationStarted (VOID)
{
  return 0;
}


/* ValidateLCType ordinal = 749, argument = 0 temporary */
DWORD WINAPI ValidateLCType (VOID)
{
  return 0;
}


/* ValidateLocale ordinal = 750, argument = 0 temporary */
DWORD WINAPI ValidateLocale (VOID)
{
  return 0;
}


/* VerLanguageNameA ordinal = 751, argument = 12 */
DWORD WINAPI VerLanguageNameA (DWORD wLang, LPSTR szLang, DWORD nSize)
{
  gsize leng = 0;
  gint i;

  for (i = 0; nls_information[i].langage; i++)
    if (LANGIDFROMLCID (nls_information[i].lcid) == LANGIDFROMLCID (wLang))
      {
        gchar *mb;

        mb = w32ldr_utf8_to_mb (nls_information[i].locale);
        leng = g_strlen (mb);
        if (szLang && leng < nSize)
          g_strcpy (szLang, mb);
        else
          leng++;
        g_free (mb);
        break;
      }
  return leng;
}


/* VerLanguageNameW ordinal = 752, argument = 12 */
DWORD WINAPI VerLanguageNameW (DWORD wLang, LPWSTR szLang, DWORD nSize)
{
  gsize leng = 0;
  gint i;

  for (i = 0; nls_information[i].langage; i++)
    if (LANGIDFROMLCID (nls_information[i].lcid) == LANGIDFROMLCID (wLang))
      {
        gunichar2 *wc;

        wc = g_utf8_to_utf16 (nls_information[i].locale, -1, NULL, NULL, NULL);
        leng = lstrlenW (wc);
        if (szLang && leng < nSize)
          lstrcpyW (szLang, wc);
        else
          leng++;
        g_free (wc);
        break;
      }
  return leng;
}


/* VerSetConditionMask ordinal = 753, argument = 16 temporary */
DWORD WINAPI VerSetConditionMask (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* VerifyConsoleIoHandle ordinal = 754, argument = 0 temporary */
DWORD WINAPI VerifyConsoleIoHandle (VOID)
{
  return 0;
}


/* VerifyVersionInfoA ordinal = 755, argument = 16 temporary */
DWORD WINAPI VerifyVersionInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* VerifyVersionInfoW ordinal = 756, argument = 16 temporary */
DWORD WINAPI VerifyVersionInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* VirtualAlloc ordinal = 757, argument = 16 */
LPVOID WINAPI VirtualAlloc (LPVOID lpAddress, DWORD dwSize, DWORD flAllocationType, DWORD flProtect)
{
  return g_malloc (dwSize);
}


/* VirtualAllocEx ordinal = 758, argument = 20 temporary */
DWORD WINAPI VirtualAllocEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* VirtualBufferExceptionHandler ordinal = 759, argument = 0 temporary */
DWORD WINAPI VirtualBufferExceptionHandler (VOID)
{
  return 0;
}


/* VirtualFree ordinal = 760, argument = 12 */
BOOL WINAPI VirtualFree (LPVOID lpAddress, DWORD dwSize, DWORD dwFreeType)
{
  g_free (lpAddress);
  return TRUE;
}


/* VirtualFreeEx ordinal = 761, argument = 16 temporary */
DWORD WINAPI VirtualFreeEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* VirtualLock ordinal = 762, argument = 8 */
BOOL WINAPI VirtualLock (LPVOID lpAddress, DWORD dwSize)
{
  return TRUE;
}


/* VirtualProtect ordinal = 763, argument = 16 */
BOOL WINAPI VirtualProtect (LPVOID lpAddress, DWORD dwSize, DWORD flNewProtect, PDWORD lpflOldProtect)
{
  return TRUE;
}


/* VirtualProtectEx ordinal = 764, argument = 20 temporary */
DWORD WINAPI VirtualProtectEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* VirtualQuery ordinal = 765, argument = 12 */
DWORD WINAPI VirtualQuery (LPCVOID lpAddress, PMEMORY_BASIC_INFORMATION lpBuffer, DWORD dwLength)
{
  return sizeof (MEMORY_BASIC_INFORMATION);
}


/* VirtualQueryEx ordinal = 766, argument = 16 temporary */
DWORD WINAPI VirtualQueryEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* VirtualUnlock ordinal = 767, argument = 8 */
BOOL WINAPI VirtualUnlock (LPVOID lpAddress, DWORD dwSize)
{
  return TRUE;
}


/* WaitCommEvent ordinal = 768, argument = 12 temporary */
DWORD WINAPI WaitCommEvent (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* WaitForDebugEvent ordinal = 769, argument = 8 temporary */
DWORD WINAPI WaitForDebugEvent (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WaitForMultipleObjects ordinal = 770, argument = 16 temporary */
DWORD WINAPI WaitForMultipleObjects (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* WaitForMultipleObjectsEx ordinal = 771, argument = 20 temporary */
DWORD WINAPI WaitForMultipleObjectsEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WaitForSingleObject ordinal = 772, argument = 8 */
DWORD WINAPI WaitForSingleObject (HANDLE hHandle, DWORD dwMilliseconds)
{
  return WAIT_FAILED;
}


/* WaitForSingleObjectEx ordinal = 773, argument = 12 temporary */
DWORD WINAPI WaitForSingleObjectEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* WaitNamedPipeA ordinal = 774, argument = 8 temporary */
DWORD WINAPI WaitNamedPipeA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WaitNamedPipeW ordinal = 775, argument = 8 temporary */
DWORD WINAPI WaitNamedPipeW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WideCharToMultiByte ordinal = 776, argument = 32 */
INT WINAPI WideCharToMultiByte (UINT CodePage, DWORD dwFlags, LPCWSTR lpWideCharStr, INT cchWideChar, LPSTR lpMultiByteStr, INT cchMultiByte, LPCSTR lpDefaultChar, LPBOOL lpUsedDefaultChar)
{
  gsize bytes_done = 0, bytes_read, bytes_stored = 0, bytes_written, leng;
  gssize len;
  gchar *charset, *mb = NULL;
  gint result;
  GError *error = NULL;

  if (!lpWideCharStr || cchWideChar == 0)
    return 0;
  leng = g_strlen (lpDefaultChar);
  switch (CodePage)
    {
      case CP_ACP:
      case CP_MACCP:
      case CP_THREAD_ACP:
      case CP_SYMBOL:
        charset = g_strdup_printf ("CP%d", GetACP ());
        break;
      case CP_OEMCP:
        charset = g_strdup_printf ("CP%d", GetOEMCP ());
        break;
      case CP_UTF7:
        charset = g_strdup ("UTF-7");
        break;
      case CP_UTF8:
        charset = g_strdup ("UTF-8");
        break;
      default:
        charset = g_strdup_printf ("CP%d", CodePage);
    }
  len = (cchWideChar < 0 ? lstrlenW (lpWideCharStr) + 1 : cchWideChar)
                                                        * sizeof (gunichar2);
  if (lpUsedDefaultChar)
    *lpUsedDefaultChar = FALSE;
  while (len - bytes_done > 0)
    {
      gchar *tmp;

      tmp = g_convert ((const gchar *)lpWideCharStr + bytes_done,
                                        len - bytes_done,
                                        charset, "UTF-16LE",
                                        &bytes_read, &bytes_written, &error);
      if (!tmp && error && g_error_matches (error, G_CONVERT_ERROR,
                                            G_CONVERT_ERROR_ILLEGAL_SEQUENCE)
                                        && bytes_read >= sizeof (gunichar2))
        tmp = g_convert ((const gchar *)lpWideCharStr + bytes_done,
                                        bytes_read,
                                        charset, "UTF-16LE",
                                        &bytes_read, &bytes_written, NULL);
      g_clear_error (&error);
      if (tmp)
        {
          bytes_done += bytes_read;
          mb = g_realloc (mb, bytes_stored + bytes_written);
          g_memmove (mb + bytes_stored, tmp, bytes_written);
          bytes_stored += bytes_written;
        }
      if (len - bytes_done > 0)
        {
          bytes_done += sizeof (gunichar2);
          if (lpDefaultChar)
            {
              mb = g_realloc (mb, bytes_stored + leng);
              g_memmove (mb + bytes_stored, lpDefaultChar, leng);
              bytes_stored += leng;
            }
          else
            {
              mb = g_realloc (mb, bytes_stored + 1);
              mb[bytes_stored++] = '?';
            }
          if (lpUsedDefaultChar)
            *lpUsedDefaultChar = TRUE;
        }
    }
  g_free (charset);
  result = bytes_stored / sizeof (gchar);
  if (cchWideChar < 0)
    result++;
  if (lpMultiByteStr && cchMultiByte > 0)
    {
      if (result > cchMultiByte)
        result = cchMultiByte;
      g_memmove (lpMultiByteStr, mb, result * sizeof (gchar));
    }
  g_free (mb);
  return result;
}


/* WinExec ordinal = 777, argument = 8 temporary */
DWORD WINAPI WinExec (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WriteConsoleA ordinal = 778, argument = 20 */
BOOL WINAPI WriteConsoleA (HANDLE hConsoleOutput, CONST VOID *lpBuffer, DWORD nNumberOfCharsToWrite, LPDWORD lpNumberOfCharsWritten, LPVOID lpReserved)
{
  gchar *buf, *str;

  if (!lpBuffer)
    return FALSE;
  buf = g_malloc ((nNumberOfCharsToWrite + 1) * sizeof (gchar));
  g_memmove (buf, lpBuffer, nNumberOfCharsToWrite * sizeof (gchar));
  buf[nNumberOfCharsToWrite] = '\0';
  str = w32ldr_utf8_from_mb (buf);
  g_free (buf);
  g_print (str);
  g_free (str);
  if (lpNumberOfCharsWritten)
    *lpNumberOfCharsWritten = nNumberOfCharsToWrite;
  return TRUE;
}


/* WriteConsoleInputA ordinal = 779, argument = 16 temporary */
DWORD WINAPI WriteConsoleInputA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* WriteConsoleInputVDMA ordinal = 780, argument = 0 temporary */
DWORD WINAPI WriteConsoleInputVDMA (VOID)
{
  return 0;
}


/* WriteConsoleInputVDMW ordinal = 781, argument = 0 temporary */
DWORD WINAPI WriteConsoleInputVDMW (VOID)
{
  return 0;
}


/* WriteConsoleInputW ordinal = 782, argument = 16 temporary */
DWORD WINAPI WriteConsoleInputW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* WriteConsoleOutputA ordinal = 783, argument = 20 temporary */
DWORD WINAPI WriteConsoleOutputA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteConsoleOutputAttribute ordinal = 784, argument = 20 temporary */
DWORD WINAPI WriteConsoleOutputAttribute (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteConsoleOutputCharacterA ordinal = 785, argument = 20 temporary */
DWORD WINAPI WriteConsoleOutputCharacterA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteConsoleOutputCharacterW ordinal = 786, argument = 20 temporary */
DWORD WINAPI WriteConsoleOutputCharacterW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteConsoleOutputW ordinal = 787, argument = 20 temporary */
DWORD WINAPI WriteConsoleOutputW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteConsoleW ordinal = 788, argument = 20 */
BOOL WINAPI WriteConsoleW (HANDLE hConsoleOutput, CONST VOID *lpBuffer, DWORD nNumberOfCharsToWrite, LPDWORD lpNumberOfCharsWritten, LPVOID lpReserved)
{
  gchar *str;

  if (!lpBuffer)
    return FALSE;
  str = g_utf16_to_utf8 (lpBuffer, nNumberOfCharsToWrite, NULL, NULL, NULL);
  g_print (str);
  g_free (str);
  if (lpNumberOfCharsWritten)
    *lpNumberOfCharsWritten = nNumberOfCharsToWrite;
  return TRUE;
}


/* WriteFile ordinal = 789, argument = 20 */
BOOL WINAPI WriteFile (HANDLE hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped)
{
  return FALSE;
}


/* WriteFileEx ordinal = 790, argument = 20 temporary */
DWORD WINAPI WriteFileEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteFileGather ordinal = 791, argument = 20 temporary */
DWORD WINAPI WriteFileGather (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WritePrivateProfileSectionA ordinal = 792, argument = 12 temporary */
DWORD WINAPI WritePrivateProfileSectionA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* WritePrivateProfileSectionW ordinal = 793, argument = 12 temporary */
DWORD WINAPI WritePrivateProfileSectionW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* WritePrivateProfileStringA ordinal = 794, argument = 16 */
BOOL WINAPI WritePrivateProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpString, LPCSTR lpFileName)
{
  gboolean result = FALSE;
  gsize length;
  gchar *group, *key, *file, *str, *tmp;
  GKeyFile *key_file;

  group = w32ldr_utf8_from_mb (lpAppName);
  key = w32ldr_utf8_from_mb (lpKeyName);
  str = w32ldr_utf8_from_mb (lpString);
  tmp = w32ldr_filename_from_mb (lpFileName);
  file = w32ldr_dir_get_filename_for_read (tmp);
  key_file = g_key_file_new ();
  g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
  g_key_file_set_string (key_file, group, key, str);
  g_free (group);
  g_free (key);
  g_free (str);
  g_free (file);
  str = g_key_file_to_data (key_file, &length, NULL);
  g_key_file_free (key_file);
  if (str)
    {
      file = w32ldr_dir_get_filename_for_write (tmp);
      result = fileio_save (file, str, length);
      g_free (file);
      g_free (str);
    }
  g_free (tmp);
  return result;
}


/* WritePrivateProfileStringW ordinal = 795, argument = 16 */
BOOL WINAPI WritePrivateProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpString, LPCWSTR lpFileName)
{
  gboolean result = FALSE;
  gsize length;
  gchar *group, *key, *file, *str, *tmp;
  GKeyFile *key_file;

  group = g_utf16_to_utf8 (lpAppName, -1, NULL, NULL, NULL);
  key = g_utf16_to_utf8 (lpKeyName, -1, NULL, NULL, NULL);
  str = g_utf16_to_utf8 (lpString, -1, NULL, NULL, NULL);
  tmp = w32ldr_filename_from_wc (lpFileName);
  file = w32ldr_dir_get_filename_for_read (tmp);
  key_file = g_key_file_new ();
  g_key_file_load_from_file (key_file, file, G_KEY_FILE_NONE, NULL);
  g_key_file_set_string (key_file, group, key, str);
  g_free (group);
  g_free (key);
  g_free (str);
  g_free (file);
  str = g_key_file_to_data (key_file, &length, NULL);
  g_key_file_free (key_file);
  if (str)
    {
      file = w32ldr_dir_get_filename_for_write (tmp);
      result = fileio_save (file, str, length);
      g_free (file);
      g_free (str);
    }
  g_free (tmp);
  return result;
}


/* WritePrivateProfileStructA ordinal = 796, argument = 20 temporary */
DWORD WINAPI WritePrivateProfileStructA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WritePrivateProfileStructW ordinal = 797, argument = 20 temporary */
DWORD WINAPI WritePrivateProfileStructW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteProcessMemory ordinal = 798, argument = 20 temporary */
DWORD WINAPI WriteProcessMemory (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* WriteProfileSectionA ordinal = 799, argument = 8 temporary */
DWORD WINAPI WriteProfileSectionA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WriteProfileSectionW ordinal = 800, argument = 8 temporary */
DWORD WINAPI WriteProfileSectionW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* WriteProfileStringA ordinal = 801, argument = 12 */
BOOL WINAPI WriteProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpString)
{
  return WritePrivateProfileStringA (lpAppName, lpKeyName, lpString,
                                                                    "win.ini");
}


/* WriteProfileStringW ordinal = 802, argument = 12 */
BOOL WINAPI WriteProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpString)
{
  gunichar2 file[] = {'w', 'i', 'n', '.', 'i', 'n', 'i', '\0'};

  return WritePrivateProfileStringW (lpAppName, lpKeyName, lpString, file);
}


/* WriteTapemark ordinal = 803, argument = 16 temporary */
DWORD WINAPI WriteTapemark (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* _hread ordinal = 804, argument = 12 temporary */
DWORD WINAPI _hread (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* _hwrite ordinal = 805, argument = 12 temporary */
DWORD WINAPI _hwrite (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* _lclose ordinal = 806, argument = 4 */
HFILE WINAPI _lclose (HFILE hFile)
{
  return fileio_close (hFile) ? (HFILE)0 : HFILE_ERROR;
}


/* _lcreat ordinal = 807, argument = 8 */
HFILE WINAPI _lcreat (LPCSTR lpPathName, INT iAttribute)
{
  return HFILE_ERROR;
}


/* _llseek ordinal = 808, argument = 12 */
LONG WINAPI _llseek (HFILE hFile, LONG lOffset, INT iOrigin)
{
  guint whence;

  switch (iOrigin)
    {
      case FILE_BEGIN: whence = FILEIO_SEEK_SET; break;
      case FILE_END:   whence = FILEIO_SEEK_END; break;
      default:         whence = FILEIO_SEEK_CUR;
    }
  return fileio_seek (hFile, lOffset, whence);
}


/* _lopen ordinal = 809, argument = 8 temporary */
HFILE WINAPI _lopen (LPCSTR lpPathName, INT iReadWrite)
{
  gchar *file;
  FileIO *fio;

  file = w32ldr_filename_from_mb (lpPathName);
  fio = fileio_open (file,
            FILEIO_ACCESS_READ, FILEIO_SHARE_READ, FILEIO_MODE_OPEN_EXISTING);
  g_free (file);
  return fio;
}


/* _lread ordinal = 810, argument = 12 */
UINT WINAPI _lread (HFILE hFile, LPVOID lpBuffer, UINT uBytes)
{
  return fileio_read (hFile, lpBuffer, uBytes);
}


/* _lwrite ordinal = 811, argument = 12 */
UINT WINAPI _lwrite (HFILE hFile, LPVOID lpBuffer, UINT uBytes)
{
  return (UINT)HFILE_ERROR;
}


/* lstrcat ordinal = 812, argument = 8 */
/* LPSTR WINAPI lstrcat (LPSTR lpString1, LPCSTR lpString2) */


/* lstrcatA ordinal = 813, argument = 8 */
LPSTR WINAPI lstrcatA (LPSTR lpString1, LPCSTR lpString2)
{
  if (!lpString1 || !lpString2)
    return NULL;
  g_strcat (lpString1, lpString2);
  return lpString1;
}


/* lstrcatW ordinal = 814, argument = 8 */
LPWSTR WINAPI lstrcatW (LPWSTR lpString1, LPCWSTR lpString2)
{
  gint i, j;

  if (!lpString1 || !lpString2)
    return NULL;
  i = lstrlenW (lpString1);
  for (j = 0; lpString1[j] != '\0'; j++)
    lpString1[i + j] = lpString2[j];
  lpString1[i + j] = '\0';
  return lpString1;
}


/* lstrcmp ordinal = 815, argument = 8 */
/* INT WINAPI lstrcmp (LPCSTR lpString1, LPCSTR lpString2) */


/* lstrcmpA ordinal = 816, argument = 8 */
INT WINAPI lstrcmpA (LPCSTR lpString1, LPCSTR lpString2)
{
  return g_strcmp (lpString1, lpString2);
}


/* lstrcmpW ordinal = 817, argument = 8 */
INT WINAPI lstrcmpW (LPCWSTR lpString1, LPCWSTR lpString2)
{
  gint i;

  if (!lpString1 || !lpString2)
    return 0;
  for (i = 0; lpString1[i] != '\0' && lpString2[i] != '\0'; i++)
    if (lpString1[i] != lpString2[i])
      break;
  return lpString1[i] - lpString2[i];
}


/* lstrcmpi ordinal = 818, argument = 8 */
/* INT WINAPI lstrcmpi (LPCSTR lpString1, LPCSTR lpString2) */


/* lstrcmpiA ordinal = 819, argument = 8 */
INT WINAPI lstrcmpiA (LPCSTR lpString1, LPCSTR lpString2)
{
  gchar *str1, *str2;
  gint result;

  str1 = w32ldr_utf8_from_mb (lpString1);
  str2 = w32ldr_utf8_from_mb (lpString2);
  result = g_strcasecmp (str1, str2);
  g_free (str1);
  g_free (str2);
  return result;
}


/* lstrcmpiW ordinal = 820, argument = 8 */
INT WINAPI lstrcmpiW (LPCWSTR lpString1, LPCWSTR lpString2)
{
  gchar *str1, *str2;
  gint result;

  str1 = g_utf16_to_utf8 (lpString1, -1, NULL, NULL, NULL);
  str2 = g_utf16_to_utf8 (lpString2, -1, NULL, NULL, NULL);
  result = g_strcasecmp (str1, str2);
  g_free (str1);
  g_free (str2);
  return result;
}


/* lstrcpy ordinal = 821, argument = 8 */
/* LPSTR WINAPI lstrcpy (LPSTR lpString1, LPCSTR lpString2) */


/* lstrcpyA ordinal = 822, argument = 8 */
LPSTR WINAPI lstrcpyA (LPSTR lpString1, LPCSTR lpString2)
{
  if (!lpString1 || !lpString2)
    return NULL;
  g_strcpy (lpString1, lpString2);
  return lpString1;
}


/* lstrcpyW ordinal = 823, argument = 8 */
LPWSTR WINAPI lstrcpyW (LPWSTR lpString1, LPCWSTR lpString2)
{
  if (!lpString1 || !lpString2)
    return NULL;
  g_memmove (lpString1, lpString2, lstrlenW (lpString2) * sizeof (gunichar2));
  return lpString1;
}


/* lstrcpyn ordinal = 824, argument = 12 */
/* LPSTR WINAPI lstrcpyn (LPSTR lpString1, LPCSTR lpString2, INT iMaxLength) */


/* lstrcpynA ordinal = 825, argument = 12 */
LPSTR WINAPI lstrcpynA (LPSTR lpString1, LPCSTR lpString2, INT iMaxLength)
{
  if (!lpString1 || !lpString2 || iMaxLength <= 0)
    return NULL;
  g_strlcpy (lpString1, lpString2, iMaxLength);
  return lpString1;
}


/* lstrcpynW ordinal = 826, argument = 12 */
LPWSTR WINAPI lstrcpynW (LPWSTR lpString1, LPCWSTR lpString2, INT iMaxLength)
{
  gsize leng;

  if (!lpString1 || !lpString2 || iMaxLength <= 0)
    return NULL;
  leng = MIN (iMaxLength - 1, lstrlenW (lpString2));
  g_memmove (lpString1, lpString2, leng * sizeof (WCHAR));
  lpString1[leng] = '\0';
  return lpString1;
}


/* lstrlen ordinal = 827, argument = 4 */
/* INT WINAPI lstrlen (LPCSTR lpString) */


/* lstrlenA ordinal = 828, argument = 4 */
INT WINAPI lstrlenA (LPCSTR lpString)
{
  return lpString ? g_strlen (lpString) : 0;
}


/* lstrlenW ordinal = 829, argument = 4 */
INT WINAPI lstrlenW (LPCWSTR lpString)
{
  gint i;

  if (!lpString)
    return 0;
  for (i = 0; lpString[i] != '\0'; i++);
  return i;
}


W32LdrExport kernel32_exports[] = {
{1, "AddAtomA", AddAtomA},
{2, "AddAtomW", AddAtomW},
{3, "AddConsoleAliasA", AddConsoleAliasA},
{4, "AddConsoleAliasW", AddConsoleAliasW},
{5, "AllocConsole", AllocConsole},
{6, "AllocateUserPhysicalPages", AllocateUserPhysicalPages},
{7, "AreFileApisANSI", AreFileApisANSI},
{8, "AssignProcessToJobObject", AssignProcessToJobObject},
{9, "BackupRead", BackupRead},
{10, "BackupSeek", BackupSeek},
{11, "BackupWrite", BackupWrite},
{12, "BaseAttachCompleteThunk", BaseAttachCompleteThunk},
{13, "Beep", Beep},
{14, "BeginUpdateResourceA", BeginUpdateResourceA},
{15, "BeginUpdateResourceW", BeginUpdateResourceW},
{16, "BindIoCompletionCallback", BindIoCompletionCallback},
{17, "BuildCommDCBA", BuildCommDCBA},
{18, "BuildCommDCBAndTimeoutsA", BuildCommDCBAndTimeoutsA},
{19, "BuildCommDCBAndTimeoutsW", BuildCommDCBAndTimeoutsW},
{20, "BuildCommDCBW", BuildCommDCBW},
{21, "CallNamedPipeA", CallNamedPipeA},
{22, "CallNamedPipeW", CallNamedPipeW},
{23, "CancelDeviceWakeupRequest", CancelDeviceWakeupRequest},
{24, "CancelIo", CancelIo},
{25, "CancelTimerQueueTimer", CancelTimerQueueTimer},
{26, "CancelWaitableTimer", CancelWaitableTimer},
{27, "ChangeTimerQueueTimer", ChangeTimerQueueTimer},
{28, "ClearCommBreak", ClearCommBreak},
{29, "ClearCommError", ClearCommError},
{30, "CloseConsoleHandle", CloseConsoleHandle},
{31, "CloseHandle", CloseHandle},
{32, "CloseProfileUserMapping", CloseProfileUserMapping},
{33, "CmdBatNotification", CmdBatNotification},
{34, "CommConfigDialogA", CommConfigDialogA},
{35, "CommConfigDialogW", CommConfigDialogW},
{36, "CompareFileTime", CompareFileTime},
{37, "CompareStringA", CompareStringA},
{38, "CompareStringW", CompareStringW},
{39, "ConnectNamedPipe", ConnectNamedPipe},
{40, "ConsoleMenuControl", ConsoleMenuControl},
{41, "ContinueDebugEvent", ContinueDebugEvent},
{42, "ConvertDefaultLocale", ConvertDefaultLocale},
{43, "ConvertThreadToFiber", ConvertThreadToFiber},
{44, "CopyFileA", CopyFileA},
{45, "CopyFileExA", CopyFileExA},
{46, "CopyFileExW", CopyFileExW},
{47, "CopyFileW", CopyFileW},
{48, "CreateConsoleScreenBuffer", CreateConsoleScreenBuffer},
{49, "CreateDirectoryA", CreateDirectoryA},
{50, "CreateDirectoryExA", CreateDirectoryExA},
{51, "CreateDirectoryExW", CreateDirectoryExW},
{52, "CreateDirectoryW", CreateDirectoryW},
{53, "CreateEventA", CreateEventA},
{54, "CreateEventW", CreateEventW},
{55, "CreateFiber", CreateFiber},
{56, "CreateFiberEx", CreateFiberEx},
{57, "CreateFileA", CreateFileA},
{58, "CreateFileMappingA", CreateFileMappingA},
{59, "CreateFileMappingW", CreateFileMappingW},
{60, "CreateFileW", CreateFileW},
{61, "CreateHardLinkA", CreateHardLinkA},
{62, "CreateHardLinkW", CreateHardLinkW},
{63, "CreateIoCompletionPort", CreateIoCompletionPort},
{64, "CreateJobObjectA", CreateJobObjectA},
{65, "CreateJobObjectW", CreateJobObjectW},
{66, "CreateMailslotA", CreateMailslotA},
{67, "CreateMailslotW", CreateMailslotW},
{68, "CreateMutexA", CreateMutexA},
{69, "CreateMutexW", CreateMutexW},
{70, "CreateNamedPipeA", CreateNamedPipeA},
{71, "CreateNamedPipeW", CreateNamedPipeW},
{72, "CreatePipe", CreatePipe},
{73, "CreateProcessA", CreateProcessA},
{74, "CreateProcessInternalA", CreateProcessInternalA},
{75, "CreateProcessInternalW", CreateProcessInternalW},
{76, "CreateProcessInternalWSecure", CreateProcessInternalWSecure},
{77, "CreateProcessW", CreateProcessW},
{78, "CreateRemoteThread", CreateRemoteThread},
{79, "CreateSemaphoreA", CreateSemaphoreA},
{80, "CreateSemaphoreW", CreateSemaphoreW},
{81, "CreateTapePartition", CreateTapePartition},
{82, "CreateThread", CreateThread},
{83, "CreateTimerQueue", CreateTimerQueue},
{84, "CreateTimerQueueTimer", CreateTimerQueueTimer},
{85, "CreateToolhelp32Snapshot", CreateToolhelp32Snapshot},
{86, "CreateVirtualBuffer", CreateVirtualBuffer},
{87, "CreateWaitableTimerA", CreateWaitableTimerA},
{88, "CreateWaitableTimerW", CreateWaitableTimerW},
{89, "DebugActiveProcess", DebugActiveProcess},
{90, "DebugBreak", DebugBreak},
{91, "DefineDosDeviceA", DefineDosDeviceA},
{92, "DefineDosDeviceW", DefineDosDeviceW},
{93, "DelayLoadFailureHook", DelayLoadFailureHook},
{94, "DeleteAtom", DeleteAtom},
{95, "DeleteCriticalSection", DeleteCriticalSection},
{96, "DeleteFiber", DeleteFiber},
{97, "DeleteFileA", DeleteFileA},
{98, "DeleteFileW", DeleteFileW},
{99, "DeleteTimerQueue", DeleteTimerQueue},
{100, "DeleteTimerQueueEx", DeleteTimerQueueEx},
{101, "DeleteTimerQueueTimer", DeleteTimerQueueTimer},
{102, "DeleteVolumeMountPointA", DeleteVolumeMountPointA},
{103, "DeleteVolumeMountPointW", DeleteVolumeMountPointW},
{104, "DeviceIoControl", DeviceIoControl},
{105, "DisableThreadLibraryCalls", DisableThreadLibraryCalls},
{106, "DisconnectNamedPipe", DisconnectNamedPipe},
{107, "DnsHostnameToComputerNameA", DnsHostnameToComputerNameA},
{108, "DnsHostnameToComputerNameW", DnsHostnameToComputerNameW},
{109, "DosDateTimeToFileTime", DosDateTimeToFileTime},
{110, "DosPathToSessionPathA", DosPathToSessionPathA},
{111, "DosPathToSessionPathW", DosPathToSessionPathW},
{112, "DuplicateConsoleHandle", DuplicateConsoleHandle},
{113, "DuplicateHandle", DuplicateHandle},
{114, "EndUpdateResourceA", EndUpdateResourceA},
{115, "EndUpdateResourceW", EndUpdateResourceW},
{116, "EnterCriticalSection", EnterCriticalSection},
{117, "EnumCalendarInfoA", EnumCalendarInfoA},
{118, "EnumCalendarInfoExA", EnumCalendarInfoExA},
{119, "EnumCalendarInfoExW", EnumCalendarInfoExW},
{120, "EnumCalendarInfoW", EnumCalendarInfoW},
{121, "EnumDateFormatsA", EnumDateFormatsA},
{122, "EnumDateFormatsExA", EnumDateFormatsExA},
{123, "EnumDateFormatsExW", EnumDateFormatsExW},
{124, "EnumDateFormatsW", EnumDateFormatsW},
{125, "EnumLanguageGroupLocalesA", EnumLanguageGroupLocalesA},
{126, "EnumLanguageGroupLocalesW", EnumLanguageGroupLocalesW},
{127, "EnumResourceLanguagesA", EnumResourceLanguagesA},
{128, "EnumResourceLanguagesW", EnumResourceLanguagesW},
{129, "EnumResourceNamesA", EnumResourceNamesA},
{130, "EnumResourceNamesW", EnumResourceNamesW},
{131, "EnumResourceTypesA", EnumResourceTypesA},
{132, "EnumResourceTypesW", EnumResourceTypesW},
{133, "EnumSystemCodePagesA", EnumSystemCodePagesA},
{134, "EnumSystemCodePagesW", EnumSystemCodePagesW},
{135, "EnumSystemLanguageGroupsA", EnumSystemLanguageGroupsA},
{136, "EnumSystemLanguageGroupsW", EnumSystemLanguageGroupsW},
{137, "EnumSystemLocalesA", EnumSystemLocalesA},
{138, "EnumSystemLocalesW", EnumSystemLocalesW},
{139, "EnumTimeFormatsA", EnumTimeFormatsA},
{140, "EnumTimeFormatsW", EnumTimeFormatsW},
{141, "EnumUILanguagesA", EnumUILanguagesA},
{142, "EnumUILanguagesW", EnumUILanguagesW},
{143, "EraseTape", EraseTape},
{144, "EscapeCommFunction", EscapeCommFunction},
{145, "ExitProcess", ExitProcess},
{146, "ExitThread", ExitThread},
{147, "ExitVDM", ExitVDM},
{148, "ExpandEnvironmentStringsA", ExpandEnvironmentStringsA},
{149, "ExpandEnvironmentStringsW", ExpandEnvironmentStringsW},
{150, "ExpungeConsoleCommandHistoryA", ExpungeConsoleCommandHistoryA},
{151, "ExpungeConsoleCommandHistoryW", ExpungeConsoleCommandHistoryW},
{152, "ExtendVirtualBuffer", ExtendVirtualBuffer},
{153, "FatalAppExitA", FatalAppExitA},
{154, "FatalAppExitW", FatalAppExitW},
{155, "FatalExit", FatalExit},
{156, "FileTimeToDosDateTime", FileTimeToDosDateTime},
{157, "FileTimeToLocalFileTime", FileTimeToLocalFileTime},
{158, "FileTimeToSystemTime", FileTimeToSystemTime},
{159, "FillConsoleOutputAttribute", FillConsoleOutputAttribute},
{160, "FillConsoleOutputCharacterA", FillConsoleOutputCharacterA},
{161, "FillConsoleOutputCharacterW", FillConsoleOutputCharacterW},
{162, "FindAtomA", FindAtomA},
{163, "FindAtomW", FindAtomW},
{164, "FindClose", FindClose},
{165, "FindCloseChangeNotification", FindCloseChangeNotification},
{166, "FindFirstChangeNotificationA", FindFirstChangeNotificationA},
{167, "FindFirstChangeNotificationW", FindFirstChangeNotificationW},
{168, "FindFirstFileA", FindFirstFileA},
{169, "FindFirstFileExA", FindFirstFileExA},
{170, "FindFirstFileExW", FindFirstFileExW},
{171, "FindFirstFileW", FindFirstFileW},
{172, "FindFirstVolumeA", FindFirstVolumeA},
{173, "FindFirstVolumeMountPointA", FindFirstVolumeMountPointA},
{174, "FindFirstVolumeMountPointW", FindFirstVolumeMountPointW},
{175, "FindFirstVolumeW", FindFirstVolumeW},
{176, "FindNextChangeNotification", FindNextChangeNotification},
{177, "FindNextFileA", FindNextFileA},
{178, "FindNextFileW", FindNextFileW},
{179, "FindNextVolumeA", FindNextVolumeA},
{180, "FindNextVolumeMountPointA", FindNextVolumeMountPointA},
{181, "FindNextVolumeMountPointW", FindNextVolumeMountPointW},
{182, "FindNextVolumeW", FindNextVolumeW},
{183, "FindResourceA", FindResourceA},
{184, "FindResourceExA", FindResourceExA},
{185, "FindResourceExW", FindResourceExW},
{186, "FindResourceW", FindResourceW},
{187, "FindVolumeClose", FindVolumeClose},
{188, "FindVolumeMountPointClose", FindVolumeMountPointClose},
{189, "FlushConsoleInputBuffer", FlushConsoleInputBuffer},
{190, "FlushFileBuffers", FlushFileBuffers},
{191, "FlushInstructionCache", FlushInstructionCache},
{192, "FlushViewOfFile", FlushViewOfFile},
{193, "FoldStringA", FoldStringA},
{194, "FoldStringW", FoldStringW},
{195, "FormatMessageA", FormatMessageA},
{196, "FormatMessageW", FormatMessageW},
{197, "FreeConsole", FreeConsole},
{198, "FreeEnvironmentStringsA", FreeEnvironmentStringsA},
{199, "FreeEnvironmentStringsW", FreeEnvironmentStringsW},
{200, "FreeLibrary", FreeLibrary},
{201, "FreeLibraryAndExitThread", FreeLibraryAndExitThread},
{202, "FreeResource", FreeResource},
{203, "FreeUserPhysicalPages", FreeUserPhysicalPages},
{204, "FreeVirtualBuffer", FreeVirtualBuffer},
{205, "GenerateConsoleCtrlEvent", GenerateConsoleCtrlEvent},
{206, "GetACP", GetACP},
{207, "GetAtomNameA", GetAtomNameA},
{208, "GetAtomNameW", GetAtomNameW},
{209, "GetBinaryType", GetBinaryTypeA},
{210, "GetBinaryTypeA", GetBinaryTypeA},
{211, "GetBinaryTypeW", GetBinaryTypeW},
{212, "GetCPInfo", GetCPInfo},
{213, "GetCPInfoExA", GetCPInfoExA},
{214, "GetCPInfoExW", GetCPInfoExW},
{215, "GetCalendarInfoA", GetCalendarInfoA},
{216, "GetCalendarInfoW", GetCalendarInfoW},
{217, "GetCommConfig", GetCommConfig},
{218, "GetCommMask", GetCommMask},
{219, "GetCommModemStatus", GetCommModemStatus},
{220, "GetCommProperties", GetCommProperties},
{221, "GetCommState", GetCommState},
{222, "GetCommTimeouts", GetCommTimeouts},
{223, "GetCommandLineA", GetCommandLineA},
{224, "GetCommandLineW", GetCommandLineW},
{225, "GetCompressedFileSizeA", GetCompressedFileSizeA},
{226, "GetCompressedFileSizeW", GetCompressedFileSizeW},
{227, "GetComputerNameA", GetComputerNameA},
{228, "GetComputerNameExA", GetComputerNameExA},
{229, "GetComputerNameExW", GetComputerNameExW},
{230, "GetComputerNameW", GetComputerNameW},
{231, "GetConsoleAliasA", GetConsoleAliasA},
{232, "GetConsoleAliasExesA", GetConsoleAliasExesA},
{233, "GetConsoleAliasExesLengthA", GetConsoleAliasExesLengthA},
{234, "GetConsoleAliasExesLengthW", GetConsoleAliasExesLengthW},
{235, "GetConsoleAliasExesW", GetConsoleAliasExesW},
{236, "GetConsoleAliasW", GetConsoleAliasW},
{237, "GetConsoleAliasesA", GetConsoleAliasesA},
{238, "GetConsoleAliasesLengthA", GetConsoleAliasesLengthA},
{239, "GetConsoleAliasesLengthW", GetConsoleAliasesLengthW},
{240, "GetConsoleAliasesW", GetConsoleAliasesW},
{241, "GetConsoleCP", GetConsoleCP},
{242, "GetConsoleCharType", GetConsoleCharType},
{243, "GetConsoleCommandHistoryA", GetConsoleCommandHistoryA},
{244, "GetConsoleCommandHistoryLengthA", GetConsoleCommandHistoryLengthA},
{245, "GetConsoleCommandHistoryLengthW", GetConsoleCommandHistoryLengthW},
{246, "GetConsoleCommandHistoryW", GetConsoleCommandHistoryW},
{247, "GetConsoleCursorInfo", GetConsoleCursorInfo},
{248, "GetConsoleCursorMode", GetConsoleCursorMode},
{249, "GetConsoleDisplayMode", GetConsoleDisplayMode},
{250, "GetConsoleFontInfo", GetConsoleFontInfo},
{251, "GetConsoleFontSize", GetConsoleFontSize},
{252, "GetConsoleHardwareState", GetConsoleHardwareState},
{253, "GetConsoleInputExeNameA", GetConsoleInputExeNameA},
{254, "GetConsoleInputExeNameW", GetConsoleInputExeNameW},
{255, "GetConsoleInputWaitHandle", GetConsoleInputWaitHandle},
{256, "GetConsoleKeyboardLayoutNameA", GetConsoleKeyboardLayoutNameA},
{257, "GetConsoleKeyboardLayoutNameW", GetConsoleKeyboardLayoutNameW},
{258, "GetConsoleMode", GetConsoleMode},
{259, "GetConsoleNlsMode", GetConsoleNlsMode},
{260, "GetConsoleOutputCP", GetConsoleOutputCP},
{261, "GetConsoleScreenBufferInfo", GetConsoleScreenBufferInfo},
{262, "GetConsoleTitleA", GetConsoleTitleA},
{263, "GetConsoleTitleW", GetConsoleTitleW},
{264, "GetConsoleWindow", GetConsoleWindow},
{265, "GetCurrencyFormatA", GetCurrencyFormatA},
{266, "GetCurrencyFormatW", GetCurrencyFormatW},
{267, "GetCurrentConsoleFont", GetCurrentConsoleFont},
{268, "GetCurrentDirectoryA", GetCurrentDirectoryA},
{269, "GetCurrentDirectoryW", GetCurrentDirectoryW},
{270, "GetCurrentProcess", GetCurrentProcess},
{271, "GetCurrentProcessId", GetCurrentProcessId},
{272, "GetCurrentThread", GetCurrentThread},
{273, "GetCurrentThreadId", GetCurrentThreadId},
{274, "GetDateFormatA", GetDateFormatA},
{275, "GetDateFormatW", GetDateFormatW},
{276, "GetDefaultCommConfigA", GetDefaultCommConfigA},
{277, "GetDefaultCommConfigW", GetDefaultCommConfigW},
{278, "GetDefaultSortkeySize", GetDefaultSortkeySize},
{279, "GetDevicePowerState", GetDevicePowerState},
{280, "GetDiskFreeSpaceA", GetDiskFreeSpaceA},
{281, "GetDiskFreeSpaceExA", GetDiskFreeSpaceExA},
{282, "GetDiskFreeSpaceExW", GetDiskFreeSpaceExW},
{283, "GetDiskFreeSpaceW", GetDiskFreeSpaceW},
{284, "GetDriveTypeA", GetDriveTypeA},
{285, "GetDriveTypeW", GetDriveTypeW},
{286, "GetEnvironmentStrings", GetEnvironmentStringsA},
{287, "GetEnvironmentStringsA", GetEnvironmentStringsA},
{288, "GetEnvironmentStringsW", GetEnvironmentStringsW},
{289, "GetEnvironmentVariableA", GetEnvironmentVariableA},
{290, "GetEnvironmentVariableW", GetEnvironmentVariableW},
{291, "GetExitCodeProcess", GetExitCodeProcess},
{292, "GetExitCodeThread", GetExitCodeThread},
{293, "GetFileAttributesA", GetFileAttributesA},
{294, "GetFileAttributesExA", GetFileAttributesExA},
{295, "GetFileAttributesExW", GetFileAttributesExW},
{296, "GetFileAttributesW", GetFileAttributesW},
{297, "GetFileInformationByHandle", GetFileInformationByHandle},
{298, "GetFileSize", GetFileSize},
{299, "GetFileSizeEx", GetFileSizeEx},
{300, "GetFileTime", GetFileTime},
{301, "GetFileType", GetFileType},
{302, "GetFullPathNameA", GetFullPathNameA},
{303, "GetFullPathNameW", GetFullPathNameW},
{304, "GetHandleInformation", GetHandleInformation},
{305, "GetLargestConsoleWindowSize", GetLargestConsoleWindowSize},
{306, "GetLastError", GetLastError},
{307, "GetLinguistLangSize", GetLinguistLangSize},
{308, "GetLocalTime", GetLocalTime},
{309, "GetLocaleInfoA", GetLocaleInfoA},
{310, "GetLocaleInfoW", GetLocaleInfoW},
{311, "GetLogicalDriveStringsA", GetLogicalDriveStringsA},
{312, "GetLogicalDriveStringsW", GetLogicalDriveStringsW},
{313, "GetLogicalDrives", GetLogicalDrives},
{314, "GetLongPathNameA", GetLongPathNameA},
{315, "GetLongPathNameW", GetLongPathNameW},
{316, "GetMailslotInfo", GetMailslotInfo},
{317, "GetModuleFileNameA", GetModuleFileNameA},
{318, "GetModuleFileNameW", GetModuleFileNameW},
{319, "GetModuleHandleA", GetModuleHandleA},
{320, "GetModuleHandleW", GetModuleHandleW},
{321, "GetNamedPipeHandleStateA", GetNamedPipeHandleStateA},
{322, "GetNamedPipeHandleStateW", GetNamedPipeHandleStateW},
{323, "GetNamedPipeInfo", GetNamedPipeInfo},
{324, "GetNextVDMCommand", GetNextVDMCommand},
{325, "GetNlsSectionName", GetNlsSectionName},
{326, "GetNumberFormatA", GetNumberFormatA},
{327, "GetNumberFormatW", GetNumberFormatW},
{328, "GetNumberOfConsoleFonts", GetNumberOfConsoleFonts},
{329, "GetNumberOfConsoleInputEvents", GetNumberOfConsoleInputEvents},
{330, "GetNumberOfConsoleMouseButtons", GetNumberOfConsoleMouseButtons},
{331, "GetOEMCP", GetOEMCP},
{332, "GetOverlappedResult", GetOverlappedResult},
{333, "GetPriorityClass", GetPriorityClass},
{334, "GetPrivateProfileIntA", GetPrivateProfileIntA},
{335, "GetPrivateProfileIntW", GetPrivateProfileIntW},
{336, "GetPrivateProfileSectionA", GetPrivateProfileSectionA},
{337, "GetPrivateProfileSectionNamesA", GetPrivateProfileSectionNamesA},
{338, "GetPrivateProfileSectionNamesW", GetPrivateProfileSectionNamesW},
{339, "GetPrivateProfileSectionW", GetPrivateProfileSectionW},
{340, "GetPrivateProfileStringA", GetPrivateProfileStringA},
{341, "GetPrivateProfileStringW", GetPrivateProfileStringW},
{342, "GetPrivateProfileStructA", GetPrivateProfileStructA},
{343, "GetPrivateProfileStructW", GetPrivateProfileStructW},
{344, "GetProcAddress", GetProcAddress},
{345, "GetProcessAffinityMask", GetProcessAffinityMask},
{346, "GetProcessHeap", GetProcessHeap},
{347, "GetProcessHeaps", GetProcessHeaps},
{348, "GetProcessIoCounters", GetProcessIoCounters},
{349, "GetProcessPriorityBoost", GetProcessPriorityBoost},
{350, "GetProcessShutdownParameters", GetProcessShutdownParameters},
{351, "GetProcessTimes", GetProcessTimes},
{352, "GetProcessVersion", GetProcessVersion},
{353, "GetProcessWorkingSetSize", GetProcessWorkingSetSize},
{354, "GetProfileIntA", GetProfileIntA},
{355, "GetProfileIntW", GetProfileIntW},
{356, "GetProfileSectionA", GetProfileSectionA},
{357, "GetProfileSectionW", GetProfileSectionW},
{358, "GetProfileStringA", GetProfileStringA},
{359, "GetProfileStringW", GetProfileStringW},
{360, "GetQueuedCompletionStatus", GetQueuedCompletionStatus},
{361, "GetShortPathNameA", GetShortPathNameA},
{362, "GetShortPathNameW", GetShortPathNameW},
{363, "GetStartupInfoA", GetStartupInfoA},
{364, "GetStartupInfoW", GetStartupInfoW},
{365, "GetStdHandle", GetStdHandle},
{366, "GetStringTypeA", GetStringTypeA},
{367, "GetStringTypeExA", GetStringTypeExA},
{368, "GetStringTypeExW", GetStringTypeExW},
{369, "GetStringTypeW", GetStringTypeW},
{370, "GetSystemDefaultLCID", GetSystemDefaultLCID},
{371, "GetSystemDefaultLangID", GetSystemDefaultLangID},
{372, "GetSystemDefaultUILanguage", GetSystemDefaultUILanguage},
{373, "GetSystemDirectoryA", GetSystemDirectoryA},
{374, "GetSystemDirectoryW", GetSystemDirectoryW},
{375, "GetSystemInfo", GetSystemInfo},
{376, "GetSystemPowerStatus", GetSystemPowerStatus},
{377, "GetSystemTime", GetSystemTime},
{378, "GetSystemTimeAdjustment", GetSystemTimeAdjustment},
{379, "GetSystemTimeAsFileTime", GetSystemTimeAsFileTime},
{380, "GetSystemWindowsDirectoryA", GetSystemWindowsDirectoryA},
{381, "GetSystemWindowsDirectoryW", GetSystemWindowsDirectoryW},
{382, "GetTapeParameters", GetTapeParameters},
{383, "GetTapePosition", GetTapePosition},
{384, "GetTapeStatus", GetTapeStatus},
{385, "GetTempFileNameA", GetTempFileNameA},
{386, "GetTempFileNameW", GetTempFileNameW},
{387, "GetTempPathA", GetTempPathA},
{388, "GetTempPathW", GetTempPathW},
{389, "GetThreadContext", GetThreadContext},
{390, "GetThreadLocale", GetThreadLocale},
{391, "GetThreadPriority", GetThreadPriority},
{392, "GetThreadPriorityBoost", GetThreadPriorityBoost},
{393, "GetThreadSelectorEntry", GetThreadSelectorEntry},
{394, "GetThreadTimes", GetThreadTimes},
{395, "GetTickCount", GetTickCount},
{396, "GetTimeFormatA", GetTimeFormatA},
{397, "GetTimeFormatW", GetTimeFormatW},
{398, "GetTimeZoneInformation", GetTimeZoneInformation},
{399, "GetUserDefaultLCID", GetUserDefaultLCID},
{400, "GetUserDefaultLangID", GetUserDefaultLangID},
{401, "GetUserDefaultUILanguage", GetUserDefaultUILanguage},
{402, "GetVDMCurrentDirectories", GetVDMCurrentDirectories},
{403, "GetVersion", GetVersion},
{404, "GetVersionExA", GetVersionExA},
{405, "GetVersionExW", GetVersionExW},
{406, "GetVolumeInformationA", GetVolumeInformationA},
{407, "GetVolumeInformationW", GetVolumeInformationW},
{408, "GetVolumeNameForVolumeMountPointA", GetVolumeNameForVolumeMountPointA},
{409, "GetVolumeNameForVolumeMountPointW", GetVolumeNameForVolumeMountPointW},
{410, "GetVolumePathNameA", GetVolumePathNameA},
{411, "GetVolumePathNameW", GetVolumePathNameW},
{412, "GetWindowsDirectoryA", GetWindowsDirectoryA},
{413, "GetWindowsDirectoryW", GetWindowsDirectoryW},
{414, "GetWriteWatch", GetWriteWatch},
{415, "GlobalAddAtomA", GlobalAddAtomA},
{416, "GlobalAddAtomW", GlobalAddAtomW},
{417, "GlobalAlloc", GlobalAlloc},
{418, "GlobalCompact", GlobalCompact},
{419, "GlobalDeleteAtom", GlobalDeleteAtom},
{420, "GlobalFindAtomA", GlobalFindAtomA},
{421, "GlobalFindAtomW", GlobalFindAtomW},
{422, "GlobalFix", GlobalFix},
{423, "GlobalFlags", GlobalFlags},
{424, "GlobalFree", GlobalFree},
{425, "GlobalGetAtomNameA", GlobalGetAtomNameA},
{426, "GlobalGetAtomNameW", GlobalGetAtomNameW},
{427, "GlobalHandle", GlobalHandle},
{428, "GlobalLock", GlobalLock},
{429, "GlobalMemoryStatus", GlobalMemoryStatus},
{430, "GlobalMemoryStatusEx", GlobalMemoryStatusEx},
{431, "GlobalReAlloc", GlobalReAlloc},
{432, "GlobalSize", GlobalSize},
{433, "GlobalUnWire", GlobalUnWire},
{434, "GlobalUnfix", GlobalUnfix},
{435, "GlobalUnlock", GlobalUnlock},
{436, "GlobalWire", GlobalWire},
{437, "Heap32First", Heap32First},
{438, "Heap32ListFirst", Heap32ListFirst},
{439, "Heap32ListNext", Heap32ListNext},
{440, "Heap32Next", Heap32Next},
{441, "HeapAlloc", HeapAlloc},
{442, "HeapCompact", HeapCompact},
{443, "HeapCreate", HeapCreate},
{444, "HeapCreateTagsW", HeapCreateTagsW},
{445, "HeapDestroy", HeapDestroy},
{446, "HeapExtend", HeapExtend},
{447, "HeapFree", HeapFree},
{448, "HeapLock", HeapLock},
{449, "HeapQueryInformation", HeapQueryInformation},
{450, "HeapQueryTagW", HeapQueryTagW},
{451, "HeapReAlloc", HeapReAlloc},
{452, "HeapSetInformation", HeapSetInformation},
{453, "HeapSize", HeapSize},
{454, "HeapSummary", HeapSummary},
{455, "HeapUnlock", HeapUnlock},
{456, "HeapUsage", HeapUsage},
{457, "HeapValidate", HeapValidate},
{458, "HeapWalk", HeapWalk},
{459, "InitAtomTable", InitAtomTable},
{460, "InitializeCriticalSection", InitializeCriticalSection},
{461, "InitializeCriticalSectionAndSpinCount", InitializeCriticalSectionAndSpinCount},
{462, "InterlockedCompareExchange", InterlockedCompareExchange},
{463, "InterlockedDecrement", InterlockedDecrement},
{464, "InterlockedExchange", InterlockedExchange},
{465, "InterlockedExchangeAdd", InterlockedExchangeAdd},
{466, "InterlockedIncrement", InterlockedIncrement},
{467, "InvalidateConsoleDIBits", InvalidateConsoleDIBits},
{468, "IsBadCodePtr", IsBadCodePtr},
{469, "IsBadHugeReadPtr", IsBadHugeReadPtr},
{470, "IsBadHugeWritePtr", IsBadHugeWritePtr},
{471, "IsBadReadPtr", IsBadReadPtr},
{472, "IsBadStringPtrA", IsBadStringPtrA},
{473, "IsBadStringPtrW", IsBadStringPtrW},
{474, "IsBadWritePtr", IsBadWritePtr},
{475, "IsDBCSLeadByte", IsDBCSLeadByte},
{476, "IsDBCSLeadByteEx", IsDBCSLeadByteEx},
{477, "IsDebuggerPresent", IsDebuggerPresent},
{478, "IsProcessorFeaturePresent", IsProcessorFeaturePresent},
{479, "IsSystemResumeAutomatic", IsSystemResumeAutomatic},
{480, "IsValidCodePage", IsValidCodePage},
{481, "IsValidLanguageGroup", IsValidLanguageGroup},
{482, "IsValidLocale", IsValidLocale},
{483, "LCMapStringA", LCMapStringA},
{484, "LCMapStringW", LCMapStringW},
{485, "LeaveCriticalSection", LeaveCriticalSection},
{486, "LoadLibraryA", LoadLibraryA},
{487, "LoadLibraryExA", LoadLibraryExA},
{488, "LoadLibraryExW", LoadLibraryExW},
{489, "LoadLibraryW", LoadLibraryW},
{490, "LoadModule", LoadModule},
{491, "LoadResource", LoadResource},
{492, "LocalAlloc", LocalAlloc},
{493, "LocalCompact", LocalCompact},
{494, "LocalFileTimeToFileTime", LocalFileTimeToFileTime},
{495, "LocalFlags", LocalFlags},
{496, "LocalFree", LocalFree},
{497, "LocalHandle", LocalHandle},
{498, "LocalLock", LocalLock},
{499, "LocalReAlloc", LocalReAlloc},
{500, "LocalShrink", LocalShrink},
{501, "LocalSize", LocalSize},
{502, "LocalUnlock", LocalUnlock},
{503, "LockFile", LockFile},
{504, "LockFileEx", LockFileEx},
{505, "LockResource", LockResource},
{506, "MapUserPhysicalPages", MapUserPhysicalPages},
{507, "MapUserPhysicalPagesScatter", MapUserPhysicalPagesScatter},
{508, "MapViewOfFile", MapViewOfFile},
{509, "MapViewOfFileEx", MapViewOfFileEx},
{510, "Module32First", Module32First},
{511, "Module32FirstW", Module32FirstW},
{512, "Module32Next", Module32Next},
{513, "Module32NextW", Module32NextW},
{514, "MoveFileA", MoveFileA},
{515, "MoveFileExA", MoveFileExA},
{516, "MoveFileExW", MoveFileExW},
{517, "MoveFileW", MoveFileW},
{518, "MoveFileWithProgressA", MoveFileWithProgressA},
{519, "MoveFileWithProgressW", MoveFileWithProgressW},
{520, "MulDiv", MulDiv},
{521, "MultiByteToWideChar", MultiByteToWideChar},
{522, "NlsConvertIntegerToString", NlsConvertIntegerToString},
{523, "NlsGetCacheUpdateCount", NlsGetCacheUpdateCount},
{524, "NlsResetProcessLocale", NlsResetProcessLocale},
{525, "OpenConsoleW", OpenConsoleW},
{526, "OpenDataFile", OpenDataFile},
{527, "OpenEventA", OpenEventA},
{528, "OpenEventW", OpenEventW},
{529, "OpenFile", OpenFile},
{530, "OpenFileMappingA", OpenFileMappingA},
{531, "OpenFileMappingW", OpenFileMappingW},
{532, "OpenJobObjectA", OpenJobObjectA},
{533, "OpenJobObjectW", OpenJobObjectW},
{534, "OpenMutexA", OpenMutexA},
{535, "OpenMutexW", OpenMutexW},
{536, "OpenProcess", OpenProcess},
{537, "OpenProfileUserMapping", OpenProfileUserMapping},
{538, "OpenSemaphoreA", OpenSemaphoreA},
{539, "OpenSemaphoreW", OpenSemaphoreW},
{540, "OpenThread", OpenThread},
{541, "OpenWaitableTimerA", OpenWaitableTimerA},
{542, "OpenWaitableTimerW", OpenWaitableTimerW},
{543, "OutputDebugStringA", OutputDebugStringA},
{544, "OutputDebugStringW", OutputDebugStringW},
{545, "PeekConsoleInputA", PeekConsoleInputA},
{546, "PeekConsoleInputW", PeekConsoleInputW},
{547, "PeekNamedPipe", PeekNamedPipe},
{548, "PostQueuedCompletionStatus", PostQueuedCompletionStatus},
{549, "PrepareTape", PrepareTape},
{550, "PrivCopyFileExW", PrivCopyFileExW},
{551, "PrivMoveFileIdentityW", PrivMoveFileIdentityW},
{552, "Process32First", Process32First},
{553, "Process32FirstW", Process32FirstW},
{554, "Process32Next", Process32Next},
{555, "Process32NextW", Process32NextW},
{556, "ProcessIdToSessionId", ProcessIdToSessionId},
{557, "PulseEvent", PulseEvent},
{558, "PurgeComm", PurgeComm},
{559, "QueryDosDeviceA", QueryDosDeviceA},
{560, "QueryDosDeviceW", QueryDosDeviceW},
{561, "QueryInformationJobObject", QueryInformationJobObject},
{562, "QueryPerformanceCounter", QueryPerformanceCounter},
{563, "QueryPerformanceFrequency", QueryPerformanceFrequency},
{564, "QueryWin31IniFilesMappedToRegistry", QueryWin31IniFilesMappedToRegistry},
{565, "QueueUserAPC", QueueUserAPC},
{566, "QueueUserWorkItem", QueueUserWorkItem},
{567, "RaiseException", RaiseException},
{568, "ReadConsoleA", ReadConsoleA},
{569, "ReadConsoleInputA", ReadConsoleInputA},
{570, "ReadConsoleInputExA", ReadConsoleInputExA},
{571, "ReadConsoleInputExW", ReadConsoleInputExW},
{572, "ReadConsoleInputW", ReadConsoleInputW},
{573, "ReadConsoleOutputA", ReadConsoleOutputA},
{574, "ReadConsoleOutputAttribute", ReadConsoleOutputAttribute},
{575, "ReadConsoleOutputCharacterA", ReadConsoleOutputCharacterA},
{576, "ReadConsoleOutputCharacterW", ReadConsoleOutputCharacterW},
{577, "ReadConsoleOutputW", ReadConsoleOutputW},
{578, "ReadConsoleW", ReadConsoleW},
{579, "ReadDirectoryChangesW", ReadDirectoryChangesW},
{580, "ReadFile", ReadFile},
{581, "ReadFileEx", ReadFileEx},
{582, "ReadFileScatter", ReadFileScatter},
{583, "ReadProcessMemory", ReadProcessMemory},
{584, "RegisterConsoleIME", RegisterConsoleIME},
{585, "RegisterConsoleOS2", RegisterConsoleOS2},
{586, "RegisterConsoleVDM", RegisterConsoleVDM},
{587, "RegisterWaitForInputIdle", RegisterWaitForInputIdle},
{588, "RegisterWaitForSingleObject", RegisterWaitForSingleObject},
{589, "RegisterWaitForSingleObjectEx", RegisterWaitForSingleObjectEx},
{590, "RegisterWowBaseHandlers", RegisterWowBaseHandlers},
{591, "RegisterWowExec", RegisterWowExec},
{592, "ReleaseMutex", ReleaseMutex},
{593, "ReleaseSemaphore", ReleaseSemaphore},
{594, "RemoveDirectoryA", RemoveDirectoryA},
{595, "RemoveDirectoryW", RemoveDirectoryW},
{596, "ReplaceFile", ReplaceFileA},
{597, "ReplaceFileA", ReplaceFileA},
{598, "ReplaceFileW", ReplaceFileW},
{599, "RequestDeviceWakeup", RequestDeviceWakeup},
{600, "RequestWakeupLatency", RequestWakeupLatency},
{601, "ResetEvent", ResetEvent},
{602, "ResetWriteWatch", ResetWriteWatch},
{603, "ResumeThread", ResumeThread},
{604, "RtlFillMemory", RtlFillMemory},
{605, "RtlMoveMemory", RtlMoveMemory},
{606, "RtlUnwind", RtlUnwind},
{607, "RtlZeroMemory", RtlZeroMemory},
{608, "ScrollConsoleScreenBufferA", ScrollConsoleScreenBufferA},
{609, "ScrollConsoleScreenBufferW", ScrollConsoleScreenBufferW},
{610, "SearchPathA", SearchPathA},
{611, "SearchPathW", SearchPathW},
{612, "SetCPGlobal", SetCPGlobal},
{613, "SetCalendarInfoA", SetCalendarInfoA},
{614, "SetCalendarInfoW", SetCalendarInfoW},
{615, "SetCommBreak", SetCommBreak},
{616, "SetCommConfig", SetCommConfig},
{617, "SetCommMask", SetCommMask},
{618, "SetCommState", SetCommState},
{619, "SetCommTimeouts", SetCommTimeouts},
{620, "SetComputerNameA", SetComputerNameA},
{621, "SetComputerNameExA", SetComputerNameExA},
{622, "SetComputerNameExW", SetComputerNameExW},
{623, "SetComputerNameW", SetComputerNameW},
{624, "SetConsoleActiveScreenBuffer", SetConsoleActiveScreenBuffer},
{625, "SetConsoleCP", SetConsoleCP},
{626, "SetConsoleCommandHistoryMode", SetConsoleCommandHistoryMode},
{627, "SetConsoleCtrlHandler", SetConsoleCtrlHandler},
{628, "SetConsoleCursor", SetConsoleCursor},
{629, "SetConsoleCursorInfo", SetConsoleCursorInfo},
{630, "SetConsoleCursorMode", SetConsoleCursorMode},
{631, "SetConsoleCursorPosition", SetConsoleCursorPosition},
{632, "SetConsoleDisplayMode", SetConsoleDisplayMode},
{633, "SetConsoleFont", SetConsoleFont},
{634, "SetConsoleHardwareState", SetConsoleHardwareState},
{635, "SetConsoleIcon", SetConsoleIcon},
{636, "SetConsoleInputExeNameA", SetConsoleInputExeNameA},
{637, "SetConsoleInputExeNameW", SetConsoleInputExeNameW},
{638, "SetConsoleKeyShortcuts", SetConsoleKeyShortcuts},
{639, "SetConsoleLocalEUDC", SetConsoleLocalEUDC},
{640, "SetConsoleMaximumWindowSize", SetConsoleMaximumWindowSize},
{641, "SetConsoleMenuClose", SetConsoleMenuClose},
{642, "SetConsoleMode", SetConsoleMode},
{643, "SetConsoleNlsMode", SetConsoleNlsMode},
{644, "SetConsoleNumberOfCommandsA", SetConsoleNumberOfCommandsA},
{645, "SetConsoleNumberOfCommandsW", SetConsoleNumberOfCommandsW},
{646, "SetConsoleOS2OemFormat", SetConsoleOS2OemFormat},
{647, "SetConsoleOutputCP", SetConsoleOutputCP},
{648, "SetConsolePalette", SetConsolePalette},
{649, "SetConsoleScreenBufferSize", SetConsoleScreenBufferSize},
{650, "SetConsoleTextAttribute", SetConsoleTextAttribute},
{651, "SetConsoleTitleA", SetConsoleTitleA},
{652, "SetConsoleTitleW", SetConsoleTitleW},
{653, "SetConsoleWindowInfo", SetConsoleWindowInfo},
{654, "SetCriticalSectionSpinCount", SetCriticalSectionSpinCount},
{655, "SetCurrentDirectoryA", SetCurrentDirectoryA},
{656, "SetCurrentDirectoryW", SetCurrentDirectoryW},
{657, "SetDefaultCommConfigA", SetDefaultCommConfigA},
{658, "SetDefaultCommConfigW", SetDefaultCommConfigW},
{659, "SetEndOfFile", SetEndOfFile},
{660, "SetEnvironmentVariableA", SetEnvironmentVariableA},
{661, "SetEnvironmentVariableW", SetEnvironmentVariableW},
{662, "SetErrorMode", SetErrorMode},
{663, "SetEvent", SetEvent},
{664, "SetFileApisToANSI", SetFileApisToANSI},
{665, "SetFileApisToOEM", SetFileApisToOEM},
{666, "SetFileAttributesA", SetFileAttributesA},
{667, "SetFileAttributesW", SetFileAttributesW},
{668, "SetFilePointer", SetFilePointer},
{669, "SetFilePointerEx", SetFilePointerEx},
{670, "SetFileTime", SetFileTime},
{671, "SetHandleCount", SetHandleCount},
{672, "SetHandleInformation", SetHandleInformation},
{673, "SetInformationJobObject", SetInformationJobObject},
{674, "SetLastConsoleEventActive", SetLastConsoleEventActive},
{675, "SetLastError", SetLastError},
{676, "SetLocalTime", SetLocalTime},
{677, "SetLocaleInfoA", SetLocaleInfoA},
{678, "SetLocaleInfoW", SetLocaleInfoW},
{679, "SetMailslotInfo", SetMailslotInfo},
{680, "SetMessageWaitingIndicator", SetMessageWaitingIndicator},
{681, "SetNamedPipeHandleState", SetNamedPipeHandleState},
{682, "SetPriorityClass", SetPriorityClass},
{683, "SetProcessAffinityMask", SetProcessAffinityMask},
{684, "SetProcessPriorityBoost", SetProcessPriorityBoost},
{685, "SetProcessShutdownParameters", SetProcessShutdownParameters},
{686, "SetProcessWorkingSetSize", SetProcessWorkingSetSize},
{687, "SetStdHandle", SetStdHandle},
{688, "SetSystemPowerState", SetSystemPowerState},
{689, "SetSystemTime", SetSystemTime},
{690, "SetSystemTimeAdjustment", SetSystemTimeAdjustment},
{691, "SetTapeParameters", SetTapeParameters},
{692, "SetTapePosition", SetTapePosition},
{693, "SetTermsrvAppInstallMode", SetTermsrvAppInstallMode},
{694, "SetThreadAffinityMask", SetThreadAffinityMask},
{695, "SetThreadContext", SetThreadContext},
{696, "SetThreadExecutionState", SetThreadExecutionState},
{697, "SetThreadIdealProcessor", SetThreadIdealProcessor},
{698, "SetThreadLocale", SetThreadLocale},
{699, "SetThreadPriority", SetThreadPriority},
{700, "SetThreadPriorityBoost", SetThreadPriorityBoost},
{701, "SetTimeZoneInformation", SetTimeZoneInformation},
{702, "SetTimerQueueTimer", SetTimerQueueTimer},
{703, "SetUnhandledExceptionFilter", SetUnhandledExceptionFilter},
{704, "SetVDMCurrentDirectories", SetVDMCurrentDirectories},
{705, "SetVolumeLabelA", SetVolumeLabelA},
{706, "SetVolumeLabelW", SetVolumeLabelW},
{707, "SetVolumeMountPointA", SetVolumeMountPointA},
{708, "SetVolumeMountPointW", SetVolumeMountPointW},
{709, "SetWaitableTimer", SetWaitableTimer},
{710, "SetupComm", SetupComm},
{711, "ShowConsoleCursor", ShowConsoleCursor},
{712, "SignalObjectAndWait", SignalObjectAndWait},
{713, "SizeofResource", SizeofResource},
{714, "Sleep", Sleep},
{715, "SleepEx", SleepEx},
{716, "SuspendThread", SuspendThread},
{717, "SwitchToFiber", SwitchToFiber},
{718, "SwitchToThread", SwitchToThread},
{719, "SystemTimeToFileTime", SystemTimeToFileTime},
{720, "SystemTimeToTzSpecificLocalTime", SystemTimeToTzSpecificLocalTime},
{721, "TerminateJobObject", TerminateJobObject},
{722, "TerminateProcess", TerminateProcess},
{723, "TerminateThread", TerminateThread},
{724, "TermsrvAppInstallMode", TermsrvAppInstallMode},
{725, "Thread32First", Thread32First},
{726, "Thread32Next", Thread32Next},
{727, "TlsAlloc", TlsAlloc},
{728, "TlsFree", TlsFree},
{729, "TlsGetValue", TlsGetValue},
{730, "TlsSetValue", TlsSetValue},
{731, "Toolhelp32ReadProcessMemory", Toolhelp32ReadProcessMemory},
{732, "TransactNamedPipe", TransactNamedPipe},
{733, "TransmitCommChar", TransmitCommChar},
{734, "TrimVirtualBuffer", TrimVirtualBuffer},
{735, "TryEnterCriticalSection", TryEnterCriticalSection},
{736, "UTRegister", UTRegister},
{737, "UTUnRegister", UTUnRegister},
{738, "UnhandledExceptionFilter", UnhandledExceptionFilter},
{739, "UnlockFile", UnlockFile},
{740, "UnlockFileEx", UnlockFileEx},
{741, "UnmapViewOfFile", UnmapViewOfFile},
{742, "UnregisterConsoleIME", UnregisterConsoleIME},
{743, "UnregisterWait", UnregisterWait},
{744, "UnregisterWaitEx", UnregisterWaitEx},
{745, "UpdateResourceA", UpdateResourceA},
{746, "UpdateResourceW", UpdateResourceW},
{747, "VDMConsoleOperation", VDMConsoleOperation},
{748, "VDMOperationStarted", VDMOperationStarted},
{749, "ValidateLCType", ValidateLCType},
{750, "ValidateLocale", ValidateLocale},
{751, "VerLanguageNameA", VerLanguageNameA},
{752, "VerLanguageNameW", VerLanguageNameW},
{753, "VerSetConditionMask", VerSetConditionMask},
{754, "VerifyConsoleIoHandle", VerifyConsoleIoHandle},
{755, "VerifyVersionInfoA", VerifyVersionInfoA},
{756, "VerifyVersionInfoW", VerifyVersionInfoW},
{757, "VirtualAlloc", VirtualAlloc},
{758, "VirtualAllocEx", VirtualAllocEx},
{759, "VirtualBufferExceptionHandler", VirtualBufferExceptionHandler},
{760, "VirtualFree", VirtualFree},
{761, "VirtualFreeEx", VirtualFreeEx},
{762, "VirtualLock", VirtualLock},
{763, "VirtualProtect", VirtualProtect},
{764, "VirtualProtectEx", VirtualProtectEx},
{765, "VirtualQuery", VirtualQuery},
{766, "VirtualQueryEx", VirtualQueryEx},
{767, "VirtualUnlock", VirtualUnlock},
{768, "WaitCommEvent", WaitCommEvent},
{769, "WaitForDebugEvent", WaitForDebugEvent},
{770, "WaitForMultipleObjects", WaitForMultipleObjects},
{771, "WaitForMultipleObjectsEx", WaitForMultipleObjectsEx},
{772, "WaitForSingleObject", WaitForSingleObject},
{773, "WaitForSingleObjectEx", WaitForSingleObjectEx},
{774, "WaitNamedPipeA", WaitNamedPipeA},
{775, "WaitNamedPipeW", WaitNamedPipeW},
{776, "WideCharToMultiByte", WideCharToMultiByte},
{777, "WinExec", WinExec},
{778, "WriteConsoleA", WriteConsoleA},
{779, "WriteConsoleInputA", WriteConsoleInputA},
{780, "WriteConsoleInputVDMA", WriteConsoleInputVDMA},
{781, "WriteConsoleInputVDMW", WriteConsoleInputVDMW},
{782, "WriteConsoleInputW", WriteConsoleInputW},
{783, "WriteConsoleOutputA", WriteConsoleOutputA},
{784, "WriteConsoleOutputAttribute", WriteConsoleOutputAttribute},
{785, "WriteConsoleOutputCharacterA", WriteConsoleOutputCharacterA},
{786, "WriteConsoleOutputCharacterW", WriteConsoleOutputCharacterW},
{787, "WriteConsoleOutputW", WriteConsoleOutputW},
{788, "WriteConsoleW", WriteConsoleW},
{789, "WriteFile", WriteFile},
{790, "WriteFileEx", WriteFileEx},
{791, "WriteFileGather", WriteFileGather},
{792, "WritePrivateProfileSectionA", WritePrivateProfileSectionA},
{793, "WritePrivateProfileSectionW", WritePrivateProfileSectionW},
{794, "WritePrivateProfileStringA", WritePrivateProfileStringA},
{795, "WritePrivateProfileStringW", WritePrivateProfileStringW},
{796, "WritePrivateProfileStructA", WritePrivateProfileStructA},
{797, "WritePrivateProfileStructW", WritePrivateProfileStructW},
{798, "WriteProcessMemory", WriteProcessMemory},
{799, "WriteProfileSectionA", WriteProfileSectionA},
{800, "WriteProfileSectionW", WriteProfileSectionW},
{801, "WriteProfileStringA", WriteProfileStringA},
{802, "WriteProfileStringW", WriteProfileStringW},
{803, "WriteTapemark", WriteTapemark},
{804, "_hread", _hread},
{805, "_hwrite", _hwrite},
{806, "_lclose", _lclose},
{807, "_lcreat", _lcreat},
{808, "_llseek", _llseek},
{809, "_lopen", _lopen},
{810, "_lread", _lread},
{811, "_lwrite", _lwrite},
{812, "lstrcat", lstrcatA},
{813, "lstrcatA", lstrcatA},
{814, "lstrcatW", lstrcatW},
{815, "lstrcmp", lstrcmpA},
{816, "lstrcmpA", lstrcmpA},
{817, "lstrcmpW", lstrcmpW},
{818, "lstrcmpi", lstrcmpiA},
{819, "lstrcmpiA", lstrcmpiA},
{820, "lstrcmpiW", lstrcmpiW},
{821, "lstrcpy", lstrcpyA},
{822, "lstrcpyA", lstrcpyA},
{823, "lstrcpyW", lstrcpyW},
{824, "lstrcpyn", lstrcpynA},
{825, "lstrcpynA", lstrcpynA},
{826, "lstrcpynW", lstrcpynW},
{827, "lstrlen", lstrlenA},
{828, "lstrlenA", lstrlenA},
{829, "lstrlenW", lstrlenW},
{0, NULL, NULL}};
