/*
    w32loader
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "msvcrt.h"


#define EXCEPTION_MAXIMUM_PARAMETERS 15
#define MAXIMUM_SUPPORTED_EXTENSION 512
#define SIZE_OF_80387_REGISTERS 80
typedef struct _CONTEXT86 CONTEXT86, *PCONTEXT86, *LPCONTEXT86, CONTEXT, *PCONTEXT, *LPCONTEXT;
typedef struct _EXCEPTION_FRAME EXCEPTION_FRAME;
typedef struct _EXCEPTION_POINTERS EXCEPTION_POINTERS, *PEXCEPTION_POINTERS;
typedef struct _EXCEPTION_RECORD EXCEPTION_RECORD, *PEXCEPTION_RECORD, *LPEXCEPTION_RECORD;
typedef struct _EXCEPTION_REGISTRATION_RECORD EXCEPTION_REGISTRATION_RECORD;
typedef struct _FLOATING_SAVE_AREA FLOATING_SAVE_AREA, *PFLOATING_SAVE_AREA, *LPFLOATING_SAVE_AREA;
typedef struct _SCOPETABLE SCOPETABLE, *PSCOPETABLE, *LPSCOPETABLE;
typedef struct _MSVCRT_EXCEPTION_FRAME MSVCRT_EXCEPTION_FRAME;
typedef DWORD (*PEXCEPTION_HANDLER)(PEXCEPTION_RECORD, struct _EXCEPTION_REGISTRATION_RECORD*, PCONTEXT, struct _EXCEPTION_REGISTRATION_RECORD **);
#include "pshpack1.h"
struct _FLOATING_SAVE_AREA
{
  DWORD ControlWord;
  DWORD StatusWord;
  DWORD TagWord;
  DWORD ErrorOffset;
  DWORD ErrorSelector;
  DWORD DataOffset;
  DWORD DataSelector;
  BYTE RegisterArea[SIZE_OF_80387_REGISTERS];
  DWORD Cr0NpxState;
};
struct _CONTEXT86
{
  DWORD ContextFlags;
  DWORD Dr0;
  DWORD Dr1;
  DWORD Dr2;
  DWORD Dr3;
  DWORD Dr6;
  DWORD Dr7;
  FLOATING_SAVE_AREA FloatSave;
  DWORD SegGs;
  DWORD SegFs;
  DWORD SegEs;
  DWORD SegDs;
  DWORD Edi;
  DWORD Esi;
  DWORD Ebx;
  DWORD Edx;
  DWORD Ecx;
  DWORD Eax;
  DWORD Ebp;
  DWORD Eip;
  DWORD SegCs;
  DWORD EFlags;
  DWORD Esp;
  DWORD SegSs;
  BYTE ExtendedRegisters[MAXIMUM_SUPPORTED_EXTENSION];
};
struct _EXCEPTION_POINTERS
{
  PEXCEPTION_RECORD ExceptionRecord;
  PCONTEXT ContextRecord;
};
struct _EXCEPTION_RECORD
{
  DWORD ExceptionCode;
  DWORD ExceptionFlags;
  struct _EXCEPTION_RECORD *ExceptionRecord;
  PVOID ExceptionAddress;
  DWORD NumberParameters;
  ULONG_PTR ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
};
struct _MSVCRT_EXCEPTION_FRAME
{
  EXCEPTION_REGISTRATION_RECORD *prev;
  void (*handler)(PEXCEPTION_RECORD, EXCEPTION_REGISTRATION_RECORD*, PCONTEXT, PEXCEPTION_RECORD);
  PSCOPETABLE scopetable;
  int trylevel;
  int _ebp;
  PEXCEPTION_POINTERS xpointers;
};
struct _SCOPETABLE
{
  int previousTryLevel;
  int (*lpfnFilter)(PEXCEPTION_POINTERS);
  int (*lpfnHandler)(void);
};
struct _EXCEPTION_REGISTRATION_RECORD
{
  struct _EXCEPTION_REGISTRATION_RECORD *Prev;
  PEXCEPTION_HANDLER Handler;
};
#include "poppack.h"


/* ??2@YAPAXI@Z ordinal = 15, argument = 0 */
static void CDECL *msvcrt_new (size_t size)
{
  return g_malloc (size);
}


/* ??3@YAXPAX@Z ordinal = 16, argument = 0 */
static void CDECL msvcrt_delete (void *memblock)
{
  g_free (memblock);
}


/* _CIacos ordinal = 52, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIacos (VOID)
{
  return 0;
}


/* _CIasin ordinal = 53, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIasin (VOID)
{
  return 0;
}


/* _CIatan ordinal = 54, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIatan (VOID)
{
  return 0;
}


/* _CIatan2 ordinal = 55, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIatan2 (VOID)
{
  return 0;
}


/* _CIcos ordinal = 56, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIcos (VOID)
{
  return 0;
}


/* _CIcosh ordinal = 57, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIcosh (VOID)
{
  return 0;
}


/* _CIexp ordinal = 58, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIexp (VOID)
{
  return 0;
}


/* _CIfmod ordinal = 59, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIfmod (VOID)
{
  return 0;
}


/* _CIlog ordinal = 60, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIlog (VOID)
{
  return 0;
}


/* _CIlog10 ordinal = 61, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIlog10 (VOID)
{
  return 0;
}


/* _CIpow ordinal = 62, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIpow (VOID)
{
  return 0;
}


/* _CIsin ordinal = 63, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIsin (VOID)
{
  return 0;
}


/* _CIsinh ordinal = 64, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIsinh (VOID)
{
  return 0;
}


/* _CIsqrt ordinal = 65, argument = 0 temporary */
static DWORD WINAPI msvcrt_CIsqrt (VOID)
{
  return 0;
}


/* _CItan ordinal = 66, argument = 0 temporary */
static DWORD WINAPI msvcrt_CItan (VOID)
{
  return 0;
}


/* _CItanh ordinal = 67, argument = 0 temporary */
static DWORD WINAPI msvcrt_CItanh (VOID)
{
  return 0;
}


/* _CxxThrowException ordinal = 68, argument = 8 temporary */
static DWORD WINAPI msvcrt_CxxThrowException (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* _EH_prolog ordinal = 69, argument = 0 */
static guint8 msvcrt_EH_prolog[] = {
  0x6a, 0xff, 0x50, 0x64, 0xa1, 0x00, 0x00, 0x00,
  0x00, 0x50, 0x64, 0x89, 0x25, 0x00, 0x00, 0x00,
  0x00, 0x8b, 0x44, 0x24, 0x0c, 0x89, 0x6c, 0x24,
  0x0c, 0x8d, 0x6c, 0x24, 0x0c, 0x50, 0xc3};


/* _Getdays ordinal = 70, argument = 0 temporary */
static DWORD WINAPI msvcrt_Getdays (VOID)
{
  return 0;
}


/* _Getmonths ordinal = 71, argument = 0 temporary */
static DWORD WINAPI msvcrt_Getmonths (VOID)
{
  return 0;
}


/* _Gettnames ordinal = 72, argument = 0 temporary */
static DWORD WINAPI msvcrt_Gettnames (VOID)
{
  return 0;
}


/* _HUGE ordinal = 73, argument = 0 temporary */
static DWORD WINAPI msvcrt_HUGE (VOID)
{
  return 0;
}


/* _Strftime ordinal = 74, argument = 0 temporary */
static DWORD WINAPI msvcrt_Strftime (VOID)
{
  return 0;
}


/* _XcptFilter ordinal = 75, argument = 0 temporary */
static DWORD WINAPI msvcrt_XcptFilter (VOID)
{
  return 0;
}


/* __CxxFrameHandler ordinal = 76, argument = 0 */
static void msvcrt_CxxFrameHandler (PEXCEPTION_RECORD rec, EXCEPTION_FRAME* frame, PCONTEXT exc_context, EXCEPTION_FRAME** dispatch, CONTEXT86 *context)
{
}


/* __CxxLongjmpUnwind ordinal = 77, argument = 4 temporary */
static DWORD WINAPI msvcrt_CxxLongjmpUnwind (DWORD dwArgv0)
{
  return 0;
}


/* __RTCastToVoid ordinal = 78, argument = 0 temporary */
static DWORD WINAPI msvcrt_RTCastToVoid (VOID)
{
  return 0;
}


/* __RTDynamicCast ordinal = 79, argument = 0 temporary */
static DWORD WINAPI msvcrt_RTDynamicCast (VOID)
{
  return 0;
}


/* __RTtypeid ordinal = 80, argument = 0 temporary */
static DWORD WINAPI msvcrt_RTtypeid (VOID)
{
  return 0;
}


/* __STRINGTOLD ordinal = 81, argument = 0 temporary */
static DWORD WINAPI msvcrt_STRINGTOLD (VOID)
{
  return 0;
}


/* __argc ordinal = 82, argument = 0 temporary */
static DWORD WINAPI msvcrt_argc (VOID)
{
  return 0;
}


/* __argv ordinal = 83, argument = 0 temporary */
static DWORD WINAPI msvcrt_argv (VOID)
{
  return 0;
}


/* __badioinfo ordinal = 84, argument = 0 temporary */
static DWORD WINAPI msvcrt_badioinfo (VOID)
{
  return 0;
}


/* __crtCompareStringA ordinal = 85, argument = 0 temporary */
static DWORD WINAPI msvcrt_crtCompareStringA (VOID)
{
  return 0;
}


/* __crtGetLocaleInfoW ordinal = 86, argument = 0 temporary */
static DWORD WINAPI msvcrt_crtGetLocaleInfoW (VOID)
{
  return 0;
}


/* __crtLCMapStringA ordinal = 87, argument = 0 temporary */
static DWORD WINAPI msvcrt_crtLCMapStringA (VOID)
{
  return 0;
}


/* __dllonexit ordinal = 88, argument = 0 */
static void CDECL *msvcrt_dllonexit (void *arg1, void *arg2, void *arg3)
{
  return NULL;
}


/* __doserrno ordinal = 89, argument = 0 temporary */
static DWORD WINAPI msvcrt_doserrno (VOID)
{
  return 0;
}


/* __fpecode ordinal = 90, argument = 0 temporary */
static DWORD WINAPI msvcrt_fpecode (VOID)
{
  return 0;
}


/* __getmainargs ordinal = 91, argument = 0 temporary */
static DWORD WINAPI msvcrt_getmainargs (VOID)
{
  return 0;
}


/* __initenv ordinal = 92, argument = 0 temporary */
static DWORD WINAPI msvcrt_initenv (VOID)
{
  return 0;
}


/* __isascii ordinal = 93, argument = 0 temporary */
static DWORD WINAPI msvcrt_isascii (VOID)
{
  return 0;
}


/* __iscsym ordinal = 94, argument = 0 temporary */
static DWORD WINAPI msvcrt_iscsym (VOID)
{
  return 0;
}


/* __iscsymf ordinal = 95, argument = 0 temporary */
static DWORD WINAPI msvcrt_iscsymf (VOID)
{
  return 0;
}


/* __lc_codepage ordinal = 96, argument = 0 temporary */
static DWORD WINAPI msvcrt_lc_codepage (VOID)
{
  return 0;
}


/* __lc_collate_cp ordinal = 97, argument = 0 temporary */
static DWORD WINAPI msvcrt_lc_collate_cp (VOID)
{
  return 0;
}


/* __lc_handle ordinal = 98, argument = 0 temporary */
static DWORD WINAPI msvcrt_lc_handle (VOID)
{
  return 0;
}


/* __lconv_init ordinal = 99, argument = 0 temporary */
static DWORD WINAPI msvcrt_lconv_init (VOID)
{
  return 0;
}


/* __mb_cur_max ordinal = 100, argument = 0 temporary */
static DWORD WINAPI msvcrt_mb_cur_max (VOID)
{
  return 0;
}


/* __p___argc ordinal = 101, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___argc (VOID)
{
  return 0;
}


/* __p___argv ordinal = 102, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___argv (VOID)
{
  return 0;
}


/* __p___initenv ordinal = 103, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___initenv (VOID)
{
  return 0;
}


/* __p___mb_cur_max ordinal = 104, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___mb_cur_max (VOID)
{
  return 0;
}


/* __p___wargv ordinal = 105, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___wargv (VOID)
{
  return 0;
}


/* __p___winitenv ordinal = 106, argument = 0 temporary */
static DWORD WINAPI msvcrt_p___winitenv (VOID)
{
  return 0;
}


/* __p__acmdln ordinal = 107, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__acmdln (VOID)
{
  return 0;
}


/* __p__amblksiz ordinal = 108, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__amblksiz (VOID)
{
  return 0;
}


/* __p__commode ordinal = 109, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__commode (VOID)
{
  return 0;
}


/* __p__daylight ordinal = 110, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__daylight (VOID)
{
  return 0;
}


/* __p__dstbias ordinal = 111, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__dstbias (VOID)
{
  return 0;
}


/* __p__environ ordinal = 112, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__environ (VOID)
{
  return 0;
}


/* __p__fileinfo ordinal = 113, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__fileinfo (VOID)
{
  return 0;
}


/* __p__fmode ordinal = 114, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__fmode (VOID)
{
  return 0;
}


/* __p__iob ordinal = 115, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__iob (VOID)
{
  return 0;
}


/* __p__mbcasemap ordinal = 116, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__mbcasemap (VOID)
{
  return 0;
}


/* __p__mbctype ordinal = 117, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__mbctype (VOID)
{
  return 0;
}


/* __p__osver ordinal = 118, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__osver (VOID)
{
  return 0;
}


/* __p__pctype ordinal = 119, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__pctype (VOID)
{
  return 0;
}


/* __p__pgmptr ordinal = 120, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__pgmptr (VOID)
{
  return 0;
}


/* __p__pwctype ordinal = 121, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__pwctype (VOID)
{
  return 0;
}


/* __p__timezone ordinal = 122, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__timezone (VOID)
{
  return 0;
}


/* __p__tzname ordinal = 123, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__tzname (VOID)
{
  return 0;
}


/* __p__wcmdln ordinal = 124, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__wcmdln (VOID)
{
  return 0;
}


/* __p__wenviron ordinal = 125, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__wenviron (VOID)
{
  return 0;
}


/* __p__winmajor ordinal = 126, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__winmajor (VOID)
{
  return 0;
}


/* __p__winminor ordinal = 127, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__winminor (VOID)
{
  return 0;
}


/* __p__winver ordinal = 128, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__winver (VOID)
{
  return 0;
}


/* __p__wpgmptr ordinal = 129, argument = 0 temporary */
static DWORD WINAPI msvcrt_p__wpgmptr (VOID)
{
  return 0;
}


/* __pioinfo ordinal = 130, argument = 0 temporary */
static DWORD WINAPI msvcrt_pioinfo (VOID)
{
  return 0;
}


/* __pxcptinfoptrs ordinal = 131, argument = 0 temporary */
static DWORD WINAPI msvcrt_pxcptinfoptrs (VOID)
{
  return 0;
}


/* __set_app_type ordinal = 132, argument = 0 temporary */
static DWORD WINAPI msvcrt_set_app_type (VOID)
{
  return 0;
}


/* __setlc_active ordinal = 133, argument = 0 temporary */
static DWORD WINAPI msvcrt_setlc_active (VOID)
{
  return 0;
}


/* __setusermatherr ordinal = 134, argument = 0 temporary */
static DWORD WINAPI msvcrt_setusermatherr (VOID)
{
  return 0;
}


/* __threadhandle ordinal = 135, argument = 0 temporary */
static DWORD WINAPI msvcrt_threadhandle (VOID)
{
  return 0;
}


/* __threadid ordinal = 136, argument = 0 temporary */
static DWORD WINAPI msvcrt_threadid (VOID)
{
  return 0;
}


/* __toascii ordinal = 137, argument = 0 temporary */
static DWORD WINAPI msvcrt_toascii (VOID)
{
  return 0;
}


/* __unDName ordinal = 138, argument = 0 temporary */
static DWORD WINAPI msvcrt_unDName (VOID)
{
  return 0;
}


/* __unDNameEx ordinal = 139, argument = 0 temporary */
static DWORD WINAPI msvcrt_unDNameEx (VOID)
{
  return 0;
}


/* __unguarded_readlc_active ordinal = 140, argument = 0 temporary */
static DWORD WINAPI msvcrt_unguarded_readlc_active (VOID)
{
  return 0;
}


/* __wargv ordinal = 141, argument = 0 temporary */
static DWORD WINAPI msvcrt_wargv (VOID)
{
  return 0;
}


/* __wgetmainargs ordinal = 142, argument = 0 temporary */
static DWORD WINAPI msvcrt_wgetmainargs (VOID)
{
  return 0;
}


/* __winitenv ordinal = 143, argument = 0 temporary */
static DWORD WINAPI msvcrt_winitenv (VOID)
{
  return 0;
}


/* _abnormal_termination ordinal = 144, argument = 0 temporary */
static DWORD WINAPI msvcrt_abnormal_termination (VOID)
{
  return 0;
}


/* _access ordinal = 145, argument = 0 temporary */
static DWORD WINAPI msvcrt_access (VOID)
{
  return 0;
}


/* _acmdln ordinal = 146, argument = 0 temporary */
static DWORD WINAPI msvcrt_acmdln (VOID)
{
  return 0;
}


/* _adj_fdiv_m16i ordinal = 147, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdiv_m16i (VOID)
{
  return 0;
}


/* _adj_fdiv_m32 ordinal = 148, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdiv_m32 (VOID)
{
  return 0;
}


/* _adj_fdiv_m32i ordinal = 149, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdiv_m32i (VOID)
{
  return 0;
}


/* _adj_fdiv_m64 ordinal = 150, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdiv_m64 (VOID)
{
  return 0;
}


/* _adj_fdiv_r ordinal = 151, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdiv_r (VOID)
{
  return 0;
}


/* _adj_fdivr_m16i ordinal = 152, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdivr_m16i (VOID)
{
  return 0;
}


/* _adj_fdivr_m32 ordinal = 153, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdivr_m32 (VOID)
{
  return 0;
}


/* _adj_fdivr_m32i ordinal = 154, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdivr_m32i (VOID)
{
  return 0;
}


/* _adj_fdivr_m64 ordinal = 155, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fdivr_m64 (VOID)
{
  return 0;
}


/* _adj_fpatan ordinal = 156, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fpatan (VOID)
{
  return 0;
}


/* _adj_fprem ordinal = 157, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fprem (VOID)
{
  return 0;
}


/* _adj_fprem1 ordinal = 158, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fprem1 (VOID)
{
  return 0;
}


/* _adj_fptan ordinal = 159, argument = 0 temporary */
static DWORD WINAPI msvcrt_adj_fptan (VOID)
{
  return 0;
}


/* _adjust_fdiv ordinal = 160, argument = 0 */
static int msvcrt_adjust_fdiv = 0;


/* _aexit_rtn ordinal = 161, argument = 0 temporary */
static DWORD WINAPI msvcrt_aexit_rtn (VOID)
{
  return 0;
}


/* _amsg_exit ordinal = 162, argument = 0 temporary */
static DWORD WINAPI msvcrt_amsg_exit (VOID)
{
  return 0;
}


/* _assert ordinal = 163, argument = 0 temporary */
static DWORD WINAPI msvcrt_assert (VOID)
{
  return 0;
}


/* _atodbl ordinal = 164, argument = 0 temporary */
static DWORD WINAPI msvcrt_atodbl (VOID)
{
  return 0;
}


/* _atoi64 ordinal = 165, argument = 0 temporary */
static DWORD WINAPI msvcrt_atoi64 (VOID)
{
  return 0;
}


/* _atoldbl ordinal = 166, argument = 0 temporary */
static DWORD WINAPI msvcrt_atoldbl (VOID)
{
  return 0;
}


/* _beep ordinal = 167, argument = 0 temporary */
static DWORD WINAPI msvcrt_beep (VOID)
{
  return 0;
}


/* _beginthread ordinal = 168, argument = 0 temporary */
static DWORD WINAPI msvcrt_beginthread (VOID)
{
  return 0;
}


/* _beginthreadex ordinal = 169, argument = 0 temporary */
static DWORD WINAPI msvcrt_beginthreadex (VOID)
{
  return 0;
}


/* _c_exit ordinal = 170, argument = 0 temporary */
static DWORD WINAPI msvcrt_c_exit (VOID)
{
  return 0;
}


/* _cabs ordinal = 171, argument = 0 temporary */
static DWORD WINAPI msvcrt_cabs (VOID)
{
  return 0;
}


/* _callnewh ordinal = 172, argument = 0 temporary */
static DWORD WINAPI msvcrt_callnewh (VOID)
{
  return 0;
}


/* _cexit ordinal = 173, argument = 0 temporary */
static DWORD WINAPI msvcrt_cexit (VOID)
{
  return 0;
}


/* _cgets ordinal = 174, argument = 0 temporary */
static DWORD WINAPI msvcrt_cgets (VOID)
{
  return 0;
}


/* _chdir ordinal = 175, argument = 0 temporary */
static DWORD WINAPI msvcrt_chdir (VOID)
{
  return 0;
}


/* _chdrive ordinal = 176, argument = 0 temporary */
static DWORD WINAPI msvcrt_chdrive (VOID)
{
  return 0;
}


/* _chgsign ordinal = 177, argument = 0 temporary */
static DWORD WINAPI msvcrt_chgsign (VOID)
{
  return 0;
}


/* _chkesp ordinal = 178, argument = 0 temporary */
static DWORD WINAPI msvcrt_chkesp (VOID)
{
  return 0;
}


/* _chmod ordinal = 179, argument = 0 temporary */
static DWORD WINAPI msvcrt_chmod (VOID)
{
  return 0;
}


/* _chsize ordinal = 180, argument = 0 temporary */
static DWORD WINAPI msvcrt_chsize (VOID)
{
  return 0;
}


/* _clearfp ordinal = 181, argument = 0 */
static CDECL unsigned int msvcrt_clearfp (void)
{
  return 0;
}


/* _close ordinal = 182, argument = 0 temporary */
static DWORD WINAPI msvcrt_close (VOID)
{
  return 0;
}


/* _commit ordinal = 183, argument = 0 temporary */
static DWORD WINAPI msvcrt_commit (VOID)
{
  return 0;
}


/* _commode ordinal = 184, argument = 0 temporary */
static DWORD WINAPI msvcrt_commode (VOID)
{
  return 0;
}


/* _control87 ordinal = 185, argument = 0 temporary */
static DWORD WINAPI msvcrt_control87 (VOID)
{
  return 0;
}


/* _controlfp ordinal = 186, argument = 0 temporary */
static DWORD WINAPI msvcrt_controlfp (VOID)
{
  return 0;
}


/* _copysign ordinal = 187, argument = 0 temporary */
static DWORD WINAPI msvcrt_copysign (VOID)
{
  return 0;
}


/* _cprintf ordinal = 188, argument = 0 temporary */
static DWORD WINAPI msvcrt_cprintf (VOID)
{
  return 0;
}


/* _cputs ordinal = 189, argument = 0 temporary */
static DWORD WINAPI msvcrt_cputs (VOID)
{
  return 0;
}


/* _creat ordinal = 190, argument = 0 temporary */
static DWORD WINAPI msvcrt_creat (VOID)
{
  return 0;
}


/* _cscanf ordinal = 191, argument = 0 temporary */
static DWORD WINAPI msvcrt_cscanf (VOID)
{
  return 0;
}


/* _ctime64 ordinal = 192, argument = 0 temporary */
static DWORD WINAPI msvcrt_ctime64 (VOID)
{
  return 0;
}


/* _ctype ordinal = 193, argument = 0 temporary */
static DWORD WINAPI msvcrt_ctype (VOID)
{
  return 0;
}


/* _cwait ordinal = 194, argument = 0 temporary */
static DWORD WINAPI msvcrt_cwait (VOID)
{
  return 0;
}


/* _daylight ordinal = 195, argument = 0 temporary */
static DWORD WINAPI msvcrt_daylight (VOID)
{
  return 0;
}


/* _dstbias ordinal = 196, argument = 0 temporary */
static DWORD WINAPI msvcrt_dstbias (VOID)
{
  return 0;
}


/* _dup ordinal = 197, argument = 0 temporary */
static DWORD WINAPI msvcrt_dup (VOID)
{
  return 0;
}


/* _dup2 ordinal = 198, argument = 0 temporary */
static DWORD WINAPI msvcrt_dup2 (VOID)
{
  return 0;
}


/* _ecvt ordinal = 199, argument = 0 temporary */
static DWORD WINAPI msvcrt_ecvt (VOID)
{
  return 0;
}


/* _endthread ordinal = 200, argument = 0 temporary */
static DWORD WINAPI msvcrt_endthread (VOID)
{
  return 0;
}


/* _endthreadex ordinal = 201, argument = 0 temporary */
static DWORD WINAPI msvcrt_endthreadex (VOID)
{
  return 0;
}


/* _environ ordinal = 202, argument = 0 temporary */
static DWORD WINAPI msvcrt_environ (VOID)
{
  return 0;
}


/* _eof ordinal = 203, argument = 0 temporary */
static DWORD WINAPI msvcrt_eof (VOID)
{
  return 0;
}


/* _errno ordinal = 204, argument = 0 temporary */
static DWORD WINAPI msvcrt_errno (VOID)
{
  return 0;
}


/* _except_handler2 ordinal = 205, argument = 0 temporary */
static DWORD WINAPI msvcrt_except_handler2 (VOID)
{
  return 0;
}


/* _except_handler3 ordinal = 206, argument = 0 */
static int CDECL msvcrt_except_handler3 (PEXCEPTION_RECORD rec, MSVCRT_EXCEPTION_FRAME* frame, PCONTEXT context, void* dispatcher)
{
  return 0;
}


/* _execl ordinal = 207, argument = 0 temporary */
static DWORD WINAPI msvcrt_execl (VOID)
{
  return 0;
}


/* _execle ordinal = 208, argument = 0 temporary */
static DWORD WINAPI msvcrt_execle (VOID)
{
  return 0;
}


/* _execlp ordinal = 209, argument = 0 temporary */
static DWORD WINAPI msvcrt_execlp (VOID)
{
  return 0;
}


/* _execlpe ordinal = 210, argument = 0 temporary */
static DWORD WINAPI msvcrt_execlpe (VOID)
{
  return 0;
}


/* _execv ordinal = 211, argument = 0 temporary */
static DWORD WINAPI msvcrt_execv (VOID)
{
  return 0;
}


/* _execve ordinal = 212, argument = 0 temporary */
static DWORD WINAPI msvcrt_execve (VOID)
{
  return 0;
}


/* _execvp ordinal = 213, argument = 0 temporary */
static DWORD WINAPI msvcrt_execvp (VOID)
{
  return 0;
}


/* _execvpe ordinal = 214, argument = 0 temporary */
static DWORD WINAPI msvcrt_execvpe (VOID)
{
  return 0;
}


/* _exit ordinal = 215, argument = 0 temporary */
static DWORD WINAPI msvcrt__exit (VOID)
{
  return 0;
}


/* _expand ordinal = 216, argument = 0 temporary */
static DWORD WINAPI msvcrt_expand (VOID)
{
  return 0;
}


/* _fcloseall ordinal = 217, argument = 0 temporary */
static DWORD WINAPI msvcrt_fcloseall (VOID)
{
  return 0;
}


/* _fcvt ordinal = 218, argument = 0 temporary */
static DWORD WINAPI msvcrt_fcvt (VOID)
{
  return 0;
}


/* _fdopen ordinal = 219, argument = 0 temporary */
static DWORD WINAPI msvcrt_fdopen (VOID)
{
  return 0;
}


/* _fgetchar ordinal = 220, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgetchar (VOID)
{
  return 0;
}


/* _fgetwchar ordinal = 221, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgetwchar (VOID)
{
  return 0;
}


/* _filbuf ordinal = 222, argument = 0 temporary */
static DWORD WINAPI msvcrt_filbuf (VOID)
{
  return 0;
}


/* _fileinfo ordinal = 223, argument = 0 temporary */
static DWORD WINAPI msvcrt_fileinfo (VOID)
{
  return 0;
}


/* _filelength ordinal = 224, argument = 0 temporary */
static DWORD WINAPI msvcrt_filelength (VOID)
{
  return 0;
}


/* _filelengthi64 ordinal = 225, argument = 0 temporary */
static DWORD WINAPI msvcrt_filelengthi64 (VOID)
{
  return 0;
}


/* _fileno ordinal = 226, argument = 0 temporary */
static DWORD WINAPI msvcrt_fileno (VOID)
{
  return 0;
}


/* _findclose ordinal = 227, argument = 0 temporary */
static DWORD WINAPI msvcrt_findclose (VOID)
{
  return 0;
}


/* _findfirst ordinal = 228, argument = 0 temporary */
static DWORD WINAPI msvcrt_findfirst (VOID)
{
  return 0;
}


/* _findfirst64 ordinal = 229, argument = 0 temporary */
static DWORD WINAPI msvcrt_findfirst64 (VOID)
{
  return 0;
}


/* _findfirsti64 ordinal = 230, argument = 0 temporary */
static DWORD WINAPI msvcrt_findfirsti64 (VOID)
{
  return 0;
}


/* _findnext ordinal = 231, argument = 0 temporary */
static DWORD WINAPI msvcrt_findnext (VOID)
{
  return 0;
}


/* _findnext64 ordinal = 232, argument = 0 temporary */
static DWORD WINAPI msvcrt_findnext64 (VOID)
{
  return 0;
}


/* _findnexti64 ordinal = 233, argument = 0 temporary */
static DWORD WINAPI msvcrt_findnexti64 (VOID)
{
  return 0;
}


/* _finite ordinal = 234, argument = 0 temporary */
static DWORD WINAPI msvcrt_finite (VOID)
{
  return 0;
}


/* _flsbuf ordinal = 235, argument = 0 temporary */
static DWORD WINAPI msvcrt_flsbuf (VOID)
{
  return 0;
}


/* _flushall ordinal = 236, argument = 0 temporary */
static DWORD WINAPI msvcrt_flushall (VOID)
{
  return 0;
}


/* _fmode ordinal = 237, argument = 0 temporary */
static DWORD WINAPI msvcrt_fmode (VOID)
{
  return 0;
}


/* _fpclass ordinal = 238, argument = 0 temporary */
static DWORD WINAPI msvcrt_fpclass (VOID)
{
  return 0;
}


/* _fpieee_flt ordinal = 239, argument = 0 temporary */
static DWORD WINAPI msvcrt_fpieee_flt (VOID)
{
  return 0;
}


/* _fpreset ordinal = 240, argument = 0 temporary */
static DWORD WINAPI msvcrt_fpreset (VOID)
{
  return 0;
}


/* _fputchar ordinal = 241, argument = 0 temporary */
static DWORD WINAPI msvcrt_fputchar (VOID)
{
  return 0;
}


/* _fputwchar ordinal = 242, argument = 0 temporary */
static DWORD WINAPI msvcrt_fputwchar (VOID)
{
  return 0;
}


/* _fsopen ordinal = 243, argument = 0 temporary */
static DWORD WINAPI msvcrt_fsopen (VOID)
{
  return 0;
}


/* _fstat ordinal = 244, argument = 0 temporary */
static DWORD WINAPI msvcrt_fstat (VOID)
{
  return 0;
}


/* _fstat64 ordinal = 245, argument = 0 temporary */
static DWORD WINAPI msvcrt_fstat64 (VOID)
{
  return 0;
}


/* _fstati64 ordinal = 246, argument = 0 temporary */
static DWORD WINAPI msvcrt_fstati64 (VOID)
{
  return 0;
}


/* _ftime ordinal = 247, argument = 0 temporary */
static DWORD WINAPI msvcrt_ftime (VOID)
{
  return 0;
}


/* _ftime64 ordinal = 248, argument = 0 temporary */
static DWORD WINAPI msvcrt_ftime64 (VOID)
{
  return 0;
}


/* _ftol ordinal = 249, argument = 0 */
static LONG CDECL msvcrt_ftol (void)
{
  double fl;

  __asm__ __volatile__( "fstpl" " %0;fwait" : "=m" (fl) : );
  return (LONG)fl;
}


/* _fullpath ordinal = 250, argument = 0 temporary */
static DWORD WINAPI msvcrt_fullpath (VOID)
{
  return 0;
}


/* _futime ordinal = 251, argument = 0 temporary */
static DWORD WINAPI msvcrt_futime (VOID)
{
  return 0;
}


/* _futime64 ordinal = 252, argument = 0 temporary */
static DWORD WINAPI msvcrt_futime64 (VOID)
{
  return 0;
}


/* _gcvt ordinal = 253, argument = 0 temporary */
static DWORD WINAPI msvcrt_gcvt (VOID)
{
  return 0;
}


/* _get_heap_handle ordinal = 254, argument = 0 temporary */
static DWORD WINAPI msvcrt_get_heap_handle (VOID)
{
  return 0;
}


/* _get_osfhandle ordinal = 255, argument = 0 temporary */
static DWORD WINAPI msvcrt_get_osfhandle (VOID)
{
  return 0;
}


/* _get_sbh_threshold ordinal = 256, argument = 0 temporary */
static DWORD WINAPI msvcrt_get_sbh_threshold (VOID)
{
  return 0;
}


/* _getch ordinal = 257, argument = 0 temporary */
static DWORD WINAPI msvcrt_getch (VOID)
{
  return 0;
}


/* _getche ordinal = 258, argument = 0 temporary */
static DWORD WINAPI msvcrt_getche (VOID)
{
  return 0;
}


/* _getcwd ordinal = 259, argument = 0 temporary */
static DWORD WINAPI msvcrt_getcwd (VOID)
{
  return 0;
}


/* _getdcwd ordinal = 260, argument = 0 temporary */
static DWORD WINAPI msvcrt_getdcwd (VOID)
{
  return 0;
}


/* _getdiskfree ordinal = 261, argument = 0 temporary */
static DWORD WINAPI msvcrt_getdiskfree (VOID)
{
  return 0;
}


/* _getdllprocaddr ordinal = 262, argument = 0 temporary */
static DWORD WINAPI msvcrt_getdllprocaddr (VOID)
{
  return 0;
}


/* _getdrive ordinal = 263, argument = 0 temporary */
static DWORD WINAPI msvcrt_getdrive (VOID)
{
  return 0;
}


/* _getdrives ordinal = 264, argument = 0 temporary */
static DWORD WINAPI msvcrt_getdrives (VOID)
{
  return 0;
}


/* _getmaxstdio ordinal = 265, argument = 0 temporary */
static DWORD WINAPI msvcrt_getmaxstdio (VOID)
{
  return 0;
}


/* _getmbcp ordinal = 266, argument = 0 temporary */
static DWORD WINAPI msvcrt_getmbcp (VOID)
{
  return 0;
}


/* _getpid ordinal = 267, argument = 0 temporary */
static DWORD WINAPI msvcrt_getpid (VOID)
{
  return 0;
}


/* _getsystime ordinal = 268, argument = 0 temporary */
static DWORD WINAPI msvcrt_getsystime (VOID)
{
  return 0;
}


/* _getw ordinal = 269, argument = 0 temporary */
static DWORD WINAPI msvcrt_getw (VOID)
{
  return 0;
}


/* _getws ordinal = 270, argument = 0 temporary */
static DWORD WINAPI msvcrt_getws (VOID)
{
  return 0;
}


/* _global_unwind2 ordinal = 271, argument = 0 temporary */
static DWORD WINAPI msvcrt_global_unwind2 (VOID)
{
  return 0;
}


/* _gmtime64 ordinal = 272, argument = 0 temporary */
static DWORD WINAPI msvcrt_gmtime64 (VOID)
{
  return 0;
}


/* _heapadd ordinal = 273, argument = 0 temporary */
static DWORD WINAPI msvcrt_heapadd (VOID)
{
  return 0;
}


/* _heapchk ordinal = 274, argument = 0 temporary */
static DWORD WINAPI msvcrt_heapchk (VOID)
{
  return 0;
}


/* _heapmin ordinal = 275, argument = 0 temporary */
static DWORD WINAPI msvcrt_heapmin (VOID)
{
  return 0;
}


/* _heapset ordinal = 276, argument = 0 temporary */
static DWORD WINAPI msvcrt_heapset (VOID)
{
  return 0;
}


/* _heapused ordinal = 277, argument = 0 temporary */
static DWORD WINAPI msvcrt_heapused (VOID)
{
  return 0;
}


/* _heapwalk ordinal = 278, argument = 0 temporary */
static DWORD WINAPI msvcrt_heapwalk (VOID)
{
  return 0;
}


/* _hypot ordinal = 279, argument = 0 temporary */
static DWORD WINAPI msvcrt_hypot (VOID)
{
  return 0;
}


/* _i64toa ordinal = 280, argument = 0 temporary */
static DWORD WINAPI msvcrt_i64toa (VOID)
{
  return 0;
}


/* _i64tow ordinal = 281, argument = 0 temporary */
static DWORD WINAPI msvcrt_i64tow (VOID)
{
  return 0;
}


/* _initterm ordinal = 282, argument = 0 */
static int CDECL msvcrt_initterm (void **arg1, void **arg2)
{
  BOOL (*initterm_func)(void);

  while (arg1 < arg2)
    {
      if ((initterm_func = (BOOL(*)(void))*arg1))
        initterm_func ();
      arg1++;
    }
  return 0;
}


/* _inp ordinal = 283, argument = 0 temporary */
static DWORD WINAPI msvcrt_inp (VOID)
{
  return 0;
}


/* _inpd ordinal = 284, argument = 0 temporary */
static DWORD WINAPI msvcrt_inpd (VOID)
{
  return 0;
}


/* _inpw ordinal = 285, argument = 0 temporary */
static DWORD WINAPI msvcrt_inpw (VOID)
{
  return 0;
}


/* _iob ordinal = 286, argument = 0 temporary */
static DWORD WINAPI msvcrt_iob (VOID)
{
  return 0;
}


/* _isatty ordinal = 287, argument = 0 temporary */
static DWORD WINAPI msvcrt_isatty (VOID)
{
  return 0;
}


/* _isctype ordinal = 288, argument = 0 temporary */
static DWORD WINAPI msvcrt_isctype (VOID)
{
  return 0;
}


/* _ismbbalnum ordinal = 289, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbbalnum (VOID)
{
  return 0;
}


/* _ismbbalpha ordinal = 290, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbbalpha (VOID)
{
  return 0;
}


/* _ismbbgraph ordinal = 291, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbbgraph (VOID)
{
  return 0;
}


/* _ismbbkalnum ordinal = 292, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbbkalnum (VOID)
{
  return 0;
}


/* _ismbbkana ordinal = 293, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbbkana (VOID)
{
  return 0;
}


/* _ismbbkprint ordinal = 294, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbbkprint (VOID)
{
  return 0;
}


/* _ismbbkpunct ordinal = 295, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbbkpunct (VOID)
{
  return 0;
}


/* _ismbblead ordinal = 296, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbblead (VOID)
{
  return 0;
}


/* _ismbbprint ordinal = 297, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbbprint (VOID)
{
  return 0;
}


/* _ismbbpunct ordinal = 298, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbbpunct (VOID)
{
  return 0;
}


/* _ismbbtrail ordinal = 299, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbbtrail (VOID)
{
  return 0;
}


/* _ismbcalnum ordinal = 300, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcalnum (VOID)
{
  return 0;
}


/* _ismbcalpha ordinal = 301, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcalpha (VOID)
{
  return 0;
}


/* _ismbcdigit ordinal = 302, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcdigit (VOID)
{
  return 0;
}


/* _ismbcgraph ordinal = 303, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcgraph (VOID)
{
  return 0;
}


/* _ismbchira ordinal = 304, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbchira (VOID)
{
  return 0;
}


/* _ismbckata ordinal = 305, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbckata (VOID)
{
  return 0;
}


/* _ismbcl0 ordinal = 306, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcl0 (VOID)
{
  return 0;
}


/* _ismbcl1 ordinal = 307, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcl1 (VOID)
{
  return 0;
}


/* _ismbcl2 ordinal = 308, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcl2 (VOID)
{
  return 0;
}


/* _ismbclegal ordinal = 309, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbclegal (VOID)
{
  return 0;
}


/* _ismbclower ordinal = 310, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbclower (VOID)
{
  return 0;
}


/* _ismbcprint ordinal = 311, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcprint (VOID)
{
  return 0;
}


/* _ismbcpunct ordinal = 312, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcpunct (VOID)
{
  return 0;
}


/* _ismbcspace ordinal = 313, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcspace (VOID)
{
  return 0;
}


/* _ismbcsymbol ordinal = 314, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcsymbol (VOID)
{
  return 0;
}


/* _ismbcupper ordinal = 315, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbcupper (VOID)
{
  return 0;
}


/* _ismbslead ordinal = 316, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbslead (VOID)
{
  return 0;
}


/* _ismbstrail ordinal = 317, argument = 0 temporary */
static DWORD WINAPI msvcrt_ismbstrail (VOID)
{
  return 0;
}


/* _isnan ordinal = 318, argument = 0 temporary */
static DWORD WINAPI msvcrt_isnan (VOID)
{
  return 0;
}


/* _itoa ordinal = 319, argument = 0 temporary */
static DWORD WINAPI msvcrt_itoa (VOID)
{
  return 0;
}


/* _itow ordinal = 320, argument = 0 temporary */
static DWORD WINAPI msvcrt_itow (VOID)
{
  return 0;
}


/* _j0 ordinal = 321, argument = 0 temporary */
static DWORD WINAPI msvcrt_j0 (VOID)
{
  return 0;
}


/* _j1 ordinal = 322, argument = 0 temporary */
static DWORD WINAPI msvcrt_j1 (VOID)
{
  return 0;
}


/* _jn ordinal = 323, argument = 0 temporary */
static DWORD WINAPI msvcrt_jn (VOID)
{
  return 0;
}


/* _kbhit ordinal = 324, argument = 0 temporary */
static DWORD WINAPI msvcrt_kbhit (VOID)
{
  return 0;
}


/* _lfind ordinal = 325, argument = 0 temporary */
static DWORD WINAPI msvcrt_lfind (VOID)
{
  return 0;
}


/* _loaddll ordinal = 326, argument = 0 temporary */
static DWORD WINAPI msvcrt_loaddll (VOID)
{
  return 0;
}


/* _local_unwind2 ordinal = 327, argument = 0 temporary */
static DWORD WINAPI msvcrt_local_unwind2 (VOID)
{
  return 0;
}


/* _localtime64 ordinal = 328, argument = 0 temporary */
static DWORD WINAPI msvcrt_localtime64 (VOID)
{
  return 0;
}


/* _lock ordinal = 329, argument = 0 temporary */
static DWORD WINAPI msvcrt_lock (VOID)
{
  return 0;
}


/* _locking ordinal = 330, argument = 0 temporary */
static DWORD WINAPI msvcrt_locking (VOID)
{
  return 0;
}


/* _logb ordinal = 331, argument = 0 temporary */
static DWORD WINAPI msvcrt_logb (VOID)
{
  return 0;
}


/* _longjmpex ordinal = 332, argument = 0 temporary */
static DWORD WINAPI msvcrt_longjmpex (VOID)
{
  return 0;
}


/* _lrotl ordinal = 333, argument = 0 temporary */
static DWORD WINAPI msvcrt_lrotl (VOID)
{
  return 0;
}


/* _lrotr ordinal = 334, argument = 0 temporary */
static DWORD WINAPI msvcrt_lrotr (VOID)
{
  return 0;
}


/* _lsearch ordinal = 335, argument = 0 temporary */
static DWORD WINAPI msvcrt_lsearch (VOID)
{
  return 0;
}


/* _lseek ordinal = 336, argument = 0 temporary */
static DWORD WINAPI msvcrt_lseek (VOID)
{
  return 0;
}


/* _lseeki64 ordinal = 337, argument = 0 temporary */
static DWORD WINAPI msvcrt_lseeki64 (VOID)
{
  return 0;
}


/* _ltoa ordinal = 338, argument = 0 temporary */
static DWORD WINAPI msvcrt_ltoa (VOID)
{
  return 0;
}


/* _ltow ordinal = 339, argument = 0 temporary */
static DWORD WINAPI msvcrt_ltow (VOID)
{
  return 0;
}


/* _makepath ordinal = 340, argument = 0 temporary */
static DWORD WINAPI msvcrt_makepath (VOID)
{
  return 0;
}


/* _mbbtombc ordinal = 341, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbbtombc (VOID)
{
  return 0;
}


/* _mbbtype ordinal = 342, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbbtype (VOID)
{
  return 0;
}


/* _mbcasemap ordinal = 343, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbcasemap (VOID)
{
  return 0;
}


/* _mbccpy ordinal = 344, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbccpy (VOID)
{
  return 0;
}


/* _mbcjistojms ordinal = 345, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbcjistojms (VOID)
{
  return 0;
}


/* _mbcjmstojis ordinal = 346, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbcjmstojis (VOID)
{
  return 0;
}


/* _mbclen ordinal = 347, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbclen (VOID)
{
  return 0;
}


/* _mbctohira ordinal = 348, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbctohira (VOID)
{
  return 0;
}


/* _mbctokata ordinal = 349, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbctokata (VOID)
{
  return 0;
}


/* _mbctolower ordinal = 350, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbctolower (VOID)
{
  return 0;
}


/* _mbctombb ordinal = 351, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbctombb (VOID)
{
  return 0;
}


/* _mbctoupper ordinal = 352, argument = 0 */
static DWORD WINAPI msvcrt_mbctoupper (VOID)
{
  return 0;
}


/* _mbctype ordinal = 353, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbctype (VOID)
{
  return 0;
}


/* _mbsbtype ordinal = 354, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsbtype (VOID)
{
  return 0;
}


/* _mbscat ordinal = 355, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbscat (VOID)
{
  return 0;
}


/* _mbschr ordinal = 356, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbschr (VOID)
{
  return 0;
}


/* _mbscmp ordinal = 357, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbscmp (VOID)
{
  return 0;
}


/* _mbscoll ordinal = 358, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbscoll (VOID)
{
  return 0;
}


/* _mbscpy ordinal = 359, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbscpy (VOID)
{
  return 0;
}


/* _mbscspn ordinal = 360, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbscspn (VOID)
{
  return 0;
}


/* _mbsdec ordinal = 361, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsdec (VOID)
{
  return 0;
}


/* _mbsdup ordinal = 362, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsdup (VOID)
{
  return 0;
}


/* _mbsicmp ordinal = 363, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsicmp (VOID)
{
  return 0;
}


/* _mbsicoll ordinal = 364, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsicoll (VOID)
{
  return 0;
}


/* _mbsinc ordinal = 365, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsinc (VOID)
{
  return 0;
}


/* _mbslen ordinal = 366, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbslen (VOID)
{
  return 0;
}


/* _mbslwr ordinal = 367, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbslwr (VOID)
{
  return 0;
}


/* _mbsnbcat ordinal = 368, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnbcat (VOID)
{
  return 0;
}


/* _mbsnbcmp ordinal = 369, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnbcmp (VOID)
{
  return 0;
}


/* _mbsnbcnt ordinal = 370, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnbcnt (VOID)
{
  return 0;
}


/* _mbsnbcoll ordinal = 371, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnbcoll (VOID)
{
  return 0;
}


/* _mbsnbcpy ordinal = 372, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnbcpy (VOID)
{
  return 0;
}


/* _mbsnbicmp ordinal = 373, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnbicmp (VOID)
{
  return 0;
}


/* _mbsnbicoll ordinal = 374, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnbicoll (VOID)
{
  return 0;
}


/* _mbsnbset ordinal = 375, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnbset (VOID)
{
  return 0;
}


/* _mbsncat ordinal = 376, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsncat (VOID)
{
  return 0;
}


/* _mbsnccnt ordinal = 377, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnccnt (VOID)
{
  return 0;
}


/* _mbsncmp ordinal = 378, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsncmp (VOID)
{
  return 0;
}


/* _mbsncoll ordinal = 379, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsncoll (VOID)
{
  return 0;
}


/* _mbsncpy ordinal = 380, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsncpy (VOID)
{
  return 0;
}


/* _mbsnextc ordinal = 381, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnextc (VOID)
{
  return 0;
}


/* _mbsnicmp ordinal = 382, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnicmp (VOID)
{
  return 0;
}


/* _mbsnicoll ordinal = 383, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnicoll (VOID)
{
  return 0;
}


/* _mbsninc ordinal = 384, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsninc (VOID)
{
  return 0;
}


/* _mbsnset ordinal = 385, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsnset (VOID)
{
  return 0;
}


/* _mbspbrk ordinal = 386, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbspbrk (VOID)
{
  return 0;
}


/* _mbsrchr ordinal = 387, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsrchr (VOID)
{
  return 0;
}


/* _mbsrev ordinal = 388, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsrev (VOID)
{
  return 0;
}


/* _mbsset ordinal = 389, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsset (VOID)
{
  return 0;
}


/* _mbsspn ordinal = 390, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsspn (VOID)
{
  return 0;
}


/* _mbsspnp ordinal = 391, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsspnp (VOID)
{
  return 0;
}


/* _mbsstr ordinal = 392, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsstr (VOID)
{
  return 0;
}


/* _mbstok ordinal = 393, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbstok (VOID)
{
  return 0;
}


/* _mbstrlen ordinal = 394, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbstrlen (VOID)
{
  return 0;
}


/* _mbsupr ordinal = 395, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbsupr (VOID)
{
  return 0;
}


/* _memccpy ordinal = 396, argument = 0 temporary */
static DWORD WINAPI msvcrt_memccpy (VOID)
{
  return 0;
}


/* _memicmp ordinal = 397, argument = 0 temporary */
static DWORD WINAPI msvcrt_memicmp (VOID)
{
  return 0;
}


/* _mkdir ordinal = 398, argument = 0 temporary */
static DWORD WINAPI msvcrt_mkdir (VOID)
{
  return 0;
}


/* _mktemp ordinal = 399, argument = 0 temporary */
static DWORD WINAPI msvcrt_mktemp (VOID)
{
  return 0;
}


/* _mktime64 ordinal = 400, argument = 0 temporary */
static DWORD WINAPI msvcrt_mktime64 (VOID)
{
  return 0;
}


/* _msize ordinal = 401, argument = 0 temporary */
static DWORD WINAPI msvcrt_msize (VOID)
{
  return 0;
}


/* _nextafter ordinal = 402, argument = 0 temporary */
static DWORD WINAPI msvcrt_nextafter (VOID)
{
  return 0;
}


/* _onexit ordinal = 403, argument = 0 */
static CDECL void *msvcrt_onexit (void *arg1)
{
  return NULL;
}


/* _open ordinal = 404, argument = 0 temporary */
static DWORD WINAPI msvcrt_open (VOID)
{
  return 0;
}


/* _open_osfhandle ordinal = 405, argument = 0 temporary */
static DWORD WINAPI msvcrt_open_osfhandle (VOID)
{
  return 0;
}


/* _osplatform ordinal = 406, argument = 0 temporary */
static DWORD WINAPI msvcrt_osplatform (VOID)
{
  return 0;
}


/* _osver ordinal = 407, argument = 0 temporary */
static DWORD WINAPI msvcrt_osver (VOID)
{
  return 0;
}


/* _outp ordinal = 408, argument = 0 temporary */
static DWORD WINAPI msvcrt_outp (VOID)
{
  return 0;
}


/* _outpd ordinal = 409, argument = 0 temporary */
static DWORD WINAPI msvcrt_outpd (VOID)
{
  return 0;
}


/* _outpw ordinal = 410, argument = 0 temporary */
static DWORD WINAPI msvcrt_outpw (VOID)
{
  return 0;
}


/* _pclose ordinal = 411, argument = 0 temporary */
static DWORD WINAPI msvcrt_pclose (VOID)
{
  return 0;
}


/* _pctype ordinal = 412, argument = 0 temporary */
static DWORD WINAPI msvcrt_pctype (VOID)
{
  return 0;
}


/* _pgmptr ordinal = 413, argument = 0 temporary */
static DWORD WINAPI msvcrt_pgmptr (VOID)
{
  return 0;
}


/* _pipe ordinal = 414, argument = 0 temporary */
static DWORD WINAPI msvcrt_pipe (VOID)
{
  return 0;
}


/* _popen ordinal = 415, argument = 0 temporary */
static DWORD WINAPI msvcrt_popen (VOID)
{
  return 0;
}


/* _purecall ordinal = 416, argument = 0 temporary */
static DWORD WINAPI msvcrt_purecall (VOID)
{
  return 0;
}


/* _putch ordinal = 417, argument = 0 temporary */
static DWORD WINAPI msvcrt_putch (VOID)
{
  return 0;
}


/* _putenv ordinal = 418, argument = 0 temporary */
static DWORD WINAPI msvcrt_putenv (VOID)
{
  return 0;
}


/* _putw ordinal = 419, argument = 0 temporary */
static DWORD WINAPI msvcrt_putw (VOID)
{
  return 0;
}


/* _putws ordinal = 420, argument = 0 temporary */
static DWORD WINAPI msvcrt_putws (VOID)
{
  return 0;
}


/* _pwctype ordinal = 421, argument = 0 temporary */
static DWORD WINAPI msvcrt_pwctype (VOID)
{
  return 0;
}


/* _read ordinal = 422, argument = 0 temporary */
static DWORD WINAPI msvcrt_read (VOID)
{
  return 0;
}


/* _rmdir ordinal = 423, argument = 0 temporary */
static DWORD WINAPI msvcrt_rmdir (VOID)
{
  return 0;
}


/* _rmtmp ordinal = 424, argument = 0 temporary */
static DWORD WINAPI msvcrt_rmtmp (VOID)
{
  return 0;
}


/* _rotl ordinal = 425, argument = 0 temporary */
static DWORD WINAPI msvcrt_rotl (VOID)
{
  return 0;
}


/* _rotr ordinal = 426, argument = 0 temporary */
static DWORD WINAPI msvcrt_rotr (VOID)
{
  return 0;
}


/* _safe_fdiv ordinal = 427, argument = 0 temporary */
static DWORD WINAPI msvcrt_safe_fdiv (VOID)
{
  return 0;
}


/* _safe_fdivr ordinal = 428, argument = 0 temporary */
static DWORD WINAPI msvcrt_safe_fdivr (VOID)
{
  return 0;
}


/* _safe_fprem ordinal = 429, argument = 0 temporary */
static DWORD WINAPI msvcrt_safe_fprem (VOID)
{
  return 0;
}


/* _safe_fprem1 ordinal = 430, argument = 0 temporary */
static DWORD WINAPI msvcrt_safe_fprem1 (VOID)
{
  return 0;
}


/* _scalb ordinal = 431, argument = 0 temporary */
static DWORD WINAPI msvcrt_scalb (VOID)
{
  return 0;
}


/* _searchenv ordinal = 432, argument = 0 temporary */
static DWORD WINAPI msvcrt_searchenv (VOID)
{
  return 0;
}


/* _seh_longjmp_unwind ordinal = 433, argument = 4 temporary */
static DWORD WINAPI msvcrt_seh_longjmp_unwind (DWORD dwArgv0)
{
  return 0;
}


/* _set_error_mode ordinal = 434, argument = 0 temporary */
static DWORD WINAPI msvcrt_set_error_mode (VOID)
{
  return 0;
}


/* _set_sbh_threshold ordinal = 435, argument = 0 temporary */
static DWORD WINAPI msvcrt_set_sbh_threshold (VOID)
{
  return 0;
}


/* _seterrormode ordinal = 436, argument = 0 temporary */
static DWORD WINAPI msvcrt_seterrormode (VOID)
{
  return 0;
}


/* _setjmp ordinal = 437, argument = 0 temporary */
static DWORD WINAPI msvcrt_setjmp (VOID)
{
  return 0;
}


/* _setjmp3 ordinal = 438, argument = 0 temporary */
static DWORD WINAPI msvcrt_setjmp3 (VOID)
{
  return 0;
}


/* _setmaxstdio ordinal = 439, argument = 0 temporary */
static DWORD WINAPI msvcrt_setmaxstdio (VOID)
{
  return 0;
}


/* _setmbcp ordinal = 440, argument = 0 temporary */
static DWORD WINAPI msvcrt_setmbcp (VOID)
{
  return 0;
}


/* _setmode ordinal = 441, argument = 0 temporary */
static DWORD WINAPI msvcrt_setmode (VOID)
{
  return 0;
}


/* _setsystime ordinal = 442, argument = 0 temporary */
static DWORD WINAPI msvcrt_setsystime (VOID)
{
  return 0;
}


/* _sleep ordinal = 443, argument = 0 temporary */
static DWORD WINAPI msvcrt_sleep (VOID)
{
  return 0;
}


/* _snprintf ordinal = 444, argument = 0 temporary */
static DWORD WINAPI msvcrt_snprintf (VOID)
{
  return 0;
}


/* _snwprintf ordinal = 445, argument = 0 temporary */
static DWORD WINAPI msvcrt_snwprintf (VOID)
{
  return 0;
}


/* _sopen ordinal = 446, argument = 0 temporary */
static DWORD WINAPI msvcrt_sopen (VOID)
{
  return 0;
}


/* _spawnl ordinal = 447, argument = 0 temporary */
static DWORD WINAPI msvcrt_spawnl (VOID)
{
  return 0;
}


/* _spawnle ordinal = 448, argument = 0 temporary */
static DWORD WINAPI msvcrt_spawnle (VOID)
{
  return 0;
}


/* _spawnlp ordinal = 449, argument = 0 temporary */
static DWORD WINAPI msvcrt_spawnlp (VOID)
{
  return 0;
}


/* _spawnlpe ordinal = 450, argument = 0 temporary */
static DWORD WINAPI msvcrt_spawnlpe (VOID)
{
  return 0;
}


/* _spawnv ordinal = 451, argument = 0 temporary */
static DWORD WINAPI msvcrt_spawnv (VOID)
{
  return 0;
}


/* _spawnve ordinal = 452, argument = 0 temporary */
static DWORD WINAPI msvcrt_spawnve (VOID)
{
  return 0;
}


/* _spawnvp ordinal = 453, argument = 0 temporary */
static DWORD WINAPI msvcrt_spawnvp (VOID)
{
  return 0;
}


/* _spawnvpe ordinal = 454, argument = 0 temporary */
static DWORD WINAPI msvcrt_spawnvpe (VOID)
{
  return 0;
}


/* _splitpath ordinal = 455, argument = 0 temporary */
static DWORD WINAPI msvcrt_splitpath (VOID)
{
  return 0;
}


/* _stat ordinal = 456, argument = 0 temporary */
static DWORD WINAPI msvcrt_stat (VOID)
{
  return 0;
}


/* _stat64 ordinal = 457, argument = 0 temporary */
static DWORD WINAPI msvcrt_stat64 (VOID)
{
  return 0;
}


/* _stati64 ordinal = 458, argument = 0 temporary */
static DWORD WINAPI msvcrt_stati64 (VOID)
{
  return 0;
}


/* _statusfp ordinal = 459, argument = 0 temporary */
static DWORD WINAPI msvcrt_statusfp (VOID)
{
  return 0;
}


/* _strcmpi ordinal = 460, argument = 0 */
static int CDECL msvcrt_strcmpi (const char *string1, const char *string2)
{
  gchar *str1, *str2;
  gint result;

  str1 = w32ldr_utf8_from_mb (string1);
  str2 = w32ldr_utf8_from_mb (string2);
  result = g_strcasecmp (str1, str2);
  g_free (str1);
  g_free (str2);
  return result;
}


/* _strdate ordinal = 461, argument = 0 temporary */
static DWORD WINAPI msvcrt_strdate (VOID)
{
  return 0;
}


/* _strdup ordinal = 462, argument = 0 temporary */
static DWORD WINAPI msvcrt_strdup (VOID)
{
  return 0;
}


/* _strerror ordinal = 463, argument = 0 temporary */
static DWORD WINAPI msvcrt__strerror (VOID)
{
  return 0;
}


/* _stricmp ordinal = 464, argument = 0 temporary */
static DWORD WINAPI msvcrt_stricmp (VOID)
{
  return 0;
}


/* _stricoll ordinal = 465, argument = 0 temporary */
static DWORD WINAPI msvcrt_stricoll (VOID)
{
  return 0;
}


/* _strlwr ordinal = 466, argument = 0 temporary */
static DWORD WINAPI msvcrt_strlwr (VOID)
{
  return 0;
}


/* _strncoll ordinal = 467, argument = 0 temporary */
static DWORD WINAPI msvcrt_strncoll (VOID)
{
  return 0;
}


/* _strnicmp ordinal = 468, argument = 0 temporary */
static DWORD WINAPI msvcrt_strnicmp (VOID)
{
  return 0;
}


/* _strnicoll ordinal = 469, argument = 0 temporary */
static DWORD WINAPI msvcrt_strnicoll (VOID)
{
  return 0;
}


/* _strnset ordinal = 470, argument = 0 temporary */
static DWORD WINAPI msvcrt_strnset (VOID)
{
  return 0;
}


/* _strrev ordinal = 471, argument = 0 temporary */
static DWORD WINAPI msvcrt_strrev (VOID)
{
  return 0;
}


/* _strset ordinal = 472, argument = 0 temporary */
static DWORD WINAPI msvcrt_strset (VOID)
{
  return 0;
}


/* _strtime ordinal = 473, argument = 0 temporary */
static DWORD WINAPI msvcrt_strtime (VOID)
{
  return 0;
}


/* _strupr ordinal = 474, argument = 0 temporary */
static DWORD WINAPI msvcrt_strupr (VOID)
{
  return 0;
}


/* _swab ordinal = 475, argument = 0 temporary */
static DWORD WINAPI msvcrt_swab (VOID)
{
  return 0;
}


/* _sys_errlist ordinal = 476, argument = 0 temporary */
static DWORD WINAPI msvcrt_sys_errlist (VOID)
{
  return 0;
}


/* _sys_nerr ordinal = 477, argument = 0 temporary */
static DWORD WINAPI msvcrt_sys_nerr (VOID)
{
  return 0;
}


/* _tell ordinal = 478, argument = 0 temporary */
static DWORD WINAPI msvcrt_tell (VOID)
{
  return 0;
}


/* _telli64 ordinal = 479, argument = 0 temporary */
static DWORD WINAPI msvcrt_telli64 (VOID)
{
  return 0;
}


/* _tempnam ordinal = 480, argument = 0 temporary */
static DWORD WINAPI msvcrt_tempnam (VOID)
{
  return 0;
}


/* _time64 ordinal = 481, argument = 0 temporary */
static DWORD WINAPI msvcrt_time64 (VOID)
{
  return 0;
}


/* _timezone ordinal = 482, argument = 0 temporary */
static DWORD WINAPI msvcrt_timezone (VOID)
{
  return 0;
}


/* _tolower ordinal = 483, argument = 0 temporary */
static DWORD WINAPI msvcrt__tolower (VOID)
{
  return 0;
}


/* _toupper ordinal = 484, argument = 0 temporary */
static DWORD WINAPI msvcrt__toupper (VOID)
{
  return 0;
}


/* _tzname ordinal = 485, argument = 0 temporary */
static DWORD WINAPI msvcrt_tzname (VOID)
{
  return 0;
}


/* _tzset ordinal = 486, argument = 0 temporary */
static DWORD WINAPI msvcrt_tzset (VOID)
{
  return 0;
}


/* _ui64toa ordinal = 487, argument = 0 temporary */
static DWORD WINAPI msvcrt_ui64toa (VOID)
{
  return 0;
}


/* _ui64tow ordinal = 488, argument = 0 temporary */
static DWORD WINAPI msvcrt_ui64tow (VOID)
{
  return 0;
}


/* _ultoa ordinal = 489, argument = 0 temporary */
static DWORD WINAPI msvcrt_ultoa (VOID)
{
  return 0;
}


/* _ultow ordinal = 490, argument = 0 temporary */
static DWORD WINAPI msvcrt_ultow (VOID)
{
  return 0;
}


/* _umask ordinal = 491, argument = 0 temporary */
static DWORD WINAPI msvcrt_umask (VOID)
{
  return 0;
}


/* _ungetch ordinal = 492, argument = 0 temporary */
static DWORD WINAPI msvcrt_ungetch (VOID)
{
  return 0;
}


/* _unlink ordinal = 493, argument = 0 temporary */
static DWORD WINAPI msvcrt_unlink (VOID)
{
  return 0;
}


/* _unloaddll ordinal = 494, argument = 0 temporary */
static DWORD WINAPI msvcrt_unloaddll (VOID)
{
  return 0;
}


/* _unlock ordinal = 495, argument = 0 temporary */
static DWORD WINAPI msvcrt_unlock (VOID)
{
  return 0;
}


/* _utime ordinal = 496, argument = 0 temporary */
static DWORD WINAPI msvcrt_utime (VOID)
{
  return 0;
}


/* _utime64 ordinal = 497, argument = 0 temporary */
static DWORD WINAPI msvcrt_utime64 (VOID)
{
  return 0;
}


/* _vsnprintf ordinal = 498, argument = 0 temporary */
static DWORD WINAPI msvcrt_vsnprintf (VOID)
{
  return 0;
}


/* _vsnwprintf ordinal = 499, argument = 0 temporary */
static DWORD WINAPI msvcrt_vsnwprintf (VOID)
{
  return 0;
}


/* _waccess ordinal = 500, argument = 0 temporary */
static DWORD WINAPI msvcrt_waccess (VOID)
{
  return 0;
}


/* _wasctime ordinal = 501, argument = 0 temporary */
static DWORD WINAPI msvcrt_wasctime (VOID)
{
  return 0;
}


/* _wchdir ordinal = 502, argument = 0 temporary */
static DWORD WINAPI msvcrt_wchdir (VOID)
{
  return 0;
}


/* _wchmod ordinal = 503, argument = 0 temporary */
static DWORD WINAPI msvcrt_wchmod (VOID)
{
  return 0;
}


/* _wcmdln ordinal = 504, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcmdln (VOID)
{
  return 0;
}


/* _wcreat ordinal = 505, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcreat (VOID)
{
  return 0;
}


/* _wcsdup ordinal = 506, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsdup (VOID)
{
  return 0;
}


/* _wcsicmp ordinal = 507, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsicmp (VOID)
{
  return 0;
}


/* _wcsicoll ordinal = 508, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsicoll (VOID)
{
  return 0;
}


/* _wcslwr ordinal = 509, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcslwr (VOID)
{
  return 0;
}


/* _wcsncoll ordinal = 510, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsncoll (VOID)
{
  return 0;
}


/* _wcsnicmp ordinal = 511, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsnicmp (VOID)
{
  return 0;
}


/* _wcsnicoll ordinal = 512, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsnicoll (VOID)
{
  return 0;
}


/* _wcsnset ordinal = 513, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsnset (VOID)
{
  return 0;
}


/* _wcsrev ordinal = 514, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsrev (VOID)
{
  return 0;
}


/* _wcsset ordinal = 515, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsset (VOID)
{
  return 0;
}


/* _wcsupr ordinal = 516, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsupr (VOID)
{
  return 0;
}


/* _wctime ordinal = 517, argument = 0 temporary */
static DWORD WINAPI msvcrt_wctime (VOID)
{
  return 0;
}


/* _wctime64 ordinal = 518, argument = 0 temporary */
static DWORD WINAPI msvcrt_wctime64 (VOID)
{
  return 0;
}


/* _wenviron ordinal = 519, argument = 0 temporary */
static DWORD WINAPI msvcrt_wenviron (VOID)
{
  return 0;
}


/* _wexecl ordinal = 520, argument = 0 temporary */
static DWORD WINAPI msvcrt_wexecl (VOID)
{
  return 0;
}


/* _wexecle ordinal = 521, argument = 0 temporary */
static DWORD WINAPI msvcrt_wexecle (VOID)
{
  return 0;
}


/* _wexeclp ordinal = 522, argument = 0 temporary */
static DWORD WINAPI msvcrt_wexeclp (VOID)
{
  return 0;
}


/* _wexeclpe ordinal = 523, argument = 0 temporary */
static DWORD WINAPI msvcrt_wexeclpe (VOID)
{
  return 0;
}


/* _wexecv ordinal = 524, argument = 0 temporary */
static DWORD WINAPI msvcrt_wexecv (VOID)
{
  return 0;
}


/* _wexecve ordinal = 525, argument = 0 temporary */
static DWORD WINAPI msvcrt_wexecve (VOID)
{
  return 0;
}


/* _wexecvp ordinal = 526, argument = 0 temporary */
static DWORD WINAPI msvcrt_wexecvp (VOID)
{
  return 0;
}


/* _wexecvpe ordinal = 527, argument = 0 temporary */
static DWORD WINAPI msvcrt_wexecvpe (VOID)
{
  return 0;
}


/* _wfdopen ordinal = 528, argument = 0 temporary */
static DWORD WINAPI msvcrt_wfdopen (VOID)
{
  return 0;
}


/* _wfindfirst ordinal = 529, argument = 0 temporary */
static DWORD WINAPI msvcrt_wfindfirst (VOID)
{
  return 0;
}


/* _wfindfirst64 ordinal = 530, argument = 0 temporary */
static DWORD WINAPI msvcrt_wfindfirst64 (VOID)
{
  return 0;
}


/* _wfindfirsti64 ordinal = 531, argument = 0 temporary */
static DWORD WINAPI msvcrt_wfindfirsti64 (VOID)
{
  return 0;
}


/* _wfindnext ordinal = 532, argument = 0 temporary */
static DWORD WINAPI msvcrt_wfindnext (VOID)
{
  return 0;
}


/* _wfindnext64 ordinal = 533, argument = 0 temporary */
static DWORD WINAPI msvcrt_wfindnext64 (VOID)
{
  return 0;
}


/* _wfindnexti64 ordinal = 534, argument = 0 temporary */
static DWORD WINAPI msvcrt_wfindnexti64 (VOID)
{
  return 0;
}


/* _wfopen ordinal = 535, argument = 0 temporary */
static DWORD WINAPI msvcrt_wfopen (VOID)
{
  return 0;
}


/* _wfreopen ordinal = 536, argument = 0 temporary */
static DWORD WINAPI msvcrt_wfreopen (VOID)
{
  return 0;
}


/* _wfsopen ordinal = 537, argument = 0 temporary */
static DWORD WINAPI msvcrt_wfsopen (VOID)
{
  return 0;
}


/* _wfullpath ordinal = 538, argument = 0 temporary */
static DWORD WINAPI msvcrt_wfullpath (VOID)
{
  return 0;
}


/* _wgetcwd ordinal = 539, argument = 0 temporary */
static DWORD WINAPI msvcrt_wgetcwd (VOID)
{
  return 0;
}


/* _wgetdcwd ordinal = 540, argument = 0 temporary */
static DWORD WINAPI msvcrt_wgetdcwd (VOID)
{
  return 0;
}


/* _wgetenv ordinal = 541, argument = 0 temporary */
static DWORD WINAPI msvcrt_wgetenv (VOID)
{
  return 0;
}


/* _winmajor ordinal = 542, argument = 0 temporary */
static DWORD WINAPI msvcrt_winmajor (VOID)
{
  return 0;
}


/* _winminor ordinal = 543, argument = 0 temporary */
static DWORD WINAPI msvcrt_winminor (VOID)
{
  return 0;
}


/* _winver ordinal = 544, argument = 0 temporary */
static DWORD WINAPI msvcrt_winver (VOID)
{
  return 0;
}


/* _wmakepath ordinal = 545, argument = 0 temporary */
static DWORD WINAPI msvcrt_wmakepath (VOID)
{
  return 0;
}


/* _wmkdir ordinal = 546, argument = 0 temporary */
static DWORD WINAPI msvcrt_wmkdir (VOID)
{
  return 0;
}


/* _wmktemp ordinal = 547, argument = 0 temporary */
static DWORD WINAPI msvcrt_wmktemp (VOID)
{
  return 0;
}


/* _wopen ordinal = 548, argument = 0 temporary */
static DWORD WINAPI msvcrt_wopen (VOID)
{
  return 0;
}


/* _wperror ordinal = 549, argument = 0 temporary */
static DWORD WINAPI msvcrt_wperror (VOID)
{
  return 0;
}


/* _wpgmptr ordinal = 550, argument = 0 temporary */
static DWORD WINAPI msvcrt_wpgmptr (VOID)
{
  return 0;
}


/* _wpopen ordinal = 551, argument = 0 temporary */
static DWORD WINAPI msvcrt_wpopen (VOID)
{
  return 0;
}


/* _wputenv ordinal = 552, argument = 0 temporary */
static DWORD WINAPI msvcrt_wputenv (VOID)
{
  return 0;
}


/* _wremove ordinal = 553, argument = 0 temporary */
static DWORD WINAPI msvcrt_wremove (VOID)
{
  return 0;
}


/* _wrename ordinal = 554, argument = 0 temporary */
static DWORD WINAPI msvcrt_wrename (VOID)
{
  return 0;
}


/* _write ordinal = 555, argument = 0 temporary */
static DWORD WINAPI msvcrt_write (VOID)
{
  return 0;
}


/* _wrmdir ordinal = 556, argument = 0 temporary */
static DWORD WINAPI msvcrt_wrmdir (VOID)
{
  return 0;
}


/* _wsearchenv ordinal = 557, argument = 0 temporary */
static DWORD WINAPI msvcrt_wsearchenv (VOID)
{
  return 0;
}


/* _wsetlocale ordinal = 558, argument = 0 temporary */
static DWORD WINAPI msvcrt_wsetlocale (VOID)
{
  return 0;
}


/* _wsopen ordinal = 559, argument = 0 temporary */
static DWORD WINAPI msvcrt_wsopen (VOID)
{
  return 0;
}


/* _wspawnl ordinal = 560, argument = 0 temporary */
static DWORD WINAPI msvcrt_wspawnl (VOID)
{
  return 0;
}


/* _wspawnle ordinal = 561, argument = 0 temporary */
static DWORD WINAPI msvcrt_wspawnle (VOID)
{
  return 0;
}


/* _wspawnlp ordinal = 562, argument = 0 temporary */
static DWORD WINAPI msvcrt_wspawnlp (VOID)
{
  return 0;
}


/* _wspawnlpe ordinal = 563, argument = 0 temporary */
static DWORD WINAPI msvcrt_wspawnlpe (VOID)
{
  return 0;
}


/* _wspawnv ordinal = 564, argument = 0 temporary */
static DWORD WINAPI msvcrt_wspawnv (VOID)
{
  return 0;
}


/* _wspawnve ordinal = 565, argument = 0 temporary */
static DWORD WINAPI msvcrt_wspawnve (VOID)
{
  return 0;
}


/* _wspawnvp ordinal = 566, argument = 0 temporary */
static DWORD WINAPI msvcrt_wspawnvp (VOID)
{
  return 0;
}


/* _wspawnvpe ordinal = 567, argument = 0 temporary */
static DWORD WINAPI msvcrt_wspawnvpe (VOID)
{
  return 0;
}


/* _wsplitpath ordinal = 568, argument = 0 temporary */
static DWORD WINAPI msvcrt_wsplitpath (VOID)
{
  return 0;
}


/* _wstat ordinal = 569, argument = 0 temporary */
static DWORD WINAPI msvcrt_wstat (VOID)
{
  return 0;
}


/* _wstat64 ordinal = 570, argument = 0 temporary */
static DWORD WINAPI msvcrt_wstat64 (VOID)
{
  return 0;
}


/* _wstati64 ordinal = 571, argument = 0 temporary */
static DWORD WINAPI msvcrt_wstati64 (VOID)
{
  return 0;
}


/* _wstrdate ordinal = 572, argument = 0 temporary */
static DWORD WINAPI msvcrt_wstrdate (VOID)
{
  return 0;
}


/* _wstrtime ordinal = 573, argument = 0 temporary */
static DWORD WINAPI msvcrt_wstrtime (VOID)
{
  return 0;
}


/* _wsystem ordinal = 574, argument = 0 temporary */
static DWORD WINAPI msvcrt_wsystem (VOID)
{
  return 0;
}


/* _wtempnam ordinal = 575, argument = 0 temporary */
static DWORD WINAPI msvcrt_wtempnam (VOID)
{
  return 0;
}


/* _wtmpnam ordinal = 576, argument = 0 temporary */
static DWORD WINAPI msvcrt_wtmpnam (VOID)
{
  return 0;
}


/* _wtoi ordinal = 577, argument = 0 temporary */
static DWORD WINAPI msvcrt_wtoi (VOID)
{
  return 0;
}


/* _wtoi64 ordinal = 578, argument = 0 temporary */
static DWORD WINAPI msvcrt_wtoi64 (VOID)
{
  return 0;
}


/* _wtol ordinal = 579, argument = 0 temporary */
static DWORD WINAPI msvcrt_wtol (VOID)
{
  return 0;
}


/* _wunlink ordinal = 580, argument = 0 temporary */
static DWORD WINAPI msvcrt_wunlink (VOID)
{
  return 0;
}


/* _wutime ordinal = 581, argument = 0 temporary */
static DWORD WINAPI msvcrt_wutime (VOID)
{
  return 0;
}


/* _wutime64 ordinal = 582, argument = 0 temporary */
static DWORD WINAPI msvcrt_wutime64 (VOID)
{
  return 0;
}


/* _y0 ordinal = 583, argument = 0 temporary */
static DWORD WINAPI msvcrt_y0 (VOID)
{
  return 0;
}


/* _y1 ordinal = 584, argument = 0 temporary */
static DWORD WINAPI msvcrt_y1 (VOID)
{
  return 0;
}


/* _yn ordinal = 585, argument = 0 temporary */
static DWORD WINAPI msvcrt_yn (VOID)
{
  return 0;
}


/* abort ordinal = 586, argument = 0 temporary */
static DWORD WINAPI msvcrt_abort (VOID)
{
  return 0;
}


/* abs ordinal = 587, argument = 0 temporary */
static DWORD WINAPI msvcrt_abs (VOID)
{
  return 0;
}


/* acos ordinal = 588, argument = 0 temporary */
static DWORD WINAPI msvcrt_acos (VOID)
{
  return 0;
}


/* asctime ordinal = 589, argument = 0 temporary */
static DWORD WINAPI msvcrt_asctime (VOID)
{
  return 0;
}


/* asin ordinal = 590, argument = 0 temporary */
static DWORD WINAPI msvcrt_asin (VOID)
{
  return 0;
}


/* atan ordinal = 591, argument = 0 temporary */
static DWORD WINAPI msvcrt_atan (VOID)
{
  return 0;
}


/* atan2 ordinal = 592, argument = 0 temporary */
static DWORD WINAPI msvcrt_atan2 (VOID)
{
  return 0;
}


/* atexit ordinal = 593, argument = 0 temporary */
static DWORD WINAPI msvcrt_atexit (VOID)
{
  return 0;
}


/* atof ordinal = 594, argument = 0 */
static CDECL double msvcrt_atof (const char *string)
{
  return g_strtod (string, NULL);
}


/* atoi ordinal = 595, argument = 0 temporary */
static DWORD WINAPI msvcrt_atoi (VOID)
{
  return 0;
}


/* atol ordinal = 596, argument = 0 temporary */
static DWORD WINAPI msvcrt_atol (VOID)
{
  return 0;
}


/* bsearch ordinal = 597, argument = 0 temporary */
static DWORD WINAPI msvcrt_bsearch (VOID)
{
  return 0;
}


/* calloc ordinal = 598, argument = 0 temporary */
static DWORD WINAPI msvcrt_calloc (VOID)
{
  return 0;
}


/* ceil ordinal = 599, argument = 0 temporary */
static DWORD WINAPI msvcrt_ceil (VOID)
{
  return 0;
}


/* clearerr ordinal = 600, argument = 0 temporary */
static DWORD WINAPI msvcrt_clearerr (VOID)
{
  return 0;
}


/* clock ordinal = 601, argument = 0 temporary */
static DWORD WINAPI msvcrt_clock (VOID)
{
  return 0;
}


/* cos ordinal = 602, argument = 0 temporary */
static DWORD WINAPI msvcrt_cos (VOID)
{
  return 0;
}


/* cosh ordinal = 603, argument = 0 temporary */
static DWORD WINAPI msvcrt_cosh (VOID)
{
  return 0;
}


/* ctime ordinal = 604, argument = 0 temporary */
static DWORD WINAPI msvcrt_ctime (VOID)
{
  return 0;
}


/* difftime ordinal = 605, argument = 0 temporary */
static DWORD WINAPI msvcrt_difftime (VOID)
{
  return 0;
}


/* div ordinal = 606, argument = 0 temporary */
static DWORD WINAPI msvcrt_div (VOID)
{
  return 0;
}


/* exit ordinal = 607, argument = 0 temporary */
static DWORD WINAPI msvcrt_exit (VOID)
{
  return 0;
}


/* exp ordinal = 608, argument = 0 temporary */
static DWORD WINAPI msvcrt_exp (VOID)
{
  return 0;
}


/* fabs ordinal = 609, argument = 0 temporary */
static DWORD WINAPI msvcrt_fabs (VOID)
{
  return 0;
}


/* fclose ordinal = 610, argument = 0 temporary */
static DWORD WINAPI msvcrt_fclose (VOID)
{
  return 0;
}


/* feof ordinal = 611, argument = 0 temporary */
static DWORD WINAPI msvcrt_feof (VOID)
{
  return 0;
}


/* ferror ordinal = 612, argument = 0 temporary */
static DWORD WINAPI msvcrt_ferror (VOID)
{
  return 0;
}


/* fflush ordinal = 613, argument = 0 temporary */
static DWORD WINAPI msvcrt_fflush (VOID)
{
  return 0;
}


/* fgetc ordinal = 614, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgetc (VOID)
{
  return 0;
}


/* fgetpos ordinal = 615, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgetpos (VOID)
{
  return 0;
}


/* fgets ordinal = 616, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgets (VOID)
{
  return 0;
}


/* fgetwc ordinal = 617, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgetwc (VOID)
{
  return 0;
}


/* fgetws ordinal = 618, argument = 0 temporary */
static DWORD WINAPI msvcrt_fgetws (VOID)
{
  return 0;
}


/* floor ordinal = 619, argument = 0 temporary */
static DWORD WINAPI msvcrt_floor (VOID)
{
  return 0;
}


/* fmod ordinal = 620, argument = 0 temporary */
static DWORD WINAPI msvcrt_fmod (VOID)
{
  return 0;
}


/* fopen ordinal = 621, argument = 0 temporary */
static DWORD WINAPI msvcrt_fopen (VOID)
{
  return 0;
}


/* fprintf ordinal = 622, argument = 0 temporary */
static DWORD WINAPI msvcrt_fprintf (VOID)
{
  return 0;
}


/* fputc ordinal = 623, argument = 0 temporary */
static DWORD WINAPI msvcrt_fputc (VOID)
{
  return 0;
}


/* fputs ordinal = 624, argument = 0 temporary */
static DWORD WINAPI msvcrt_fputs (VOID)
{
  return 0;
}


/* fputwc ordinal = 625, argument = 0 temporary */
static DWORD WINAPI msvcrt_fputwc (VOID)
{
  return 0;
}


/* fputws ordinal = 626, argument = 0 temporary */
static DWORD WINAPI msvcrt_fputws (VOID)
{
  return 0;
}


/* fread ordinal = 627, argument = 0 temporary */
static DWORD WINAPI msvcrt_fread (VOID)
{
  return 0;
}


/* free ordinal = 628, argument = 0 */
static void msvcrt_free (void *memblock)
{
  g_free (memblock);
}


/* freopen ordinal = 629, argument = 0 temporary */
static DWORD WINAPI msvcrt_freopen (VOID)
{
  return 0;
}


/* frexp ordinal = 630, argument = 0 temporary */
static DWORD WINAPI msvcrt_frexp (VOID)
{
  return 0;
}


/* fscanf ordinal = 631, argument = 0 temporary */
static DWORD WINAPI msvcrt_fscanf (VOID)
{
  return 0;
}


/* fseek ordinal = 632, argument = 0 temporary */
static DWORD WINAPI msvcrt_fseek (VOID)
{
  return 0;
}


/* fsetpos ordinal = 633, argument = 0 temporary */
static DWORD WINAPI msvcrt_fsetpos (VOID)
{
  return 0;
}


/* ftell ordinal = 634, argument = 0 temporary */
static DWORD WINAPI msvcrt_ftell (VOID)
{
  return 0;
}


/* fwprintf ordinal = 635, argument = 0 temporary */
static DWORD WINAPI msvcrt_fwprintf (VOID)
{
  return 0;
}


/* fwrite ordinal = 636, argument = 0 temporary */
static DWORD WINAPI msvcrt_fwrite (VOID)
{
  return 0;
}


/* fwscanf ordinal = 637, argument = 0 temporary */
static DWORD WINAPI msvcrt_fwscanf (VOID)
{
  return 0;
}


/* getc ordinal = 638, argument = 0 temporary */
static DWORD WINAPI msvcrt_getc (VOID)
{
  return 0;
}


/* getchar ordinal = 639, argument = 0 temporary */
static DWORD WINAPI msvcrt_getchar (VOID)
{
  return 0;
}


/* getenv ordinal = 640, argument = 0 temporary */
static DWORD WINAPI msvcrt_getenv (VOID)
{
  return 0;
}


/* gets ordinal = 641, argument = 0 temporary */
static DWORD WINAPI msvcrt_gets (VOID)
{
  return 0;
}


/* getwc ordinal = 642, argument = 0 temporary */
static DWORD WINAPI msvcrt_getwc (VOID)
{
  return 0;
}


/* getwchar ordinal = 643, argument = 0 temporary */
static DWORD WINAPI msvcrt_getwchar (VOID)
{
  return 0;
}


/* gmtime ordinal = 644, argument = 0 temporary */
static DWORD WINAPI msvcrt_gmtime (VOID)
{
  return 0;
}


/* is_wctype ordinal = 645, argument = 0 temporary */
static DWORD WINAPI msvcrt_is_wctype (VOID)
{
  return 0;
}


/* isalnum ordinal = 646, argument = 0 */
static int CDECL msvcrt_isalnum (int c)
{
  return g_ascii_isalnum (c);
}


/* isalpha ordinal = 647, argument = 0 temporary */
static DWORD WINAPI msvcrt_isalpha (VOID)
{
  return 0;
}


/* iscntrl ordinal = 648, argument = 0 temporary */
static DWORD WINAPI msvcrt_iscntrl (VOID)
{
  return 0;
}


/* isdigit ordinal = 649, argument = 0 temporary */
static DWORD WINAPI msvcrt_isdigit (VOID)
{
  return 0;
}


/* isgraph ordinal = 650, argument = 0 temporary */
static DWORD WINAPI msvcrt_isgraph (VOID)
{
  return 0;
}


/* isleadbyte ordinal = 651, argument = 0 temporary */
static DWORD WINAPI msvcrt_isleadbyte (VOID)
{
  return 0;
}


/* islower ordinal = 652, argument = 0 temporary */
static DWORD WINAPI msvcrt_islower (VOID)
{
  return 0;
}


/* isprint ordinal = 653, argument = 0 temporary */
static DWORD WINAPI msvcrt_isprint (VOID)
{
  return 0;
}


/* ispunct ordinal = 654, argument = 0 temporary */
static DWORD WINAPI msvcrt_ispunct (VOID)
{
  return 0;
}


/* isspace ordinal = 655, argument = 0 temporary */
static DWORD WINAPI msvcrt_isspace (VOID)
{
  return 0;
}


/* isupper ordinal = 656, argument = 0 temporary */
static DWORD WINAPI msvcrt_isupper (VOID)
{
  return 0;
}


/* iswalnum ordinal = 657, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswalnum (VOID)
{
  return 0;
}


/* iswalpha ordinal = 658, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswalpha (VOID)
{
  return 0;
}


/* iswascii ordinal = 659, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswascii (VOID)
{
  return 0;
}


/* iswcntrl ordinal = 660, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswcntrl (VOID)
{
  return 0;
}


/* iswctype ordinal = 661, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswctype (VOID)
{
  return 0;
}


/* iswdigit ordinal = 662, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswdigit (VOID)
{
  return 0;
}


/* iswgraph ordinal = 663, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswgraph (VOID)
{
  return 0;
}


/* iswlower ordinal = 664, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswlower (VOID)
{
  return 0;
}


/* iswprint ordinal = 665, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswprint (VOID)
{
  return 0;
}


/* iswpunct ordinal = 666, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswpunct (VOID)
{
  return 0;
}


/* iswspace ordinal = 667, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswspace (VOID)
{
  return 0;
}


/* iswupper ordinal = 668, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswupper (VOID)
{
  return 0;
}


/* iswxdigit ordinal = 669, argument = 0 temporary */
static DWORD WINAPI msvcrt_iswxdigit (VOID)
{
  return 0;
}


/* isxdigit ordinal = 670, argument = 0 temporary */
static DWORD WINAPI msvcrt_isxdigit (VOID)
{
  return 0;
}


/* labs ordinal = 671, argument = 0 temporary */
static DWORD WINAPI msvcrt_labs (VOID)
{
  return 0;
}


/* ldexp ordinal = 672, argument = 0 temporary */
static DWORD WINAPI msvcrt_ldexp (VOID)
{
  return 0;
}


/* ldiv ordinal = 673, argument = 0 temporary */
static DWORD WINAPI msvcrt_ldiv (VOID)
{
  return 0;
}


/* localeconv ordinal = 674, argument = 0 temporary */
static DWORD WINAPI msvcrt_localeconv (VOID)
{
  return 0;
}


/* localtime ordinal = 675, argument = 0 temporary */
static DWORD WINAPI msvcrt_localtime (VOID)
{
  return 0;
}


/* log ordinal = 676, argument = 0 temporary */
static DWORD WINAPI msvcrt_log (VOID)
{
  return 0;
}


/* log10 ordinal = 677, argument = 0 temporary */
static DWORD WINAPI msvcrt_log10 (VOID)
{
  return 0;
}


/* longjmp ordinal = 678, argument = 0 temporary */
static DWORD WINAPI msvcrt_longjmp (VOID)
{
  return 0;
}


/* malloc ordinal = 679, argument = 0 */
static void CDECL *msvcrt_malloc (size_t size)
{
  return g_malloc (size);
}


/* mblen ordinal = 680, argument = 0 temporary */
static DWORD WINAPI msvcrt_mblen (VOID)
{
  return 0;
}


/* mbstowcs ordinal = 681, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbstowcs (VOID)
{
  return 0;
}


/* mbtowc ordinal = 682, argument = 0 temporary */
static DWORD WINAPI msvcrt_mbtowc (VOID)
{
  return 0;
}


/* memchr ordinal = 683, argument = 0 temporary */
static DWORD WINAPI msvcrt_memchr (VOID)
{
  return 0;
}


/* memcmp ordinal = 684, argument = 0 temporary */
static DWORD WINAPI msvcrt_memcmp (VOID)
{
  return 0;
}


/* memcpy ordinal = 685, argument = 0 */
static void CDECL *msvcrt_memcpy (void *dst, const void *src, size_t n)
{
  g_memmove (dst, src, n);
  return dst;
}


/* memmove ordinal = 686, argument = 0 */
static void CDECL *msvcrt_memmove (void *dst, const void *src, size_t n)
{
  g_memmove (dst, src, n);
  return dst;
}


/* memset ordinal = 687, argument = 0 temporary */
static DWORD WINAPI msvcrt_memset (VOID)
{
  return 0;
}


/* mktime ordinal = 688, argument = 0 temporary */
static DWORD WINAPI msvcrt_mktime (VOID)
{
  return 0;
}


/* modf ordinal = 689, argument = 0 temporary */
static DWORD WINAPI msvcrt_modf (VOID)
{
  return 0;
}


/* perror ordinal = 690, argument = 0 temporary */
static DWORD WINAPI msvcrt_perror (VOID)
{
  return 0;
}


/* pow ordinal = 691, argument = 0 temporary */
static DWORD WINAPI msvcrt_pow (VOID)
{
  return 0;
}


/* printf ordinal = 692, argument = 0 temporary */
static DWORD WINAPI msvcrt_printf (VOID)
{
  return 0;
}


/* putc ordinal = 693, argument = 0 temporary */
static DWORD WINAPI msvcrt_putc (VOID)
{
  return 0;
}


/* putchar ordinal = 694, argument = 0 temporary */
static DWORD WINAPI msvcrt_putchar (VOID)
{
  return 0;
}


/* puts ordinal = 695, argument = 0 temporary */
static DWORD WINAPI msvcrt_puts (VOID)
{
  return 0;
}


/* putwc ordinal = 696, argument = 0 temporary */
static DWORD WINAPI msvcrt_putwc (VOID)
{
  return 0;
}


/* putwchar ordinal = 697, argument = 0 temporary */
static DWORD WINAPI msvcrt_putwchar (VOID)
{
  return 0;
}


/* qsort ordinal = 698, argument = 0 temporary */
static DWORD WINAPI msvcrt_qsort (VOID)
{
  return 0;
}


/* raise ordinal = 699, argument = 0 temporary */
static DWORD WINAPI msvcrt_raise (VOID)
{
  return 0;
}


/* rand ordinal = 700, argument = 0 */
static int CDECL msvcrt_rand (void)
{
  return rand ();
}


/* realloc ordinal = 701, argument = 0 temporary */
static DWORD WINAPI msvcrt_realloc (VOID)
{
  return 0;
}


/* remove ordinal = 702, argument = 0 temporary */
static DWORD WINAPI msvcrt_remove (VOID)
{
  return 0;
}


/* rename ordinal = 703, argument = 0 temporary */
static DWORD WINAPI msvcrt_rename (VOID)
{
  return 0;
}


/* rewind ordinal = 704, argument = 0 temporary */
static DWORD WINAPI msvcrt_rewind (VOID)
{
  return 0;
}


/* scanf ordinal = 705, argument = 0 temporary */
static DWORD WINAPI msvcrt_scanf (VOID)
{
  return 0;
}


/* setbuf ordinal = 706, argument = 0 temporary */
static DWORD WINAPI msvcrt_setbuf (VOID)
{
  return 0;
}


/* setlocale ordinal = 707, argument = 0 temporary */
static DWORD WINAPI msvcrt_setlocale (VOID)
{
  return 0;
}


/* setvbuf ordinal = 708, argument = 0 temporary */
static DWORD WINAPI msvcrt_setvbuf (VOID)
{
  return 0;
}


/* signal ordinal = 709, argument = 0 temporary */
static DWORD WINAPI msvcrt_signal (VOID)
{
  return 0;
}


/* sin ordinal = 710, argument = 0 temporary */
static DWORD WINAPI msvcrt_sin (VOID)
{
  return 0;
}


/* sinh ordinal = 711, argument = 0 temporary */
static DWORD WINAPI msvcrt_sinh (VOID)
{
  return 0;
}


/* sprintf ordinal = 712, argument = 0 temporary */
static DWORD WINAPI msvcrt_sprintf (VOID)
{
  return 0;
}


/* sqrt ordinal = 713, argument = 0 temporary */
static DWORD WINAPI msvcrt_sqrt (VOID)
{
  return 0;
}


/* srand ordinal = 714, argument = 0 */
static void CDECL msvcrt_srand (unsigned int seed)
{
  return srand (seed);
}


/* sscanf ordinal = 715, argument = 0 temporary */
static DWORD WINAPI msvcrt_sscanf (VOID)
{
  return 0;
}


/* strcat ordinal = 716, argument = 0 temporary */
static DWORD WINAPI msvcrt_strcat (VOID)
{
  return 0;
}


/* strchr ordinal = 717, argument = 0 */
static char CDECL *msvcrt_strchr (const char *string, int c)
{
  return g_strchr (string, c);
}


/* strcmp ordinal = 718, argument = 0 temporary */
static DWORD WINAPI msvcrt_strcmp (VOID)
{
  return 0;
}


/* strcoll ordinal = 719, argument = 0 temporary */
static DWORD WINAPI msvcrt_strcoll (VOID)
{
  return 0;
}


/* strcpy ordinal = 720, argument = 0 temporary */
static DWORD WINAPI msvcrt_strcpy (VOID)
{
  return 0;
}


/* strcspn ordinal = 721, argument = 0 temporary */
static DWORD WINAPI msvcrt_strcspn (VOID)
{
  return 0;
}


/* strerror ordinal = 722, argument = 0 temporary */
static DWORD WINAPI msvcrt_strerror (VOID)
{
  return 0;
}


/* strftime ordinal = 723, argument = 0 temporary */
static DWORD WINAPI msvcrt_strftime (VOID)
{
  return 0;
}


/* strlen ordinal = 724, argument = 0 temporary */
static DWORD WINAPI msvcrt_strlen (VOID)
{
  return 0;
}


/* strncat ordinal = 725, argument = 0 temporary */
static DWORD WINAPI msvcrt_strncat (VOID)
{
  return 0;
}


/* strncmp ordinal = 726, argument = 0 temporary */
static DWORD WINAPI msvcrt_strncmp (VOID)
{
  return 0;
}


/* strncpy ordinal = 727, argument = 0 temporary */
static DWORD WINAPI msvcrt_strncpy (VOID)
{
  return 0;
}


/* strpbrk ordinal = 728, argument = 0 temporary */
static DWORD WINAPI msvcrt_strpbrk (VOID)
{
  return 0;
}


/* strrchr ordinal = 729, argument = 0 */
static char CDECL *msvcrt_strrchr (const char *string, int c)
{
  return g_strrchr (string, c);
}


/* strspn ordinal = 730, argument = 0 temporary */
static DWORD WINAPI msvcrt_strspn (VOID)
{
  return 0;
}


/* strstr ordinal = 731, argument = 0 temporary */
static DWORD WINAPI msvcrt_strstr (VOID)
{
  return 0;
}


/* strtod ordinal = 732, argument = 0 temporary */
static DWORD WINAPI msvcrt_strtod (VOID)
{
  return 0;
}


/* strtok ordinal = 733, argument = 0 temporary */
static DWORD WINAPI msvcrt_strtok (VOID)
{
  return 0;
}


/* strtol ordinal = 734, argument = 0 temporary */
static DWORD WINAPI msvcrt_strtol (VOID)
{
  return 0;
}


/* strtoul ordinal = 735, argument = 0 temporary */
static DWORD WINAPI msvcrt_strtoul (VOID)
{
  return 0;
}


/* strxfrm ordinal = 736, argument = 0 temporary */
static DWORD WINAPI msvcrt_strxfrm (VOID)
{
  return 0;
}


/* swprintf ordinal = 737, argument = 0 temporary */
static DWORD WINAPI msvcrt_swprintf (VOID)
{
  return 0;
}


/* swscanf ordinal = 738, argument = 0 temporary */
static DWORD WINAPI msvcrt_swscanf (VOID)
{
  return 0;
}


/* system ordinal = 739, argument = 0 temporary */
static DWORD WINAPI msvcrt_system (VOID)
{
  return 0;
}


/* tan ordinal = 740, argument = 0 temporary */
static DWORD WINAPI msvcrt_tan (VOID)
{
  return 0;
}


/* tanh ordinal = 741, argument = 0 temporary */
static DWORD WINAPI msvcrt_tanh (VOID)
{
  return 0;
}


/* time ordinal = 742, argument = 0 temporary */
static DWORD WINAPI msvcrt_time (VOID)
{
  return 0;
}


/* tmpfile ordinal = 743, argument = 0 temporary */
static DWORD WINAPI msvcrt_tmpfile (VOID)
{
  return 0;
}


/* tmpnam ordinal = 744, argument = 0 temporary */
static DWORD WINAPI msvcrt_tmpnam (VOID)
{
  return 0;
}


/* tolower ordinal = 745, argument = 0 temporary */
static DWORD WINAPI msvcrt_tolower (VOID)
{
  return 0;
}


/* toupper ordinal = 746, argument = 0 */
static int CDECL msvcrt_toupper (int c)
{
  return g_ascii_toupper (c);
}


/* towlower ordinal = 747, argument = 0 temporary */
static DWORD WINAPI msvcrt_towlower (VOID)
{
  return 0;
}


/* towupper ordinal = 748, argument = 0 temporary */
static DWORD WINAPI msvcrt_towupper (VOID)
{
  return 0;
}


/* ungetc ordinal = 749, argument = 0 temporary */
static DWORD WINAPI msvcrt_ungetc (VOID)
{
  return 0;
}


/* ungetwc ordinal = 750, argument = 0 temporary */
static DWORD WINAPI msvcrt_ungetwc (VOID)
{
  return 0;
}


/* vfprintf ordinal = 751, argument = 0 temporary */
static DWORD WINAPI msvcrt_vfprintf (VOID)
{
  return 0;
}


/* vfwprintf ordinal = 752, argument = 0 temporary */
static DWORD WINAPI msvcrt_vfwprintf (VOID)
{
  return 0;
}


/* vprintf ordinal = 753, argument = 0 temporary */
static DWORD WINAPI msvcrt_vprintf (VOID)
{
  return 0;
}


/* vsprintf ordinal = 754, argument = 0 temporary */
static DWORD WINAPI msvcrt_vsprintf (VOID)
{
  return 0;
}


/* vswprintf ordinal = 755, argument = 0 temporary */
static DWORD WINAPI msvcrt_vswprintf (VOID)
{
  return 0;
}


/* vwprintf ordinal = 756, argument = 0 temporary */
static DWORD WINAPI msvcrt_vwprintf (VOID)
{
  return 0;
}


/* wcscat ordinal = 757, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcscat (VOID)
{
  return 0;
}


/* wcschr ordinal = 758, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcschr (VOID)
{
  return 0;
}


/* wcscmp ordinal = 759, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcscmp (VOID)
{
  return 0;
}


/* wcscoll ordinal = 760, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcscoll (VOID)
{
  return 0;
}


/* wcscpy ordinal = 761, argument = 0 */
static gunichar2 CDECL *msvcrt_wcscpy (gunichar2 *string1, const gunichar2 *string2)
{
  gint i = 0;

  do
    string1[i] = string2[i];
  while (string2[i++] != '\0');
  return string1;
}


/* wcscspn ordinal = 762, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcscspn (VOID)
{
  return 0;
}


/* wcsftime ordinal = 763, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsftime (VOID)
{
  return 0;
}


/* wcslen ordinal = 764, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcslen (VOID)
{
  return 0;
}


/* wcsncat ordinal = 765, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsncat (VOID)
{
  return 0;
}


/* wcsncmp ordinal = 766, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsncmp (VOID)
{
  return 0;
}


/* wcsncpy ordinal = 767, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsncpy (VOID)
{
  return 0;
}


/* wcspbrk ordinal = 768, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcspbrk (VOID)
{
  return 0;
}


/* wcsrchr ordinal = 769, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsrchr (VOID)
{
  return 0;
}


/* wcsspn ordinal = 770, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsspn (VOID)
{
  return 0;
}


/* wcsstr ordinal = 771, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsstr (VOID)
{
  return 0;
}


/* wcstod ordinal = 772, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcstod (VOID)
{
  return 0;
}


/* wcstok ordinal = 773, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcstok (VOID)
{
  return 0;
}


/* wcstol ordinal = 774, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcstol (VOID)
{
  return 0;
}


/* wcstombs ordinal = 775, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcstombs (VOID)
{
  return 0;
}


/* wcstoul ordinal = 776, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcstoul (VOID)
{
  return 0;
}


/* wcsxfrm ordinal = 777, argument = 0 temporary */
static DWORD WINAPI msvcrt_wcsxfrm (VOID)
{
  return 0;
}


/* wctomb ordinal = 778, argument = 0 temporary */
static DWORD WINAPI msvcrt_wctomb (VOID)
{
  return 0;
}


/* wprintf ordinal = 779, argument = 0 temporary */
static DWORD WINAPI msvcrt_wprintf (VOID)
{
  return 0;
}


/* wscanf ordinal = 780, argument = 0 temporary */
static DWORD WINAPI msvcrt_wscanf (VOID)
{
  return 0;
}


W32LdrExport msvcrt_exports[] = {
{15, "??2@YAPAXI@Z", msvcrt_new},
{16, "??3@YAXPAX@Z", msvcrt_delete},
{52, "_CIacos", msvcrt_CIacos},
{53, "_CIasin", msvcrt_CIasin},
{54, "_CIatan", msvcrt_CIatan},
{55, "_CIatan2", msvcrt_CIatan2},
{56, "_CIcos", msvcrt_CIcos},
{57, "_CIcosh", msvcrt_CIcosh},
{58, "_CIexp", msvcrt_CIexp},
{59, "_CIfmod", msvcrt_CIfmod},
{60, "_CIlog", msvcrt_CIlog},
{61, "_CIlog10", msvcrt_CIlog10},
{62, "_CIpow", msvcrt_CIpow},
{63, "_CIsin", msvcrt_CIsin},
{64, "_CIsinh", msvcrt_CIsinh},
{65, "_CIsqrt", msvcrt_CIsqrt},
{66, "_CItan", msvcrt_CItan},
{67, "_CItanh", msvcrt_CItanh},
{68, "_CxxThrowException", msvcrt_CxxThrowException},
{69, "_EH_prolog", msvcrt_EH_prolog},
{70, "_Getdays", msvcrt_Getdays},
{71, "_Getmonths", msvcrt_Getmonths},
{72, "_Gettnames", msvcrt_Gettnames},
{73, "_HUGE", msvcrt_HUGE},
{74, "_Strftime", msvcrt_Strftime},
{75, "_XcptFilter", msvcrt_XcptFilter},
{76, "__CxxFrameHandler", msvcrt_CxxFrameHandler},
{77, "__CxxLongjmpUnwind", msvcrt_CxxLongjmpUnwind},
{78, "__RTCastToVoid", msvcrt_RTCastToVoid},
{79, "__RTDynamicCast", msvcrt_RTDynamicCast},
{80, "__RTtypeid", msvcrt_RTtypeid},
{81, "__STRINGTOLD", msvcrt_STRINGTOLD},
{82, "__argc", msvcrt_argc},
{83, "__argv", msvcrt_argv},
{84, "__badioinfo", msvcrt_badioinfo},
{85, "__crtCompareStringA", msvcrt_crtCompareStringA},
{86, "__crtGetLocaleInfoW", msvcrt_crtGetLocaleInfoW},
{87, "__crtLCMapStringA", msvcrt_crtLCMapStringA},
{88, "__dllonexit", msvcrt_dllonexit},
{89, "__doserrno", msvcrt_doserrno},
{90, "__fpecode", msvcrt_fpecode},
{91, "__getmainargs", msvcrt_getmainargs},
{92, "__initenv", msvcrt_initenv},
{93, "__isascii", msvcrt_isascii},
{94, "__iscsym", msvcrt_iscsym},
{95, "__iscsymf", msvcrt_iscsymf},
{96, "__lc_codepage", msvcrt_lc_codepage},
{97, "__lc_collate_cp", msvcrt_lc_collate_cp},
{98, "__lc_handle", msvcrt_lc_handle},
{99, "__lconv_init", msvcrt_lconv_init},
{100, "__mb_cur_max", msvcrt_mb_cur_max},
{101, "__p___argc", msvcrt_p___argc},
{102, "__p___argv", msvcrt_p___argv},
{103, "__p___initenv", msvcrt_p___initenv},
{104, "__p___mb_cur_max", msvcrt_p___mb_cur_max},
{105, "__p___wargv", msvcrt_p___wargv},
{106, "__p___winitenv", msvcrt_p___winitenv},
{107, "__p__acmdln", msvcrt_p__acmdln},
{108, "__p__amblksiz", msvcrt_p__amblksiz},
{109, "__p__commode", msvcrt_p__commode},
{110, "__p__daylight", msvcrt_p__daylight},
{111, "__p__dstbias", msvcrt_p__dstbias},
{112, "__p__environ", msvcrt_p__environ},
{113, "__p__fileinfo", msvcrt_p__fileinfo},
{114, "__p__fmode", msvcrt_p__fmode},
{115, "__p__iob", msvcrt_p__iob},
{116, "__p__mbcasemap", msvcrt_p__mbcasemap},
{117, "__p__mbctype", msvcrt_p__mbctype},
{118, "__p__osver", msvcrt_p__osver},
{119, "__p__pctype", msvcrt_p__pctype},
{120, "__p__pgmptr", msvcrt_p__pgmptr},
{121, "__p__pwctype", msvcrt_p__pwctype},
{122, "__p__timezone", msvcrt_p__timezone},
{123, "__p__tzname", msvcrt_p__tzname},
{124, "__p__wcmdln", msvcrt_p__wcmdln},
{125, "__p__wenviron", msvcrt_p__wenviron},
{126, "__p__winmajor", msvcrt_p__winmajor},
{127, "__p__winminor", msvcrt_p__winminor},
{128, "__p__winver", msvcrt_p__winver},
{129, "__p__wpgmptr", msvcrt_p__wpgmptr},
{130, "__pioinfo", msvcrt_pioinfo},
{131, "__pxcptinfoptrs", msvcrt_pxcptinfoptrs},
{132, "__set_app_type", msvcrt_set_app_type},
{133, "__setlc_active", msvcrt_setlc_active},
{134, "__setusermatherr", msvcrt_setusermatherr},
{135, "__threadhandle", msvcrt_threadhandle},
{136, "__threadid", msvcrt_threadid},
{137, "__toascii", msvcrt_toascii},
{138, "__unDName", msvcrt_unDName},
{139, "__unDNameEx", msvcrt_unDNameEx},
{140, "__unguarded_readlc_active", msvcrt_unguarded_readlc_active},
{141, "__wargv", msvcrt_wargv},
{142, "__wgetmainargs", msvcrt_wgetmainargs},
{143, "__winitenv", msvcrt_winitenv},
{144, "_abnormal_termination", msvcrt_abnormal_termination},
{145, "_access", msvcrt_access},
{146, "_acmdln", msvcrt_acmdln},
{147, "_adj_fdiv_m16i", msvcrt_adj_fdiv_m16i},
{148, "_adj_fdiv_m32", msvcrt_adj_fdiv_m32},
{149, "_adj_fdiv_m32i", msvcrt_adj_fdiv_m32i},
{150, "_adj_fdiv_m64", msvcrt_adj_fdiv_m64},
{151, "_adj_fdiv_r", msvcrt_adj_fdiv_r},
{152, "_adj_fdivr_m16i", msvcrt_adj_fdivr_m16i},
{153, "_adj_fdivr_m32", msvcrt_adj_fdivr_m32},
{154, "_adj_fdivr_m32i", msvcrt_adj_fdivr_m32i},
{155, "_adj_fdivr_m64", msvcrt_adj_fdivr_m64},
{156, "_adj_fpatan", msvcrt_adj_fpatan},
{157, "_adj_fprem", msvcrt_adj_fprem},
{158, "_adj_fprem1", msvcrt_adj_fprem1},
{159, "_adj_fptan", msvcrt_adj_fptan},
{160, "_adjust_fdiv", &msvcrt_adjust_fdiv},
{161, "_aexit_rtn", msvcrt_aexit_rtn},
{162, "_amsg_exit", msvcrt_amsg_exit},
{163, "_assert", msvcrt_assert},
{164, "_atodbl", msvcrt_atodbl},
{165, "_atoi64", msvcrt_atoi64},
{166, "_atoldbl", msvcrt_atoldbl},
{167, "_beep", msvcrt_beep},
{168, "_beginthread", msvcrt_beginthread},
{169, "_beginthreadex", msvcrt_beginthreadex},
{170, "_c_exit", msvcrt_c_exit},
{171, "_cabs", msvcrt_cabs},
{172, "_callnewh", msvcrt_callnewh},
{173, "_cexit", msvcrt_cexit},
{174, "_cgets", msvcrt_cgets},
{175, "_chdir", msvcrt_chdir},
{176, "_chdrive", msvcrt_chdrive},
{177, "_chgsign", msvcrt_chgsign},
{178, "_chkesp", msvcrt_chkesp},
{179, "_chmod", msvcrt_chmod},
{180, "_chsize", msvcrt_chsize},
{181, "_clearfp", msvcrt_clearfp},
{182, "_close", msvcrt_close},
{183, "_commit", msvcrt_commit},
{184, "_commode", msvcrt_commode},
{185, "_control87", msvcrt_control87},
{186, "_controlfp", msvcrt_controlfp},
{187, "_copysign", msvcrt_copysign},
{188, "_cprintf", msvcrt_cprintf},
{189, "_cputs", msvcrt_cputs},
{190, "_creat", msvcrt_creat},
{191, "_cscanf", msvcrt_cscanf},
{192, "_ctime64", msvcrt_ctime64},
{193, "_ctype", msvcrt_ctype},
{194, "_cwait", msvcrt_cwait},
{195, "_daylight", msvcrt_daylight},
{196, "_dstbias", msvcrt_dstbias},
{197, "_dup", msvcrt_dup},
{198, "_dup2", msvcrt_dup2},
{199, "_ecvt", msvcrt_ecvt},
{200, "_endthread", msvcrt_endthread},
{201, "_endthreadex", msvcrt_endthreadex},
{202, "_environ", msvcrt_environ},
{203, "_eof", msvcrt_eof},
{204, "_errno", msvcrt_errno},
{205, "_except_handler2", msvcrt_except_handler2},
{206, "_except_handler3", msvcrt_except_handler3},
{207, "_execl", msvcrt_execl},
{208, "_execle", msvcrt_execle},
{209, "_execlp", msvcrt_execlp},
{210, "_execlpe", msvcrt_execlpe},
{211, "_execv", msvcrt_execv},
{212, "_execve", msvcrt_execve},
{213, "_execvp", msvcrt_execvp},
{214, "_execvpe", msvcrt_execvpe},
{215, "_exit", msvcrt__exit},
{216, "_expand", msvcrt_expand},
{217, "_fcloseall", msvcrt_fcloseall},
{218, "_fcvt", msvcrt_fcvt},
{219, "_fdopen", msvcrt_fdopen},
{220, "_fgetchar", msvcrt_fgetchar},
{221, "_fgetwchar", msvcrt_fgetwchar},
{222, "_filbuf", msvcrt_filbuf},
{223, "_fileinfo", msvcrt_fileinfo},
{224, "_filelength", msvcrt_filelength},
{225, "_filelengthi64", msvcrt_filelengthi64},
{226, "_fileno", msvcrt_fileno},
{227, "_findclose", msvcrt_findclose},
{228, "_findfirst", msvcrt_findfirst},
{229, "_findfirst64", msvcrt_findfirst64},
{230, "_findfirsti64", msvcrt_findfirsti64},
{231, "_findnext", msvcrt_findnext},
{232, "_findnext64", msvcrt_findnext64},
{233, "_findnexti64", msvcrt_findnexti64},
{234, "_finite", msvcrt_finite},
{235, "_flsbuf", msvcrt_flsbuf},
{236, "_flushall", msvcrt_flushall},
{237, "_fmode", msvcrt_fmode},
{238, "_fpclass", msvcrt_fpclass},
{239, "_fpieee_flt", msvcrt_fpieee_flt},
{240, "_fpreset", msvcrt_fpreset},
{241, "_fputchar", msvcrt_fputchar},
{242, "_fputwchar", msvcrt_fputwchar},
{243, "_fsopen", msvcrt_fsopen},
{244, "_fstat", msvcrt_fstat},
{245, "_fstat64", msvcrt_fstat64},
{246, "_fstati64", msvcrt_fstati64},
{247, "_ftime", msvcrt_ftime},
{248, "_ftime64", msvcrt_ftime64},
{249, "_ftol", msvcrt_ftol},
{250, "_fullpath", msvcrt_fullpath},
{251, "_futime", msvcrt_futime},
{252, "_futime64", msvcrt_futime64},
{253, "_gcvt", msvcrt_gcvt},
{254, "_get_heap_handle", msvcrt_get_heap_handle},
{255, "_get_osfhandle", msvcrt_get_osfhandle},
{256, "_get_sbh_threshold", msvcrt_get_sbh_threshold},
{257, "_getch", msvcrt_getch},
{258, "_getche", msvcrt_getche},
{259, "_getcwd", msvcrt_getcwd},
{260, "_getdcwd", msvcrt_getdcwd},
{261, "_getdiskfree", msvcrt_getdiskfree},
{262, "_getdllprocaddr", msvcrt_getdllprocaddr},
{263, "_getdrive", msvcrt_getdrive},
{264, "_getdrives", msvcrt_getdrives},
{265, "_getmaxstdio", msvcrt_getmaxstdio},
{266, "_getmbcp", msvcrt_getmbcp},
{267, "_getpid", msvcrt_getpid},
{268, "_getsystime", msvcrt_getsystime},
{269, "_getw", msvcrt_getw},
{270, "_getws", msvcrt_getws},
{271, "_global_unwind2", msvcrt_global_unwind2},
{272, "_gmtime64", msvcrt_gmtime64},
{273, "_heapadd", msvcrt_heapadd},
{274, "_heapchk", msvcrt_heapchk},
{275, "_heapmin", msvcrt_heapmin},
{276, "_heapset", msvcrt_heapset},
{277, "_heapused", msvcrt_heapused},
{278, "_heapwalk", msvcrt_heapwalk},
{279, "_hypot", msvcrt_hypot},
{280, "_i64toa", msvcrt_i64toa},
{281, "_i64tow", msvcrt_i64tow},
{282, "_initterm", msvcrt_initterm},
{283, "_inp", msvcrt_inp},
{284, "_inpd", msvcrt_inpd},
{285, "_inpw", msvcrt_inpw},
{286, "_iob", msvcrt_iob},
{287, "_isatty", msvcrt_isatty},
{288, "_isctype", msvcrt_isctype},
{289, "_ismbbalnum", msvcrt_ismbbalnum},
{290, "_ismbbalpha", msvcrt_ismbbalpha},
{291, "_ismbbgraph", msvcrt_ismbbgraph},
{292, "_ismbbkalnum", msvcrt_ismbbkalnum},
{293, "_ismbbkana", msvcrt_ismbbkana},
{294, "_ismbbkprint", msvcrt_ismbbkprint},
{295, "_ismbbkpunct", msvcrt_ismbbkpunct},
{296, "_ismbblead", msvcrt_ismbblead},
{297, "_ismbbprint", msvcrt_ismbbprint},
{298, "_ismbbpunct", msvcrt_ismbbpunct},
{299, "_ismbbtrail", msvcrt_ismbbtrail},
{300, "_ismbcalnum", msvcrt_ismbcalnum},
{301, "_ismbcalpha", msvcrt_ismbcalpha},
{302, "_ismbcdigit", msvcrt_ismbcdigit},
{303, "_ismbcgraph", msvcrt_ismbcgraph},
{304, "_ismbchira", msvcrt_ismbchira},
{305, "_ismbckata", msvcrt_ismbckata},
{306, "_ismbcl0", msvcrt_ismbcl0},
{307, "_ismbcl1", msvcrt_ismbcl1},
{308, "_ismbcl2", msvcrt_ismbcl2},
{309, "_ismbclegal", msvcrt_ismbclegal},
{310, "_ismbclower", msvcrt_ismbclower},
{311, "_ismbcprint", msvcrt_ismbcprint},
{312, "_ismbcpunct", msvcrt_ismbcpunct},
{313, "_ismbcspace", msvcrt_ismbcspace},
{314, "_ismbcsymbol", msvcrt_ismbcsymbol},
{315, "_ismbcupper", msvcrt_ismbcupper},
{316, "_ismbslead", msvcrt_ismbslead},
{317, "_ismbstrail", msvcrt_ismbstrail},
{318, "_isnan", msvcrt_isnan},
{319, "_itoa", msvcrt_itoa},
{320, "_itow", msvcrt_itow},
{321, "_j0", msvcrt_j0},
{322, "_j1", msvcrt_j1},
{323, "_jn", msvcrt_jn},
{324, "_kbhit", msvcrt_kbhit},
{325, "_lfind", msvcrt_lfind},
{326, "_loaddll", msvcrt_loaddll},
{327, "_local_unwind2", msvcrt_local_unwind2},
{328, "_localtime64", msvcrt_localtime64},
{329, "_lock", msvcrt_lock},
{330, "_locking", msvcrt_locking},
{331, "_logb", msvcrt_logb},
{332, "_longjmpex", msvcrt_longjmpex},
{333, "_lrotl", msvcrt_lrotl},
{334, "_lrotr", msvcrt_lrotr},
{335, "_lsearch", msvcrt_lsearch},
{336, "_lseek", msvcrt_lseek},
{337, "_lseeki64", msvcrt_lseeki64},
{338, "_ltoa", msvcrt_ltoa},
{339, "_ltow", msvcrt_ltow},
{340, "_makepath", msvcrt_makepath},
{341, "_mbbtombc", msvcrt_mbbtombc},
{342, "_mbbtype", msvcrt_mbbtype},
{343, "_mbcasemap", msvcrt_mbcasemap},
{344, "_mbccpy", msvcrt_mbccpy},
{345, "_mbcjistojms", msvcrt_mbcjistojms},
{346, "_mbcjmstojis", msvcrt_mbcjmstojis},
{347, "_mbclen", msvcrt_mbclen},
{348, "_mbctohira", msvcrt_mbctohira},
{349, "_mbctokata", msvcrt_mbctokata},
{350, "_mbctolower", msvcrt_mbctolower},
{351, "_mbctombb", msvcrt_mbctombb},
{352, "_mbctoupper", msvcrt_mbctoupper},
{353, "_mbctype", msvcrt_mbctype},
{354, "_mbsbtype", msvcrt_mbsbtype},
{355, "_mbscat", msvcrt_mbscat},
{356, "_mbschr", msvcrt_mbschr},
{357, "_mbscmp", msvcrt_mbscmp},
{358, "_mbscoll", msvcrt_mbscoll},
{359, "_mbscpy", msvcrt_mbscpy},
{360, "_mbscspn", msvcrt_mbscspn},
{361, "_mbsdec", msvcrt_mbsdec},
{362, "_mbsdup", msvcrt_mbsdup},
{363, "_mbsicmp", msvcrt_mbsicmp},
{364, "_mbsicoll", msvcrt_mbsicoll},
{365, "_mbsinc", msvcrt_mbsinc},
{366, "_mbslen", msvcrt_mbslen},
{367, "_mbslwr", msvcrt_mbslwr},
{368, "_mbsnbcat", msvcrt_mbsnbcat},
{369, "_mbsnbcmp", msvcrt_mbsnbcmp},
{370, "_mbsnbcnt", msvcrt_mbsnbcnt},
{371, "_mbsnbcoll", msvcrt_mbsnbcoll},
{372, "_mbsnbcpy", msvcrt_mbsnbcpy},
{373, "_mbsnbicmp", msvcrt_mbsnbicmp},
{374, "_mbsnbicoll", msvcrt_mbsnbicoll},
{375, "_mbsnbset", msvcrt_mbsnbset},
{376, "_mbsncat", msvcrt_mbsncat},
{377, "_mbsnccnt", msvcrt_mbsnccnt},
{378, "_mbsncmp", msvcrt_mbsncmp},
{379, "_mbsncoll", msvcrt_mbsncoll},
{380, "_mbsncpy", msvcrt_mbsncpy},
{381, "_mbsnextc", msvcrt_mbsnextc},
{382, "_mbsnicmp", msvcrt_mbsnicmp},
{383, "_mbsnicoll", msvcrt_mbsnicoll},
{384, "_mbsninc", msvcrt_mbsninc},
{385, "_mbsnset", msvcrt_mbsnset},
{386, "_mbspbrk", msvcrt_mbspbrk},
{387, "_mbsrchr", msvcrt_mbsrchr},
{388, "_mbsrev", msvcrt_mbsrev},
{389, "_mbsset", msvcrt_mbsset},
{390, "_mbsspn", msvcrt_mbsspn},
{391, "_mbsspnp", msvcrt_mbsspnp},
{392, "_mbsstr", msvcrt_mbsstr},
{393, "_mbstok", msvcrt_mbstok},
{394, "_mbstrlen", msvcrt_mbstrlen},
{395, "_mbsupr", msvcrt_mbsupr},
{396, "_memccpy", msvcrt_memccpy},
{397, "_memicmp", msvcrt_memicmp},
{398, "_mkdir", msvcrt_mkdir},
{399, "_mktemp", msvcrt_mktemp},
{400, "_mktime64", msvcrt_mktime64},
{401, "_msize", msvcrt_msize},
{402, "_nextafter", msvcrt_nextafter},
{403, "_onexit", msvcrt_onexit},
{404, "_open", msvcrt_open},
{405, "_open_osfhandle", msvcrt_open_osfhandle},
{406, "_osplatform", msvcrt_osplatform},
{407, "_osver", msvcrt_osver},
{408, "_outp", msvcrt_outp},
{409, "_outpd", msvcrt_outpd},
{410, "_outpw", msvcrt_outpw},
{411, "_pclose", msvcrt_pclose},
{412, "_pctype", msvcrt_pctype},
{413, "_pgmptr", msvcrt_pgmptr},
{414, "_pipe", msvcrt_pipe},
{415, "_popen", msvcrt_popen},
{416, "_purecall", msvcrt_purecall},
{417, "_putch", msvcrt_putch},
{418, "_putenv", msvcrt_putenv},
{419, "_putw", msvcrt_putw},
{420, "_putws", msvcrt_putws},
{421, "_pwctype", msvcrt_pwctype},
{422, "_read", msvcrt_read},
{423, "_rmdir", msvcrt_rmdir},
{424, "_rmtmp", msvcrt_rmtmp},
{425, "_rotl", msvcrt_rotl},
{426, "_rotr", msvcrt_rotr},
{427, "_safe_fdiv", msvcrt_safe_fdiv},
{428, "_safe_fdivr", msvcrt_safe_fdivr},
{429, "_safe_fprem", msvcrt_safe_fprem},
{430, "_safe_fprem1", msvcrt_safe_fprem1},
{431, "_scalb", msvcrt_scalb},
{432, "_searchenv", msvcrt_searchenv},
{433, "_seh_longjmp_unwind", msvcrt_seh_longjmp_unwind},
{434, "_set_error_mode", msvcrt_set_error_mode},
{435, "_set_sbh_threshold", msvcrt_set_sbh_threshold},
{436, "_seterrormode", msvcrt_seterrormode},
{437, "_setjmp", msvcrt_setjmp},
{438, "_setjmp3", msvcrt_setjmp3},
{439, "_setmaxstdio", msvcrt_setmaxstdio},
{440, "_setmbcp", msvcrt_setmbcp},
{441, "_setmode", msvcrt_setmode},
{442, "_setsystime", msvcrt_setsystime},
{443, "_sleep", msvcrt_sleep},
{444, "_snprintf", msvcrt_snprintf},
{445, "_snwprintf", msvcrt_snwprintf},
{446, "_sopen", msvcrt_sopen},
{447, "_spawnl", msvcrt_spawnl},
{448, "_spawnle", msvcrt_spawnle},
{449, "_spawnlp", msvcrt_spawnlp},
{450, "_spawnlpe", msvcrt_spawnlpe},
{451, "_spawnv", msvcrt_spawnv},
{452, "_spawnve", msvcrt_spawnve},
{453, "_spawnvp", msvcrt_spawnvp},
{454, "_spawnvpe", msvcrt_spawnvpe},
{455, "_splitpath", msvcrt_splitpath},
{456, "_stat", msvcrt_stat},
{457, "_stat64", msvcrt_stat64},
{458, "_stati64", msvcrt_stati64},
{459, "_statusfp", msvcrt_statusfp},
{460, "_strcmpi", msvcrt_strcmpi},
{461, "_strdate", msvcrt_strdate},
{462, "_strdup", msvcrt_strdup},
{463, "_strerror", msvcrt__strerror},
{464, "_stricmp", msvcrt_stricmp},
{465, "_stricoll", msvcrt_stricoll},
{466, "_strlwr", msvcrt_strlwr},
{467, "_strncoll", msvcrt_strncoll},
{468, "_strnicmp", msvcrt_strnicmp},
{469, "_strnicoll", msvcrt_strnicoll},
{470, "_strnset", msvcrt_strnset},
{471, "_strrev", msvcrt_strrev},
{472, "_strset", msvcrt_strset},
{473, "_strtime", msvcrt_strtime},
{474, "_strupr", msvcrt_strupr},
{475, "_swab", msvcrt_swab},
{476, "_sys_errlist", msvcrt_sys_errlist},
{477, "_sys_nerr", msvcrt_sys_nerr},
{478, "_tell", msvcrt_tell},
{479, "_telli64", msvcrt_telli64},
{480, "_tempnam", msvcrt_tempnam},
{481, "_time64", msvcrt_time64},
{482, "_timezone", msvcrt_timezone},
{483, "_tolower", msvcrt__tolower},
{484, "_toupper", msvcrt__toupper},
{485, "_tzname", msvcrt_tzname},
{486, "_tzset", msvcrt_tzset},
{487, "_ui64toa", msvcrt_ui64toa},
{488, "_ui64tow", msvcrt_ui64tow},
{489, "_ultoa", msvcrt_ultoa},
{490, "_ultow", msvcrt_ultow},
{491, "_umask", msvcrt_umask},
{492, "_ungetch", msvcrt_ungetch},
{493, "_unlink", msvcrt_unlink},
{494, "_unloaddll", msvcrt_unloaddll},
{495, "_unlock", msvcrt_unlock},
{496, "_utime", msvcrt_utime},
{497, "_utime64", msvcrt_utime64},
{498, "_vsnprintf", msvcrt_vsnprintf},
{499, "_vsnwprintf", msvcrt_vsnwprintf},
{500, "_waccess", msvcrt_waccess},
{501, "_wasctime", msvcrt_wasctime},
{502, "_wchdir", msvcrt_wchdir},
{503, "_wchmod", msvcrt_wchmod},
{504, "_wcmdln", msvcrt_wcmdln},
{505, "_wcreat", msvcrt_wcreat},
{506, "_wcsdup", msvcrt_wcsdup},
{507, "_wcsicmp", msvcrt_wcsicmp},
{508, "_wcsicoll", msvcrt_wcsicoll},
{509, "_wcslwr", msvcrt_wcslwr},
{510, "_wcsncoll", msvcrt_wcsncoll},
{511, "_wcsnicmp", msvcrt_wcsnicmp},
{512, "_wcsnicoll", msvcrt_wcsnicoll},
{513, "_wcsnset", msvcrt_wcsnset},
{514, "_wcsrev", msvcrt_wcsrev},
{515, "_wcsset", msvcrt_wcsset},
{516, "_wcsupr", msvcrt_wcsupr},
{517, "_wctime", msvcrt_wctime},
{518, "_wctime64", msvcrt_wctime64},
{519, "_wenviron", msvcrt_wenviron},
{520, "_wexecl", msvcrt_wexecl},
{521, "_wexecle", msvcrt_wexecle},
{522, "_wexeclp", msvcrt_wexeclp},
{523, "_wexeclpe", msvcrt_wexeclpe},
{524, "_wexecv", msvcrt_wexecv},
{525, "_wexecve", msvcrt_wexecve},
{526, "_wexecvp", msvcrt_wexecvp},
{527, "_wexecvpe", msvcrt_wexecvpe},
{528, "_wfdopen", msvcrt_wfdopen},
{529, "_wfindfirst", msvcrt_wfindfirst},
{530, "_wfindfirst64", msvcrt_wfindfirst64},
{531, "_wfindfirsti64", msvcrt_wfindfirsti64},
{532, "_wfindnext", msvcrt_wfindnext},
{533, "_wfindnext64", msvcrt_wfindnext64},
{534, "_wfindnexti64", msvcrt_wfindnexti64},
{535, "_wfopen", msvcrt_wfopen},
{536, "_wfreopen", msvcrt_wfreopen},
{537, "_wfsopen", msvcrt_wfsopen},
{538, "_wfullpath", msvcrt_wfullpath},
{539, "_wgetcwd", msvcrt_wgetcwd},
{540, "_wgetdcwd", msvcrt_wgetdcwd},
{541, "_wgetenv", msvcrt_wgetenv},
{542, "_winmajor", msvcrt_winmajor},
{543, "_winminor", msvcrt_winminor},
{544, "_winver", msvcrt_winver},
{545, "_wmakepath", msvcrt_wmakepath},
{546, "_wmkdir", msvcrt_wmkdir},
{547, "_wmktemp", msvcrt_wmktemp},
{548, "_wopen", msvcrt_wopen},
{549, "_wperror", msvcrt_wperror},
{550, "_wpgmptr", msvcrt_wpgmptr},
{551, "_wpopen", msvcrt_wpopen},
{552, "_wputenv", msvcrt_wputenv},
{553, "_wremove", msvcrt_wremove},
{554, "_wrename", msvcrt_wrename},
{555, "_write", msvcrt_write},
{556, "_wrmdir", msvcrt_wrmdir},
{557, "_wsearchenv", msvcrt_wsearchenv},
{558, "_wsetlocale", msvcrt_wsetlocale},
{559, "_wsopen", msvcrt_wsopen},
{560, "_wspawnl", msvcrt_wspawnl},
{561, "_wspawnle", msvcrt_wspawnle},
{562, "_wspawnlp", msvcrt_wspawnlp},
{563, "_wspawnlpe", msvcrt_wspawnlpe},
{564, "_wspawnv", msvcrt_wspawnv},
{565, "_wspawnve", msvcrt_wspawnve},
{566, "_wspawnvp", msvcrt_wspawnvp},
{567, "_wspawnvpe", msvcrt_wspawnvpe},
{568, "_wsplitpath", msvcrt_wsplitpath},
{569, "_wstat", msvcrt_wstat},
{570, "_wstat64", msvcrt_wstat64},
{571, "_wstati64", msvcrt_wstati64},
{572, "_wstrdate", msvcrt_wstrdate},
{573, "_wstrtime", msvcrt_wstrtime},
{574, "_wsystem", msvcrt_wsystem},
{575, "_wtempnam", msvcrt_wtempnam},
{576, "_wtmpnam", msvcrt_wtmpnam},
{577, "_wtoi", msvcrt_wtoi},
{578, "_wtoi64", msvcrt_wtoi64},
{579, "_wtol", msvcrt_wtol},
{580, "_wunlink", msvcrt_wunlink},
{581, "_wutime", msvcrt_wutime},
{582, "_wutime64", msvcrt_wutime64},
{583, "_y0", msvcrt_y0},
{584, "_y1", msvcrt_y1},
{585, "_yn", msvcrt_yn},
{586, "abort", msvcrt_abort},
{587, "abs", msvcrt_abs},
{588, "acos", msvcrt_acos},
{589, "asctime", msvcrt_asctime},
{590, "asin", msvcrt_asin},
{591, "atan", msvcrt_atan},
{592, "atan2", msvcrt_atan2},
{593, "atexit", msvcrt_atexit},
{594, "atof", msvcrt_atof},
{595, "atoi", msvcrt_atoi},
{596, "atol", msvcrt_atol},
{597, "bsearch", msvcrt_bsearch},
{598, "calloc", msvcrt_calloc},
{599, "ceil", msvcrt_ceil},
{600, "clearerr", msvcrt_clearerr},
{601, "clock", msvcrt_clock},
{602, "cos", msvcrt_cos},
{603, "cosh", msvcrt_cosh},
{604, "ctime", msvcrt_ctime},
{605, "difftime", msvcrt_difftime},
{606, "div", msvcrt_div},
{607, "exit", msvcrt_exit},
{608, "exp", msvcrt_exp},
{609, "fabs", msvcrt_fabs},
{610, "fclose", msvcrt_fclose},
{611, "feof", msvcrt_feof},
{612, "ferror", msvcrt_ferror},
{613, "fflush", msvcrt_fflush},
{614, "fgetc", msvcrt_fgetc},
{615, "fgetpos", msvcrt_fgetpos},
{616, "fgets", msvcrt_fgets},
{617, "fgetwc", msvcrt_fgetwc},
{618, "fgetws", msvcrt_fgetws},
{619, "floor", msvcrt_floor},
{620, "fmod", msvcrt_fmod},
{621, "fopen", msvcrt_fopen},
{622, "fprintf", msvcrt_fprintf},
{623, "fputc", msvcrt_fputc},
{624, "fputs", msvcrt_fputs},
{625, "fputwc", msvcrt_fputwc},
{626, "fputws", msvcrt_fputws},
{627, "fread", msvcrt_fread},
{628, "free", msvcrt_free},
{629, "freopen", msvcrt_freopen},
{630, "frexp", msvcrt_frexp},
{631, "fscanf", msvcrt_fscanf},
{632, "fseek", msvcrt_fseek},
{633, "fsetpos", msvcrt_fsetpos},
{634, "ftell", msvcrt_ftell},
{635, "fwprintf", msvcrt_fwprintf},
{636, "fwrite", msvcrt_fwrite},
{637, "fwscanf", msvcrt_fwscanf},
{638, "getc", msvcrt_getc},
{639, "getchar", msvcrt_getchar},
{640, "getenv", msvcrt_getenv},
{641, "gets", msvcrt_gets},
{642, "getwc", msvcrt_getwc},
{643, "getwchar", msvcrt_getwchar},
{644, "gmtime", msvcrt_gmtime},
{645, "is_wctype", msvcrt_is_wctype},
{646, "isalnum", msvcrt_isalnum},
{647, "isalpha", msvcrt_isalpha},
{648, "iscntrl", msvcrt_iscntrl},
{649, "isdigit", msvcrt_isdigit},
{650, "isgraph", msvcrt_isgraph},
{651, "isleadbyte", msvcrt_isleadbyte},
{652, "islower", msvcrt_islower},
{653, "isprint", msvcrt_isprint},
{654, "ispunct", msvcrt_ispunct},
{655, "isspace", msvcrt_isspace},
{656, "isupper", msvcrt_isupper},
{657, "iswalnum", msvcrt_iswalnum},
{658, "iswalpha", msvcrt_iswalpha},
{659, "iswascii", msvcrt_iswascii},
{660, "iswcntrl", msvcrt_iswcntrl},
{661, "iswctype", msvcrt_iswctype},
{662, "iswdigit", msvcrt_iswdigit},
{663, "iswgraph", msvcrt_iswgraph},
{664, "iswlower", msvcrt_iswlower},
{665, "iswprint", msvcrt_iswprint},
{666, "iswpunct", msvcrt_iswpunct},
{667, "iswspace", msvcrt_iswspace},
{668, "iswupper", msvcrt_iswupper},
{669, "iswxdigit", msvcrt_iswxdigit},
{670, "isxdigit", msvcrt_isxdigit},
{671, "labs", msvcrt_labs},
{672, "ldexp", msvcrt_ldexp},
{673, "ldiv", msvcrt_ldiv},
{674, "localeconv", msvcrt_localeconv},
{675, "localtime", msvcrt_localtime},
{676, "log", msvcrt_log},
{677, "log10", msvcrt_log10},
{678, "longjmp", msvcrt_longjmp},
{679, "malloc", msvcrt_malloc},
{680, "mblen", msvcrt_mblen},
{681, "mbstowcs", msvcrt_mbstowcs},
{682, "mbtowc", msvcrt_mbtowc},
{683, "memchr", msvcrt_memchr},
{684, "memcmp", msvcrt_memcmp},
{685, "memcpy", msvcrt_memcpy},
{686, "memmove", msvcrt_memmove},
{687, "memset", msvcrt_memset},
{688, "mktime", msvcrt_mktime},
{689, "modf", msvcrt_modf},
{690, "perror", msvcrt_perror},
{691, "pow", msvcrt_pow},
{692, "printf", msvcrt_printf},
{693, "putc", msvcrt_putc},
{694, "putchar", msvcrt_putchar},
{695, "puts", msvcrt_puts},
{696, "putwc", msvcrt_putwc},
{697, "putwchar", msvcrt_putwchar},
{698, "qsort", msvcrt_qsort},
{699, "raise", msvcrt_raise},
{700, "rand", msvcrt_rand},
{701, "realloc", msvcrt_realloc},
{702, "remove", msvcrt_remove},
{703, "rename", msvcrt_rename},
{704, "rewind", msvcrt_rewind},
{705, "scanf", msvcrt_scanf},
{706, "setbuf", msvcrt_setbuf},
{707, "setlocale", msvcrt_setlocale},
{708, "setvbuf", msvcrt_setvbuf},
{709, "signal", msvcrt_signal},
{710, "sin", msvcrt_sin},
{711, "sinh", msvcrt_sinh},
{712, "sprintf", msvcrt_sprintf},
{713, "sqrt", msvcrt_sqrt},
{714, "srand", msvcrt_srand},
{715, "sscanf", msvcrt_sscanf},
{716, "strcat", msvcrt_strcat},
{717, "strchr", msvcrt_strchr},
{718, "strcmp", msvcrt_strcmp},
{719, "strcoll", msvcrt_strcoll},
{720, "strcpy", msvcrt_strcpy},
{721, "strcspn", msvcrt_strcspn},
{722, "strerror", msvcrt_strerror},
{723, "strftime", msvcrt_strftime},
{724, "strlen", msvcrt_strlen},
{725, "strncat", msvcrt_strncat},
{726, "strncmp", msvcrt_strncmp},
{727, "strncpy", msvcrt_strncpy},
{728, "strpbrk", msvcrt_strpbrk},
{729, "strrchr", msvcrt_strrchr},
{730, "strspn", msvcrt_strspn},
{731, "strstr", msvcrt_strstr},
{732, "strtod", msvcrt_strtod},
{733, "strtok", msvcrt_strtok},
{734, "strtol", msvcrt_strtol},
{735, "strtoul", msvcrt_strtoul},
{736, "strxfrm", msvcrt_strxfrm},
{737, "swprintf", msvcrt_swprintf},
{738, "swscanf", msvcrt_swscanf},
{739, "system", msvcrt_system},
{740, "tan", msvcrt_tan},
{741, "tanh", msvcrt_tanh},
{742, "time", msvcrt_time},
{743, "tmpfile", msvcrt_tmpfile},
{744, "tmpnam", msvcrt_tmpnam},
{745, "tolower", msvcrt_tolower},
{746, "toupper", msvcrt_toupper},
{747, "towlower", msvcrt_towlower},
{748, "towupper", msvcrt_towupper},
{749, "ungetc", msvcrt_ungetc},
{750, "ungetwc", msvcrt_ungetwc},
{751, "vfprintf", msvcrt_vfprintf},
{752, "vfwprintf", msvcrt_vfwprintf},
{753, "vprintf", msvcrt_vprintf},
{754, "vsprintf", msvcrt_vsprintf},
{755, "vswprintf", msvcrt_vswprintf},
{756, "vwprintf", msvcrt_vwprintf},
{757, "wcscat", msvcrt_wcscat},
{758, "wcschr", msvcrt_wcschr},
{759, "wcscmp", msvcrt_wcscmp},
{760, "wcscoll", msvcrt_wcscoll},
{761, "wcscpy", msvcrt_wcscpy},
{762, "wcscspn", msvcrt_wcscspn},
{763, "wcsftime", msvcrt_wcsftime},
{764, "wcslen", msvcrt_wcslen},
{765, "wcsncat", msvcrt_wcsncat},
{766, "wcsncmp", msvcrt_wcsncmp},
{767, "wcsncpy", msvcrt_wcsncpy},
{768, "wcspbrk", msvcrt_wcspbrk},
{769, "wcsrchr", msvcrt_wcsrchr},
{770, "wcsspn", msvcrt_wcsspn},
{771, "wcsstr", msvcrt_wcsstr},
{772, "wcstod", msvcrt_wcstod},
{773, "wcstok", msvcrt_wcstok},
{774, "wcstol", msvcrt_wcstol},
{775, "wcstombs", msvcrt_wcstombs},
{776, "wcstoul", msvcrt_wcstoul},
{777, "wcsxfrm", msvcrt_wcsxfrm},
{778, "wctomb", msvcrt_wctomb},
{779, "wprintf", msvcrt_wprintf},
{780, "wscanf", msvcrt_wscanf},
{0, NULL, NULL}};
