/*
    w32loader
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __VFW_H__
#define __VFW_H__


#include "windef.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MAKEFOURCC(ch0, ch1, ch2, ch3)                                      \
    ((DWORD)(BYTE)(ch0) | ((DWORD)(BYTE)(ch1) << 8) |                       \
    ((DWORD)(BYTE)(ch2) << 16) | ((DWORD)(BYTE)(ch3) << 24 ))


#define DRV_LOAD                    0x0001
#define DRV_ENABLE                  0x0002
#define DRV_OPEN                    0x0003
#define DRV_CLOSE                   0x0004
#define DRV_DISABLE                 0x0005
#define DRV_FREE                    0x0006
#define DRV_CONFIGURE               0x0007
#define DRV_QUERYCONFIGURE          0x0008
#define DRV_INSTALL                 0x0009
#define DRV_REMOVE                  0x000A
#define DRV_EXITSESSION             0x000B
#define DRV_EXITAPPLICATION         0x000C
#define DRV_POWER                   0x000F
#define DRV_RESERVED                0x0800
#define DRV_USER                    0x4000

#define DRVCNF_CANCEL               0x0000
#define DRVCNF_OK                   0x0001
#define DRVCNF_RESTART              0x0002

#define DRVEA_NORMALEXIT            0x0001
#define DRVEA_ABNORMALEXIT          0x0002

#define DRV_SUCCESS                 0x0001
#define DRV_FAILURE                 0x0000

#define ICTYPE_VIDEO                make4cc('v','i','d','c')
#define ICTYPE_AUDIO                make4cc('a','u','d','c')

/* en:error return codes */
#define ICERR_OK                    0
#define ICERR_DONTDRAW              1
#define ICERR_NEWPALETTE            2
#define ICERR_GOTOKEYFRAME          3
#define ICERR_STOPDRAWING           4

#define ICERR_UNSUPPORTED           -1
#define ICERR_BADFORMAT             -2
#define ICERR_MEMORY                -3
#define ICERR_INTERNAL              -4
#define ICERR_BADFLAGS              -5
#define ICERR_BADPARAM              -6
#define ICERR_BADSIZE               -7
#define ICERR_BADHANDLE             -8
#define ICERR_CANTUPDATE            -9
#define ICERR_ABORT                 -10
#define ICERR_ERROR                 -100
#define ICERR_BADBITDEPTH           -200
#define ICERR_BADIMAGESIZE          -201

#define ICERR_CUSTOM                -400

/* en:ICM Messages */
#define ICM_USER                    (DRV_USER+0x0000)

/* en:ICM driver message range */
#define ICM_RESERVED_LOW            (DRV_USER+0x1000)
#define ICM_RESERVED_HIGH           (DRV_USER+0x2000)
#define ICM_RESERVED                ICM_RESERVED_LOW
#define ICM_GETSTATE                (ICM_RESERVED+0)
#define ICM_SETSTATE                (ICM_RESERVED+1)
#define ICM_GETINFO                 (ICM_RESERVED+2)
#define ICM_CONFIGURE               (ICM_RESERVED+10)
#define ICM_ABOUT                   (ICM_RESERVED+11)
/* */
#define ICM_GETDEFAULTQUALITY       (ICM_RESERVED+30)
#define ICM_GETQUALITY              (ICM_RESERVED+31)
#define ICM_SETQUALITY              (ICM_RESERVED+32)
#define ICM_SET                     (ICM_RESERVED+40)
#define ICM_GET                     (ICM_RESERVED+41)

/* en:2 constant FOURCC codes */
#define ICM_FRAMERATE               make4cc('F','r','m','R')
#define ICM_KEYFRAMERATE            make4cc('K','e','y','R')
#define ICM_COMPRESS_GET_FORMAT     (ICM_USER+4)
#define ICM_COMPRESS_GET_SIZE       (ICM_USER+5)
#define ICM_COMPRESS_QUERY          (ICM_USER+6)
#define ICM_COMPRESS_BEGIN          (ICM_USER+7)
#define ICM_COMPRESS                (ICM_USER+8)
#define ICM_COMPRESS_END            (ICM_USER+9)
#define ICM_DECOMPRESS_GET_FORMAT   (ICM_USER+10)
#define ICM_DECOMPRESS_QUERY        (ICM_USER+11)
#define ICM_DECOMPRESS_BEGIN        (ICM_USER+12)
#define ICM_DECOMPRESS              (ICM_USER+13)
#define ICM_DECOMPRESS_END          (ICM_USER+14)
#define ICM_DECOMPRESS_SET_PALETTE  (ICM_USER+29)
#define ICM_DECOMPRESS_GET_PALETTE  (ICM_USER+30)
#define ICM_DRAW_QUERY              (ICM_USER+31)
#define ICM_DRAW_BEGIN              (ICM_USER+15)
#define ICM_DRAW_GET_PALETTE        (ICM_USER+16)
#define ICM_DRAW_START              (ICM_USER+18)
#define ICM_DRAW_STOP               (ICM_USER+19)
#define ICM_DRAW_END                (ICM_USER+21)
#define ICM_DRAW_GETTIME            (ICM_USER+32)
#define ICM_DRAW                    (ICM_USER+33)
#define ICM_DRAW_WINDOW             (ICM_USER+34)
#define ICM_DRAW_SETTIME            (ICM_USER+35)
#define ICM_DRAW_REALIZE            (ICM_USER+36)
#define ICM_DRAW_FLUSH              (ICM_USER+37)
#define ICM_DRAW_RENDERBUFFER       (ICM_USER+38)
#define ICM_DRAW_START_PLAY         (ICM_USER+39)
#define ICM_DRAW_STOP_PLAY          (ICM_USER+40)
#define ICM_DRAW_SUGGESTFORMAT      (ICM_USER+50)
#define ICM_DRAW_CHANGEPALETTE      (ICM_USER+51)
#define ICM_GETBUFFERSWANTED        (ICM_USER+41)
#define ICM_GETDEFAULTKEYFRAMERATE  (ICM_USER+42)
#define ICM_DECOMPRESSEX_BEGIN      (ICM_USER+60)
#define ICM_DECOMPRESSEX_QUERY      (ICM_USER+61)
#define ICM_DECOMPRESSEX            (ICM_USER+62)
#define ICM_DECOMPRESSEX_END        (ICM_USER+63)
#define ICM_COMPRESS_FRAMES_INFO    (ICM_USER+70)
#define ICM_SET_STATUS_PROC         (ICM_USER+72)

#define ICCOMPRESS_KEYFRAME         0x00000001

/* en:Values for wMode of ICOpen() */
#define ICMODE_COMPRESS             1
#define ICMODE_DECOMPRESS           2
#define ICMODE_FASTDECOMPRESS       3
#define ICMODE_QUERY                4
#define ICMODE_FASTCOMPRESS         5
#define ICMODE_DRAW                 8

/* en:quality flags */
#define ICQUALITY_LOW               0
#define ICQUALITY_HIGH              10000
#define ICQUALITY_DEFAULT           -1

/* en:ICINFO.dwFlags */
#define VIDCF_QUALITY               0x0001  /* en:supports quality */
#define VIDCF_CRUNCH                0x0002  /* en:supports crunching to a frame size */
#define VIDCF_TEMPORAL              0x0004  /* en:supports inter-frame compress */
#define VIDCF_COMPRESSFRAMES        0x0008  /* en:wants the compress all frames message */
#define VIDCF_DRAW                  0x0010  /* en:supports drawing */
#define VIDCF_FASTTEMPORALC         0x0020  /* en:does not need prev frame on compress */
#define VIDCF_FASTTEMPORALD         0x0080  /* en:does not need prev frame on decompress */
#define VIDCF_QUALITYTIME           0x0040  /* en:supports temporal quality */

/* en:Decompression stuff */
#define ICDECOMPRESS_HURRYUP        0x80000000  /* don't draw just buffer (hurry up!) */
#define ICDECOMPRESS_UPDATE         0x40000000  /* don't draw just update screen */
#define ICDECOMPRESS_PREROLL        0x20000000  /* this frame is before real start */
#define ICDECOMPRESS_NULLFRAME      0x10000000  /* repeat last frame */
#define ICDECOMPRESS_NOTKEYFRAME    0x08000000  /* this frame is not a key frame */

/* en:AVIINDEXENTRY.dwFlags */
#define AVIIF_LIST                  0x00000001  /* chunk is a 'LIST' */
#define AVIIF_TWOCC                 0x00000002  
#define AVIIF_KEYFRAME              0x00000010  /* this frame is a key frame. */
#define AVIIF_NOTIME                0x00000100  /* this frame doesn't take any time */
#define AVIIF_COMPUSE               0x0FFF0000


typedef BitmapInfoHeader *LPBITMAPINFOHEADER;
#include "pshpack1.h"
typedef struct
{
  DWORD   dwSize;           /* en:00: size */
  DWORD   fccType;          /* en:04: type 'vidc' usually */
  DWORD   fccHandler;       /* en:08: */
  DWORD   dwVersion;        /* en:0c: version of compman opening you */
  DWORD   dwFlags;          /* en:10: LOWORD is type specific */
  LRESULT dwError;          /* en:14: */
  LPVOID  pV1Reserved;      /* en:18: */
  LPVOID  pV2Reserved;      /* en:1c: */
  DWORD   dnDevNode;        /* en:20: */
                            /* en:24: */
} ICOPEN, *PICOPEN, *LPICOPEN;
typedef struct
{
  DWORD dwSize;             /* en:00: */
  DWORD fccType;            /* en:04:compressor type     'vidc' 'audc' */
  DWORD fccHandler;         /* en:08:compressor sub-type 'rle ' 'jpeg' 'pcm '*/
  DWORD dwFlags;            /* en:0c:flags LOWORD is type specific */
  DWORD dwVersion;          /* en:10:version of the driver */
  DWORD dwVersionICM;       /* en:14:version of the ICM used */
    /*
     * en:under Win32, the driver always returns UNICODE strings.
     */
  WCHAR szName[16];         /* en:18:short name */
  WCHAR szDescription[128]; /* en:38:long name */
  WCHAR szDriver[128];      /* en:138:driver that contains compressor*/
                            /* en:238: */
} ICINFO, *PICINFO, *LPICINFO;
typedef struct
{
  DWORD              dwFlags;
  LPBITMAPINFOHEADER lpbiOutput;
  LPARAM             lOutput;
  LPBITMAPINFOHEADER lpbiInput;
  LPARAM             lInput;
  LONG               lStartFrame;
  LONG               lFrameCount;
  LONG               lQuality;
  LONG               lDataRate;
  LONG               lKeyRate;
  DWORD              dwRate;
  DWORD              dwScale;
  DWORD              dwOverheadPerFrame;
  DWORD              dwReserved2;
  LONG (CALLBACK *GetData)(LPARAM lInput,LONG lFrame,LPVOID lpBits,LONG len);
  LONG (CALLBACK *PutData)(LPARAM lOutput,LONG lFrame,LPVOID lpBits,LONG len);
} ICCOMPRESSFRAMES, *PICCOMPRESSFRAMES, *LPICCOMPRESSFRAMES;
typedef struct
{
  DWORD              dwFlags;
  LPBITMAPINFOHEADER lpbiOutput;
  LPVOID             lpOutput;
  LPBITMAPINFOHEADER lpbiInput;
  LPVOID             lpInput;
  LPDWORD            lpckid;
  LPDWORD            lpdwFlags;
  LONG               lFrameNum;
  DWORD              dwFrameSize;
  DWORD              dwQuality;
  LPBITMAPINFOHEADER lpbiPrev;
  LPVOID             lpPrev;
} ICCOMPRESS, *PICCOMPRESS, *LPICCOMPRESS;
typedef struct
{
  DWORD              dwFlags;       /* en:flags (from AVI index...) */
  LPBITMAPINFOHEADER lpbiInput;     /* en:BITMAPINFO of compressed data */
  LPVOID             lpInput;       /* en:compressed data */
  LPBITMAPINFOHEADER lpbiOutput;    /* en:DIB to decompress to */
  LPVOID             lpOutput;
  DWORD              ckid;          /* en:ckid from AVI file */
} ICDECOMPRESS, *PICDECOMPRESS, *LPICDECOMPRESS;
#include "poppack.h"


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __VFW_H__ */
