#include "compiler.h"
#include "kbdmng.h"
#include "keystat.h"

static struct {
	UINT8 vsun86_key;
	UINT8 np2_key;
} key_convtbl[] =
{
	{ KEY_ESCAPE,		0x00 },
	{ KEY_1,			0x01 },
	{ KEY_2,			0x02 },
	{ KEY_3,			0x03 },
	{ KEY_4,			0x04 },
	{ KEY_5,			0x05 },
	{ KEY_6,			0x06 },
	{ KEY_7,			0x07 },
	{ KEY_8,			0x08 },
	{ KEY_9,			0x09 },
	{ KEY_0,			0x0A },
	{ KEY_MINUS,		0x0B },
	{ KEY_EQUALS,		0x0C },
	{ KEY_BACKSLASH,	0x0D },
	{ KEY_BACKSPACE,	0x0E },
	{ KEY_TAB,			0x0F },
	{ KEY_Q,			0x10 },
	{ KEY_W,			0x11 },
	{ KEY_E,			0x12 },
	{ KEY_R,			0x13 },
	{ KEY_T,			0x14 },
	{ KEY_Y,			0x15 },
	{ KEY_U,			0x16 },
	{ KEY_I,			0x17 },
	{ KEY_O,			0x18 },
	{ KEY_P,			0x19 },
	{ KEY_ATMARK,		0x1A },
	{ KEY_LBLACKET,		0x1B },
	{ KEY_RETURN,		0x1C },
	{ KEY_A,			0x1D },
	{ KEY_S,			0x1E },
	{ KEY_D,			0x1F },
	{ KEY_F,			0x20 },
	{ KEY_G,			0x21 },
	{ KEY_H,			0x22 },
	{ KEY_J,			0x23 },
	{ KEY_K,			0x24 },
	{ KEY_L,			0x25 },
	{ KEY_SEMICOLON,	0x26 },
	{ KEY_COLON,		0x27 },
	{ KEY_RBLACKET,		0x28 },
	{ KEY_Z,			0x29 },
	{ KEY_X,			0x2A },
	{ KEY_C,			0x2B },
	{ KEY_V,			0x2C },
	{ KEY_B,			0x2D },
	{ KEY_N,			0x2E },
	{ KEY_M,			0x2F },
	{ KEY_COMMA,		0x30 },
	{ KEY_PERIOD,		0x31 },
	{ KEY_SLASH,		0x32 },
	{ KEY_UNDERBAR,		0x33 },
	{ KEY_SPACE,		0x34 },
	{ KEY_CONVERT,		0x35 },		// XFER
	{ KEY_PAGEDOWN,		0x36 },		// ROLL DOWN
	{ KEY_PAGEUP,		0x37 },		// ROLL UP
	{ KEY_INSERT,		0x38 },
	{ KEY_DELETE,		0x39 },
	{ KEY_UP,			0x3A },
	{ KEY_LEFT,			0x3B },
	{ KEY_RIGHT,		0x3C },
	{ KEY_DOWN,			0x3D },
	{ KEY_HOME,			0x3E },
	{ KEY_END,			0x3F },
	{ KEY_NUM_SUB,		0x40 },
	{ KEY_NUM_DIV,		0x41 },
	{ KEY_NUM_7,		0x42 },
	{ KEY_NUM_8,		0x43 },
	{ KEY_NUM_9,		0x44 },
	{ KEY_NUM_MUL,		0x45 },
	{ KEY_NUM_4,		0x46 },
	{ KEY_NUM_5,		0x47 },
	{ KEY_NUM_6,		0x48 },
	{ KEY_NUM_ADD,		0x49 },
	{ KEY_NUM_1,		0x4A },
	{ KEY_NUM_2,		0x4B },
	{ KEY_NUM_3,		0x4C },
	// 0x4D (NUM "=")
	{ KEY_NUM_0,		0x4E },
	// 0x4F (NUM ",")
	{ KEY_NUM_DOT,		0x50 },
	{ KEY_NONCONVERT,	0x51 },		// NFER
	// 0x52`0x5F
	{ KEY_PAUSE,		0x60 },		// STOP
	{ KEY_PRINTSCREEN,	0x61 },		// COPY
	{ KEY_F1,			0x62 },
	{ KEY_F2,			0x63 },
	{ KEY_F3,			0x64 },
	{ KEY_F4,			0x65 },
	{ KEY_F5,			0x66 },
	{ KEY_F6,			0x67 },
	{ KEY_F7,			0x68 },
	{ KEY_F8,			0x69 },
	{ KEY_F9,			0x6A },
	{ KEY_F10,			0x6B },
	// 0x6C`0x6F
	{ KEY_LSHIFT,		0x70 },		{ KEY_RSHIFT,		0x70 },
	{ KEY_CAPSLOCK,		0x71 },
	{ KEY_KANA,			0x72 },
	{ KEY_LALT,			0x73 },		{ KEY_RALT,			0x73 },
	{ KEY_LCTRL,		0x74 },		{ KEY_RCTRL,		0x74 },

	{ KEY_NULL,			0xFF }
};

static UINT8 keytbl[256];

void kbdmng_initialize( void )
{
	keystat_initialize();

	for ( int i=0; i<256; i++ )
		keytbl[i] = 0xFF;
	for ( int i=0; key_convtbl[i].vsun86_key != KEY_NULL; i++ )
		keytbl[key_convtbl[i].vsun86_key] = key_convtbl[i].np2_key;
}

static void kbdmng_check_modkey( UINT8 mod )
{
	static UINT8 mod_save = 0x00;

	const UINT8 changed = mod ^ mod_save;

	if ( changed & KEY_MOD_LCTRL ) {
		if ( mod & KEY_MOD_LCTRL )	keystat_keydown( keytbl[KEY_LCTRL] );
		else						keystat_keyup  ( keytbl[KEY_LCTRL] );
	}
	if ( changed & KEY_MOD_RCTRL ) {
		if ( mod & KEY_MOD_RCTRL )	keystat_keydown( keytbl[KEY_RCTRL] );
		else						keystat_keyup  ( keytbl[KEY_RCTRL] );
	}
	if ( changed & KEY_MOD_LSHIFT ) {
		if ( mod & KEY_MOD_LSHIFT )	keystat_keydown( keytbl[KEY_LSHIFT] );
		else						keystat_keyup  ( keytbl[KEY_LSHIFT] );
	}
	if ( changed & KEY_MOD_RSHIFT ) {
		if ( mod & KEY_MOD_RSHIFT )	keystat_keydown( keytbl[KEY_RSHIFT] );
		else						keystat_keyup  ( keytbl[KEY_RSHIFT] );
	}
	if ( changed & KEY_MOD_LALT ) {
		if ( mod & KEY_MOD_LALT )	keystat_keydown( keytbl[KEY_LALT] );
		else						keystat_keyup  ( keytbl[KEY_LALT] );
	}
	if ( changed & KEY_MOD_RALT ) {
		if ( mod & KEY_MOD_RALT )	keystat_keydown( keytbl[KEY_RALT] );
		else						keystat_keyup  ( keytbl[KEY_RALT] );
	}
	mod_save = mod;
}

void kbdmng_key_down( UINT8 mod, UINT8 key )
{
	kbdmng_check_modkey( mod );
	keystat_keydown( keytbl[key] );
}

void kbdmng_key_up( UINT8 mod, UINT8 key )
{
	kbdmng_check_modkey( mod );
	keystat_keyup( keytbl[key] );
}
