/*!
******************************************************************************

	@file	mov.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "pfemu.h"
#include "pfemu/vcpu.h"
#include "pfemu/softemu.h"

bool vcpu_emulate_mov_modrm( VCPU *cpu, u8 *mem, u32 op_info )
{
	MODRM_INFO modrm;
	if ( !vcpu_analyze_modrm( cpu, mem, op_info, &modrm ) )
		return false;

	const u8 ip_off = OP_BYTES( op_info ) + modrm.bytes;

	VCPU_MMIO_PROCS *mmio;
	u32 addr;

	switch ( OP_CODE(op_info) )
	{
	case 0x88:
		{	// MOV r/m8, r8
			if ( modrm.rm_index == MODRM_RM_MEM ) {
				addr = modrm.rm_seg->base + modrm.rm_off;
				mmio = vcpu_get_mmio( cpu, addr >> 12 );
				if ( mmio->write8 )
					mmio->write8( addr, *(u8 *)modrm.reg );
				else
//					mem[addr] = *(u8 *)modrm.reg;
					return false;
			}
			else
//				*(u8 *)modrm.rm_reg = *(u8 *)modrm.reg;
				return false;
		}
		break;

	case 0x89:
		if ( op_info & OP_PREFIX_CODE32 )
		{	// MOV r/m32, r32
			if ( modrm.rm_index == MODRM_RM_MEM ) {
				addr = modrm.rm_seg->base + modrm.rm_off;
				mmio = vcpu_get_mmio( cpu, addr >> 12 );
				if ( mmio->write32 )
					mmio->write32( addr, *(u32 *)modrm.reg );
				else
//					*(u32 *)&mem[addr] = *(u32 *)modrm.reg;
					return false;
			}
			else
//				*(u32 *)modrm.rm_reg = *(u32 *)modrm.reg;
				return false;
		}
		else
		{	// MOV r/m16, r16
			if ( modrm.rm_index == MODRM_RM_MEM ) {
				addr = modrm.rm_seg->base + modrm.rm_off;
				mmio = vcpu_get_mmio( cpu, addr >> 12 );
				if ( mmio->write16 )
					mmio->write16( addr, *(u16 *)modrm.reg );
				else
//					*(u16 *)&mem[addr] = *(u16 *)modrm.reg;
					return false;
			}
			else
//				*(u16 *)modrm.rm_reg = *(u16 *)modrm.reg;
				return false;
		}
		break;

	case 0x8A:
		{	// MOV r8, r/m8
			if ( modrm.rm_index == MODRM_RM_MEM ) {
				addr = modrm.rm_seg->base + modrm.rm_off;
				mmio = vcpu_get_mmio( cpu, addr >> 12 );
				if ( mmio->read8 )
					*(u8 *)modrm.reg = mmio->read8( addr );
				else
//					*(u8 *)modrm.reg = mem[addr];
					return false;
			}
			else
//				*(u8 *)modrm.reg = *(u8 *)modrm.rm_reg;
				return false;
		}
		break;

	case 0x8B:
		if ( op_info & OP_PREFIX_CODE32 )
		{	// MOV r32, r/m32
			if ( modrm.rm_index == MODRM_RM_MEM ) {
				addr = modrm.rm_seg->base + modrm.rm_off;
				mmio = vcpu_get_mmio( cpu, addr >> 12 );
				if ( mmio->read32 )
					*(u32 *)modrm.reg = mmio->read32( addr );
				else
//					*(u32 *)modrm.reg = *(u32 *)&mem[addr];
					return false;
			}
			else
//				*(u32 *)modrm.reg = *(u32 *)modrm.rm_reg;
				return false;
		}
		else
		{	// MOV r16, r/m16
			if ( modrm.rm_index == MODRM_RM_MEM ) {
				addr = modrm.rm_seg->base + modrm.rm_off;
				mmio = vcpu_get_mmio( cpu, addr >> 12 );
				if ( mmio->read16 )
					*(u16 *)modrm.reg = mmio->read16( addr );
				else
//					*(u16 *)modrm.reg = *(u16 *)&mem[addr];
					return false;
			}
			else
//				*(u16 *)modrm.reg = *(u16 *)modrm.rm_reg;
				return false;
		}
		break;
	}

	_EIP(cpu) += ip_off;
	return true;
}

bool vcpu_emulate_mov_moffs( VCPU *cpu, u8 *mem, u32 op_info )
{
	u8 ip_off = OP_BYTES( op_info );

	u32 moffs;
	if ( op_info & OP_PREFIX_ADDR32 ) {
		moffs = *(u32 *)&mem[_CS(cpu).base + _EIP(cpu) + ip_off];
		ip_off += 4;
	}
	else {
		moffs = *(u16 *)&mem[_CS(cpu).base + _EIP(cpu) + ip_off];
		ip_off += 2;
	}

	SVM_VMCB_SEG *seg;
	seg = vcpu_get_seg( cpu, OP_PREFIX_SEG( op_info ) >> OP_PREFIX_SEG_SHIFT );
	if ( seg == NULL )
		return false;

	const u32 addr = seg->base + moffs;

	VCPU_MMIO_PROCS *mmio;
	mmio = vcpu_get_mmio( cpu, addr >> 12 );

	switch ( OP_CODE( op_info ) )
	{
	case 0xA0:	// MOV AL, moffs8
		if ( mmio->read8 )
			_AL(cpu) = mmio->read8( addr );
		else
//			_AL(cpu) = mem[addr];
			return false;
		break;

	case 0xA1:	// MOV rAX, moffs
		if ( op_info & OP_PREFIX_CODE32 ) {
			if ( mmio->read32 )
				_EAX(cpu) = mmio->read32( addr );
			else
//				_EAX(cpu) = *(u32 *)&mem[addr];
				return false;
		}
		else {
			if ( mmio->read16 )
				_AX(cpu) = mmio->read16( addr );
			else
//				_AX(cpu) = *(u16 *)&mem[addr];
				return false;
		}
		break;

	case 0xA2:	// MOV moffs8, AL
		if ( mmio->write8 )
			mmio->write8( addr, _AL(cpu) );
		else
//			mem[addr] = _AL(cpu);
			return false;
		break;

	case 0xA3:	// MOV moffs, rAX
		if ( op_info & OP_PREFIX_CODE32 ) {
			if ( mmio->write32 )
				mmio->write32( addr, _EAX(cpu) );
			else
//				*(u32 *)&mem[addr] = _EAX(cpu);
				return false;
		}
		else {
			if ( mmio->write16 )
				mmio->write16( addr, _AX(cpu) );
			else
//				*(u16 *)&mem[addr] = _AX(cpu);
				return false;
		}
		break;

	default:
		return false;
	}

	_EIP(cpu) += ip_off;
	return true;
}
