/*!
******************************************************************************

	@file	ehci.cpp

	Copyright (C) 2008-2009 Vsun86 Development Project. All rights reserved.

******************************************************************************
*/

#include "vsun86.h"
#include "pci.h"
#include "usb.h"
#include "ehci.h"
#include "printf.h"

static u8 ehci_num;
static EHCI_HCD ehci_hcd[EHCI_HOST_MAX];

#define EHCI_CAPLENGTH( hcd )	(hcd)->cap_regs->caplength
#define EHCI_HCIVERSION( hcd )	(hcd)->cap_regs->hciversion

#define EHCI_USBCMD( hcd )		(hcd)->op_regs->usbcmd
#define EHCI_USBSTS( hcd )		(hcd)->op_regs->usbsts

#define USBCMD_RS			0x0001	// Run / Stop

static void ehci_stop( EHCI_HCD * );

bool ehci_init( void )
{
	ehci_num = 0;
	memset( ehci_hcd, 0, sizeof(ehci_hcd) );

	return true;
}

bool ehci_probe( PCI_DEVICE *dev )
{
	const u8 index = ehci_num;

	EHCI_HCD *hcd = &ehci_hcd[index];
	memset( hcd, 0, sizeof(EHCI_HCD) );

	hcd->id = index;
	if ( PCI_ADDR_IS_IO( dev->base_addr[0] ) )
		return false;	// MMIOłȂƃ_
	hcd->cap_regs = (EHCI_CAP_REGS *)(dev->base_addr[0] & 0xFFFFFFF8);
	hcd->op_regs  = (EHCI_OP_REGS  *)(((u8 *)hcd->cap_regs) + EHCI_CAPLENGTH( hcd ));

	hcd->ports = 0;

	vmm_printf( VMM_DEBUG, "usb_ehci(%d): revision=%x.%x\n",
				index, EHCI_HCIVERSION( hcd ) >> 8, EHCI_HCIVERSION( hcd ) & 0xFF );
	vmm_printf( VMM_DEBUG, "usb_ehci(%d): cap_regs=%08x, op_regs=%08x, irq=%02x\n",
				index, hcd->cap_regs, hcd->op_regs, dev->interrupt_line );

	ehci_stop( hcd );

	ehci_num++;
	return true;
}

bool ehci_start( void )
{
	return true;
}

static void ehci_stop( EHCI_HCD *hcd )
{
	EHCI_USBCMD( hcd ) &= ~USBCMD_RS;
}
