/*
 * Copyright 2006-2008 The Wankuma.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.wankuma.mail;

/**
 * メールの送受信のための接続のサービスを表現します。
 * 
 * @author Katsunori Koyanagi
 * @version 1.0
 */
public interface MailService {

	/**
	 * メール送受信を行うサーバへの接続を切断します。
	 * 
	 * @throws MailException
	 *             切断に失敗した場合
	 */
	void close() throws MailException;

	/**
	 * メール送受信を行うサーバへの接続が切断されているかを返します。
	 * 
	 * @return 切断されている場合は{@code true}
	 */
	boolean isClosed();

	/**
	 * メール送受信を行うサーバへの接続を行います。
	 * 
	 * @throws MailException
	 *             メール送受信サーバへの接続に失敗した場合
	 */
	void open() throws MailException;

	/**
	 * 指定の接続設定でメール送受信を行うサーバへの接続を行います。<br>
	 * {@code null}が指定された場合は、{@link Configuration}の初期値が利用されます。
	 * 
	 * @param configuration
	 *            設定
	 * @throws MailException
	 *             メール送受信を行うサーバへの接続に失敗した場合
	 */
	void open(Configuration configuration) throws MailException;

}
