package org.infodb.wax.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;

public interface ActionParams {
    String getMethod();
    String getTarget();
    String getParameter(String name);
    
    
    String getContentType();
    InputStream getInputStream() throws IOException;
    
    /**
     * 出力するContentTypeを指定する。
     * 指定せずにWriterを取得するとtext/html; charset=UTF-8が設定される。
     * @param contentType 
     */
    void setOutputContentType(String contentType);
    Writer getWriter() throws IOException;
    OutputStream getOutputStream() throws IOException;
    
    void redirect(String url) throws IOException;
}
