/*
 * Copyright (C) 2006 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core;

import java.util.Iterator;
import java.util.TreeSet;

class BraceArray {
    class BraceItem implements Comparable<BraceItem> {
        private BraceType braceType;
        private int from;
        private int to;

        public BraceItem(BraceType type, int f, int t) {
            braceType = type;
            from = f;
            to = t;
        }
        public BraceType getBraceType() {
            return braceType;
        }
        public int getFrom() {
            return from;
        }
        public int getTo() {
            return to;
        }
        @Override
        public int compareTo(BraceItem item) {
            int diff = from - item.from;
            if (diff != 0) {
                return diff;
            }
            return item.to - to;
        }
    }
    private TreeSet<BraceItem> braceList;
    /**
     * 
     */
    public BraceArray() {
        super();
        braceList = new TreeSet<>();
    }
    public boolean add(BraceType type, int from, int to) {
        if (from >= to) {
            return false;
        }
        braceList.add(new BraceItem(type, from, to));
        return true;
    }
    public Iterator<BraceItem> iterator() {
        return braceList.iterator();
    }
}
