package org.infodb.wax.core;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.infodb.wax.core.db.TableDef;
import org.infodb.wax.core.db.XmlStorage;

/**
 * 初期化の際のシステム環境を保持するインターフェイス
 */
public interface SystemEnv {
    /**
     * システムのカレントフォルダを取得する
     * @return 
     */
    File getCurrentDirectory();
    /**
     * ロケール情報を取得する
     * @return 
     */
    Locale getLocale();
    
    /**
     * ヘッダ部に追加するメニューを追加する
     * 基本的にはほとんどのメニューがプラグインとして実装されている
     * @param menu 
     */
    void addMenu(HeaderMenu menu);
    /**
     * 追加されたメニューのリストを返戻する
     * 返戻前にはリストのソートを保証すること
     * @return 
     */
    List<HeaderMenu> getMenuList();
    
    /**
     * XMLストレージクラスを取得する
     * @param name
     * @return 
     */
    XmlStorage getStorage(String name);
    /**
     * XMLストレージクラスを生成する。
     * テーブルの有無はチェックしない。
     * @param name
     * @param tableDef
     * @return 
     */
    XmlStorage newStorage(String name, TableDef tableDef);
}
