/*
 * Copyright (C) 2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.db;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.xml.sax.SAXException;

public class BindBlobResolver implements BindResolver {
    @Override
    public void bind(Connection conn, PreparedStatement stmt, XmlStore store, int index) throws SQLException {
        Blob blob = conn.createBlob();
        try (OutputStream os = blob.setBinaryStream(1)) {
            store.setWriter(new OutputStreamWriter(os));
            store.execute();
            stmt.setBlob(index, blob);
        }
        catch(IOException | SAXException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }
}
