/*
 * Copyright (C) 2011 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.db;

import java.text.MessageFormat;

public class DefDerby implements Definition {
    private static final String[] TYPE_DERBY = {"CHAR","VARCHAR","NUMERIC","DATE","DATE","DATE", "CLOB","BLOB","XML", null, null};
    private BindClobResolver adapter = new BindClobResolver();

    @Override
    public String[] getTypes() {
        return TYPE_DERBY;
    }
    @Override
    public String getSelectXmlCol(String colName) {
        return MessageFormat.format("XMLSERIALIZE({0} AS CLOB)", new Object[] { colName });
    }
    @Override
    public String getUpdateXmlCol() {
        return "XMLPARSE(DOCUMENT CAST(? AS CLOB) PRESERVE WHITESPACE)";
    }
    @Override
    public String getCurDateFunc() {
        return "current_date";
    }
    @Override
    public BindResolver getAdapter() {
        return adapter;
    }
}
