/*
 * Copyright (C) 2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlQuery {
    private ContentResolver contentResolver;
    private ContentHandler contentHandler;
    private InputSource xmlSource;
    private XMLReader reader;
    private List<SQLWhere> wheres;
    
    public XmlQuery(ContentResolver contentResolver) {
        this.contentResolver = contentResolver;
        wheres = new ArrayList<>();
    }
    public void addWhere(SQLWhere where) {
        wheres.add(where);
    }
    protected List<SQLWhere> getWheres() {
        return wheres;
    }
    public void setInputSouce(InputSource xml) {
        xmlSource = xml;
    }
    public void setContentType(String contentType) throws IOException {
        contentResolver.setContentType(contentType);
        contentHandler = contentResolver.getContentHandler();
    }
    public void begin() throws SAXException {
        reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(contentHandler);

        contentHandler.startDocument();
        Attributes atts = new AttributesImpl();
        contentHandler.startElement("", "data", "data", atts);
    }
    public void end() throws SAXException {
        contentHandler.endElement("", "data", "data");
        contentHandler.endDocument();
    }
    public void execute() throws SAXException {
        try {
            reader.parse(xmlSource);
        }
        catch(IOException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }
}
