/*
 * Copyright (C) 2011-2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.html;

import java.io.IOException;
import java.io.Writer;

public abstract class AbstractTable {
    protected Writer writer;
    protected String elementName;
    
    protected  AbstractTable(Writer writer, String elementName, Attr... attr) throws IOException {
        this.writer = writer;
        this.elementName = elementName;
        writer.write("<");
        writer.write(elementName);
        Attr.output(writer, attr);
        writer.write(">");
    }
    public final void end() throws IOException {
        writer.write("</");
        writer.write(elementName);
        writer.write(">");
    }
    public TR tr(Attr... attr) throws IOException {
        return new TR(writer, attr);
    }
}
