/*
 * Copyright (C) 2011-2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.html;

import java.io.IOException;
import java.io.Writer;

public class HEAD {
    private Writer writer;
    
    public HEAD(Writer writer) throws IOException {
        this.writer = writer;
        writer.write("<head>");
    }
    public HEAD meta(Attr... attr) throws IOException {
        writer.write("<meta");
        Attr.output(writer, attr);
        writer.write("/>");
        return this;
    }
    public HEAD title(String title) throws IOException {
        writer.write("<title>");
        writer.write(title);
        writer.write("</title>");
        return this;
    }
    public HEAD link(Attr... attr) throws IOException {
        writer.write("<link");
        Attr.output(writer, attr);
        writer.write("/>");
        return this;
    }
    public void end() throws IOException {
        writer.write("</head>");
    }
}
