/*
 * Copyright (C) 2011-2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.html;

import java.io.IOException;
import java.io.Writer;

public class HTML5 {
    private Writer writer;
    public HTML5(Writer writer) throws IOException {
        this.writer = writer;
        writer.write("<!DOCTYPE html>");
        writer.write("<html lang=\"ja\">");
    }
    public void end() throws IOException {
        writer.write("</html>");
        writer.close();
    }
    public HEAD head() throws IOException {
        return new HEAD(writer);
    }
    public BODY body() throws IOException {
        return new BODY(writer);
    }
}
