/*
 * Copyright (C) 2011-2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.html;

import java.io.IOException;
import java.io.Writer;

public class TR {
    private Writer writer;
    
    public TR(Writer writer, Attr... attr) throws IOException {
        this.writer = writer;
        writer.write("<tr");
        Attr.output(writer, attr);
        writer.write(">");
    }
    public final void end() throws IOException {
        writer.write("</tr>");
    }
    public TH th(Attr... attr) throws IOException {
        return new TH(writer, attr);
    }
    public TD td(Attr... attr) throws IOException {
        return new TD(writer, attr);
    }
}
