/*
 * Copyright (C) 2007-2012 infodb.org. All rights reserved.
 * This program is made available under the terms of
 * the Common Public License v1.0
 */
package org.infodb.wax.core.utils;

import java.io.File;
import java.io.IOException;

public class DirectoryScanner {
	public interface Listener {
		public void found(File f) throws IOException;
	}
	public static boolean search(String path, boolean recursive, Listener cb) throws IOException {
		File root = new File(path);
		if(root.exists() == false) {
			return false;
		}
		search(root, recursive, cb);
                return true;
	}
	public static void search(File base, boolean recursive, Listener cb) throws IOException {
		File[] files = base.listFiles();
		for(File f : files) {
			cb.found(f);
			if(recursive == true && f.isDirectory()) {
				search(f, recursive, cb);
			}
		}
	}
}
