package org.infodb.wax.core;

import java.io.StringWriter;
import org.infodb.wax.core.html.BODY;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class WikiProcessorTest {
    @DataProvider(name = "wiki")
    public Object[][] data() {
        return new Object[][] {
            {"*This is test.", "<body><h1>This is test.</h1></body>"}
        ,   {"**This is test.", "<body><h2>This is test.</h2></body>"}
        ,   {"***This is test.", "<body><h3>This is test.</h3></body>"}
        ,   {"-This is test.\n-No.2", "<body><ul><li>This is test.</li><li>No.2</li></ul></body>"}
        ,   {"--This is test.", "<body><ul><ul><li>This is test.</li></ul></ul></body>" }
        ,   {"---This is test.", "<body><ul><ul><ul><li>This is test.</li></ul></ul></ul></body>" }
        ,   {"+This is test.\n+No.2", "<body><ol><li>This is test.</li><li>No.2</li></ol></body>" }
        ,   {"++This is test.", "<body><ol><ol><li>This is test.</li></ol></ol></body>" }
        ,   {"+++This is test.", "<body><ol><ol><ol><li>This is test.</li></ol></ol></ol></body>" }
        ,   {"-This is test.\n-No.2\n--This is test.\n---This is test.\n-No.3",
             "<body><ul><li>This is test.</li><li>No.2</li><ul><li>This is test.</li><ul><li>This is test.</li></ul></ul><li>No.3</li></ul></body>"}
        ,   {"-This is test.\n-No.2\n++This is test.\n---This is test.\n-No.3",
             "<body><ul><li>This is test.</li><li>No.2</li><ol><li>This is test.</li><ul><li>This is test.</li></ul></ol><li>No.3</li></ul></body>"}
        ,   {"-This is test.\n-No.2\n++This is test.\n--This is test.\n-No.3",
             "<body><ul><li>This is test.</li><li>No.2</li><ol><li>This is test.</li></ol><ul><li>This is test.</li></ul><li>No.3</li></ul></body>"}
        ,   {"[[FrontPage]]", "<body><a href=\"FrontPage\">FrontPage</a></body>" }
        ,   {"abc[[FrontPage]]efg", "<body>abc<a href=\"FrontPage\">FrontPage</a>efg</body>" }
        ,   {"'''Italic'''", "<body><i>Italic</i></body>" }
        ,   {"''Bold''", "<body><strong>Bold</strong></body>" }
        ,   {"%%InvLine%%", "<body><s>InvLine</s></body>" }
        ,   {"test''Bold%%InvLine%%''abc", "<body>test<strong>Bold<s>InvLine</s></strong>abc</body>" }
        ,   {"test''Bold%%InvLine%%''abc'''Italic'''test", "<body>test<strong>Bold<s>InvLine</s></strong>abc<i>Italic</i>test</body>" }
        };
    }
    @Test(dataProvider="wiki")
    public void wikiTest(String before, String after) throws Exception {
        WikiBridge bridge = new WikiBridge();
        PluginManager pluginManager = new PluginManager();
        WikiProcessor processor = new WikiProcessor(bridge, pluginManager);
        
        StringWriter writer = new StringWriter();
        BODY body = new BODY(writer);
        processor.parse(before, body);
        body.end();
        Assert.assertEquals(writer.toString(), after);
    }
}
