package org.infodb.wax.core.db;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.xml.sax.ContentHandler;

public class TestContentResolver implements ContentResolver {
    private String contentType;
    private StringWriter writer;
    
    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
    @Override
    public ContentHandler getContentHandler() throws IOException {
        writer = new StringWriter();
        return new XmlWriter(writer);
    }
    
    public String getContentType() {
        return contentType;
    }
    public String getOutputString() throws UnsupportedEncodingException {
        return writer.toString();
    }
}
