package org.infodb.wax.core.db;

import org.testng.Assert;
import org.testng.annotations.Test;
import org.xml.sax.InputSource;

public class XmlQueryTest {
    @Test
    public void writeTest() throws Exception {
        TestContentResolver tcr = new TestContentResolver();
        
        XmlQuery xq = new XmlQuery(tcr);
        xq.setContentType("text/xml");
        xq.setInputSouce(new InputSource("src/test/data/test3.xml"));
        xq.begin();
        xq.execute();
        xq.end();
        
        Assert.assertEquals(tcr.getContentType(), "text/xml");
        Assert.assertEquals(tcr.getOutputString(), "<?xml version=\"1.0\" encoding=\"UTF-8\"?><data><root>\n    <abc test=\"this is test.\"></abc>\n</root></data>");
    }
}
