package org.infodb.wax.core.db;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.UUID;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.xml.sax.InputSource;

public class XmlStorageTest {
    private XmlStorage storage;
    private EmbeddedDataSource ds;
    
    @BeforeClass
    private void init() throws Exception {
        Injector injector = Guice.createInjector(new Module() {
            @Override
            public void configure(Binder binder) {
                binder.bind(Definition.class).to(DefDerby.class);
                binder.bind(TableDef.class).to(TestTableDef.class);
            }
            @Provides
            public DataSource provideDataSource() {
                ds = new EmbeddedDataSource();
                ds.setDatabaseName("wax");
                ds.setCreateDatabase("create");
                
                return ds;
            }
        });
        storage = injector.getInstance(XmlStorage.class);
    }
    @AfterClass
    private void exit() throws Exception {
        ds.setShutdownDatabase("shutdown");
    }
    @Test
    public void createTable() throws Exception {
        if(storage.existTable() == false) {
            storage.createTable();
        }
    }
    @Test(dependsOnMethods = {"createTable"})
    public void insertTest1() throws Exception {
        XmlStore xs = new XmlStore();
        xs.setInputSource(new InputSource("src/test/data/test1.xml"));
        storage.insert(UUID.randomUUID().toString(), "test1", "text/xml", xs, "test1");
    }
    @Test(dependsOnMethods = {"createTable"})
    public void insertTest2() throws Exception {
        XmlStore xs = new XmlStore();
        xs.setInputSource(new InputSource("src/test/data/test2.xml"));
        storage.insert(UUID.randomUUID().toString(), "test2", "text/xml", xs, "test2");
    }
    @Test(dependsOnMethods = {"insertTest1", "insertTest2"})
    public void queryTest() throws Exception {
        TestContentResolver tcr = new TestContentResolver();
        
        XmlQuery xq = new XmlQuery(tcr);
        xq.addWhere(new SQLWhere("test2"));
        storage.query(UUID.randomUUID().toString(), xq);

        Assert.assertEquals(tcr.getContentType(), "text/xml");
        Assert.assertEquals(tcr.getOutputString(), "<?xml version=\"1.0\" encoding=\"UTF-8\"?><data><test2 xmlns=\"http://infodb.org/wax2/test\" test=\"true\">\n    This is Test2.\n</test2></data>");
    }
    @Test(dependsOnMethods = {"insertTest1", "insertTest2"})
    public void queryTest2() throws Exception {
        TestContentResolver tcr = new TestContentResolver();
        
        XmlQuery xq = new XmlQuery(tcr);
        storage.query(UUID.randomUUID().toString(), xq);
        
        System.out.println(tcr.getContentType());
        System.out.println(tcr.getOutputString());
    }
}
