package org.infodb.wax.core.db;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.xml.sax.InputSource;

public class XmlStoreTest {
    /**
     * XmlStoreはDOMも同時に作成する機能を持っている。
     * そのDOMをTransformerで変換して、XmlWriterで書き込んだ結果と比較している。
     * このテストではDOMとして生成されているXMLが過不足無いことと
     * Transformerで変換した結果とXmlWriterが同じである事が確認できる。
     * 
     * ただ懸念点としては、名前空間の宣言位置の書き方で問題が生じるかもしれない。
     * 
     * @throws Exception 
     */
    @Test
    public void writeTest() throws Exception {
        XmlStore xs = new XmlStore();

        StringWriter w1 = new StringWriter();
        StringWriter w2 = new StringWriter();
        
        xs.setInputSource(new InputSource(new StringReader("<test>abc</test>")));
        xs.setWriter(w1);
        xs.execute();
        
        TransformerFactory transFactory = TransformerFactory.newInstance();
        SAXTransformerFactory saxFactory = (SAXTransformerFactory) transFactory;
        TransformerHandler trans = saxFactory.newTransformerHandler();
        trans.getTransformer().transform(new DOMSource(xs.getDocument()), new StreamResult(w2));
        
        Assert.assertEquals(w1.toString(), w2.toString());
    }
}
