#!/bin/sh

GIT_BASE_DIR=${HOME}/git/sfjp/wesnoth-ja/ja-po
GIT_TOOLS_DIR=${HOME}/git/sfjp/wesnoth-ja/tools/create-update18-archive
TARGET_DIR=${HOME}/tmp

DATE=`date +%Y%m%d`
TARGET_VER=1.8.5
NAME=wesnoth-${TARGET_VER}_ja-catalogs-${DATE}

TRANSLATED_FILES=(httt)

rm -rf  $TARGET_DIR/$NAME
rm -f $TARGET_DIR/${NAME}.{zip,tar.gz}
mkdir -p $TARGET_DIR/$NAME
cd $TARGET_DIR/$NAME

#mkdir wesnoth
#cp $GIT_BASE_DIR/wesnoth/ja.po wesnoth-${TARGET_VER}_wesnoth-${DATE}_ja.po

for fname in ${TRANSLATED_FILES[@]}
do
    cp ${GIT_BASE_DIR}/wesnoth-${fname}/ja.po wesnoth-${TARGET_VER}_${fname}-${DATE}_ja.po
done

# add files
cp ${GIT_BASE_DIR}/COPYING .
cp ${GIT_TOOLS_DIR}/README.txt .

cd $TARGET_DIR
tar zcvf ${NAME}.tar.gz ${NAME}
zip -r ${NAME}.zip ${NAME}

