package org.wicketja;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.wicket.protocol.http.WebApplication;
import org.wicketja.pages.AboutWicketPage;
import org.wicketja.pages.AboutWicketjaPage;
import org.wicketja.pages.FaqPage;
import org.wicketja.pages.HomePage;
import org.wicketja.pages.LinksPage;
import org.wicketja.pages.NewsPage;

/**
 * Wicket-JAサイトのアプリケーションクラスです。
 * @author Yoichiro Tanaka
 */
public class WicketApplication extends WebApplication {

    EntityManagerFactory entityManagerFactory;

    /**
     * このオブジェクトが生成されるときに呼び出されます。
     */
    public WicketApplication() {
        super();
    }

    /**
     * 各種の初期化処理を行います。
     */
    @Override
    protected void init() {
        super.init();
        //テンプレートエンコーディングの設定
        getMarkupSettings().setDefaultMarkupEncoding("UTF-8");

        //レスポンスのエンコーディング設定
        getRequestCycleSettings().setResponseRequestEncoding("UTF-8");

        // 各ページを分かりやすいURLに変更 
        mountBookmarkablePage("/news", NewsPage.class);
        mountBookmarkablePage("/faq", FaqPage.class);
        mountBookmarkablePage("/links", LinksPage.class);
        mountBookmarkablePage("/about_wicket", AboutWicketPage.class);
        mountBookmarkablePage("/about_wicket-ja", AboutWicketjaPage.class);

        entityManagerFactory = Persistence.createEntityManagerFactory("WicketJaPersistenceUnit");
    }

    @Override
    public String getConfigurationType() {
        //filterのinit-parameterでconfigurationに「development」と指定したときだけ、developmentモードで起動します。
        //それ以外のケースでは常にdeploymentモードで起動します。
        String configuration = this.getWicketFilter().getFilterConfig().getInitParameter("configuration");
        if (configuration != null && configuration.equalsIgnoreCase(WebApplication.DEVELOPMENT)) {
            return WebApplication.DEVELOPMENT;
        }

        return WebApplication.DEPLOYMENT;
    }

    /**
     * ホームページとなるページのクラスを返します。
     * @return ホームページとなるページのクラスオブジェクト
     * @see org.apache.wicket.Application#getHomePage()
     */
    @Override
    public Class<?> getHomePage() {
        return HomePage.class;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return entityManagerFactory;
    }

    @Override
    protected void onDestroy() {
        if(entityManagerFactory != null) {
            entityManagerFactory.close();
        }
    }
}
