package org.wicketja.pages;

import java.text.DateFormat;
import java.util.Locale;

import org.apache.wicket.PageParameters;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.wicketja.dao.LinkDao;
import org.wicketja.dao.LinkDaoImpl;
import org.wicketja.model.LinkItem;

/**
 * リンク集を掲載するページクラスです。
 * 
 * @author Yoichiro Tanaka
 * @author Tsutomu YANO
 */
@SuppressWarnings("serial")
public class LinksPage extends AbstractWebPage {

    IModel linkModel = new LoadableDetachableModel() {
        @Override
        protected Object load() {
            linkDao = new LinkDaoImpl(getEntityManager());
            return linkDao.findAll();
        }
    };
    
    // DI導入したら修正
    //@SpringBean 
    //private LinkDao linkDao;
    protected LinkDao linkDao = null;

    /**
     * このオブジェクトが生成される時に呼び出されます。
     * 
     * @param params
     *            ページパラメータ
     */
    public LinksPage(PageParameters params) {
        super();
        add(new ListView("linkList", linkModel) {

            /**
             * 
             */
            private static final long serialVersionUID = -549300948518205781L;

            @Override
            protected void populateItem(ListItem item) {
                LinkItem linkItem = (LinkItem) item.getModelObject();
                item.add(new ExternalLink("title", linkItem.getUrl(), linkItem.getName()));
                item.add(new Label("excerpt", linkItem.getExcerpt()));
                item.add(new Label("registered", DateFormat.getDateInstance(
                        DateFormat.FULL, Locale.JAPAN).format(
                        linkItem.getRegisterDate().getTime())));
                item.add(new Label("category", linkItem.getCategory().getTitle()));
                ExternalLink externalLink = new ExternalLink("rss", linkItem.getFeedUrl(), "RSS");
                if (linkItem.getFeedUrl() == null || linkItem.getFeedUrl().equals("")) {
                    externalLink.setVisible(false);
                } else {
                    externalLink.setVisible(true);
                }
                item.add(externalLink);
            }
        });
    }
}
