#pragma once
#include "WaveTableSynth.h"
#include "Sequencer.h"
#include "TestSong.h"

typedef Microsoft::WRL::ComPtr<IAudioClient2> IAudioClient2Ptr;
//typedef Microsoft::WRL::ComPtr<IAudioClock2> IAudioClock2Ptr;
typedef Microsoft::WRL::ComPtr<IAudioRenderClient> IAudioRenderClientPtr;
//typedef Microsoft::WRL::ComPtr<IAudioCaptureClient> IAudioCaptureClientPtr;
//typedef Microsoft::WRL::ComPtr<IAudioClockAdjustment> IAudioClockAdjustmentPtr;

namespace sf {

  DefineException(AudioClientNull);
  DefineException(AudioFormatNotSupported);

  struct SoundDriver
  {
    typedef std::function<void (boost::shared_array<float> arr,int bufferSize)> ProcessBufferType;

    SoundDriver();
    ~SoundDriver();

    void Render();
    void Start();
    void Stop();
    void DefaultProcessBuffer(boost::shared_array<float> arr,int bufferSize);
    void SetProcessBufferFunc(ProcessBufferType&& v);
    void ResetProcessBufferFunc();
    WAVEFORMATEXTENSIBLE& Format();
  private:
	  struct impl;
    std::unique_ptr<impl> impl_;
  };
}

