#pragma once

#include "SoundDriver.h"
#include "WaveTableSynth.h"
#include "Sequencer.h"
#include "TestSong.h"

namespace sf {
  struct SoundManager
  {
    SoundManager(SoundDriver& driver);
    void ProcessBuffer(boost::shared_array<float> arr,int bufferSize);
    virtual ~SoundManager();
    sf::Synthesizer& SoundManager::Synthesizer() {return synth_;}
    sf::Sequencer& SoundManager::Sequencer() {return sequencer_;}
  private:
    SoundDriver& driver_;
    sf::Synthesizer synth_;
    sf::Sequencer sequencer_;
  };
}

