#include "pch.h"
#include "SoundManager.h"

namespace stps = std::placeholders;

namespace sf {
SoundManager::SoundManager(SoundDriver& driver) : driver_(driver),synth_(driver_.Format()),sequencer_(synth_,driver_.Format())
{
    sequencer_.Tempo(150.0f);
    TestSong song(sequencer_.SequenceTracks());
    driver_.SetProcessBufferFunc(std::bind(&SoundManager::ProcessBuffer,this,stps::_1,stps::_2));
}

void SoundManager::ProcessBuffer(boost::shared_array<float> arr,int bufferSize)
{
  // ̂Ƃo͂̓XeIO
  //for(int j = 0;j < voices_.size();++j)
  //{
  //  voices_[j].Process(buffer);
  //  *ptr +=  buffer[0]; 
  //  *(ptr + 1) += buffer[1]; 
  //}
  float *ptr = arr.get();

  ZeroMemory(ptr,sizeof(float) * bufferSize * 2);

  for(int i = 0;i < bufferSize;++i)
  {
    sequencer_.Process();
    synth_.Process(ptr);
    ptr += 2;
  }

}



SoundManager::~SoundManager()
{
}
}
