﻿/*
  graph.c

  glue layer for drivers

  g_print rev_area tg_copy tg_copy2 t_scrw txcur

  Made by Studio Breeze. 1998, 2002


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#include "sted.h"
#include "sted_screen.h"

void
g_print( int in_x, int in_y, char *in_str, int in_col )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->SetGraphicsColor(in_col);
  scr->GraphicsPuts(in_x, in_y, in_str);

  return;
}

void
rev_area( int in_r_ad, int in_r_ln, int in_edit_scr )
{

  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->TextReverseArea(in_r_ad, in_r_ln, in_edit_scr);
  return;
}

void
tg_copy( int in_edit_scr )
{

  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  /* T_VRAM to G_VRAM */
  /* edit_scr=0 : left, edit_scr=1 : right  */
  /* (2,4)-(19,31)      (58, 4)-(75,31)     */

  scr->CopyTextToGraphics(in_edit_scr);
  return;
}

void
tg_copy2( int in_edit_scr )
{

  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  /* T_VRAM to G_VRAM */
  /* edit_scr=0 : left, edit_scr=1 : right  */
  /* (0,6)-(27,29)         (38,6)-(65,29) */

  scr->CopyTextToGraphics2(in_edit_scr);
  return;
}

void
t_scrw( int in_x0, int in_y0, int in_xs, int in_ys, int in_x1, int in_y1 ) {

  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->TextScroll(in_x0, in_y0, in_xs, in_ys, in_x1, in_y1);
  return;
}

void
txcur( int in_a, int in_b, int in_c1, int in_c2, int in_cs )
{

  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  int i;

  if ( edit_scr ) in_a+=56; // edit_scr: grobal variable
  for (i=0; i<in_c2; i++) {
    scr->TextReverse(in_a, in_b+i, in_c1, in_cs);
  }
  return;
}
