﻿/*
  mcpy.c

  functions for compatibility to mcpy.s
  ( some memory-oriented functions )

  Made by Studio Breeze. 1998, 2002


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#include "sted.h"
#include "sted_screen.h"

/*
  void memcpy_l( unsigned char *dest, unsigned char *src , int len )

   copies len bytes from src to dest

   I guess that original programmer want to make fast copy function
   by coding long-word copy routine.
 */

void memcpy_l( unsigned char *dest, unsigned char *src, int len ) {

  memmove( (void *)dest, (void *)src, (size_t)len );
  return;

#if 0
  int d1,d2;

  if ( !len ) return;
  if ( dest=src ) return;

  len/=4;
  d2=len;
  len--;
  d1=d0;

  if ( dest > src ) {
    d2*=4;
    dest+=d2;
    src+=d2;
  }

  while ( len ) {
    while ( d1 ) {
      *(--dest) == *(--src);
    }
  }
  return;
#endif

}

/*
  void keyclr( void )

   clear key buffer

 */

void
keyclr( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;
  scr->ClearKeyBuffer();
}

