﻿/*
 * MIDI Music Composer STed v2.07j : sted.h (header) 1997-07-20 by TURBO
 */
#pragma once
#ifndef _STED_H_
#define _STED_H_

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <errno.h>
#include <math.h>
#include <ctype.h>
#include <sys/stat.h>

#ifdef HAVE_STRING_H
#  include <string.h>
#endif /* HAVE_STRING_H */

#ifndef STDC_HEADERS
#  ifndef HAVE_STRCHR
#    define strchr index
#    define strrchr rindex
#  endif /* HAVE_STRCHR */
   char *strchr(), *strrchr();
#  ifndef HAVE_MEMCPY
#    define memcpy(d, s, n) bcopy((s), (d), (n))
#    define memmove(d, s, n) bcopy((s), (d), (n))
#  endif
#endif

#ifdef HAVE_FCNTL_H
#  include <fcntl.h>
#endif /* HAVE_FCNTL_H */

#ifdef HAVE_UNISTD_H
#  include <sys/types.h>
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */

#ifndef HAVE_SYS_TIME_H
#  include <time.h>
#else /* HAVE_SYS_TIME */
#  ifdef TIME_WITH_SYS_TIME
#    include <time.h>
#  endif /* TIME_WITH_SYS_TIME */
#  include <sys/time.h>
#endif

#include <sys/types.h>
#ifdef HAVE_SYS_WAIT_H
#  include <sys/wait.h>
#endif /* HAVE_SYS_WAIT_H */
#ifndef WEXITSTATUS
#  define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif /* WEXITSTATUS */
#ifndef WIFEXITED
#  define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif /* WIFEXITED */

#ifdef HAVE_DIRENT_H
#  include <dirent.h>
#  define NAMLEN(dirent) strlen((dirent)->d_name)
#else
#  define dirent direct
#  define NAMLEN(dirent) (dirent)->d_namlen
#  ifdef HAVE_SYS_NDIR_H
#    include <sys/ndir.h>
#  endif
#  ifdef HAVE_SYS_DIR_H
#    include <sys/dir.h>
#  endif
#  ifdef HAVE_NDIR_H
#    include <ndir.h>
#  endif
#endif /* HAVE_DIRENT_H */

#include "version.h"

#include "iocslib.h"
#include "doslib.h"
#include "graph.h"
#include "rcddef.h"
#include "x68funcs.h"
#include "midi_in.h"

#define HAVE_SUPPORT_STED3
#ifdef HAVE_SUPPORT_STED3
# include "sted3.h"
#endif

#include "sted2header.h"

 void rcd_check( void );
 void rcd_open_device( void );
extern  struct RCD_HEAD	*rcd;
extern  char rcd_version[5];
/* etc */
extern  char	hlp_path[128];			/* help file path & name	*/
extern  char	fon_path[128];			/* font file path & name	*/
extern  char	def_path[128];			/* .def path name		*/
extern  char	rcp_path[128];			/* .rcp path name		*/
extern  char	prt_path[128];			/* .prt path name		*/
extern  char	trk_path[128];			/* .trk path name		*/
extern  char	def_file[128];			/* .def file name		*/
extern  char	rcp_file[128];			/* .rcp file name		*/
extern  char	prt_file[128];			/* .prt file name		*/
extern  char	trk_file[128];			/* .trk file name		*/
extern  char	repl[128];			/* replace string		*/
extern  char	delt[128];			/* delete string		*/
extern  char	srch[128];			/* find string			*/
extern  char	repl_t[26*6][40];
extern  char	repl_d[26*6][50];
extern  int	tr_step[36];			/* track total step temp	*/
extern  int	tr_alc[36];			/* track aloc size		*/
extern  int	tr_len[36];			/* track used size		*/
extern  int	tr_pos[36][2][4];		/* track cursor position	*/
extern  int	tag[26+2][4];			/* tag jamp list buffer		*/
extern  int	es,ecode,scyp;			/* input subroutine exit code	*/
extern  int	btrack;				/* track set top track		*/
extern  int	track,track1,track2;		/* edit track no.		*/
extern  int	edit_scr;			/* 0=l_track 1=r_track 2=rhythm	*/
extern  int	cmdflag,cnfflag,mdlflag;	/* STed2 system flag		*/
extern  int	poft;
extern  int	TRACK_SIZE,work_size;		/* buffer size			*/
extern  int	buff_size,buff_free,buff_max;
extern  int	cpcy,cpadd,cplen;
extern  int	cpleng,rcpf,rcplen;		/* copy flag			*/
extern  void	*ErrorTrap_Old;			/* err trap vecter/flag		*/
extern  int	ErrFlag;
/* cnf */
extern  char	comment[64];			/* comment			*/
extern  int	tm_lag;				/* graphic rewrite time lag	*/
extern  char	inpmode;			/* editor input mode		*/
extern  char	grpmode;			/* editor graphic mode		*/
extern  char	thrumode;			/* edit midi in thru mode	*/
extern  int	rec_getch,rec_putmd;		/* recoding ch./put mode	*/
extern  int	vis_reso;			/**/
extern  unsigned char	rfilt[32][4];		/* record filter */
extern  unsigned char	pfilt[32][4];		/* play   filter */
extern  char	mplay[16][16];
extern  int	palet_dat[16];
extern  unsigned char	keyst_table[2][128];	/* key# -> st/gt convert table	*/
extern  unsigned char	stgt_tbl[60];		/* f.key -> st/gt table		*/
extern  char	rhy_vel[16];
extern  char	chcom_s[26*2][2][50];		/* child command comment	*/
extern  char	chcom_c[26*2][2][16];		/* child command parameter	*/
/* def */
extern  char	module[64];			/* module name			*/
extern  int	lsp_wait;			/* last para. transfer wait	*/
extern  int	bend_range;			/* piche bend range		*/
extern  char	tim_asin[33];			/* tone list channle assign	*/
extern  char	tim_head[400][24];		/* tone list title		*/
extern  char	tim_sym[400][8];		/* tone list symbol		*/
extern  char	tim_name[80*128][15];		/* tone name buffer		*/
extern  short	tim_top[400];			/* tone name buffer address	*/
extern  char	card_name[21][64];		/* pcm card name list		*/
extern  char	card_no[2];			/* used pcm card no.		*/
extern  short	gs_bank[18*128];		/* gs bank part no.(8+1 group)	*/
extern  short	gs_mode[18];			/* gs bank mode    (8+1 group)	*/
extern  char	rhy_stest[8];			/* rhythm sound test ch. & para	*/
extern  char	rec_met[10];			/* recording metoro tone	*/
extern  unsigned char	init_exc_data[258];	/* init exclusive data		*/
/*** rcp format head parameter ***/
extern  char	mtitle[65];			/* music title			*/
extern  char	memo[12][29];			/* memo				*/
extern  int	tbase,mtempo;
extern  int     beat1,beat2,bkey,pbias;		/* common parameter		*/
extern  char	cm6_file[128],gsd_file[128];	/* controol file name		*/
extern  char	rhyna[32][15];			/* rhythm assign name		*/
extern  unsigned char	rhyno[32][2];		/* rhythm assign key & gate	*/
extern  char	user_exc_memo[8][25];		/* user exclusive memo		*/
extern  unsigned char	user_exc_data[8][24];	/* user exclusive data		*/
extern  unsigned char	trno[36];		/* track no.			*/
extern  unsigned char	trmod[36];		/* track play mode		*/
extern  unsigned char	trrhy[36];		/* track rhythm sw.		*/
extern  unsigned char	mch[36];		/* track midi ch.		*/
extern  unsigned char	trkey[36];		/* track key shift		*/
extern  unsigned char	trst[36];		/* track st shift		*/
extern  char	trkmemo[36][37];		/* track comment		*/
/* buffer */
extern  unsigned char	lcbuf[1024*4+4];	/* delete line buffer		*/
extern  unsigned char	rlcbuf[132];		/* delete rhythm line buffer	*/
extern  unsigned char	cm6[22601],gsd[4096];	/* control file buffer		*/
extern  unsigned char	hed[1414];		/* rcp header temporary		*/
extern  unsigned char	*trk[36];		/* track buffer pointer		*/
extern  unsigned char	*cpbuf;			/* track copy buffer		*/
extern  unsigned char	*rcpbuf;		/* rhythm track copy buffer	*/
extern  unsigned char	*dat;			/* temporary & recording buffer	*/
extern  unsigned char	*dat2;			/* temporary			*/
/* the following variables is only PC version available */
extern  int issted3;                     /* Am I a new version ? */
extern  int isconsole;                   /* is console mode? */
extern  int isxwin;                      /* is X mode? */
extern  char euc_text[1024];             /* code convert buffer */
extern  char player_name[1024];          /* midi player name */
extern  char midi_port_name[1024];       /* midi_port device name */
extern  char font_name[1024];            /* X font set name */
extern  int player_flag;                 /* is player able to play only SMF? */
extern  char KEY_XF1[];                  /* keysym names */
extern  char KEY_XF2[];
extern  char KEY_XF3[];
extern  char KEY_XF4[];
extern  char KEY_XF5[];
extern  char KEY_KANA[];
extern  char KEY_KIGO[];
extern  char KEY_TOROKU[];
extern  char KEY_INS[];
extern  char KEY_DEL[];
extern  char KEY_HOME[];
extern  char KEY_UNDO[];
extern  char KEY_RUP[];
extern  char KEY_RDOWN[];
extern  char KEY_OPT1[];
extern  char KEY_OPT2[];
extern int str_vala;


 int itor( char *, char * );
 int STed_MeasureConversion( int track );
 void Exit(int);
#define exit Exit
 int sted_sleep(long in_usleep);

extern int eucenv;

 char *nkf_conv(char *, char *, char *);
#define eucconv(a) ((eucenv!=0) ? nkf_conv( a, euc_text, "EUC" ) : a)

#ifdef ENABLE_NLS
# include <locale.h>
# include <libintl.h>
# undef _
# define _(String) gettext(String)
# define N_(String) (String)

#else /* ENABLE_NLS */
# define _(String) (String)
# define N_(String) (String)
#endif /* ENABLE_NLS */

/* inlines */
 void    rec_filter(int md);
 int       option22(int md,int sm,int ad,int ew);
// int       option2(int md,int sm,int ad,int ew);

#endif /* _STED_H_ */
