﻿/*
  win32_color.cpp
  base class of screen driver

  Made by Studio Breeze. 2002

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */
#include "stdafx.h"

#include "sted_screen_win32.h"

// private
COLORREF
CSTedScreenWin32::PageToColor(int in_page)
{
  int c = 0;
  COLORREF r;

  switch (in_page) {
	  case 0: c=1;break;
	  case 1: c=2;break;
	  case 2: c=3;break;
	  case 3: c=0;break;
  }

  r = RGB(fTextPalette[c].fBlue,
	  fTextPalette[c].fGreen,
	  fTextPalette[c].fRed);
  return r;
}

// color
int
CSTedScreenWin32::SetGraphicsPalette(int in_pal, int in_color)
{
  int r,g,b;

  if (in_pal<0 || in_pal>=fMaxGraphicsColor) return 0;

  r=((in_color>>6)&0x001f)<<3;
  b=((in_color>>1)&0x001f)<<3;
  g=((in_color>>11)&0x001f)<<3;

  fGraphicsPalette[in_pal].fRed = r;
  fGraphicsPalette[in_pal].fGreen = g;
  fGraphicsPalette[in_pal].fBlue = b;

  return 0;
}

int
CSTedScreenWin32::SetTextPalette(int in_pal, int in_color)
{
  int r,g,b;
  if (in_pal<0 || in_pal>=fMaxTextColor) return 0;

  r=((in_color >> 6) &0x001f)<<3;
  b=((in_color >> 1) &0x001f)<<3;
  g=((in_color >> 11)&0x001f)<<3;

  fTextPalette[in_pal].fRed = r;
  fTextPalette[in_pal].fGreen = g;
  fTextPalette[in_pal].fBlue = b;

  return 0;
}

int
CSTedScreenWin32::SetGraphicsColor(int in_color)
{
  COLORREF r;

  if (in_color<0 || in_color>=fMaxGraphicsColor) return 0;

  fCurrentGraphicsColor = in_color;
  r = RGB(fGraphicsPalette[in_color].fBlue, 
	  fGraphicsPalette[in_color].fGreen, 
	  fGraphicsPalette[in_color].fRed);

  //::SetTextColor(fGraphicsWindowDC[0], r);
  //::SetTextColor(fGraphicsWindowDC[1], r);
  //::SetBkMode(fGraphicsWindowDC[0], TRANSPARENT);
  //::SetBkMode(fGraphicsWindowDC[1], TRANSPARENT);

  return r;
}

int
CSTedScreenWin32::SetTextColor(int in_color)
{
  int c;
  int lastcolor;
  COLORREF rgb;
  BOOL invert = FALSE;

  c = in_color;
  if (c&0x08) { // reverse
	invert = TRUE;
	c&=0x03;
  }
  lastcolor = fCurrentTextColor;

  rgb = RGB(fTextPalette[c].fBlue,
	    fTextPalette[c].fGreen,
	    fTextPalette[c].fRed);

  if (invert) {

	//::SetTextColor(fTextDC, RGB(0xff, 0xff, 0xff));
	//::SetBkColor(fTextDC, rgb);
	//::SetTextColor(fTextMaskDC, RGB(0x00, 0x00, 0x00));
	//::SetBkColor(fTextMaskDC, RGB(0xff, 0xff, 0xff));
	fCurrentTextColor = 0;
	fCurrentTextBackColor = c;
  } else {
	//::SetTextColor(fTextDC, rgb);
	//::SetBkColor(fTextDC, RGB(0xff, 0xff, 0xff));
	//::SetTextColor(fTextMaskDC, RGB(0xff, 0xff, 0xff));
	//::SetBkColor(fTextMaskDC, RGB(0x00, 0x00, 0x00));
	fCurrentTextColor = c;
	fCurrentTextBackColor = 0;
  }

 /* ::SetBkMode(fTextDC, OPAQUE);
  ::SetBkMode(fTextMaskDC, OPAQUE);*/

  return lastcolor;
}
