﻿#pragma once
/** @file
*  @brief MIDI Inputのヘッダーファイル
*/
//#include "midi_message.h"
#include "exception.h"

namespace sf {

  const int midi_ch_num = 16;
  const int control_change_num = 2;
  const int max_control_changes = 128;


  /** デバイスエラー時に投げる例外 */
  struct midi入力エラー : sf::exception 
  {
    midi入力エラー(const boost::uint32_t error) : error_id_(error),exception(get_error_string(error)){}
    const int error_id() const {return error_id_;}
  private:
    const int error_id_;
    const std::wstring get_error_string(boost::uint32_t id);
  };
  
  /** デバイスが存在しない時に投げる例外 */
  struct MIDI入力デバイスが存在しない : sf::exception 
  {
    explicit MIDI入力デバイスが存在しない()  : exception(L"MIDI Input Deviceが見つかりません。"){}
  };

  inline void MIDI入力エラーなら例外を投げる(const boost::uint32_t error)
  {
    if(MMSYSERR_NOERROR !=  error)
    {
      throw midi入力エラー(error);
    }
  };

  /** MIDI Input Class */
  struct midi入力
  {
    
    typedef boost::signals2::signal<void (boost::uint32_t wMsg,boost::uint32_t midi_message,boost::uint32_t time_stamp) > MIDIメッセージ到着時型;
    MIDIメッセージ到着時型 MIDIメッセージ到着時;


    /** MIDI IN インターフェース*/
    struct caps {
      caps(const MIDIINCAPS2& value,const boost::uint32_t dev_id) :id_(dev_id),名前_(value.szPname),デバイス情報_(value)
      {

      }
      const boost::uint32_t id() const { return id_;}
      const std::wstring& name() const  {return 名前_;}
    private:
      const boost::uint32_t id_;
      const std::wstring 名前_;
      MIDIINCAPS2 デバイス情報_;
    };

    typedef boost::ptr_vector<caps> デバイス情報コンテナ型;

    midi入力(boost::uint32_t id);
    virtual ~midi入力();

    //void id(const boost::uint32_t id) { assert(id < デバイス情報.size()); dev_id_ = id;}
    const boost::uint32_t id() {return dev_id_;} 

    const boost::uint32_t デバイス数() {return ::midiInGetNumDevs();}

    /** ドライバのオープン */
    void オープン()
    {
      if(デバイス数() > 0){
        int 結果 = midiInOpen(&hmidiin_,dev_id_,(LONG_PTR)(&midi_in_proc),(DWORD_PTR)this,CALLBACK_FUNCTION);
        assert(結果 == MMSYSERR_NOERROR);
      } else {
        throw MIDI入力デバイスが存在しない();
      }
      ::midiInPrepareHeader(hmidiin_,&MIDIバッファ情報_,sizeof(MIDIバッファ情報_));
    }

    /** 受信開始 */
    void 受信開始()
    {
      assert(hmidiin_ != NULL);

//      memset(control_change_buffer_,0,sizeof(boost::uint32_t) * midi_ch_num * control_change_num );

      boost::uint32_t 結果 = midiInStart(hmidiin_);
      assert(結果 == MMSYSERR_NOERROR);
      MIDI入力エラーなら例外を投げる(結果);
    }

    /** 受信停止 */
    void 受信停止()
    {
      if(hmidiin_ == NULL) return;
      assert(hmidiin_ != NULL);
      boost::uint32_t 結果 = midiInStop(hmidiin_);
      assert(結果 == MMSYSERR_NOERROR);
      MIDI入力エラーなら例外を投げる(結果);
    }

    /** リセット */
    void リセット()
    {
      if(hmidiin_ == NULL) return;
      assert(hmidiin_ != NULL);
      boost::uint32_t 結果 = midiInReset(hmidiin_);
      assert(結果 == MMSYSERR_NOERROR);
      MIDI入力エラーなら例外を投げる(結果);
    }

    /** クローズ */
    void クローズ()
    {
      if(hmidiin_ == NULL) return;

      boost::uint32_t 結果 = midiInClose(hmidiin_);
      assert(結果 == MMSYSERR_NOERROR);
      hmidiin_ = NULL;
      MIDI入力エラーなら例外を投げる(結果);
      ::midiInUnprepareHeader(hmidiin_,&MIDIバッファ情報_,sizeof(MIDIバッファ情報_));
    }

    /** デバイス情報のコンテナを返す */
    static const デバイス情報コンテナ型 & デバイス情報コンテナ(){return デバイス情報;};

    /** MIDI IN コールバック */
    static void CALLBACK midi_in_proc(
      HMIDIIN hMidiIn,  
      boost::uint32_t wMsg,        
      DWORD dwInstance, 
      DWORD dwParam1,   
      DWORD dwParam2    
      ){
        //::OutputDebugStringW(L"input_proc\n");
        reinterpret_cast<midi入力*>(dwInstance)->MIDIメッセージ到着時(wMsg,dwParam1,dwParam2);
    }
    /** デバイス情報を列挙し、コンテナに情報を格納する */
    static void デバイスの列挙();

    /** ハンドルを返す */
    HMIDIIN ハンドル() const {return hmidiin_;}
  private:
    /** デバイス情報が入るコンテナ */
    static デバイス情報コンテナ型 デバイス情報;
//    boost::uint32_t control_change_buffer_[midi_ch_num][control_change_num];
    /** デバイスのハンドル */
    HMIDIIN hmidiin_;
    /** デバイスのID */
    boost::uint32_t dev_id_;

    static const int バッファ容量_ = 16384;//16K
    ::MIDIHDR MIDIバッファ情報_;
    /** エクスクルーシブ用バッファ */
    boost::uint8_t エクスクルーシブバッファ_[バッファ容量_];
  };
}
