#pragma once

namespace sf
{
///Exception
	class exception : public std::exception
	{
	public:
		explicit exception(const std::wstring& reason)
		{
			m_reason = reason;
		};
		const wchar_t * what() {return m_reason.c_str();};
		const std::wstring& what_str() { return m_reason;};
	protected:
		std::wstring m_reason;
	};

	class win32_error_exception : std::exception 
	{
	public:
		win32_error_exception(boost::uint32_t hr);
		win32_error_exception();

		virtual ~win32_error_exception() {};
		boost::uint32_t hresult() {return hresult_;}
		std::wstring& error() {return error_;}
	private:
		boost::uint32_t hresult_;
		std::wstring error_;
	};


}