﻿#include "stdafx.h"
#define BOOST_ASSIGN_MAX_PARAMS 7
#include <boost/assign.hpp>
#include <boost/assign/ptr_list_of.hpp>
#include <boost/assign/ptr_list_inserter.hpp>
#include <boost/foreach.hpp>
#include "sf_windows.h"
#include "exception.h"

#define THROW_IF_ERR(hres) \
  if (FAILED(hres)) { throw sf::win32_error_exception(hres); }

#ifndef HINST_THISCOMPONENT
EXTERN_C IMAGE_DOS_HEADER __ImageBase;
#define HINST_THISCOMPONENT ((HINSTANCE)&__ImageBase)
#endif

namespace sf 
{
  LRESULT base_window::window_proc(HWND hwnd,boost::uint32_t message, WPARAM wParam, LPARAM lParam)
  {

    LRESULT result = 0;
    switch (message)
    {
    case WM_CREATE:
      {
        // TODO:
        create_device();
        break;
      }
    case WM_SIZE:
      {
        //if (render_target_)
        //{
        //	D2D1_SIZE_U size;
        //	size.width = lParam & 0xFFFF;
        //	size.height = (lParam >> 16) & 0xFFFF; ;

        //	// Note: This method can fail, but it's okay to ignore the
        //	// error here -- it will be repeated on the next call to
        //	// EndDraw.
        //	//render_target_->Resize(size);
        //}
      }
    case WM_PAINT:
      {
        //create_device();

        paint_struct begin_paint(hwnd);

        //if (!(render_target_->CheckWindowState() & D2D1_WINDOW_STATE_OCCLUDED))
        //{
        //	// Retrieve the size of the render target.
        //	D2D1_SIZE_F renderTargetSize = render_target_->GetSize();
        //	try {
        //		//render_target_->BeginDraw();
        //		base_->on_render();
        //		//THROW_IF_ERR(render_target_->EndDraw());
        //	} catch (sf::win32_error_exception& e )
        //	{
        //		if(e.hresult() == D2DERR_RECREATE_TARGET)
        //		{
        //			discard_device();
        //		} else {
        //			throw;
        //		}
        //	}
        //}
        return FALSE;
      }
    case WM_DISPLAYCHANGE:
      {
        ::InvalidateRect(hwnd, NULL, FALSE);
      }
    case WM_ERASEBKGND:
      {
        return FALSE;
      }
    case WM_MOUSEMOVE:
      {
        //					on_mouse_move(GET_X_LPARAM(lParam),GET_Y_LPARAM(lParam),wParam); 
      }
    case WM_LBUTTONDOWN:
      {
      }
    }
    return ::DefWindowProcW(hwnd,message,wParam,lParam);
  };


  void base_window::create_device_independent_resources()
  {

    // Direct2DFactory の生成

    if(!factory_){
#if defined(DEBUG) || defined(_DEBUG)
      D2D1_FACTORY_OPTIONS options;
      options.debugLevel = D2D1_DEBUG_LEVEL_INFORMATION ;
      THROW_IF_ERR(D2D1CreateFactory(
        D2D1_FACTORY_TYPE_SINGLE_THREADED,
        options,
        &factory_
        ));
#else
      THROW_IF_ERR(D2D1CreateFactory(D2D1_FACTORY_TYPE_SINGLE_THREADED, &factory_));
#endif

    }

    if(!write_factory_){
      THROW_IF_ERR(::DWriteCreateFactory(
        DWRITE_FACTORY_TYPE_SHARED,
        __uuidof(IDWriteFactory),
        reinterpret_cast<IUnknown**>(&write_factory_)
        ));
    }


    //wic_imaging_factory_.CreateInstance(CLSID_WICImagingFactory);

    //thunk_proc_ = (WNDPROC)thunk_.getCode();

  };

  void base_window::register_class (
    wchar_t * menu_name,
    boost::uint32_t        style ,
    boost::int32_t     cbClsExtra,
    HICON       hIcon ,
    HCURSOR     hCursor,
    HBRUSH      hbrBackground ,
    HICON       hIconSm
    )		
  {
    wnd_class_.reset(new sf::window_class_ex(menu_name,name_,HINST_THISCOMPONENT,thunk_proc_,style,cbClsExtra,hIcon,hCursor,hbrBackground,hIconSm));
  }

  /** デフォルト設定 */
  void base_window::register_class()
  {
    wnd_class_.reset(new sf::window_class_ex(0,name_,HINST_THISCOMPONENT,thunk_proc_));
  }

  void base_window::create_window()
  {
    // Create the application window.
    //
    // Because the CreateWindow function takes its size in pixels, we
    // obtain the system DPI and use it to scale the window size.
    FLOAT dpiX, dpiY;
    //factory_->GetDesktopDpi(&dpiX, &dpiY);


    // Windowを作成する
    CreateWindow(
      name_.c_str(),
      title_.c_str(),
      WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT,
      CW_USEDEFAULT,
      static_cast<boost::uint32_t>(ceil(width_ /** dpiX / 96.f*/)),
      static_cast<boost::uint32_t>(ceil(height_ /** dpiY / 96.f*/)),
      NULL,
      NULL,
      HINST_THISCOMPONENT,
      this
      );
  }

  void base_window::create_device()
  {

    //		input_.reset(new input(HINST_THISCOMPONENT,hwnd_));
    HRESULT hr = S_OK;


    //ウィンドウの現在の幅、高さを求める
    RECT rc;
    GetClientRect( hwnd_, &rc );
    boost::uint32_t width = rc.right - rc.left;
    boost::uint32_t height = rc.bottom - rc.top;

    {
      //wic_imaging_factory_.CreateInstance(CLSID_WICImagingFactory);
      //			bitmap_ = load_bitmap_from_file(render_target_,wic_imaging_factory_,L"myship.png");
    }

    if(!render_target_)
    {
      RECT rc;
      GetClientRect(hwnd_, &rc);

      D2D1_SIZE_U size = D2D1::SizeU(
        rc.right - rc.left,
        rc.bottom - rc.top
        );

      THROW_IF_ERR(factory_->CreateHwndRenderTarget(
        D2D1::RenderTargetProperties(),
        D2D1::HwndRenderTargetProperties(hwnd_, size,D2D1_PRESENT_OPTIONS_IMMEDIATELY),
        &render_target_
        ));
      // Create a DC render target 
      //D2D1_RENDER_TARGET_PROPERTIES props = D2D1::RenderTargetProperties(
      //	D2D1_RENDER_TARGET_TYPE_DEFAULT,
      //	D2D1::PixelFormat(
      //		DXGI_FORMAT_B8G8R8A8_UNORM,
      //		D2D1_ALPHA_MODE_IGNORE
      //		) , 0.0, 0.0,
      //	D2D1_RENDER_TARGET_USAGE_GDI_COMPATIBLE
      //	);

      //THROW_IF_ERR(factory_->CreateDCRenderTarget(
      //	&props,
      //	&render_target_
      //	));
    }
  }


  void base_window::discard_device()
  {
    /*		if(render_target_)
    {
    render_target_.Release();
    }*/
  }

  void base_window::show(boost::uint32_t show_flag) 
  {
    //HRESULT hr = S_OK;
    //BOOL enable;
    //DwmIsCompositionEnabled (&enable);
    //if(enable){
    //   //Create and populate the BlurBehind structre
    //   DWM_BLURBEHIND bb = {0};
    //   //Enable Blur Behind and Blur Region;
    //   bb.dwFlags = DWM_BB_ENABLE;
    //   bb.fEnable = true;
    //   bb.hRgnBlur = NULL;

    //   //Enable Blur Behind
    //   hr = DwmEnableBlurBehindWindow(hwnd_, &bb);
    //}
    ::ShowWindow(hwnd_,show_flag);
  }
  void base_window::update() {::UpdateWindow(hwnd_);}

  base_window::~base_window()
  {
    safe_release(factory_);
    safe_release(write_factory_);

  }


  base_window::base_window(const std::wstring& title,const std::wstring& name,bool fit_to_display,float width,float height)
    : title_(title),name_(name),fit_to_display_(fit_to_display),
    width_(width),height_(height),thunk_(this,base_window::WndProc),hwnd_(0)
  {
    thunk_proc_ = (WNDPROC)thunk_.getCode();
    //create_device_independent_resources();
  }



  base_window::operator HWND()
  {
    return hwnd_;
  };

  //ID2D1FactoryPtr base_window::factory() { return impl_->factory();};
  //ID2D1HwndRenderTargetPtr base_window::render_target() { return impl_->render_target();};
  //IDWriteFactoryPtr base_window::write_factory() {return impl_->write_factory();};

  toplevel_window_ptr create_toplevel_window
    (
    const std::wstring& menu_name,
    const std::wstring& name,
    const boost::uint32_t show_flag,
    bool fit_to_display,
    float width,
    float height
    )
  {
    toplevel_window* p = new toplevel_window(menu_name,name,fit_to_display,width,height);
    p->create_device_independent_resources();
    p->register_class();
    p->create_window();
    p->show(show_flag);
    p->update();
    return toplevel_window_ptr(p);
  }

  LRESULT toplevel_window::window_proc(HWND hwnd,boost::uint32_t message, WPARAM wParam, LPARAM lParam) 
  {


    switch (message)
    {
    case WM_CREATE:
      {
        // TODO:
        create_device();
        break;
      }
    case WM_SIZE:
      {
        //if (render_target_)
        //{
        //	D2D1_SIZE_U size;
        //	size.width = lParam & 0xFFFF;
        //	size.height = (lParam >> 16) & 0xFFFF; ;

        //	// Note: This method can fail, but it's okay to ignore the
        //	// error here -- it will be repeated on the next call to
        //	// EndDraw.
        //	render_target_->Resize(size);
        //}
      }
    case WM_PAINT:
      {
        //create_device();

        { 
          paint_struct begin_paint(hwnd);
          // 描画コードの呼び出し
          render();
        }
        return FALSE;
      }
    case WM_DISPLAYCHANGE:
      {
        ::InvalidateRect(hwnd, NULL, FALSE);
      }
    case WM_ERASEBKGND:
      {
        return FALSE;
      }
    case WM_MOUSEMOVE:
      {
        //					on_mouse_move(GET_X_LPARAM(lParam),GET_Y_LPARAM(lParam),wParam); 
      }
    case WM_LBUTTONDOWN:
      {
      }
    }

    if(message == WM_CLOSE)
    {
      // 後始末
      discard_device();
      // レンダーターゲットのリリース
      safe_release(render_target_);
      // Windowの破棄
      BOOL ret(::DestroyWindow(hwnd));
      BOOST_ASSERT(ret != 0);
    }

    if(message == WM_DESTROY)
    {
      ::PostQuitMessage(0);
      return 0;
    }

    return ::DefWindowProcW(hwnd,message,wParam,lParam);
  }

  void toplevel_window::main_loop()
  {
    render();
  }

  void toplevel_window::render()
  {

    static float t = 0.0f;

    if (render_target_)
    {
      // Retrieve the size of the render target.
      D2D1_SIZE_F renderTargetSize = render_target_->GetSize();
      try {
        render_target_->BeginDraw();
        render_target_->Clear(D2D1::ColorF(D2D1::ColorF::White));
        render_target_->SetTransform(D2D1::Matrix3x2F::Identity());
        //render_target_->Clear(D2D1::ColorF(D2D1::ColorF::White));
        ID2D1SolidColorBrushPtr brush;
        render_target_->CreateSolidColorBrush(D2D1::ColorF(D2D1::ColorF::Black), &brush);
        ID2D1SolidColorBrushPtr brushr;
        render_target_->CreateSolidColorBrush(D2D1::ColorF(D2D1::ColorF::Red), &brushr);

        D2D1_RECT_F layoutRect = D2D1::RectF(50.f, 50.f, 600.f, 200.f);
        IDWriteTextFormatPtr write_text_format;
        // Text Formatの作成
        THROW_IF_ERR(write_factory_->CreateTextFormat(
          L"メイリオ",                // Font family name.
          NULL,                       // Font collection (NULL sets it to use the system font collection).
          DWRITE_FONT_WEIGHT_REGULAR,
          DWRITE_FONT_STYLE_NORMAL,
          DWRITE_FONT_STRETCH_NORMAL,
          48.0f,
          L"ja-jp",
          &write_text_format
          ));
        // Actually draw the text at the origin.
        std::wstring m(L"こんにちは、64Bitの世界！By S.F.");
        render_target_->DrawTextW(
          m.c_str(),
          m.size(),
          write_text_format,
          layoutRect, 
          brush);
        THROW_IF_ERR(render_target_->EndDraw());

      }  catch(...) {
        throw;
      }
    }
  };

  //
  // Creates a Direct2D bitmap from the specified
  // file name.
  //
  ID2D1BitmapPtr load_bitmap_from_file(
    ID2D1HwndRenderTargetPtr render_target,
    IWICImagingFactoryPtr wic_factory,
    std::wstring uri,
    boost::uint32_t destination_width,
    boost::uint32_t destination_height
    )
  {
    HRESULT hr = S_OK;

    IWICBitmapDecoderPtr decoder;
    IWICBitmapFrameDecodePtr decoder_source;
    IWICStreamPtr stream;
    IWICFormatConverterPtr converter;
    IWICBitmapScalerPtr scaler;
    ID2D1BitmapPtr bitmap;

    THROW_IF_ERR(wic_factory->CreateDecoderFromFilename(
      uri.c_str(),
      NULL,
      GENERIC_READ,
      WICDecodeMetadataCacheOnLoad,
      &decoder
      ));

    // Create the initial frame.
    THROW_IF_ERR(decoder->GetFrame(0, &decoder_source));

    // Convert the image format to 32bppPBGRA
    // (DXGI_FORMAT_B8G8R8A8_UNORM + D2D1_ALPHA_MODE_PREMULTIPLIED).
    THROW_IF_ERR(hr = wic_factory->CreateFormatConverter(&converter));

    // If a new width or height was specified, create an
    // IWICBitmapScaler and use it to resize the image.
    if (destination_width != 0 || destination_height != 0)
    {
      boost::uint32_t originalWidth, originalHeight;
      THROW_IF_ERR(decoder_source->GetSize((UINT*)&originalWidth, (UINT*)&originalHeight));
      if (destination_width == 0)
      {
        FLOAT scalar = static_cast<FLOAT>(destination_height) / static_cast<FLOAT>(originalHeight);
        destination_width = static_cast<boost::uint32_t>(scalar * static_cast<FLOAT>(originalWidth));
      }
      else if (destination_height == 0)
      {
        FLOAT scalar = static_cast<FLOAT>(destination_width) / static_cast<FLOAT>(originalWidth);
        destination_height = static_cast<boost::uint32_t>(scalar * static_cast<FLOAT>(originalHeight));
      }

      THROW_IF_ERR(wic_factory->CreateBitmapScaler(&scaler));
      THROW_IF_ERR(scaler->Initialize(
        decoder_source,
        destination_width,
        destination_height,
        WICBitmapInterpolationModeCubic
        ));
      THROW_IF_ERR(converter->Initialize(
        scaler.GetInterfacePtr(),
        GUID_WICPixelFormat32bppPBGRA,
        WICBitmapDitherTypeNone,
        NULL,
        0.f,
        WICBitmapPaletteTypeMedianCut
        ));
    }
    else // Don't scale the image.
    {
      THROW_IF_ERR(converter->Initialize(
        decoder_source.GetInterfacePtr(),
        GUID_WICPixelFormat32bppPBGRA,
        WICBitmapDitherTypeNone,
        NULL,
        0.f,
        WICBitmapPaletteTypeMedianCut
        ));
    }

    // Create a Direct2D bitmap from the WIC bitmap.
    THROW_IF_ERR(render_target->CreateBitmapFromWicBitmap(
      converter.GetInterfacePtr(),
      NULL,
      &bitmap
      ));

    return bitmap;
  }


}

