/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-7 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#include "includes.h"
using namespace JUCE_NAMESPACE;
#include "InternalFilters.h"
#include "sequenceFilter.h"
#include "STed2Filter.h"
#include "FilterGraph.h"

//==============================================================================
InternalPluginFormat::InternalPluginFormat()
{
    {
        sf::AudioProcessorGraph::AudioGraphIOProcessor p (sf::AudioProcessorGraph::AudioGraphIOProcessor::audioOutputNode);
        p.fillInPluginDescription (audioOutDesc);
    }

    {
        sf::AudioProcessorGraph::AudioGraphIOProcessor p (sf::AudioProcessorGraph::AudioGraphIOProcessor::audioInputNode);
        p.fillInPluginDescription (audioInDesc);
    }

    {
        sf::AudioProcessorGraph::AudioGraphIOProcessor p (sf::AudioProcessorGraph::AudioGraphIOProcessor::midiInputNode);
        p.fillInPluginDescription (midiInDesc);
    }

	{
		sf::SequenceFilter f;
		f.fillInPluginDescription(sequenceDesc);
	}

	{
		sf::STed2Filter f;
		f.fillInPluginDescription(STed2Desc);
	}
}

AudioPluginInstance* InternalPluginFormat::createInstanceFromDescription (const PluginDescription& desc)
{
    if (desc.name == audioOutDesc.name)
    {
        return new sf::AudioProcessorGraph::AudioGraphIOProcessor (sf::AudioProcessorGraph::AudioGraphIOProcessor::audioOutputNode);
    }
    else if (desc.name == audioInDesc.name)
    {
        return new sf::AudioProcessorGraph::AudioGraphIOProcessor (sf::AudioProcessorGraph::AudioGraphIOProcessor::audioInputNode);
    }
    else if (desc.name == midiInDesc.name)
    {
        return new sf::AudioProcessorGraph::AudioGraphIOProcessor (sf::AudioProcessorGraph::AudioGraphIOProcessor::midiInputNode);
    }
    else if (desc.name == sequenceDesc.name)
	{
		return new sf::SequenceFilter();
	}
	else if (desc.name == STed2Desc.name)
	{
		return new sf::STed2Filter();
	}


    return 0;
}

const PluginDescription* InternalPluginFormat::getDescriptionFor (const InternalFilterType type)
{
    switch (type)
    {
    case audioInputFilter:
        return &audioInDesc;
    case audioOutputFilter:
        return &audioOutDesc;
    case midiInputFilter:
        return &midiInDesc;
	case sequenceFilter:
		return &sequenceDesc;
	case sted2Filter:
		return &STed2Desc;
	}
    return 0;
}

void InternalPluginFormat::getAllTypes (OwnedArray <PluginDescription>& results)
{
    for (int i = 0; i < (int) endOfFilterTypes; ++i)
        results.add (new PluginDescription (*getDescriptionFor ((InternalFilterType) i)));
}
