/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-7 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330,
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#include "includes.h"
#include "WASAPI.h"
using namespace JUCE_NAMESPACE;
#include "MainWindow.h"
//==============================================================================
MainWindow::MainWindow()
    : DocumentWindow (T("Windows Core Audio Demo"),
                      Colours::azure,
                      DocumentWindow::allButtons,
                      true)
{

    commandManager = new ApplicationCommandManager();
	wasapi_.reset(new sf::WASAPI(L"Test Device",L"Test",(void*)this->getWindowHandle()));
//
//    setResizable (true, false); // resizability is a property of ResizableWindow
//
//	WinAudioComponent* contentComp = new WinAudioComponent ((boost::uint32_t)this->getWindowHandle());
//
    //commandManager->registerAllCommandsForTarget (contentComp);
    commandManager->registerAllCommandsForTarget (JUCEApplication::getInstance());
//
//    // this lets the command manager use keypresses that arrive in our window to send
//    // out commands
    addKeyListener (commandManager->getKeyMappings());
//
//    // sets the main content component for the window to be this tabbed
//    // panel. This will be deleted when the window is deleted.
//    setContentComponent (contentComp);
//
//    // this tells the DocumentWindow to automatically create and manage a MenuBarComponent
//    // which uses our contentComp as its MenuBarModel
//    setMenuBar (contentComp);
//
//    // tells our menu bar model that it should watch this command manager for
//    // changes, and send change messages accordingly.
   // contentComp->setApplicationCommandManagerToWatch (commandManager);
//
    setVisible (true);
//
//#if JUCE_WIN32 || JUCE_LINUX
//    taskbarIcon = new DemoTaskbarComponent();
//#endif
}

MainWindow::~MainWindow()
{
//#if JUCE_WIN32 || JUCE_LINUX
//    deleteAndZero (taskbarIcon);
//#endif
//
//    // because we've set the content comp to be used as our menu bar model, we
//    // have to switch this off before deleting the content comp..
//    setMenuBar (0);
//
//    // setting our content component to 0 will delete the current one, and
//    // that will in turn delete all its child components. You don't always
//    // have to do this explicitly, because the base class's destructor will
//    // also delete the content component, but in this case we need to
//    // make sure our content comp has gone away before deleting our command
//    // manager.
//    setContentComponent (0, true);

    delete commandManager;
}

void MainWindow::closeButtonPressed()
{
    // The correct thing to do when you want the app to quit is to call the
    // JUCEApplication::systemRequestedQuit() method.

    // That means that requests to quit that come from your own UI, or from other
    // OS-specific sources (e.g. the dock menu on the mac) all get handled in the
    // same way.

    JUCEApplication::getInstance()->systemRequestedQuit();
}
