﻿#pragma once
/*
  ==============================================================================

   This file is part of the S.F.Tracker
   Copyright 2005-7 by Satoshi Fujiwara.

   S.F.Tracker can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   S.F.Tracker is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with S.F.Tracker; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ==============================================================================
*/
#include "aeffectx.h"
#include "MidiMultiOutPlugin.h"
#include "FilterGraph.h"

namespace sf
{
	class STed2Filter : public MidiMultiOutPlugin,juce::Timer
	{
	public:
		STed2Filter();

		/** Returns the parent graph to which this processor belongs, or 0 if it
            hasn't yet been added to one. */
		juce::FilterGraph* getParentGraph() const throw()         { return graph; }

        /** True if this is an audio or midi input. */
		bool isInput() const throw(){return true;};
        /** True if this is an audio or midi output. */
		bool isOutput() const throw(){return true;};

		const juce::String getName() const {return L"STed2";};

		void fillInPluginDescription (juce::PluginDescription& d) const;

		void prepareToPlay (double sampleRate, int estimatedSamplesPerBlock);
		void releaseResources();
//		void processBlock (juce::AudioSampleBuffer& buffer, juce::MidiBuffer& midiMessages);	
		void processBlock (juce::AudioSampleBuffer& buffer, juce::Array <juce::MidiBuffer*>& midiBuffers);

		const juce::String getInputChannelName (const int channelIndex) const {return juce::String::empty;};
		const juce::String getOutputChannelName (const int channelIndex) const{return juce::String::empty;};
		bool isInputChannelStereoPair (int index) const { return false;};
		bool isOutputChannelStereoPair (int index) const { return false;};
		bool acceptsMidi() const {return true;};
		bool producesMidi() const{return true;};

		juce::AudioProcessorEditor* createEditor();

		int getNumParameters(){return 0;};
		const juce::String getParameterName (int){return juce::String::empty;};
		float getParameter (int){return 0.0f;};
		const juce::String getParameterText (int){return juce::String::empty;};
		void setParameter (int, float){};

		int getNumPrograms(){return 0;};
		int getCurrentProgram(){return 0;};
		void setCurrentProgram (int){};
		const juce::String getProgramName (int){return juce::String::empty;};
		void changeProgramName (int, const juce::String&){};

		void getStateInformation (JUCE_NAMESPACE::MemoryBlock& destData);

		void setStateInformation (const void* data, int sizeInBytes);

        /** @internal */
		void setParentGraph (juce::FilterGraph* const graph_) throw() 
		{
			graph = graph_;
		};

		virtual ~STed2Filter() {};

		//==============================================================================
		void timerCallback (){};

		juce_UseDebuggingNewOperator

	private:
	    friend class boost::serialization::access;
		template<class Archive>
		void save(Archive & ar, const unsigned int version) const;
		template<class Archive>
		void load(Archive & ar, const unsigned int version);
		
		BOOST_SERIALIZATION_SPLIT_MEMBER();

		#if JUCE_PLUGINHOST_VST
			// vst internal timeinfo
		VstTimeInfo timeInfo;
		#endif
		juce::FilterGraph* graph;
		const STed2Filter& operator= (const STed2Filter&);

	};
}
