/*
  iocs_console.c

  functions for compatibility to iocslib
  ( containing mainly console oriented functions )

  Made by Studio Breeze. 1998


  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
  THE SOFTWARE.
 */

#include "../sted.h"
#include "sted_screen.h"

/* local val.s */

unsigned int iocs_current_console_width=96, iocs_current_console_height=32;
unsigned int iocs_console_xtop=0, iocs_console_ytop=0;
unsigned int iocs_current_text_x=0, iocs_current_text_y=0;
unsigned int iocs_current_color=15;

/* functions */

/* console */

extern "C" {
int
_iocs_b_consol( int xs, int ys, int xl, int yl )
{
  iocs_current_console_width =xl+1;
  iocs_current_console_height=yl+1;

  iocs_console_xtop = xs/8;
  iocs_console_ytop = ys/8;

  iocs_current_text_x = 0;
  iocs_current_text_y = 0;

  return xl*65536+yl;
}

int
_iocs_b_color( int in_color )
{
  int c;
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  c = iocs_current_color;
  iocs_current_color = in_color;

  scr->SetTextColor(in_color);
  return c;
}

int
_iocs_b_print( const char *in_message )
{
  int x,y;
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  scr->Puts(in_message);

  x = iocs_current_text_x + strlen(in_message);
  y = iocs_current_text_y;
  if ( x >= iocs_current_console_width ) {
    x %= iocs_current_console_width;
    x += iocs_console_xtop;
    y ++;
  }
  if ( y >= iocs_current_console_height ) {
    y=iocs_current_console_height-1;
  }

  iocs_current_text_x = x;
  iocs_current_text_y = y;

  return (x<<16)+y;
}

int
_iocs_b_putmes ( int in_col, int in_x, int in_y, int in_width, const char *in_str )
{
  int c;
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  c = scr->SetTextColor(in_col);
  scr->Locate(in_x, in_y);
  scr->Puts(in_str);
  scr->SetTextColor(c);
  scr->Locate( iocs_current_text_x+iocs_console_xtop,
	       iocs_current_text_y+iocs_console_ytop);
  return 0;
}

int
_iocs_b_locate( int in_x0, int in_y0 )
{
  int old_x, old_y;
  int x,y;
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return 0;

  old_x = iocs_current_text_x;
  old_y = iocs_current_text_y;

  if ( in_x0 != -1 ) {
    iocs_current_text_x = in_x0;
    iocs_current_text_y = in_y0;
    /*
    if ( in_x0 >= iocs_current_console_width ) return -1;
    else if ( in_y0 >= iocs_current_console_height ) return -1;
    */
    x = in_x0+iocs_console_xtop;
    y = in_y0+iocs_console_ytop;

    scr->Locate(x,y);
  }

  return (old_x<<16)+old_y;
}

void
_iocs_b_clr_al( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->ClsAll();

  iocs_current_text_x = 0;
  iocs_current_text_y = 0;

  return;
}

void
_iocs_b_clr_ed ( void )
{
  CSTedScreenBase* scr;

  scr = GetDriver();
  if (!scr) return;

  scr->ClsEd();
  return;
}

/* fonts */

int
_iocs_defchr( int type, int code, const void *buff )
{
  /* not implemented */
  return 0;
}

int
_iocs_fntget( int type, int code, struct _x68_fntbuf *fntbuf )
{
  /* not implemented */
  return 0;
}

}
