﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace wintree7
{
    public partial class FormWinTreeSettings : Form
    {
        public FormWinTreeSettings()
        {
            InitializeComponent();
        }

        private void buttonSettingsCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void buttonSettingsShowVersion_Click(object sender, EventArgs e)
        {
            FormWinTreeVersion version = new FormWinTreeVersion();
            version.ShowDialog();
        }

        private void checkBoxHtmlGenerateHtml_CheckedChanged(object sender, EventArgs e)
        {
            groupBox1.Enabled = checkBoxHtmlGenerateHtml.Checked;
        }

        private void radioButtonDisplayOrderByFileName_CheckedChanged(object sender, EventArgs e)
        {
            panelOrderByFileName.Visible = true;
            panelOrderByFileSize.Visible = false;
            panelOrderByFileTimeStamp.Visible = false;
        }

        private void radioButtonDisplayOrderByFileExtention_CheckedChanged(object sender, EventArgs e)
        {
            panelOrderByFileName.Visible = true;
            panelOrderByFileSize.Visible = false;
            panelOrderByFileTimeStamp.Visible = false;
        }

        private void radioButtonDisplayOrderByFileSize_CheckedChanged(object sender, EventArgs e)
        {
            panelOrderByFileName.Visible = false;
            panelOrderByFileSize.Visible = true;
            panelOrderByFileTimeStamp.Visible = false;
        }

        private void radioButtonDisplayOrderByFileCreateTime_CheckedChanged(object sender, EventArgs e)
        {
            panelOrderByFileName.Visible = false;
            panelOrderByFileSize.Visible = false;
            panelOrderByFileTimeStamp.Visible = true;
        }

        private void radioButtonDisplayOrderByFileUpdateTime_CheckedChanged(object sender, EventArgs e)
        {
            panelOrderByFileName.Visible = false;
            panelOrderByFileSize.Visible = false;
            panelOrderByFileTimeStamp.Visible = true;
        }

        private void FormWinTreeSettings_Load(object sender, EventArgs e)
        {
            // 設定ファイルより設定データをロードし、コントロールへ設定する。
            setAllControlAttributes(new WinTreeSettings());

        }

        private void buttonSettingsInitialize_Click(object sender, EventArgs e)
        {
            // デフォルト設定値を設定する。
            setAllControlAttributes(new WinTreeSettings(true));
        }

        private void setAllControlAttributes(WinTreeSettings settings)
        {
            // 表示項目 Display Item
            checkBoxDisplayItemFilename.Checked = settings.Item.showFileName;
            checkBoxDisplayItemSize.Checked = settings.Item.showSize;
            checkBoxDisplayItemAttribute.Checked = settings.Item.showAttribute;
            checkBoxDisplayItemCreateDate.Checked = settings.Item.showCreateDate;
            checkBoxDisplayItemCreateTime.Checked = settings.Item.showCreateTime;
            checkBoxDisplayItemUpdateDate.Checked = settings.Item.showUpdateDate;
            checkBoxDisplayItemUpdateTime.Checked = settings.Item.showUpdateTime;
            checkBoxDisplayItemCrc.Checked = settings.Item.showCRC;
            checkBoxDisplayItemFileVersion.Checked = settings.Item.showFileVersion;

            // 表示順 Display Order
            switch (settings.Order.orderType)
            {
                case WinTreeSettingsDisplayOrder.DisplayOrderType.FileName:
                    radioButtonDisplayOrderByFileName.Checked = true;
                    break;
                case WinTreeSettingsDisplayOrder.DisplayOrderType.Extention:
                    radioButtonDisplayOrderByFileExtention.Checked = true;
                    break;
                case WinTreeSettingsDisplayOrder.DisplayOrderType.Size:
                    radioButtonDisplayOrderByFileSize.Checked = true;
                    break;
                case WinTreeSettingsDisplayOrder.DisplayOrderType.CreateDate:
                    radioButtonDisplayOrderByFileCreateTime.Checked = true;
                    break;
                case WinTreeSettingsDisplayOrder.DisplayOrderType.UpdateDate:
                    radioButtonDisplayOrderByFileUpdateTime.Checked = true;
                    break;
            }
            if (settings.Order.orderByFileNameAscending)
            {
                radioButtonDisplayOrderByAscending.Checked = true;
            }
            else
            {
                radioButtonDisplayOrderByDscending.Checked = true;
            }

            if (settings.Order.orderByFileSizeSmallToLarge)
            {
                radioButtonDisplayOrderBySizeSmall.Checked = true;
            }
            else
            {
                radioButtonDisplayOrderBySizeLarge.Checked = true;
            }

            if (settings.Order.orderByFileNewToOld)
            {
                radioButtonDisplayOrderByNewer.Checked = true;
            }
            else
            {
                radioButtonDisplayOrderByOlder.Checked = true;
            }
            checkBoxDisplayOrderCaseNotSencitive.Checked = settings.Order.orderNotCaseSencetive;

            // 表示形式 Diplay Style
            textBoxDisplayStyleColumnLimit.Text = settings.Style.colomnLimit.ToString();
            textBoxDisplayStyleRowMargin.Text = settings.Style.rowMergin.ToString();
            if (settings.Style.boarderWidthType == WinTreeSettingsDisplayStyle.BoaderWidthType.Full)
            {
                radioButtonDisplayStyleBoaderFullWidth.Checked = true;
            }
            else
            {
                radioButtonDisplayStyleBoaderHalfWidth.Checked = true;
            }
            if (settings.Style.sizeNotOmit)
            {
                radioButtonDisplayStyleSizeNotOmit.Checked = true;
            }
            else
            {
                radioButtonDisplayStyleSizeOmit.Checked = true;
            }
            textBoxDisplayStyleSizeColumn.Text = settings.Style.sizeColumn.ToString();
            switch (settings.Style.styleFormat)
            {
                case WinTreeSettingsDisplayStyle.StyleFormat.Normal:
                    radioButtonDisplayStyleFormatNormal.Checked = true;
                    break;
                case WinTreeSettingsDisplayStyle.StyleFormat.Omit1:
                    radioButtonDisplayStyleFormatOmit1.Checked = true;
                    break;
                case WinTreeSettingsDisplayStyle.StyleFormat.Omit2:
                    radioButtonDisplayStyleFormatOmit2.Checked = true;
                    break;
                case WinTreeSettingsDisplayStyle.StyleFormat.Omit3:
                    radioButtonDisplayStyleFormatOmit3.Checked = true;
                    break;
            }

            // HTML
            checkBoxHtmlGenerateHtml.Checked = settings.Html.createHtml;
            comboBoxHtmlStyle.SelectedIndex = (int)settings.Html.htmlStyle;
            checkBoxHtmlLinkToFolder.Checked = settings.Html.makeLinkToFolder;
            checkBoxHtmlLinkToFile.Checked = settings.Html.makeLinkToFile;

            // その他 Other
            checkBoxOtherBootableFromShortcut.Checked = settings.Other.bootableFromShortcut;
            checkBoxOtherListHiddenFiles.Checked = settings.Other.listHiddenFiles;
            checkBoxOtherUseLongFileName.Checked = settings.Other.useLongFileName;
            checkBoxOtherSearchRecursive.Checked = settings.Other.searchRecursive;
            checkBoxOtherRememberPosition.Checked = settings.Other.rememberPosition;
            checkBoxOtherUseFileFilter.Checked = settings.Other.useFileFilter;
            checkBoxOtherOpenAfterCreateList.Checked = settings.Other.openAfterCreateList;
        }

        private void buttonSettingsSave_Click(object sender, EventArgs e)
        {
            // 設定ファイルへコントロールの設定を保存する。
        }
    }
}
