<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once USER_TRUST_PATH . '/class/AbstractEditAction.class.php';
require_once USER_TRUST_PATH . '/admin/forms/GroupAdminEditForm.class.php';
require_once USER_TRUST_PATH . '/class/core/Notification.class.php';
require_once USER_TRUST_PATH . '/class/core/User.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/Enum.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Transaction.class.php';

class User_GroupEditAction extends User_AbstractEditAction
{
	function _getId()
	{
		return xoops_getrequest('groupid');
	}
	
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('groups');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm = new User_GroupAdminEditForm();
		$this->mActionForm->prepare();
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		if (isset($_REQUEST['adminvalue'])) {
			$this->mActionForm->fetch();
			$this->mActionForm->setAdmin();
		}
		$render->setTemplateName("group_edit.html");
		$render->setAttribute("actionForm", $this->mActionForm);
		$render->setAttribute("dirname", XCUBE_CORE_USER_MODULE_NAME);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("index.php?action=GroupList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("index.php?action=GroupList", 1, _MD_USER_ERROR_DBUPDATE_FAILED);
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("index.php?action=GroupList");
	}

	function execute(&$controller, &$xoopsUser)
	{
		if ($this->mObject == null) {
			return USER_FRAME_VIEW_ERROR;
		}
	
		if (xoops_getrequest('_form_control_cancel') != null) {
			return USER_FRAME_VIEW_CANCEL;
		}
		
		if (isset($_REQUEST['adminvalue'])) {
			return USER_FRAME_VIEW_INPUT;
		}

		$this->mActionForm->load($this->mObject);
		
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
	
		if($this->mActionForm->hasError()) {
			$this->mActionForm->set('group_type', $this->mActionForm->groupType);
			return USER_FRAME_VIEW_INPUT;
		}
	
		$group = $this->mActionForm->update($this->mObject);
		$message = '';
		if (!$this->_doExecute($group, $message)) {
			if (is_array($message)) {
				$errors = new Xoonips_Errors();
				$errors->addError($message[1], 'workflow', null, false);
				$this->mActionForm->addErrorMessage($errors->getView($this->dirname, true));
				return USER_FRAME_VIEW_INPUT;
			}
			return USER_FRAME_VIEW_ERROR;
		} else {
			return USER_FRAME_VIEW_SUCCESS;
		}
	}

	function _doExecute($group, &$message)
	{
		if (is_object($group)) {
			return $this->mObjectHandler->insert($group);
		} else {
			// start transaction
			$transaction = Xoonips_Transaction::getInstance();
	  		$transaction->start();

			$group['group_type'] = '';
			$uids = array();
			foreach ($group['admins'] as $user) {
				$uids[] = $user['uid'];
			}
			$user = User_User::getInstance();
			$message = '';
			$success = true;
			if (empty($group['groupid'])) {
				$groupId = $user->doGroupRegistry($group, $uids, $message);
				if (!$groupId) {
					$success = false;
				}
			} else {
				$success = $user->doGroupEdit($group['groupPublic'], $group, $uids, $message);
				$groupId = $group['groupid'];
			}
			if ($success) {
				//delete uploaded icon
				$uploadfile = XOOPS_ROOT_PATH . '/uploads/user/group/' . $groupId;
				if ($this->mActionForm->get('showThumbnail') == 2) {
					unlink($uploadfile);
				}
				if (!empty($this->mActionForm->mFile)) {
					if (!move_uploaded_file($this->mActionForm->mFile['tmp_name'], $uploadfile)) {
						$message = _MD_USER_ERROR_GROUP_ICON_UPLOAD;
						$success = false; 		
	    	   		}
				}
			}
			if (!$success) {
				$transaction->rollback();
				return false;
			}
			$transaction->commit();
			return true;
		}
	}
}


