<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once dirname(dirname(__FILE__)) . '/core/User.class.php';

class User_WorkflowGroupRegister extends Xoonips_WorkflowBase {

	public function doCertify($gid, &$result, $comment) {
		$result[0] = false;
		$groupBean = Xoonips_BeanFactory::getBean('GroupsBean', $this->dirname, $this->trustDirname);
		$group_handler =& xoops_gethandler('group');
		$xoopsGroup = $group_handler->get($gid);
		if (!$groupBean->groupsCertify($gid)) {
			return false;
		}
		$result[0] = true;
		//event log
		$user = User_User::getInstance();
		$user->doGroupCertified($gid, $xoopsGroup, false, $comment);
	}

	public function doProgress($gid, &$result, $comment) {
		$sendToUsers = array();
		XCube_DelegateUtils::call('Legacy_Workflow.GetCurrentCertifyUsers', Xoonips_Enum::certifyGroups(), $gid, new XCube_Ref($sendToUsers));
		$this->notification->groupCertifyRequest($gid, $sendToUsers);
		$result[0] = true;
	}

	public function doRefuse($gid, &$result, $comment) {
		$result[0] = false;
		$groupBean = Xoonips_BeanFactory::getBean('GroupsBean', $this->dirname, $this->trustDirname);
		$group = $groupBean->getGroup($gid);		
		$group_handler =& xoops_gethandler('group');
		$xoopsGroup = $group_handler->get($gid);
		$group['index_path'] = '/' . $group['name'];
		$groupUserLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', $this->dirname, $this->trustDirname);
		//send to group admins
		foreach ($groupUserLinkBean->getAdminUserIds($gid) as $id) {
			$sendToUsers[$id] = $id; 
		}
		$groupUserIds = $groupUserLinkBean->getUserIds($gid);
		if (!$groupBean->delete($gid)) {
			return false;
		}
		// user leave log
		foreach($groupUserIds as $uid) {
			XCube_DelegateUtils::call('Module.User.Event.Group.Member.Leave', new XoopsUser($uid), $xoopsGroup);			
		}		
		if (!$groupUserLinkBean->deleteGroupUsers($gid)) {
			return false;
		}
		
		$result[0] = true;
		//event log
		XCube_DelegateUtils::call('Module.User.Event.Group.Reject', $xoopsGroup);

		//send to group admins and certifyUsers
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyGroups(), new XCube_Ref($sendToUsers));
		$this->notification->groupRejected($group, $sendToUsers, $comment);
	}
	
	public function getDetailView($gid) {
		$viewData = array();
		$groupbean = Xoonips_BeanFactory::getBean('GroupsBean', $this->dirname, $this->trustDirname);
		$userbean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$groupId = $gid;
		$group = $groupbean->getGroup($groupId);
		
		//if show icon
		$file_path = XOOPS_ROOT_PATH . '/uploads/user/group/' . $groupId;
		$showThumbnail = false;
		if(file_exists($file_path)) {
			$showThumbnail = true;
		}
		
		if (empty($group)) {
			return false;
		} else {
			//edit group name
			if ($group['is_hidden'] == 1) {		
				$group['name'] = $group['name'] . '(secret group)';	
			}
			//get group information	
			$admins = $userbean->getUsersGroups($groupId, true);
			$members = $userbean->getUsersGroups($groupId, false);
			$thumbnail = XOOPS_URL . '/modules/' . $this->dirname . "/image.php?group_id=$groupId";
		}

		$group_handler =& xoops_gethandler('group');
		$xoopsGroup = $group_handler->get($groupId);

		$maximumResources = array();
		XCube_DelegateUtils::call('Module.User.GetGroupMaximumResources', new XCube_Ref($maximumResources), $xoopsGroup);
		if (count($maximumResources) > 0) {
			foreach ($maximumResources as $resources) {
				$maximumResource = $resources;
			}
		} else {
			$maximumResource = array('itemNumberLimit' => 0, 'indexNumberLimit' =>0, 'itemStorageLimit' =>0);
		}

		$usedResources = array();
		XCube_DelegateUtils::call('Module.User.GetGroupUsedResources', new XCube_Ref($usedResources), $xoopsGroup);
		if (count($usedResources) > 0) {
			foreach ($usedResources as $resources) {
				$usedResource = $resources;
			}
		} else {
			$usedResource = array('itemNum' => 0, 'indexNum' =>0, 'fileSize' =>0);
		}

		global $xoopsTpl;
		$xoopsTpl->assign('group', $group);
		$xoopsTpl->assign('admins', $admins);
		$xoopsTpl->assign('members', $members);
		$xoopsTpl->assign('itemNum', $usedResource['itemNum']);
		$xoopsTpl->assign('indexNum', $usedResource['indexNum']);
		$xoopsTpl->assign('fileSize', $usedResource['fileSize'] / 1024 / 1024);
		$xoopsTpl->assign('itemNumberLimit', $maximumResource['itemNumberLimit']);
		$xoopsTpl->assign('indexNumberLimit', $maximumResource['indexNumberLimit']);
		$xoopsTpl->assign('itemStorageLimit', $maximumResource['itemStorageLimit'] / 1024 / 1024);
		$xoopsTpl->assign('showThumbnail', $showThumbnail);
		$xoopsTpl->assign('thumbnail', $thumbnail);
		$xoopsTpl->assign('workflow', true);
		return $xoopsTpl->fetch('db:' . $this->dirname . '_groupinfo.html');
	}
}

