<?php

/**
 * XooNips Table Duplicate program.
 * 
 */

/**
 *Duplicates tables 
 */

function usage($msg = NULL) {
  if(!is_null($msg)){
    fprintf(STDERR, "%s\n",$msg);
  }
  fprintf(STDERR,"Usage:duplicate.php [mainfile.php]\n");
  fprintf(STDERR,"Default maifile is /var/www/html/mainfile.php\n");
  exit(2);
}

/**
 * Common function.doing duplication
 * 
 * @param object $db    pdo object
 * @param string $tbl    table name
 * @param string $prefix prefix name
 * @return int 
 */
function do_duplication(&$db,$tbl,$prefix) {
  echo "$tbl\n";
  #Table structure copy.
  $createquery = "CREATE TABLE ".XOOPS_DB_PREFIX."_WK_".$tbl." LIKE ".$prefix.$tbl;
  $ret = $db->query($createquery);
  if($ret === FALSE){
    errmsg(APP_DUPLICATE,'E1003',$tbl);
    return -1;
  }

  # Data Copy.
  $cpquery ="INSERT INTO ".XOOPS_DB_PREFIX."_WK_".$tbl." SELECT * FROM ".$prefix.$tbl;
  $ret = $db->query($cpquery);
  if($ret === FALSE){
    errmsg(APP_DUPLICATE,'E1004',$tbl);
    return -2;
  }
  return 0;
}

/**
 * Distinct table duplicate.
 * 
 * @param object $db    pdo object
 * @param string $prefix prefix name
 * @return int Success:0,Fail:Negative Number
 */
function distinct_tables_duplicate($db,$prefix){
  #Get Item Type list
  $tbl = get_tbl('xoonips_item_type');
  $sql = "select * from ".$tbl;
  $wk_array = $db->query($sql);
  if($wk_array === FALSE)return; -1;
    
  #Check Exist conversion classes under item_type directory?
  foreach ($wk_array as $value) {
    $name = $value['name'];
    if(strcmp($name,'xoonips_index')==0){
      continue;
    }
    $fname = 'item_type/'.$name.'.inc.php';
    if(!file_exists($fname)){
      echo "Warning {$fname} not exist\n";
      continue;
    }
    require_once $fname;
  }
  #Duplicate
  foreach ($wk_array as $value) {
    $name = $value['name'];
    if(strcmp($name,'xoonips_index')==0){
      continue;
    }
    $classname = $value['name'];
    if(!class_exists($classname)){
      #return -3;
      continue;
    }
    $c = new $classname;
    $c->init($db);
    $arr = $c->get_dup_table();
    if(count($arr) == 0){
      return -5;
    }
    foreach ($arr as $tbl) {
      $rc = do_duplication($db, $tbl,$prefix);
      if($rc == -1)continue;
      if($rc < 0){
        return -4;
      }
    }
  }
  
  return 0;
}

/**
 * Table duplicate main routin
 * 
 * @param object $db db object
 * @param array $duptables processing tables.
 * @param string $prefix   sourace table prefix.
 */
function table_duplicate(&$db,$duptables,$prefix) {
  
  foreach ($duptables as $tbl) {
    # duplicate XooNIps3.46a tables.
    $rc = do_duplication($db, $tbl,$prefix);
    if($rc == -1)continue;
    if($rc < 0){
      return $rc;
    }      
  }
  return 0;
}

#
#MAIN
#

$MAIN_FILE = '/var/www/html/mainfile.php';
if($argc == 2){
  $MAIN_FILE = $argv[1];
}else if($argc > 2){
  usage();
}
if(!file_exists($MAIN_FILE)){
  usage("{$MAIN_FILE} does not exist.");
}

require_once "$MAIN_FILE";
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/inc/cmdlib.inc.php';
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/inc/migrate_db.inc.php';
require_once  XOOPS_TRUST_PATH.'/modules/xdbmigrate/status.php';

set_status(APP_DUPLICATE, XDBMIGRATE_START_DUPLICATE);
$db = new migrate_db();
$rc = $db->connect();
if($rc === FALSE){
  errmsg(APP_DUPLICATE, 'E1005');
  exit(2);
}
$db->beginTransaction();
#Duplicate distinct tables.
$rc = distinct_tables_duplicate($db,XOOPS_DB_PREFIX.'_');
if($rc < 0){
  echo  $rc."\n";
  $db->rollBack();
  exit(3);
}

#Duplicate common tables.
table_duplicate($db,$duptables,XOOPS_DB_PREFIX.'_');
if($rc < 0){
  echo  $rc."\n";
  $db->rollBack();
  exit(3);
}
set_status(APP_DUPLICATE, XDBMIGRATE_UNIST_INST_XOONIPS);
$db->commit();
echo "Duplicate Success.\n";
exit(0);
