<?php

class migrate_db{
  private $dsn;
  private $dbh;
  private $e;
  function __construct() {
    $this->dsn = 'mysql:dbname='.XOOPS_DB_NAME.';host='.XOOPS_DB_HOST.';';
  }
  
  public function connect(){
    try{
      $this->dbh = new PDO($this->dsn,XOOPS_DB_USER,XOOPS_DB_PASS,
        array(
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET CHARACTER SET `utf8`"
        )
      );
    }catch(PDOException $e){
      $this->e = $e;
      return false;
    }
    return true;
  }
  
  public function query($sql){
    try{
      $ret = $this->dbh->query($sql);
      if(is_object($ret)){
        return $ret->fetchAll(PDO::FETCH_ASSOC );
      }
    }catch(PDOException $e){
      $this->e = $e;
    }
    return FALSE;
  }
  
  public function exec($sql){
    $rc = $this->dbh->exec($sql);
    if($rc == 0){
      $err = $this->dbh->errorInfo();
      if(strcmp($err[0],'00000') == 0)return true;
      echo $sql;
      var_dump(debug_backtrace());
      print_r($err);
      return false;
    }
    return true;
  }

  public function conv_0str($val) {
    if($val === 0){
      return 'NULL';
    }else if(is_null($val)){
      return 'NULL';
    }
    return "'".$val."'";
  }
  
  public function quote($str){
    #return $this->dbh->quote($str);
    return "'".addslashes($str)."'";
  }
  
  public function get_exception() {
    return $this->e;
  }
  
  public function beginTransaction(){
    #return $this->dbh->beginTransaction();
  }

  public function rollBack(){
    #return $this->dbh->rollBack();
  }
  
  public function commit(){
    #return $this->dbh->commit();
  }

}
